/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.accessibility;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import oracle.diagram.core.context.DiagramView;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.framework.accessibility.NavigateContextMenuBuilder;
import oracle.diagram.framework.accessibility.NavigateContextMenuPlugin;
import oracle.diagram.framework.selection.SubSelectionManager;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;

public class DefaultNavigateContextMenuPlugin
extends AbstractPlugin
implements NavigateContextMenuPlugin {
    private final boolean _subSel;
    private final NavigateContextMenuBuilder _builder = this.createBuilder();

    public DefaultNavigateContextMenuPlugin(boolean useSubSelection) {
        this._subSel = useSubSelection;
    }

    @Override
    public void addNavigateMenu(ContextMenu menu) {
        DiagramView dv;
        Context context = menu.getContext();
        DiagramView diagramView = dv = context.getView() instanceof DiagramView ? (DiagramView)context.getView() : null;
        if (dv != null) {
            IlvManagerView view = dv.getActiveManagerView();
            IlvManager mgr = view.getManager();
            int selCount = mgr.getSelectedObjectsCount(true);
            if (selCount > 1) {
                return;
            }
            IlvGraphic singleSelection = null;
            if (this._subSel) {
                IlvGraphicEnumeration e = SubSelectionManager.getInstance().getSelectedSubObjects(mgr);
                if (e.hasMoreElements() && selCount > 1) {
                    return;
                }
                if (e.hasMoreElements()) {
                    singleSelection = e.nextElement();
                    if (e.hasMoreElements()) {
                        return;
                    }
                }
            }
            if (singleSelection == null && selCount > 0) {
                singleSelection = mgr.getSelectedObjects(true).nextElement();
            }
            if (singleSelection != null) {
                this.getBuilder().buildAndAddNavigateMenu(menu, singleSelection);
            }
        }
    }

    protected final NavigateContextMenuBuilder getBuilder() {
        return this._builder;
    }

    protected NavigateContextMenuBuilder createBuilder() {
        return new NavigateContextMenuBuilder();
    }
}

