/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.core.interaction;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvLinkConnector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvPoint;
import ilog.views.IlvPolyPointsInterface;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvSelectionFactory;
import ilog.views.IlvTransformer;
import ilog.views.event.TransformerChangedEvent;
import ilog.views.event.TransformerListener;
import ilog.views.graphic.IlvEnhancedPolylineLinkImage;
import ilog.views.graphic.IlvRectangle;
import ilog.views.graphic.linkpolicy.IlvCrossingAwareLinkImage;
import ilog.views.graphic.linkpolicy.IlvLinkShapePolicy;
import ilog.views.graphic.linkpolicy.IlvPolicyAwareLinkImage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.diagram.core.interaction.CoreSelectInteractor;
import oracle.diagram.core.util.CoreGraphicUtils;
import oracle.diagram.framework.graphic.Edge2EdgeLinkShapePolicy;
import oracle.diagram.framework.graphic.EdgeGraphicConnector;
import oracle.diagram.framework.graphic.FakeNode;
import oracle.diagram.framework.graphic.GraphicConnector;
import oracle.diagram.framework.graphic.GraphicPin;
import oracle.diagram.framework.graphic.IMultipresentationView;
import oracle.diagram.framework.link.LinkArrowRenderer;
import oracle.diagram.framework.link.LinkUtil;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.shape.SubSelectableShape;
import oracle.diagram.res.UndoResource;
import oracle.ide.feedback.FeedbackManager;

public class CoreLinkReconnectInteractor
extends IlvManagerViewInteractor
implements Serializable {
    protected static final String UNDO_NAME = UndoResource.getBundle().getString("linkConnect.text");
    private final CoreSelectInteractor _selectInteractor;
    private IlvPoint _srcPoint;
    private IlvPoint _dstPoint;
    private IlvPoint _trackPoint;
    private int _initialX;
    private int _initialY;
    private int _savedRedrawMode;
    private IlvSelectionFactory _oldSelectionFactory;
    private IlvGraphic _targetGraphic;
    private IlvLinkImage _link;
    private IlvLinkShapePolicy _policy;
    private IlvLinkImage _drawLink;
    private DummyNode _fixedNode;
    private DummyNode _movingNode;
    private boolean _supportsLinkstoLinks = false;
    protected boolean _supportsSubshapeConnect = false;
    private boolean _simpleFeedbackMode = false;
    private boolean _simpleFeedbackEndpointsOnly = true;
    private IlvPoint[] _simplePoints = null;
    private IlvPoint[] _simpleTmpDrawPoints = null;
    private Line2D.Float[] _simpleTmpSegments = null;
    private final IlvRect _simpleTmpInvalidateRect = new IlvRect();
    private Stroke _simpleTmpStroke = null;
    private MyTransformerListener _transformerListener;
    private MouseEvent _lastDragEvent;
    protected Collection<IlvLinkImage> _dependentLinks;
    private RecursiveLink _recursiveLink;
    private boolean _failed;
    private Cursor _oldCursor;

    protected CoreLinkReconnectInteractor(CoreSelectInteractor selectInteractor) {
        this._selectInteractor = selectInteractor;
        this._targetGraphic = null;
        this._srcPoint = new IlvPoint();
        this._dstPoint = new IlvPoint();
        this._trackPoint = null;
        this._link = null;
        this._drawLink = null;
        this._fixedNode = null;
        this._movingNode = null;
        this.enableEvents(60L);
        this.setLinkConnectionMode(true);
    }

    protected void attach(IlvManagerView IlvManagerView2) {
        super.attach(IlvManagerView2);
        this._failed = false;
        this._oldCursor = null;
        this._transformerListener = new MyTransformerListener();
        IlvManagerView2.addTransformerListener((TransformerListener)this._transformerListener);
    }

    protected void detach() {
        this.getManagerView().removeTransformerListener((TransformerListener)this._transformerListener);
        this._transformerListener = null;
        this._lastDragEvent = null;
        if (this._oldCursor != null) {
            this.getManagerView().setCursor(this._oldCursor);
            this._oldCursor = null;
        }
        super.detach();
    }

    protected final boolean isFailedState() {
        return this._failed;
    }

    public void setLinkConnectionMode(boolean enabled) {
        this._supportsLinkstoLinks = enabled;
    }

    public final boolean isLinkConnectionMode() {
        return this._supportsLinkstoLinks;
    }

    public final boolean isSubshapeConnectionMode() {
        return this._supportsSubshapeConnect;
    }

    public final void setSubshapeConnectionMode(boolean connectSubshapes) {
        this._supportsSubshapeConnect = connectSubshapes;
    }

    protected void setAdvancedFeedbackMode(boolean isAdvanced) {
        this._simpleFeedbackMode = !isAdvanced;
    }

    protected final boolean isAdvancedFeedbackMode() {
        return !this._simpleFeedbackMode;
    }

    protected void setUseAllWaypoints(boolean useAllWaypoints) {
        this._simpleFeedbackEndpointsOnly = !useAllWaypoints;
    }

    protected boolean isUsingAllWaypoints() {
        return !this._simpleFeedbackEndpointsOnly;
    }

    protected void setSimplePoints(IlvPoint[] points) {
        if (points == null) {
            this._simplePoints = null;
            this._simpleTmpDrawPoints = null;
            this._simpleTmpSegments = null;
            this._simpleTmpStroke = null;
        } else {
            int i;
            this._simplePoints = new IlvPoint[points.length];
            System.arraycopy(points, 0, this._simplePoints, 0, points.length);
            this._simpleTmpDrawPoints = new IlvPoint[points.length];
            for (i = 0; i < points.length; ++i) {
                this._simpleTmpDrawPoints[i] = new IlvPoint();
            }
            this._simpleTmpSegments = new Line2D.Float[points.length];
            for (i = 0; i < points.length; ++i) {
                this._simpleTmpSegments[i] = new Line2D.Float();
            }
            this._simpleTmpStroke = this.createSimpleStroke(this.getLink());
        }
    }

    protected final IlvPoint[] getSimplePoints() {
        return this._simplePoints;
    }

    protected final boolean isReconnectingSource() {
        return this._trackPoint == this._srcPoint;
    }

    protected final IlvPoint getSourcePoint() {
        return this._srcPoint;
    }

    protected final IlvPoint getDestinationPoint() {
        return this._dstPoint;
    }

    protected final IlvPoint getTrackPoint() {
        return this._trackPoint;
    }

    protected final void setTrackPoint(IlvPoint ilvpoint) {
        this._trackPoint = ilvpoint;
    }

    protected final DummyNode getFixedNode() {
        return this._fixedNode;
    }

    protected final void setFixedNode(DummyNode node) {
        this._fixedNode = node;
    }

    protected final DummyNode getMovingNode() {
        return this._movingNode;
    }

    protected final void setMovingNode(DummyNode node) {
        this._movingNode = node;
    }

    protected final IlvLinkImage getDrawLink() {
        return this._drawLink;
    }

    protected final void setDrawLink(IlvLinkImage link) {
        this._drawLink = link;
    }

    protected IlvLinkImage getLink() {
        return this._link;
    }

    protected void setLink(IlvLinkImage link) {
        this._link = link;
    }

    protected void setInitialXPos(int x) {
        this._initialX = x;
    }

    protected final int getInitialXPos() {
        return this._initialX;
    }

    protected final void setInitialYPos(int y) {
        this._initialY = y;
    }

    protected final int getInitialYPos() {
        return this._initialY;
    }

    protected final void setSavedRedrawMode(int oldMode) {
        this._savedRedrawMode = oldMode;
    }

    protected final int getSavedRedrawMode() {
        return this._savedRedrawMode;
    }

    protected final IlvSelectionFactory getSavedSelectionFactory() {
        return this._oldSelectionFactory;
    }

    protected final void setSavedSelectionFactory(IlvSelectionFactory factory) {
        this._oldSelectionFactory = factory;
    }

    protected final IlvGraphic getTargetGraphic() {
        return this._targetGraphic;
    }

    protected final void setTargetGraphic(IlvGraphic target) {
        this._targetGraphic = target;
    }

    protected void beginReconnection() {
        this.setSavedSelectionFactory(this.getManager().getSelectionFactory());
        GrapherPinSelectionFactory grapherpinselectionfactory = new GrapherPinSelectionFactory();
        List<IlvGrapher> graphers = this.getAllGraphers();
        for (IlvGrapher g : graphers) {
            g.setSelectionFactory((IlvSelectionFactory)grapherpinselectionfactory);
        }
    }

    protected void endReconnection() {
        List<IlvGrapher> graphers = this.getAllGraphers();
        for (IlvGrapher g : graphers) {
            g.setSelectionFactory(this.getSavedSelectionFactory());
        }
    }

    protected IlvGrapher getGrapher() {
        return (IlvGrapher)this.getManager();
    }

    protected void initialize() {
        this.setTrackPoint(null);
        this.setTargetGraphic(null);
        this.setLink(null);
        this.setDrawLink(null);
        this.setFixedNode(null);
        this.setMovingNode(null);
        this.setSimplePoints(null);
    }

    protected boolean initializeFromHit(IlvGraphic hit) {
        if (hit instanceof IlvLinkImage) {
            IlvLinkImage link = (IlvLinkImage)hit;
            this.setLink(link);
            if (this.isAdvancedFeedbackMode()) {
                this.setSimplePoints(null);
            } else {
                this.setDrawLink(null);
            }
            return true;
        }
        return false;
    }

    protected void initializeTracking(boolean source) {
    }

    protected void setAdjusting(boolean adjusting) {
    }

    protected void showTargetFeedback(IlvGraphic target, boolean on) {
    }

    protected void processMouseEvent(MouseEvent event) {
        switch (event.getID()) {
            case 501: {
                this.mousePressed(event);
                break;
            }
            case 502: {
                this.mouseReleased(event);
            }
        }
        super.processMouseEvent(event);
    }

    protected void processMouseMotionEvent(MouseEvent event) {
        boolean allowEnsureVisible = this.allowEnsureVisible();
        this.allowEnsureVisible(false);
        switch (event.getID()) {
            case 506: {
                this.mouseDragged(event);
            }
        }
        super.processMouseMotionEvent(event);
        this.allowEnsureVisible(allowEnsureVisible);
    }

    protected void mousePressed(MouseEvent mouseevent) {
        if ((mouseevent.getModifiers() & 8) != 0 || (mouseevent.getModifiers() & 4) != 0) {
            return;
        }
        this.initialize();
        this.setInitialXPos(mouseevent.getX());
        this.setInitialYPos(mouseevent.getY());
        IlvPoint point = new IlvPoint((float)this.getInitialXPos(), (float)this.getInitialYPos());
        IlvGraphic hit = null;
        IlvSelection sel = this.getManager().getSelection(point, this.getManagerView(), true);
        if (sel != null) {
            hit = sel.getObject();
        }
        if (hit == null) {
            hit = this.getGrapher().getObject(point, this.getManagerView(), true);
        }
        if (hit != null && ((IlvManager)hit.getGraphicBag()).isSelectable(hit)) {
            if (hit instanceof IlvLinkImage) {
                IlvLinkImage link = (IlvLinkImage)hit;
                IlvPoint ilvpoint = new IlvPoint((float)mouseevent.getX(), (float)mouseevent.getY());
                IlvTransformer ilvtransformer = ((IlvManager)link.getGraphicBag()).getDrawingTransformer(this.getManagerView());
                IlvPoint srcPoint = new IlvPoint();
                IlvPoint dstPoint = new IlvPoint();
                link.getConnectionPoints(srcPoint, dstPoint, ilvtransformer);
                if ((ilvpoint.x - srcPoint.x) * (ilvpoint.x - srcPoint.x) + (ilvpoint.y - srcPoint.y) * (ilvpoint.y - srcPoint.y) < (ilvpoint.x - dstPoint.x) * (ilvpoint.x - dstPoint.x) + (ilvpoint.y - dstPoint.y) * (ilvpoint.y - dstPoint.y) ? !this.isRedirectedSubshapeLinkEnd(link, true) && !this.isSurrogateEnd(link, true) && this.initializeFromHit(hit) : !this.isRedirectedSubshapeLinkEnd(link, false) && !this.isSurrogateEnd(link, false) && this.initializeFromHit(hit)) {
                    return;
                }
            } else if (this.initializeFromHit(hit)) {
                return;
            }
        }
        this._failed = true;
        this._oldCursor = this.getManagerView().getCursor();
        this.getManagerView().setCursor(DragSource.DefaultMoveNoDrop);
    }

    protected void createAnchorTarget() {
    }

    protected void connectTarget(IlvGraphic target) throws Exception {
    }

    protected void cleanup() {
        if (this._dependentLinks != null) {
            this._dependentLinks.clear();
            this._dependentLinks = null;
        }
        if (this._recursiveLink != null) {
            this._recursiveLink.disconnect();
            this._recursiveLink = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mouseReleased(MouseEvent mouseevent) {
        if ((mouseevent.getModifiers() & 8) != 0 || (mouseevent.getModifiers() & 4) != 0) {
            return;
        }
        if (this.isFailedState()) {
            mouseevent.consume();
            if (this._oldCursor != null) {
                this.getManagerView().setCursor(this._oldCursor);
                this._oldCursor = null;
            }
            if (this.getManagerView().getInteractor() == this) {
                this.getManagerView().popInteractor();
            }
            return;
        }
        if (this.getLink() == null || this.getTrackPoint() == null) {
            return;
        }
        try {
            this.setAdjusting(true);
            if (this._policy != null) {
                ((IlvPolicyAwareLinkImage)this.getDrawLink()).setLinkShapePolicy(null);
                ((IlvPolicyAwareLinkImage)this.getLink()).setLinkShapePolicy(this._policy);
            }
            if (this.getTargetGraphic() == null) {
                this.createAnchorTarget();
            }
            if (this.getTargetGraphic() != null) {
                this.connectTarget(this.getTargetGraphic());
                this.showTargetFeedback(this.getTargetGraphic(), false);
            }
            this.endReconnection();
            this.getManagerView().setRedrawMode(this.getSavedRedrawMode());
        }
        catch (Exception ex) {
            this.endReconnection();
            this.getManagerView().setRedrawMode(this.getSavedRedrawMode());
            FeedbackManager.reportException((Throwable)ex);
        }
        finally {
            IlvGrapher grapher = (IlvGrapher)this.getLink().getGraphicBag();
            grapher.setVisible((IlvGraphic)this.getLink(), true, false);
            if (this.isAdvancedFeedbackMode()) {
                this.getGrapher().removeLink(this.getDrawLink(), true);
                this.setDrawLink(null);
                this.getGrapher().removeNode((IlvGraphic)this.getFixedNode(), true);
                this.setFixedNode(null);
                this.getGrapher().removeNode((IlvGraphic)this.getMovingNode(), true);
                this.setMovingNode(null);
            } else {
                this.getManager().initReDraws();
                try {
                    if (this._dependentLinks != null) {
                        for (IlvLinkImage dep : this._dependentLinks) {
                            ManagerUtil.getManager((IlvGraphic)dep).setVisible((IlvGraphic)dep, true, true);
                        }
                    }
                    this.invalidateSimpleFeedbackRegion(this.getSimplePoints());
                    this.setSimplePoints(null);
                }
                finally {
                    try {
                        this.getManagerView().setRedrawMode(1);
                        this.getManager().reDrawViews();
                    }
                    finally {
                        this.getManagerView().setRedrawMode(this.getSavedRedrawMode());
                    }
                }
            }
            this.setAdjusting(false);
            grapher.setSelected((IlvGraphic)this.getLink(), true, true);
            this.setLink(null);
            this.setTrackPoint(null);
            this.setTargetGraphic(null);
            this.cleanup();
            if (this.getManagerView().getInteractor() == this) {
                this.getManagerView().popInteractor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mouseDragged(MouseEvent mouseevent) {
        if (this.isFailedState()) {
            mouseevent.consume();
            return;
        }
        IlvGrapher ilvgrapher = this.getGrapher();
        if (this.getLink() != null && this.getTrackPoint() == null && (mouseevent.getX() - this.getInitialXPos()) * (mouseevent.getX() - this.getInitialXPos()) + (mouseevent.getY() - this.getInitialYPos()) * (mouseevent.getY() - this.getInitialYPos()) > 20) {
            IlvPoint ilvpoint = new IlvPoint((float)this.getInitialXPos(), (float)this.getInitialYPos());
            IlvLinkImage link = this.getLink();
            IlvTransformer ilvtransformer = ((IlvManager)link.getGraphicBag()).getDrawingTransformer(this.getManagerView());
            link.getConnectionPoints(this.getSourcePoint(), this.getDestinationPoint(), ilvtransformer);
            if ((ilvpoint.x - this.getSourcePoint().x) * (ilvpoint.x - this.getSourcePoint().x) + (ilvpoint.y - this.getSourcePoint().y) * (ilvpoint.y - this.getSourcePoint().y) < (ilvpoint.x - this.getDestinationPoint().x) * (ilvpoint.x - this.getDestinationPoint().x) + (ilvpoint.y - this.getDestinationPoint().y) * (ilvpoint.y - this.getDestinationPoint().y)) {
                this.setTrackPoint(this.getSourcePoint());
                this.setTargetGraphic(this.getLinkEnd(true));
                if (this.getTargetGraphic() != CoreGraphicUtils.getManagedParent(this.getTargetGraphic())) {
                    this.setSubshapeConnectionMode(true);
                }
                this.initializeTracking(true);
            } else {
                this.setTrackPoint(this.getDestinationPoint());
                this.setTargetGraphic(this.getLinkEnd(false));
                if (this.getTargetGraphic() != CoreGraphicUtils.getManagedParent(this.getTargetGraphic())) {
                    this.setSubshapeConnectionMode(true);
                }
                this.initializeTracking(false);
            }
            this.setSavedRedrawMode(this.getManagerView().getRedrawMode());
            this.getManagerView().setRedrawMode(1);
            try {
                this.getManager().initReDraws();
                this.setAdjusting(true);
                ManagerUtil.getManager((IlvGraphic)this.getLink()).setVisible((IlvGraphic)link, false, true);
                if (!this.isAdvancedFeedbackMode()) {
                    this._dependentLinks = this.getDependentLinks();
                    if (this._dependentLinks != null) {
                        for (IlvLinkImage dep : this._dependentLinks) {
                            ManagerUtil.getManager((IlvGraphic)dep).setVisible((IlvGraphic)dep, false, true);
                        }
                    }
                }
                IlvPoint srcPoint = new IlvPoint();
                IlvPoint dstPoint = new IlvPoint();
                IlvTransformer tlTransformer = ((IlvManager)link.getGraphicBag()).getTopLevelTransformer();
                link.getConnectionPoints(srcPoint, dstPoint, tlTransformer);
                if (this.isAdvancedFeedbackMode()) {
                    if (link instanceof IlvPolicyAwareLinkImage) {
                        IlvPolicyAwareLinkImage pl = (IlvPolicyAwareLinkImage)link;
                        this._policy = pl.getLinkShapePolicy();
                        pl.setLinkShapePolicy(null);
                    }
                    IlvLinkImage drawLink = this.copyLink(link);
                    this.setDrawLink(drawLink);
                    this._recursiveLink = new RecursiveLink(link, drawLink, this.getGrapher(), this.isReconnectingSource());
                    this.setFixedNode(new DummyNode());
                    this.setMovingNode(new DummyNode());
                    this.getGrapher().addNode((IlvGraphic)this.getFixedNode(), false);
                    this.getGrapher().addNode((IlvGraphic)this.getMovingNode(), false);
                    if (!this.isReconnectingSource()) {
                        this.getGrapher().moveObject((IlvGraphic)this.getFixedNode(), srcPoint.x, srcPoint.y, false);
                        this.getGrapher().moveObject((IlvGraphic)this.getMovingNode(), dstPoint.x, dstPoint.y, false);
                    } else {
                        this.getGrapher().moveObject((IlvGraphic)this.getFixedNode(), dstPoint.x, dstPoint.y, false);
                        this.getGrapher().moveObject((IlvGraphic)this.getMovingNode(), srcPoint.x, srcPoint.y, false);
                    }
                    if (this.isReconnectingSource()) {
                        this.getDrawLink().setFrom((IlvGraphic)this.getMovingNode());
                        this.getDrawLink().setTo((IlvGraphic)this.getFixedNode());
                        ilvlinkconnector = IlvLinkConnector.GetAttached((IlvGraphic)this.getMovingNode());
                        ilvlinkconnector.connectLink(drawLink, srcPoint, true, null);
                        ilvlinkconnector = IlvLinkConnector.GetAttached((IlvGraphic)this.getFixedNode());
                        ilvlinkconnector.connectLink(drawLink, dstPoint, false, null);
                    } else {
                        drawLink.setFrom((IlvGraphic)this.getFixedNode());
                        drawLink.setTo((IlvGraphic)this.getMovingNode());
                        ilvlinkconnector = IlvLinkConnector.GetAttached((IlvGraphic)this.getFixedNode());
                        ilvlinkconnector.connectLink(drawLink, srcPoint, true, null);
                        ilvlinkconnector = IlvLinkConnector.GetAttached((IlvGraphic)this.getMovingNode());
                        ilvlinkconnector.connectLink(drawLink, dstPoint, false, null);
                    }
                    int layer = -1;
                    if (this.getGrapher() == this.getLink().getGraphicBag()) {
                        layer = ((IlvManager)this.getLink().getGraphicBag()).getLayer((IlvGraphic)this.getLink());
                    } else {
                        IlvGrapher grapher = this.getGrapher();
                        layer = grapher.getLinksInsertionLayer();
                        int layers = this.getGrapher().getLayersCount();
                        for (int i = layers - 1; i >= 0; --i) {
                            if (!grapher.getManagerLayer(i).isVisible(this.getManagerView())) continue;
                            layer = i;
                            break;
                        }
                    }
                    this.getGrapher().addLink(drawLink, layer, false);
                    if (this._policy != null && !(this._policy instanceof Edge2EdgeLinkShapePolicy)) {
                        ((IlvPolicyAwareLinkImage)drawLink).setLinkShapePolicy(this._policy);
                    }
                    this._recursiveLink.connect(layer);
                } else if (this.isUsingAllWaypoints()) {
                    int pointCount = link.getPointsCardinal();
                    IlvPoint[] points = new IlvPoint[pointCount];
                    for (int i = 0; i < pointCount; ++i) {
                        points[i] = link.getPointAt(i, tlTransformer);
                    }
                    this.setSimplePoints(points);
                } else {
                    IlvPoint[] points = new IlvPoint[]{srcPoint, dstPoint};
                    this.setSimplePoints(points);
                }
                this.beginReconnection();
                this.showTargetFeedback(this.getTargetGraphic(), true);
            }
            finally {
                this.setAdjusting(false);
                this.getManager().reDrawViews();
            }
        }
        if (this.getLink() != null && this.getTrackPoint() != null) {
            this.getTrackPoint().move((float)mouseevent.getX(), (float)mouseevent.getY());
            Object ilvgraphic = null;
            try {
                if (this.isAdvancedFeedbackMode()) {
                    ilvgrapher.setVisible((IlvGraphic)this.getDrawLink(), false, false);
                    ilvgrapher.setVisible((IlvGraphic)this.getMovingNode(), false, false);
                }
                ilvgraphic = this.getObject(this.getTrackPoint(), this.getManagerView(), true);
            }
            finally {
                if (this.isAdvancedFeedbackMode()) {
                    ilvgrapher.setVisible((IlvGraphic)this.getMovingNode(), true, false);
                    ilvgrapher.setVisible((IlvGraphic)this.getDrawLink(), true, false);
                }
            }
            try {
                this.getGrapher().initReDraws();
                if (this.isAdvancedFeedbackMode()) {
                    this.getGrapher().invalidateRegion((IlvGraphic)this.getDrawLink());
                } else {
                    this.invalidateSimpleFeedbackRegion(this.getSimplePoints());
                }
                final IlvPoint tmpPoint = new IlvPoint((float)mouseevent.getX(), (float)mouseevent.getY());
                if (this.isAdvancedFeedbackMode()) {
                    ((IlvManager)this.getMovingNode().getGraphicBag()).getDrawingTransformer(this.getManagerView()).inverse(tmpPoint);
                    this.getGrapher().invalidateRegion((IlvGraphic)this.getMovingNode());
                    this.getGrapher().moveObject((IlvGraphic)this.getMovingNode(), tmpPoint.x, tmpPoint.y, false);
                    this.getGrapher().invalidateRegion((IlvGraphic)this.getMovingNode());
                    this.getGrapher().applyToObject((IlvGraphic)this.getDrawLink(), new IlvApplyObject(){

                        public void apply(IlvGraphic g, Object arg) {
                            IlvLinkImage l = (IlvLinkImage)g;
                            l.movePoint(CoreLinkReconnectInteractor.this.isReconnectingSource() ? 0 : l.getPointsCardinal() - 1, tmpPoint.x, tmpPoint.y, null);
                        }
                    }, null, false);
                    this.getGrapher().invalidateRegion((IlvGraphic)this.getDrawLink());
                } else {
                    this.getManager().getDrawingTransformer(this.getManagerView()).inverse(tmpPoint);
                    IlvPoint[] points = this.getSimplePoints();
                    points[this.isReconnectingSource() ? 0 : points.length - 1].setLocation(tmpPoint.x, tmpPoint.y);
                    this.invalidateSimpleFeedbackRegion(points);
                }
            }
            finally {
                this.getGrapher().reDrawViews();
            }
            IlvGraphic possibleTarget = ilvgraphic;
            if (ilvgraphic != null) {
                if (ilvgraphic instanceof IlvLinkImage) {
                    ilvgraphic = this.isLinkConnectionMode() ? (this.isValidReconnectionTarget((IlvGraphic)ilvgraphic) ? ilvgraphic : null) : null;
                } else if (this.isSubshape((IlvGraphic)ilvgraphic)) {
                    IlvGraphic managedParent = CoreGraphicUtils.getManagedParent(ilvgraphic);
                    if (managedParent instanceof IMultipresentationView) {
                        managedParent = ((IMultipresentationView)managedParent).getContainer();
                    }
                    if (!this.isSubshapeConnectionMode()) {
                        possibleTarget = managedParent;
                        if (!this.isValidReconnectionTarget(managedParent)) {
                            ilvgraphic = null;
                        }
                    } else {
                        boolean valid = false;
                        while (!(valid = this.isValidReconnectionTarget((IlvGraphic)ilvgraphic)) && ilvgraphic != managedParent) {
                            IlvGraphicBag bag;
                            for (bag = ilvgraphic.getGraphicBag(); !(bag instanceof IlvGraphic) && bag != null; bag = bag.getGraphicBag()) {
                            }
                            ilvgraphic = (IlvGraphic)bag;
                            if (!valid) continue;
                        }
                        if (!valid) {
                            ilvgraphic = null;
                        } else {
                            possibleTarget = ilvgraphic;
                        }
                    }
                } else if (ilvgraphic instanceof DummyNode) {
                    ilvgraphic = null;
                } else if (ilvgraphic instanceof IMultipresentationView) {
                    IMultipresentationView view = (IMultipresentationView)ilvgraphic;
                    assert (view.getContainer() != null);
                    possibleTarget = ilvgraphic = view.getContainer();
                    if (!this.isValidReconnectionTarget((IlvGraphic)ilvgraphic)) {
                        ilvgraphic = null;
                    }
                } else if (!this.isValidReconnectionTarget((IlvGraphic)ilvgraphic)) {
                    ilvgraphic = null;
                }
            }
            if (ilvgraphic != this.getTargetGraphic()) {
                if (this.getTargetGraphic() != null) {
                    this.showTargetFeedback(this.getTargetGraphic(), false);
                }
                this.setTargetGraphic((IlvGraphic)ilvgraphic);
                if (this.getTargetGraphic() != null) {
                    this.showTargetFeedback(this.getTargetGraphic(), true);
                }
            }
            this.updateCursor(possibleTarget, possibleTarget == this.getTargetGraphic());
        }
        this._lastDragEvent = mouseevent;
    }

    protected void updateCursor(IlvGraphic target, boolean valid) {
    }

    protected IlvGraphic getLinkEnd(boolean origin) {
        return origin ? this.getLink().getFrom() : this.getLink().getTo();
    }

    protected void invalidateSimpleFeedbackRegion(IlvPoint[] points) {
        if (points == null || points.length < 2) {
            return;
        }
        float minX = points[0].x;
        float minY = points[0].y;
        float maxX = points[0].x;
        float maxY = points[0].y;
        for (int i = 1; i < points.length; ++i) {
            float x = points[i].x;
            if (x < minX) {
                minX = x;
            } else if (x > maxX) {
                maxX = x;
            }
            float y = points[i].y;
            if (y < minY) {
                minY = y;
                continue;
            }
            if (!(y > maxY)) continue;
            maxY = y;
        }
        this._simpleTmpInvalidateRect.setRect(minX - 1.0f, minY - 1.0f, maxX - minX + 3.0f, maxY - minY + 3.0f);
        IlvLinkImage link = this.getLink();
        if (link != null && link.isOriented() && link instanceof LinkArrowRenderer) {
            IlvTransformer tx = this.getGrapher().getDrawingTransformer(this.getManagerView());
            IlvRect arrowBBox = ((LinkArrowRenderer)link).publicArrowBBox(points[points.length - 2], points[points.length - 1], tx);
            this._simpleTmpInvalidateRect.add(arrowBBox);
        }
        this.getGrapher().invalidateRegion(this._simpleTmpInvalidateRect);
    }

    protected boolean isValidReconnectionTarget(IlvGraphic target) {
        return !(target instanceof IMultipresentationView);
    }

    protected final List<IlvGrapher> getAllGraphers() {
        ArrayList<IlvGrapher> graphers = new ArrayList<IlvGrapher>(128);
        this.getAllGraphersImpl((IlvGrapher)this.getManager(), graphers);
        return graphers;
    }

    private final void getAllGraphersImpl(IlvGrapher ilvgrapher, List<IlvGrapher> graphers) {
        graphers.add(ilvgrapher);
        IlvGraphicEnumeration e = ilvgrapher.getManagers();
        while (e.hasMoreElements()) {
            IlvManager ilvmanager = (IlvManager)e.nextElement();
            if (!(ilvmanager instanceof IlvGrapher)) continue;
            this.getAllGraphersImpl((IlvGrapher)ilvmanager, graphers);
        }
    }

    protected void handleExpose(Graphics g) {
        super.handleExpose(g);
        if (!this.isAdvancedFeedbackMode()) {
            Graphics2D g2d = (Graphics2D)g;
            IlvTransformer tx = this.getGrapher().getDrawingTransformer(this.getManagerView());
            IlvPoint[] tmpPoints = this.getSimplePoints();
            if (tmpPoints != null) {
                int i;
                IlvPoint[] points = this._simpleTmpDrawPoints;
                for (i = 0; i < points.length; ++i) {
                    points[i].setLocation(tmpPoints[i].x, tmpPoints[i].y);
                    tx.apply(points[i]);
                }
                for (i = 0; i < points.length - 1; ++i) {
                    this._simpleTmpSegments[i].setLine((Point2D)points[i], (Point2D)points[i + 1]);
                }
                this.drawSimpleFeedback(g2d, this._simpleTmpSegments);
            }
        }
    }

    protected Collection<IlvLinkImage> getDependentLinks() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawSimpleFeedback(Graphics2D g, Line2D.Float[] segments) {
        Paint oldPaint = g.getPaint();
        Stroke oldStroke = g.getStroke();
        try {
            g.setPaint(Color.BLACK);
            g.setStroke(this._simpleTmpStroke);
            for (Line2D.Float s : segments) {
                g.draw(s);
            }
            IlvLinkImage link = this.getLink();
            if (link.isOriented() && link instanceof LinkArrowRenderer && segments.length > 0) {
                IlvTransformer tx = this.getGrapher().getDrawingTransformer(this.getManagerView());
                int i = 1;
                Line2D.Float endSegment = segments[segments.length - i];
                while (endSegment.getBounds().width == 0 && endSegment.getBounds().height == 0 && segments.length > i) {
                    endSegment = segments[segments.length - ++i];
                }
                ((LinkArrowRenderer)link).publicDrawArrow(g, new IlvPoint(endSegment.x1, endSegment.y1), new IlvPoint(endSegment.x2, endSegment.y2), tx);
            }
        }
        finally {
            g.setPaint(oldPaint);
            g.setStroke(oldStroke);
        }
    }

    protected Stroke createSimpleStroke(IlvLinkImage link) {
        int cap = 2;
        if (link.getEndCap() == 0) {
            cap = 0;
        } else if (link.getEndCap() == 1) {
            cap = 1;
        }
        int join = 0;
        if (link.getLineJoin() == 0) {
            join = 2;
        } else if (link.getLineJoin() == 2) {
            join = 1;
        }
        return new BasicStroke(link.getLineWidth(), cap, join, 10.0f, link.getLineStyle(), 0.0f);
    }

    protected final CoreSelectInteractor getSelectInteractor() {
        return this._selectInteractor;
    }

    protected final boolean isSubshape(IlvGraphic g) {
        return CoreGraphicUtils.getManagedParent(g) != g;
    }

    protected IlvGraphic getObject(IlvPoint p, IlvManagerView view, boolean includeSubManagers) {
        IlvGraphic sub;
        IlvGraphic hit = this.getGrapher().getObject(p, view, includeSubManagers);
        if (this.isSubshapeConnectionMode() && hit instanceof SubSelectableShape && (sub = ((SubSelectableShape)hit).getSubShape(p, view)) != null) {
            return sub;
        }
        return hit;
    }

    protected boolean isRedirectedSubshapeLinkEnd(IlvLinkImage link, boolean origin) {
        return false;
    }

    protected boolean isSurrogateEnd(IlvLinkImage link, boolean origin) {
        IlvGraphic end = origin ? link.getFrom() : link.getTo();
        IlvGraphic visibleEnd = origin ? link.getVisibleFrom() : link.getVisibleTo();
        return end != visibleEnd;
    }

    protected IlvLinkImage copyLink(IlvLinkImage link) {
        Class<?> clazz = link.getClass();
        return this.copyLinkImpl(clazz, link);
    }

    private final IlvLinkImage copyLinkImpl(Class<?> clazz, IlvLinkImage link) {
        while (clazz != null && IlvLinkImage.class.isAssignableFrom(clazz)) {
            try {
                Constructor<?> c = clazz.getDeclaredConstructor(clazz);
                IlvLinkImage newLink = (IlvLinkImage)c.newInstance(link);
                if (newLink instanceof IlvEnhancedPolylineLinkImage) {
                    ((IlvEnhancedPolylineLinkImage)newLink).setCrossingMode(0);
                }
                if (newLink instanceof IlvCrossingAwareLinkImage) {
                    ((IlvCrossingAwareLinkImage)newLink).setCrossingEnabled(false);
                }
                if (newLink instanceof IlvPolyPointsInterface && this.getGrapher() != link.getGraphicBag()) {
                    IlvTransformer tx = ManagerUtil.getConversionTransformer((IlvManager)this.getGrapher(), (IlvManager)link.getGraphicBag());
                    int points = link.getPointsCardinal();
                    for (int i = 1; i < points - 1; ++i) {
                        IlvPoint old = link.getPointAt(i, tx);
                        newLink.movePoint(i, old.x, old.y, null);
                    }
                }
                return newLink;
            }
            catch (NoSuchMethodException nsmex) {
                clazz = clazz.getSuperclass();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                break;
            }
        }
        return new IlvLinkImage(link.getFrom(), link.getTo(), link.isOriented());
    }

    protected class DummyNode
    extends IlvRectangle {
        public DummyNode() {
            this.resize(3.0f, 3.0f);
            MovablePointLinkConnector movablepointlinkconnector = new MovablePointLinkConnector();
            movablepointlinkconnector.attach((IlvGraphic)this, false);
        }

        public IlvGraphic copy() {
            return null;
        }

        public void draw(Graphics g1, IlvTransformer ilvtransformer) {
        }
    }

    private class MyTransformerListener
    implements TransformerListener {
        private MyTransformerListener() {
        }

        public void transformerChanged(TransformerChangedEvent transformerChangedEvent) {
            if (CoreLinkReconnectInteractor.this._lastDragEvent != null && CoreLinkReconnectInteractor.this.getManagerView().getInteractor() == CoreLinkReconnectInteractor.this) {
                final MouseEvent event = new MouseEvent(CoreLinkReconnectInteractor.this._lastDragEvent.getComponent(), 506, System.currentTimeMillis(), CoreLinkReconnectInteractor.this._lastDragEvent.getModifiers(), CoreLinkReconnectInteractor.this._lastDragEvent.getX(), CoreLinkReconnectInteractor.this._lastDragEvent.getY(), CoreLinkReconnectInteractor.this._lastDragEvent.getClickCount(), false, CoreLinkReconnectInteractor.this._lastDragEvent.getButton());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IlvManagerView v = CoreLinkReconnectInteractor.this.getManagerView();
                        if (v != null && v.getInteractor() == CoreLinkReconnectInteractor.this) {
                            CoreLinkReconnectInteractor.this.processEvent(event);
                        }
                    }
                });
            }
        }
    }

    private class GrapherPinSelectionFactory
    implements IlvSelectionFactory {
        private GrapherPinSelectionFactory() {
        }

        public IlvSelection makeSelection(IlvGraphic ilvgraphic) {
            IlvSelection ilvselection = null;
            if (CoreLinkReconnectInteractor.this.getSavedSelectionFactory() != null) {
                ilvselection = CoreLinkReconnectInteractor.this.getSavedSelectionFactory().makeSelection(ilvgraphic);
            }
            if (ilvselection == null) {
                ilvselection = ilvgraphic.makeSelection();
            }
            return new GrapherPinSelection(ilvgraphic, ilvselection);
        }
    }

    private class RecursiveLink {
        private RecursiveLink m_parent;
        private LinkedList<RecursiveLink> m_children;
        private IlvManager m_manager;
        private IlvLinkImage m_drawLink;
        private IlvLinkImage m_origLink;
        private IlvGrapher m_grapher;
        private GraphicConnector m_origConnector;
        private GraphicConnector m_connector;
        private IlvTransformer m_transformer;
        private boolean m_reconnectOrigin;
        private IlvPoint m_fixedConnectionPoint;

        private void findDependents() {
            Collection<GraphicPin> pins = this.m_origConnector.getPins();
            if (this.m_children == null) {
                this.m_children = new LinkedList();
            }
            LinkedList<RecursiveLink> children = this.m_children;
            for (GraphicPin pin : pins) {
                IlvLinkImage link = pin.getLink();
                if (link == null) continue;
                RecursiveLink dl = new RecursiveLink(this.m_grapher, link, this, pin.isOrigin());
                children.add(dl);
            }
        }

        private RecursiveLink(IlvGrapher grapher, IlvLinkImage link, RecursiveLink parent, boolean reconnectOrigin) {
            IlvLinkConnector otherOrigConnector;
            IlvLinkImage drawLink;
            this.m_parent = parent;
            this.m_origLink = link;
            this.m_manager = ManagerUtil.getManager((IlvGraphic)link);
            this.m_reconnectOrigin = reconnectOrigin;
            this.m_grapher = grapher;
            this.m_transformer = ManagerUtil.getConversionTransformer((IlvManager)grapher, this.m_manager);
            this.m_drawLink = drawLink = CoreLinkReconnectInteractor.this.copyLink(link);
            IlvLinkConnector otherConnector = IlvLinkConnector.Get((IlvLinkImage)drawLink, (!this.m_reconnectOrigin ? 1 : 0) != 0);
            if (otherConnector != null) {
                otherConnector.disconnectLink(drawLink, !this.m_reconnectOrigin);
            }
            if ((otherOrigConnector = IlvLinkConnector.Get((IlvLinkImage)this.m_origLink, (!this.m_reconnectOrigin ? 1 : 0) != 0)) != null) {
                this.m_fixedConnectionPoint = otherOrigConnector.getConnectionPoint(this.m_origLink, !this.m_reconnectOrigin, null);
            }
            drawLink.setFrom(null);
            drawLink.setTo(null);
            GraphicConnector gc = GraphicConnector.findConnector((IlvGraphic)link);
            if (gc != null && gc instanceof EdgeGraphicConnector) {
                this.m_origConnector = (EdgeGraphicConnector)gc;
                if (drawLink instanceof IlvPolicyAwareLinkImage) {
                    ((IlvPolicyAwareLinkImage)drawLink).setLinkShapePolicy(null);
                }
                this.findDependents();
            }
        }

        RecursiveLink(IlvLinkImage rootLink, IlvLinkImage copyRootLink, IlvGrapher grapher, boolean reconnectOrigin) {
            this.m_parent = null;
            this.m_origLink = rootLink;
            this.m_manager = ManagerUtil.getManager((IlvGraphic)rootLink);
            this.m_reconnectOrigin = reconnectOrigin;
            this.m_grapher = grapher;
            this.m_transformer = ManagerUtil.getConversionTransformer((IlvManager)grapher, this.m_manager);
            this.m_drawLink = copyRootLink;
            GraphicConnector gc = GraphicConnector.findConnector((IlvGraphic)rootLink);
            if (gc != null && gc instanceof EdgeGraphicConnector) {
                this.m_origConnector = (EdgeGraphicConnector)gc;
                this.findDependents();
            }
        }

        private IlvPoint getConnectionPoint() {
            IlvLinkConnector c = IlvLinkConnector.Get((IlvLinkImage)this.m_origLink, (boolean)this.m_reconnectOrigin);
            if (c != null) {
                return c.getConnectionPoint(this.m_origLink, this.m_reconnectOrigin, this.m_transformer);
            }
            return null;
        }

        void connect(int grapherLayer) {
            IlvLinkImage drawLink = this.m_drawLink;
            if (this.m_origConnector != null) {
                this.m_connector = GraphicConnector.findOrCreateConnector((IlvGraphic)drawLink);
            }
            if (this.m_parent != null) {
                IlvLinkShapePolicy policy = ((IlvPolicyAwareLinkImage)this.m_origLink).getLinkShapePolicy();
                if (!(policy instanceof Edge2EdgeLinkShapePolicy)) {
                    ((IlvPolicyAwareLinkImage)drawLink).setLinkShapePolicy(policy);
                }
                IlvPoint p = this.getConnectionPoint();
                FakeNode fakeNode = FakeNode.find((IlvGraphic)this.m_grapher, true);
                if (this.m_reconnectOrigin) {
                    this.m_drawLink.setTo((IlvGraphic)fakeNode);
                } else {
                    this.m_drawLink.setFrom((IlvGraphic)fakeNode);
                }
                this.m_parent.connectChild(this, p);
                IlvLinkConnector connector = IlvLinkConnector.Get((IlvLinkImage)this.m_origLink, (!this.m_reconnectOrigin ? 1 : 0) != 0);
                IlvPoint connPoint = connector.getConnectionPoint(this.m_origLink, !this.m_reconnectOrigin, null);
                IlvGraphic node = connector.getNode();
                IlvLinkConnector fakeNodeConnector = IlvLinkConnector.GetAttached((IlvGraphic)fakeNode);
                IlvTransformer t = ManagerUtil.getConversionTransformer((IlvManager)this.m_grapher, ManagerUtil.getManager(node));
                t.apply(connPoint);
                fakeNodeConnector.connectLink(this.m_drawLink, connPoint, !this.m_reconnectOrigin, null);
                this.m_grapher.addLink(drawLink, grapherLayer, false);
                this.m_manager.setVisible((IlvGraphic)this.m_origLink, false, true);
            }
            if (this.m_children != null) {
                LinkedList<RecursiveLink> deps = this.m_children;
                for (RecursiveLink dep : deps) {
                    dep.connect(grapherLayer);
                }
            }
        }

        private void connectChild(RecursiveLink child, IlvPoint p) {
            if (this.m_connector != null) {
                this.m_connector.connectLink(child.m_drawLink, p, child.m_reconnectOrigin, null);
            }
        }

        private void disconnectChild(RecursiveLink child) {
            if (this.m_connector != null) {
                this.m_connector.disconnectLink(child.m_drawLink, child.m_reconnectOrigin);
            }
        }

        void disconnect() {
            if (this.m_children != null) {
                LinkedList<RecursiveLink> deps = this.m_children;
                for (RecursiveLink dep : deps) {
                    dep.disconnect();
                }
            }
            if (this.m_parent != null) {
                this.m_parent.disconnectChild(this);
                IlvLinkConnector connector = IlvLinkConnector.Get((IlvLinkImage)this.m_drawLink, (!this.m_reconnectOrigin ? 1 : 0) != 0);
                connector.disconnectLink(this.m_drawLink, !this.m_reconnectOrigin);
                this.m_grapher.removeLink(this.m_drawLink, false);
                this.m_drawLink.setFrom(null);
                this.m_drawLink.setTo(null);
                IlvManager mgr = ManagerUtil.getManager((IlvGraphic)this.m_origLink);
                IlvPoint midPoint = LinkUtil.calcLinkMidPoint(this.m_origLink);
                GraphicConnector linkConnector = GraphicConnector.findConnector((IlvGraphic)this.m_parent.m_origLink);
                if (linkConnector != null) {
                    linkConnector.connectLink(this.m_origLink, midPoint, this.m_reconnectOrigin, null);
                }
                if (this.m_fixedConnectionPoint != null) {
                    IlvLinkConnector otherConnector = IlvLinkConnector.Get((IlvLinkImage)this.m_origLink, (!this.m_reconnectOrigin ? 1 : 0) != 0);
                    otherConnector.connectLink(this.m_origLink, this.m_fixedConnectionPoint, !this.m_reconnectOrigin, null);
                }
                mgr.setVisible((IlvGraphic)this.m_origLink, true, false);
            }
            if (this.m_connector != null) {
                this.m_connector.detach();
            }
        }
    }

    protected class MovablePointLinkConnector
    extends IlvLinkConnector {
        private IlvPoint _point = null;

        public void detach(boolean flag) {
            super.detach(flag);
            this._point = null;
        }

        public IlvPoint getConnectionPoint(IlvLinkImage ilvlinkimage, boolean flag, IlvTransformer ilvtransformer) {
            if (this._point == null) {
                return new IlvPoint(0.0f, 0.0f);
            }
            IlvPoint p = new IlvPoint(this._point);
            if (ilvtransformer != null) {
                ilvtransformer.apply(p);
            }
            return p;
        }

        public void connectLink(IlvLinkImage ilvlinkimage, IlvPoint ilvpoint, boolean flag, IlvTransformer ilvtransformer) {
            if (ilvtransformer != null) {
                ilvtransformer.inverse(ilvpoint);
            }
            if (this._point == null) {
                this._point = new IlvPoint(ilvpoint.x, ilvpoint.y);
            } else {
                this._point.move(ilvpoint.x, ilvpoint.y);
            }
        }

        public boolean zoomable() {
            return true;
        }

        public IlvPoint getClosestConnectionPoint(IlvPoint ilvpoint, Object obj, Object obj1, Object obj2, boolean flag, IlvTransformer ilvtransformer) {
            return ilvpoint;
        }

        public void linkRemoved(IlvLinkImage ilvlinkimage) {
            this._point = null;
        }

        protected void allLinksRemoved() {
            this._point = null;
        }

        public IlvRect getGhostBoundingBox(IlvTransformer ilvtransformer) {
            return new IlvRect();
        }
    }

    private class GrapherPinSelection
    extends IlvSelection {
        private IlvLinkConnector _connector;
        private IlvSelection _selection;

        public GrapherPinSelection(IlvGraphic ilvgraphic, IlvSelection ilvselection) {
            super(ilvgraphic);
            this._connector = IlvLinkConnector.GetAttached((IlvGraphic)ilvgraphic);
            this._selection = ilvselection;
        }

        public void draw(Graphics g1, IlvTransformer ilvtransformer) {
            this._selection.draw(g1, ilvtransformer);
            if (this._connector != null && this._connector.supportsDrawGhost()) {
                IlvLinkImage ilvlinkimage = CoreLinkReconnectInteractor.this.getLink();
                boolean flag = CoreLinkReconnectInteractor.this.isReconnectingSource();
                this._connector.drawGhost(g1, ilvtransformer, (Object)(flag ? this.getObject() : ilvlinkimage.getFrom()), (Object)(flag ? this.getObject() : ilvlinkimage.getTo()), (Object)ilvlinkimage, flag);
            }
        }

        public IlvRect boundingBox(IlvTransformer ilvtransformer) {
            IlvRect ilvrect = this._selection.boundingBox(ilvtransformer);
            if (this._connector != null && this._connector.supportsDrawGhost()) {
                IlvRect ilvrect1 = this._connector.getGhostBoundingBox(ilvtransformer);
                ilvrect.add(ilvrect1);
            }
            return ilvrect;
        }

        public boolean isOptimizedDrawingEnabled() {
            return false;
        }
    }
}

