/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.core.editor;

import ilog.views.IlvManagerView;
import ilog.views.IlvRect;
import ilog.views.event.ManagerChangedEvent;
import ilog.views.event.ManagerChangedListener;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentChangedListener;
import ilog.views.event.ManagerLayerEvent;
import ilog.views.event.ManagerLayerInsertedEvent;
import ilog.views.event.ManagerLayerListener;
import ilog.views.event.ManagerLayerMovedEvent;
import ilog.views.event.ManagerLayerRemovedEvent;
import ilog.views.event.ManagerLayerVisibilityEvent;
import ilog.views.event.TransformerChangedEvent;
import ilog.views.event.TransformerListener;
import ilog.views.internal.IlvUtility;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import oracle.diagram.core.editor.ScrollManagerViewPlugin;
import oracle.diagram.core.interaction.AutoscrollInteractorMarker;
import oracle.diagram.core.interaction.CoreSelectInteractor;
import oracle.diagram.core.plugin.PluginUtil;

public class ScrollManagerView
extends JComponent
implements Autoscroll,
Accessible {
    private static final Insets AUTOSCROLL_INSETS = new Insets(40, 40, 40, 40);
    private static final String SCROLL_LEFT = "oracle.diagrammer.scrollLeft";
    private static final String SCROLL_RIGHT = "oracle.diagrammer.scrollRight";
    private static final String SCROLL_UP = "oracle.diagrammer.scrollUp";
    private static final String SCROLL_DOWN = "oracle.diagrammer.scrollDown";
    private static final String PAGE_UP = "oracle.diagrammer.pageUp";
    private static final String PAGE_DOWN = "oracle.diagrammer.pageDown";
    private static final float _MARGIN = 200.0f;
    private static UI VIEW_UI;
    private IlvManagerView _view;
    private JScrollBar _vsb;
    private JScrollBar _hsb;
    private int _lastHsbValue;
    private int _lastVsbValue;
    private boolean _active;
    private Listener _listener;
    private MouseWheelAdapter _mwa = new MouseWheelAdapter();
    private boolean _doAdjustBackgroundGraphics = false;

    public ScrollManagerView(IlvManagerView ilvmanagerview) {
        this(ilvmanagerview, new JScrollBar(0), new JScrollBar(1));
    }

    public ScrollManagerView(IlvManagerView ilvmanagerview, JScrollBar hsb, JScrollBar vsb) {
        this._listener = new Listener();
        this._view = ilvmanagerview;
        this.addMouseWheelListener(this._mwa);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(null);
        this.add((Component)this._view);
        this._vsb = vsb;
        this._vsb.setUnitIncrement(10);
        if (this._vsb.getParent() == null) {
            this.add(this._vsb);
        }
        this._hsb = hsb;
        this._hsb.setUnitIncrement(10);
        if (this._hsb.getParent() == null) {
            this.add(this._hsb);
        }
        this.setOpaque(true);
        this.updateUI();
        ActionMap parentActionMap = this.getActionMap();
        ActionMap actionMap = new ActionMap();
        actionMap.setParent(parentActionMap);
        actionMap.put(SCROLL_LEFT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JScrollBar hsb = ScrollManagerView.this.getHorizontalScrollBar();
                if (hsb != null && hsb.isVisible()) {
                    IlvUtility.scrollByUnits((Adjustable)hsb, (int)-1, (int)1);
                }
            }
        });
        actionMap.put(SCROLL_RIGHT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JScrollBar hsb = ScrollManagerView.this.getHorizontalScrollBar();
                if (hsb != null && hsb.isVisible()) {
                    IlvUtility.scrollByUnits((Adjustable)hsb, (int)1, (int)1);
                }
            }
        });
        actionMap.put(SCROLL_UP, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JScrollBar vsb = ScrollManagerView.this.getVerticalScrollBar();
                if (vsb != null && vsb.isVisible()) {
                    IlvUtility.scrollByUnits((Adjustable)vsb, (int)-1, (int)1);
                }
            }
        });
        actionMap.put(SCROLL_DOWN, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JScrollBar vsb = ScrollManagerView.this.getVerticalScrollBar();
                if (vsb != null && vsb.isVisible()) {
                    IlvUtility.scrollByUnits((Adjustable)vsb, (int)1, (int)1);
                }
            }
        });
        actionMap.put(PAGE_UP, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JScrollBar vsb = ScrollManagerView.this.getVerticalScrollBar();
                if (vsb != null && vsb.isVisible() && vsb.getVisibleAmount() != vsb.getMaximum()) {
                    IlvUtility.scrollByBlock((Adjustable)vsb, (int)-1);
                } else {
                    JScrollBar hsb = ScrollManagerView.this.getHorizontalScrollBar();
                    if (hsb != null && hsb.isVisible()) {
                        IlvUtility.scrollByBlock((Adjustable)hsb, (int)-1);
                    }
                }
            }
        });
        actionMap.put(PAGE_DOWN, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JScrollBar vsb = ScrollManagerView.this.getVerticalScrollBar();
                if (vsb != null && vsb.isVisible() && vsb.getVisibleAmount() != vsb.getMaximum()) {
                    IlvUtility.scrollByBlock((Adjustable)vsb, (int)1);
                } else {
                    JScrollBar hsb = ScrollManagerView.this.getHorizontalScrollBar();
                    if (hsb != null && hsb.isVisible()) {
                        IlvUtility.scrollByBlock((Adjustable)hsb, (int)1);
                    }
                }
            }
        });
        this.setActionMap(actionMap);
        InputMap parentInputMap = this.getInputMap(1);
        InputMap inputMap = new InputMap();
        inputMap.setParent(parentInputMap);
        inputMap.put(KeyStroke.getKeyStroke(37, 0), SCROLL_LEFT);
        inputMap.put(KeyStroke.getKeyStroke(39, 0), SCROLL_RIGHT);
        inputMap.put(KeyStroke.getKeyStroke(38, 0), SCROLL_UP);
        inputMap.put(KeyStroke.getKeyStroke(40, 0), SCROLL_DOWN);
        inputMap.put(KeyStroke.getKeyStroke(33, 0), PAGE_UP);
        inputMap.put(KeyStroke.getKeyStroke(34, 0), PAGE_DOWN);
        this.setInputMap(1, inputMap);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleScrollManagerView();
        }
        return this.accessibleContext;
    }

    @Override
    public void updateUI() {
        if (VIEW_UI == null) {
            VIEW_UI = new UI();
        }
        this.setUI(VIEW_UI);
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return true;
    }

    public final JScrollBar getVerticalScrollBar() {
        return this._vsb;
    }

    public final JScrollBar getHorizontalScrollBar() {
        return this._hsb;
    }

    @Override
    public void removeNotify() {
        this._active = false;
        this._hsb.removeAdjustmentListener(this._listener);
        this._vsb.removeAdjustmentListener(this._listener);
        this._view.getManager().removeManagerContentChangedListener((ManagerContentChangedListener)this._listener);
        this._view.getManager().removeManagerLayerListener((ManagerLayerListener)this._listener);
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._view.getManager().removeManagerContentChangedListener((ManagerContentChangedListener)this._listener);
        this._view.getManager().removeManagerLayerListener((ManagerLayerListener)this._listener);
        this._view.getManager().addManagerContentChangedListener((ManagerContentChangedListener)this._listener);
        this._view.getManager().addManagerLayerListener((ManagerLayerListener)this._listener);
        this._hsb.addAdjustmentListener(this._listener);
        this._vsb.addAdjustmentListener(this._listener);
        this._active = true;
        this.adjustScrollBars();
    }

    @Override
    public void doLayout() {
        int width = this.getWidth();
        int height = this.getHeight();
        Insets insets = this.getBorder().getBorderInsets(this);
        int vsbWidth = this._vsb.getPreferredSize().width;
        int hsbHeight = this._hsb.getPreferredSize().height;
        this._view.setBounds(insets.left, insets.top, Math.max(0, width - vsbWidth - (insets.left + insets.right)), Math.max(0, height - hsbHeight - (insets.top + insets.bottom)));
        this._vsb.setBounds(width - vsbWidth - insets.right, insets.top, vsbWidth, height - hsbHeight - (insets.top + insets.bottom));
        this._hsb.setBounds(insets.left, height - hsbHeight - insets.bottom, width - vsbWidth - (insets.left + insets.right), hsbHeight);
    }

    public final IlvManagerView getView() {
        return this._view;
    }

    public final void setView(IlvManagerView ilvmanagerview) {
        if (ilvmanagerview == null) {
            throw new IllegalArgumentException("view cannot be null");
        }
        this.addImpl((Component)ilvmanagerview, null, 0);
    }

    public void adjustScrollBars() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.adjustScrollBarsImpl();
        } else {
            SwingUtilities.invokeLater(this._listener);
        }
    }

    protected IlvRect getScrollableRect() {
        ScrollManagerViewPlugin smvp = PluginUtil.getPlugin(this._view, ScrollManagerViewPlugin.class);
        if (smvp != null) {
            return smvp.getScrollableRect(this._view);
        }
        IlvRect fullViewRect = this._view.computeBBox();
        boolean hasGraphics = fullViewRect.width > 1.0f && fullViewRect.height > 1.0f;
        int displayedViewWidth = this._view.getWidth();
        int displayedViewHeight = this._view.getHeight();
        fullViewRect.width = (float)Math.floor((double)fullViewRect.width + 1.0);
        fullViewRect.height = (float)Math.floor((double)fullViewRect.height + 1.0);
        fullViewRect.x = (float)Math.floor(fullViewRect.x);
        fullViewRect.y = (float)Math.floor(fullViewRect.y);
        IlvRect displayViewRect = new IlvRect(0.0f, 0.0f, (float)displayedViewWidth, (float)displayedViewHeight);
        fullViewRect.add(displayViewRect);
        if (hasGraphics) {
            fullViewRect.width += 400.0f;
            fullViewRect.height += 400.0f;
            fullViewRect.x -= 200.0f;
            fullViewRect.y -= 200.0f;
        }
        return fullViewRect;
    }

    private void adjustBackgroundGraphics() {
        if (this._doAdjustBackgroundGraphics) {
            ScrollManagerViewPlugin smvp = PluginUtil.getPlugin(this._view, ScrollManagerViewPlugin.class);
            if (smvp != null) {
                this._view.getManager().removeManagerContentChangedListener((ManagerContentChangedListener)this._listener);
                this._view.getManager().removeManagerLayerListener((ManagerLayerListener)this._listener);
                smvp.adjustBackgroundGraphics(this._view);
                this._view.getManager().addManagerContentChangedListener((ManagerContentChangedListener)this._listener);
                this._view.getManager().addManagerLayerListener((ManagerLayerListener)this._listener);
            }
            this._doAdjustBackgroundGraphics = false;
        }
    }

    protected void adjustScrollBarsImpl() {
        if (!this._active) {
            return;
        }
        int displayedViewWidth = this._view.getWidth();
        int displayedViewHeight = this._view.getHeight();
        IlvRect fullViewRect = this.getScrollableRect();
        this._lastHsbValue = (int)(-fullViewRect.x);
        this._lastVsbValue = (int)(-fullViewRect.y);
        if (this._vsb.getValue() != this._lastVsbValue || this._vsb.getVisibleAmount() != displayedViewHeight || (float)this._vsb.getMaximum() != fullViewRect.height) {
            this._vsb.removeAdjustmentListener(this._listener);
            this._vsb.setValues(this._lastVsbValue, displayedViewHeight <= 0 ? 1 : displayedViewHeight, 0, (int)fullViewRect.height);
            this._vsb.setBlockIncrement(Math.max(this._vsb.getVisibleAmount(), 1));
            this._vsb.addAdjustmentListener(this._listener);
        }
        if (this._hsb.getValue() != this._lastHsbValue || this._hsb.getVisibleAmount() != displayedViewWidth || (float)this._hsb.getMaximum() != fullViewRect.width) {
            this._hsb.removeAdjustmentListener(this._listener);
            this._hsb.setValues(this._lastHsbValue, displayedViewWidth <= 0 ? 1 : displayedViewWidth, 0, (int)fullViewRect.width);
            this._hsb.setBlockIncrement(Math.max(this._hsb.getVisibleAmount(), 1));
            this._hsb.addAdjustmentListener(this._listener);
        }
        if (this._hsb != null) {
            this._lastHsbValue = this._hsb.getValue();
        }
        if (this._vsb != null) {
            this._lastVsbValue = this._vsb.getValue();
        }
        this._doAdjustBackgroundGraphics = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScrollManagerView.this.adjustBackgroundGraphics();
            }
        });
    }

    protected void translateView(float dx, float dy) {
        this._view.translate(dx, dy, true);
        this._doAdjustBackgroundGraphics = true;
        this.adjustBackgroundGraphics();
    }

    public void adjustView() {
        if (this._hsb.getValue() != this._lastHsbValue || this._vsb.getValue() != this._lastVsbValue) {
            this._view.removeTransformerListener((TransformerListener)this._listener);
            this._view.removeComponentListener((ComponentListener)this._listener);
            this.translateView(-(this._hsb.getValue() - this._lastHsbValue), -(this._vsb.getValue() - this._lastVsbValue));
            this._view.addTransformerListener((TransformerListener)this._listener);
            this._view.addComponentListener((ComponentListener)this._listener);
            this._lastHsbValue = this._hsb.getValue();
            this._lastVsbValue = this._vsb.getValue();
        }
    }

    public void processManagerViewKeyEvent(KeyEvent keyevent) {
        this.processKeyEvent(keyevent);
    }

    @Override
    public void paintComponent(Graphics g1) {
        g1.setColor(this.getBackground());
        Border border = this.getBorder();
        int i1 = 0;
        int j1 = 0;
        if (border != null) {
            Insets insets = border.getBorderInsets(this);
            i1 = insets.right;
            j1 = insets.bottom;
        }
        int k1 = this._vsb.getPreferredSize().width;
        int l1 = this._hsb.getPreferredSize().height;
        g1.fillRect(this.getWidth() - k1 - i1, this.getHeight() - l1 - j1, k1, l1);
        super.paintComponent(g1);
    }

    @Override
    public Insets getAutoscrollInsets() {
        return AUTOSCROLL_INSETS;
    }

    @Override
    public void autoscroll(Point point) {
        Rectangle rectExtent = this.getView().getBounds();
        Insets insets = this.getAutoscrollInsets();
        if (point.y <= rectExtent.y + insets.top && point.y >= rectExtent.y) {
            this.adjustScrollPosition(this.getVerticalScrollBar(), false);
        } else if (point.y >= rectExtent.y + rectExtent.height - insets.bottom && point.y <= rectExtent.y + rectExtent.height) {
            this.adjustScrollPosition(this.getVerticalScrollBar(), true);
        }
        if (point.x <= rectExtent.x + insets.left && point.x >= rectExtent.x) {
            this.adjustScrollPosition(this.getHorizontalScrollBar(), false);
        } else if (point.x >= rectExtent.x + rectExtent.width - insets.right && point.x <= rectExtent.x + rectExtent.width) {
            this.adjustScrollPosition(this.getHorizontalScrollBar(), true);
        }
    }

    private void adjustScrollPosition(JScrollBar bar, boolean increase) {
        if (!bar.isVisible()) {
            return;
        }
        if (this.getView().getInteractor() instanceof CoreSelectInteractor) {
            if (!((CoreSelectInteractor)this.getView().getInteractor()).canAutoscroll()) {
                return;
            }
            this.adjustScrollBars();
        } else if (this.getView().getInteractor() instanceof AutoscrollInteractorMarker) {
            this.adjustScrollBars();
        }
        int increment = bar.getUnitIncrement();
        int value = bar.getValue();
        bar.setValue(increase ? value + increment : value - increment);
    }

    @Override
    protected void addImpl(Component component, Object obj, int i1) {
        if (component instanceof IlvManagerView) {
            if (this._view != null && this._view.getParent() == this) {
                this._view.removeTransformerListener((TransformerListener)this._listener);
                this._view.removeComponentListener((ComponentListener)this._listener);
                this._view.removeManagerChangedListener((ManagerChangedListener)this._listener);
                this._view.getManager().removeManagerContentChangedListener((ManagerContentChangedListener)this._listener);
                this._view.getManager().removeManagerLayerListener((ManagerLayerListener)this._listener);
                this.remove((Component)this._view);
            }
            this._view = (IlvManagerView)component;
            this._view.addTransformerListener((TransformerListener)this._listener);
            this._view.addComponentListener((ComponentListener)this._listener);
            this._view.addManagerChangedListener((ManagerChangedListener)this._listener);
            this._view.getManager().addManagerContentChangedListener((ManagerContentChangedListener)this._listener);
            this._view.getManager().addManagerLayerListener((ManagerLayerListener)this._listener);
            this._view.setDoubleBuffering(false);
            this._view.setTransparent(false);
        }
        super.addImpl(component, obj, i1);
    }

    private class MouseWheelAdapter
    implements MouseWheelListener {
        private MouseWheelAdapter() {
        }

        public Adjustable getVerticalScrollBar() {
            return ScrollManagerView.this._vsb;
        }

        public Adjustable getHorizontalScrollBar() {
            return ScrollManagerView.this._hsb;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mousewheelevent) {
            if (mousewheelevent.getScrollAmount() != 0) {
                int direction;
                Adjustable adjustable = this.getVerticalScrollBar();
                if ((adjustable == null || adjustable.getVisibleAmount() == adjustable.getMaximum()) && (adjustable = this.getHorizontalScrollBar()) == null) {
                    return;
                }
                int n = direction = mousewheelevent.getWheelRotation() >= 0 ? 1 : -1;
                if (mousewheelevent.getScrollType() == 0) {
                    IlvUtility.scrollByUnits((Adjustable)adjustable, (int)direction, (int)mousewheelevent.getScrollAmount());
                } else if (mousewheelevent.getScrollType() == 1) {
                    IlvUtility.scrollByBlock((Adjustable)adjustable, (int)direction);
                }
            }
        }
    }

    private class Listener
    extends ComponentAdapter
    implements TransformerListener,
    ManagerContentChangedListener,
    ManagerLayerListener,
    AdjustmentListener,
    Serializable,
    Runnable,
    ManagerChangedListener {
        public void managerChanged(ManagerChangedEvent managerchangedevent) {
            if (managerchangedevent.getOldValue() != null) {
                managerchangedevent.getOldValue().removeManagerContentChangedListener((ManagerContentChangedListener)this);
                managerchangedevent.getOldValue().removeManagerLayerListener((ManagerLayerListener)this);
            }
            if (managerchangedevent.getNewValue() != null) {
                managerchangedevent.getNewValue().addManagerContentChangedListener((ManagerContentChangedListener)this);
                managerchangedevent.getNewValue().addManagerLayerListener((ManagerLayerListener)this);
            }
            ScrollManagerView.this.adjustScrollBars();
        }

        @Override
        public void componentResized(ComponentEvent componentevent) {
            ScrollManagerView.this.adjustScrollBarsImpl();
        }

        public void transformerChanged(TransformerChangedEvent transformerchangedevent) {
            ScrollManagerView.this.adjustScrollBars();
        }

        public void contentsChanged(ManagerContentChangedEvent managercontentchangedevent) {
            if (!managercontentchangedevent.isAdjusting()) {
                ScrollManagerView.this.adjustScrollBars();
                ScrollManagerView.this._doAdjustBackgroundGraphics = true;
                ScrollManagerView.this.adjustBackgroundGraphics();
            }
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentevent) {
            ScrollManagerView.this.adjustView();
        }

        public void layerInserted(ManagerLayerInsertedEvent managerlayerinsertedevent) {
            ScrollManagerView.this.adjustScrollBars();
        }

        public void layerRemoved(ManagerLayerRemovedEvent managerlayerremovedevent) {
            ScrollManagerView.this.adjustScrollBars();
        }

        public void layerMoved(ManagerLayerMovedEvent managerlayermovedevent) {
        }

        public void layerChanged(ManagerLayerEvent managerlayerevent) {
            if (managerlayerevent instanceof ManagerLayerVisibilityEvent) {
                ScrollManagerView.this.adjustScrollBars();
            }
        }

        @Override
        public void run() {
            ScrollManagerView.this.adjustScrollBarsImpl();
        }

        private Listener() {
        }
    }

    protected class AccessibleScrollManagerView
    extends JComponent.AccessibleJComponent {
        protected AccessibleScrollManagerView() {
            super(ScrollManagerView.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SCROLL_PANE;
        }
    }

    private static class UI
    extends ComponentUI {
        @Override
        public void update(Graphics g1, JComponent jcomponent) {
            ScrollManagerView ilvjscrollmanagerview = (ScrollManagerView)jcomponent;
            IlvManagerView ilvmanagerview = ilvjscrollmanagerview.getView();
            if (jcomponent.isOpaque() && (ilvmanagerview == null || ilvmanagerview.isTransparent())) {
                g1.setColor(jcomponent.getBackground());
                g1.fillRect(0, 0, jcomponent.getWidth(), jcomponent.getHeight());
            }
            this.paint(g1, jcomponent);
        }

        private UI() {
        }
    }
}

