/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.utilities;

import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.fasterxml.jackson.jr.ob.impl.DeferredMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import oracle.dbtools.utilities.SAXErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CpatJsonUtils {
    private static final LinkedHashMap<String, Integer> _summary = new LinkedHashMap();

    public CpatJsonUtils() {
        _summary.put("FATAL", 0);
        _summary.put("BLOCKER", 0);
        _summary.put("WARNING", 0);
        _summary.put("INFORMATIONAL", 0);
        _summary.put("PASS", 0);
    }

    public static Object getElement(String element, Map<String, Object> json) {
        return json.get(element);
    }

    public static List<?> getList(String element, Map<String, Object> json) {
        return (List)json.get(element);
    }

    public static Map<String, Object> getMap(String element, Object json) throws JSONObjectException, IOException {
        if (json instanceof DeferredMap) {
            return (Map)((DeferredMap)json).get((Object)element);
        }
        if (json instanceof String) {
            return JSON.std.mapFrom(json);
        }
        throw new JSONObjectException("Unknown object type");
    }

    public static Map<String, Object> getRoot(Path path) throws IOException {
        String content = Files.readString(path);
        return JSON.std.mapFrom((Object)content);
    }

    public static Map<String, Object> getRoot(String json) throws IOException {
        return JSON.std.mapFrom((Object)json);
    }

    public static LinkedHashMap<String, Integer> getSummary(Map<String, Object> json) throws JSONObjectException, IOException {
        LinkedHashMap<String, Integer> summary = new LinkedHashMap<String, Integer>(_summary);
        List<?> checkListRows = CpatJsonUtils.getList("checkList", json);
        for (Object row : checkListRows) {
            Map<String, Object> rowMap = CpatJsonUtils.toMap(row);
            String result = rowMap.get("result").toString();
            summary.put(result, summary.get(result) + 1);
        }
        return summary;
    }

    public static String listToString(List<?> list) {
        StringBuilder sb = new StringBuilder();
        for (Object o : list) {
            sb.append(o.toString() + ",");
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    public static Map<String, Object> toMap(Object json) throws JSONObjectException, IOException {
        Map map;
        if (json instanceof DeferredMap) {
            map = (Map)json;
        } else if (json instanceof String) {
            map = JSON.std.mapFrom(json);
        } else {
            throw new JSONObjectException("Unknown object type");
        }
        return map;
    }

    public static String toPrettyString(String json, int indent) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            builder.setErrorHandler(new SAXErrorHandler());
            Document document = builder.parse(new InputSource(new ByteArrayInputStream(json.getBytes("utf-8"))));
            document.normalize();
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)xPath.evaluate("//text()[normalize-space()='']", document, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                node.getParentNode().removeChild(node);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", indent);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            StringWriter stringWriter = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

