/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.commands;

import java.sql.Connection;
import java.util.Optional;
import oracle.dbtools.CpatResources;
import oracle.dbtools.commands.MigrateAdvisorOptions;
import oracle.dbtools.common.CpatArguments;
import oracle.dbtools.common.CpatModel;
import oracle.dbtools.common.CpatOptionValues;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.exceptions.ProcessFailedException;
import oracle.dbtools.executors.CpatExecutor;
import oracle.dbtools.executors.CpatPostProcessor;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.generators.CpatPreprocessor;
import oracle.dbtools.generators.HtmlReportGenerator;
import oracle.dbtools.migrateadvisor.help.Messages;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.Connected;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpBundleBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPages;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPagesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.CommandPageAssemblers;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Option;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parser;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;
import oracle.dbtools.raptor.utils.ToolLogger;
import oracle.dbtools.raptor.utils.ToolLoggerResources;
import oracle.dbtools.util.Logger;

public class MigrateAdvisorCommand
extends CommandListener
implements IHelp,
SQLCLService,
Connected {
    private static final String MIGRATEADVISOR = "migrateadvisor";
    private static final String MA = "ma";
    private static final String COMMAND_HELP_PATH = "oracle.dbtools.migrateadvisor.help.Help";
    private CpatModel _model;
    final long start = System.currentTimeMillis();

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public String getCommand() {
        return MIGRATEADVISOR;
    }

    public Class<? extends CommandListener> getCommandListener() {
        return ((Object)((Object)this)).getClass();
    }

    public String getExtensionDescription() {
        return Messages.getString("EXT_DESC");
    }

    public String getExtensionName() {
        return MIGRATEADVISOR;
    }

    public String getExtensionVersion() {
        return Messages.getString("SQLclVersion.VERSION");
    }

    public Optional<String> getHelp(ScriptRunnerContext ctx, String pagePath) {
        return this.createHelpPages(ctx, MigrateAdvisorOptions.typeCommand()).get(pagePath);
    }

    public Type getParserType() {
        return MigrateAdvisorOptions.typeCommand();
    }

    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getProperty("STRIPPED_CONTINUATION") == null) {
            cmd.setSql(ScriptUtils.checkforContinuationChars((String)cmd.getSql()));
        }
        ScriptRunnerContext.Parameters parameters = ctx.getParameterInstance();
        if (!cmd.getLoweredTrimmedSQL().startsWith(MIGRATEADVISOR) && !cmd.getLoweredTrimmedSQL().startsWith(MA)) {
            return false;
        }
        if (parameters.getParameterAsBoolean("migrateadvisor.parms", "debug").booleanValue()) {
            ctx.getParameterInstance().printParametersAsRow("migrateadvisor.parms");
        }
        if (conn == null) {
            ctx.write(CpatResources.getString("CPCMPD_CONN"));
            ctx.errorLog(ctx.getSourceRef(), Messages.getString("ApexCmd.7"), cmd.getSql());
            return true;
        }
        Parser parser = new Parser(MigrateAdvisorOptions.typeCommand(), ctx.getEnvironment());
        Optional parsedCommand = parser.parse(cmd.getSql(), error -> ctx.write(error + "\n"));
        boolean correctlyParsed = parsedCommand.isPresent();
        if (correctlyParsed) {
            for (Option option : ((ParsedCommand)parsedCommand.get()).getType().getOptions()) {
                ctx.getParameterInstance().putParameter("migrateadvisor.parms", option.getName().toLowerCase(), ((ParsedCommand)parsedCommand.get()).getOptionValue(option.getId()));
            }
            CpatArguments args = new CpatArguments(ctx);
            CpatOptionValues optionValues = new CpatOptionValues((ParsedCommand)parsedCommand.get());
            this._model = new CpatModel(conn, ctx, cmd, args, optionValues);
            this._model.getToolLogger().flushLog();
        }
        if (correctlyParsed) {
            String type;
            switch (type = ((ParsedCommand)parsedCommand.get()).getType().getId().getName().toLowerCase()) {
                case "advise": {
                    this._model.isAdvise(true);
                    this.process(ctx);
                    break;
                }
                case "properties": {
                    this._model.isProperties(true);
                    this.process(ctx);
                    break;
                }
                case "version": {
                    this._model.isInfo(true);
                    this.process(ctx);
                    break;
                }
            }
        }
        return true;
    }

    private HelpPages createHelpPages(ScriptRunnerContext ctx, Type type) {
        int lineSize = Integer.parseInt(ctx.getProperty("script.runner.setlinesize").toString());
        return new HelpPagesBuilder(ctx.getEnvironment()).lineSize(lineSize).addHelpContainer(new HelpBundleBuilder(COMMAND_HELP_PATH).build()).addHelpContainer(new HelpBundleBuilder("oracle.dbtools.migrateadvisor.help.Messages").build()).addPages((Iterable)new CommandPageAssemblers(type, new Type[0])).build();
    }

    private void process(ScriptRunnerContext ctx) {
        try {
            if (this._model.isVerbose() || this._model.isDebug()) {
                this._model.getToolLogger().logToolStart(CpatResources.getString("CP"));
            }
            if (this._model.isDebug()) {
                this._model.getToolLogger().log("debug on");
            }
            if (this._model.getConn() != null) {
                String connName = ConnectionResolver.getConnectionName((Connection)this._model.getConn());
                CpatPreprocessor preprocessor = new CpatPreprocessor(this._model);
                if (preprocessor.check()) {
                    this._model.getToolLogger().flushLog();
                    CpatExecutor executor = new CpatExecutor(this._model);
                    boolean isExec = executor.exec();
                    CpatPostProcessor post = new CpatPostProcessor(this._model);
                    post.run();
                    this._model.getToolLogger().flushLog();
                    if (this._model.isDoHtml()) {
                        HtmlReportGenerator gen = new HtmlReportGenerator(this._model);
                        gen.writeReport(this._model.getHtmlReportDir());
                    }
                }
            } else {
                this._model.getToolLogger().logError(CpatResources.getString("CPCMPD_CONN"));
            }
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                Exception e1 = ((ProcessFailedException)e).getOriginalException();
                this._model.getToolLogger().logError(e1.getLocalizedMessage());
            }
            this._model.getToolLogger().logException((Throwable)e);
            Logger.warn(((Object)((Object)this)).getClass(), (Throwable)e);
        }
        if (this._model.isVerbose() || this._model.isDebug()) {
            this._model.getToolLogger().logToolEnd();
        }
        if (ctx.getTiming()) {
            this._model.getToolLogger().log(ToolLoggerResources.format((String)"TIMINGELAPSEDTOTAL", (Object[])new Object[]{ToolLogger.getElapsedTime((long)this.start)}));
        }
        this._model.getToolLogger().flushLog();
    }

    public boolean isSqlPlus() {
        return false;
    }

    public boolean needsConnection() {
        return true;
    }
}

