/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xdo.template;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import oracle.dss.util.xdo.XDOException;
import oracle.dss.util.xdo.common.log.Logger;
import oracle.dss.util.xdo.common.tmp.TmpFile;
import oracle.dss.util.xdo.template.flash.FlashProcessorEngine;
import oracle.dss.util.xdo.template.flash.FlashProcessorProps;

@Deprecated
public class FlashProcessor {
    public static final byte FORMAT_FLASH = 1;
    public static final byte FORMAT_PDF = 2;
    public static final byte FORMAT_PPTX = 3;
    public static final byte FORMAT_MHTML = 4;
    public int mOutputType = 1;
    private InputStream mTemplateStream = null;
    private boolean mCloseTemplateStreamWhenDone = false;
    private InputStream mDataStream = null;
    private boolean mCloseDataStreamWhenDone = false;
    private OutputStream mOut = null;
    private boolean mCloseOutStreamWhenDone = false;
    private FlashProcessorProps mProps = new FlashProcessorProps();

    public FlashProcessor() {
        Logger.init();
    }

    public void setTemplate(InputStream stream) {
        this.mTemplateStream = stream;
        this.mCloseTemplateStreamWhenDone = false;
    }

    public void setTemplate(String swfFile) throws IOException {
        this.mTemplateStream = new BufferedInputStream(new FileInputStream(swfFile));
        this.mCloseTemplateStreamWhenDone = true;
    }

    public void setData(String xmlFile) throws Exception {
        this.mDataStream = new BufferedInputStream(new FileInputStream(xmlFile));
        this.mCloseDataStreamWhenDone = true;
    }

    public void setData(InputStream xmlStream) throws Exception {
        this.mDataStream = xmlStream;
        this.mCloseDataStreamWhenDone = false;
    }

    public void setOutput(OutputStream outStream) {
        this.mOut = outStream;
        this.mCloseOutStreamWhenDone = false;
    }

    public void setOutput(String outFile) throws IOException {
        this.mOut = new BufferedOutputStream(new FileOutputStream(outFile));
        this.mCloseOutStreamWhenDone = true;
    }

    public void setOutputFormat(int type) {
        this.mOutputType = type;
    }

    public void setConfig(String propName, String propValue) {
        this.mProps.setProperty(propName, propValue);
    }

    public void setConfig(Properties props) {
        this.mProps.setProperties(props);
    }

    public void process() throws XDOException, IOException {
        int n;
        byte[] buf = new byte[2048];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((n = this.mTemplateStream.read(buf, 0, buf.length)) != -1) {
            out.write(buf, 0, n);
        }
        byte[] template = out.toByteArray();
        out = new ByteArrayOutputStream();
        while ((n = this.mDataStream.read(buf, 0, buf.length)) != -1) {
            out.write(buf, 0, n);
        }
        byte[] data = out.toByteArray();
        FlashProcessorEngine fpe = new FlashProcessorEngine();
        byte[] merged = fpe.merge(template, data);
        if (this.mProps.mWidth < 0.0f) {
            this.mProps.mWidth = fpe.getWidth();
        }
        if (this.mProps.mHeight < 0.0f) {
            this.mProps.mHeight = fpe.getHeight();
        }
        switch (this.mOutputType) {
            case 1: {
                ByteArrayInputStream in = new ByteArrayInputStream(merged);
                while ((n = in.read(buf, 0, buf.length)) != -1) {
                    this.mOut.write(buf, 0, n);
                }
                break;
            }
        }
        if (this.mCloseTemplateStreamWhenDone) {
            this.mTemplateStream.close();
        }
        if (this.mCloseDataStreamWhenDone) {
            this.mDataStream.close();
        }
        if (this.mCloseOutStreamWhenDone) {
            this.mOut.close();
        }
    }

    private float inch(float in) {
        return in * 72.0f;
    }

    private float transY(float y) {
        return this.mProps.mPageHeight - y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File inFile, OutputStream out) throws IOException {
        byte[] buf = new byte[2048];
        try (FileInputStream in = null;){
            int n;
            in = new FileInputStream(inFile);
            while ((n = ((InputStream)in).read(buf, 0, buf.length)) != -1) {
                this.mOut.write(buf, 0, n);
            }
        }
    }

    private File createTmpFile(String ext) {
        File tmp = null;
        try {
            String tmpDir;
            if (this.mProps.mSystemTempDir != null) {
                tmpDir = this.mProps.mSystemTempDir;
            } else {
                Logger.log("system-temp-dir is not defined.", 5);
                tmpDir = System.getProperty("java.io.tmpdir");
            }
            tmp = TmpFile.createTmpFile("xdo", ext, tmpDir);
        }
        catch (IOException e) {
            Logger.log(e);
        }
        return tmp;
    }

    public static void main(String[] args) {
        FlashProcessor processor = new FlashProcessor();
        String[] filteredArgs = new String[3];
        int filteredIndex = 0;
        int outputFormat = 1;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-property")) {
                i += 2;
                continue;
            }
            if (args[i].equals("-d") || args[i].equals("-debug")) {
                Logger.setLevel(1);
                Logger.log("Oracle BI Publisher 11.1.1.0.0", 2);
                continue;
            }
            if (args[i].equals("-pdf")) {
                outputFormat = 2;
                continue;
            }
            if (args[i].equals("-mhtml")) {
                outputFormat = 4;
                continue;
            }
            if (filteredIndex > 2) continue;
            filteredArgs[filteredIndex] = args[i];
            ++filteredIndex;
        }
        if (filteredIndex == 3) {
            try {
                processor.setTemplate(filteredArgs[0]);
                processor.setData(filteredArgs[1]);
                processor.setOutput(filteredArgs[2]);
                processor.setOutputFormat(outputFormat);
                processor.process();
            }
            catch (Exception e) {
                Logger.log(e);
            }
        } else {
            Logger.setLevel(1);
            Logger.log("Oracle BI Publisher 11.1.1.0.0", 2);
            Logger.log("Usage: java oracle.adfinternal.view.faces.bi.util.xdo.template.FlashProcessor [-d] [-pdf] [-property PropName PropValue] Template XMLData Output", 5);
        }
    }
}

