/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xdo.common.tmp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.adf.share.mt.util.MultiTenantStorage;
import oracle.dss.util.xdo.common.log.Logger;

public class TmpFile {
    public static final String RCS_ID = "$Header: dsstools/modules/dvt-utils/src/oracle/dss/util/xdo/common/tmp/TmpFile.java /st_jdevadf_pt-14.1.2.0.0/1 2023/05/30 17:34:49 krajeswa Exp $";
    private static MultiTenantStorage<AtomicInteger> mUniqueId = new MultiTenantStorage<AtomicInteger>(){

        protected AtomicInteger initialValue() {
            return new AtomicInteger(0);
        }
    };

    private static String getRandomPrefix() {
        String chars = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        StringBuffer prefix = new StringBuffer();
        try {
            Class<?> c = Class.forName("java.security.SecureRandom");
            Method m = c.getMethod("getInstance", String.class);
            Object sr = m.invoke(null, "SHA1PRNG");
            for (int i = 0; i < 10; ++i) {
                m = c.getMethod("nextInt", Integer.TYPE);
                Integer pos = (Integer)m.invoke(sr, chars.length());
                char ch = chars.charAt(pos);
                prefix.append(ch);
            }
        }
        catch (Exception e) {
            for (int i = 0; i < 10; ++i) {
                int pos = (int)(Math.random() * 100.0) % chars.length();
                char ch = chars.charAt(pos);
                prefix.append(ch);
            }
        }
        return prefix.toString();
    }

    public static File createTmpFile(String prefix, String suffix, String dir) throws IOException {
        File f = null;
        prefix = (String)prefix + TmpFile.getRandomPrefix();
        try {
            Class<?> c = Class.forName("java.io.File");
            Method m = c.getMethod("createTempFile", String.class, String.class, File.class);
            f = (File)m.invoke(null, prefix, suffix, new File(dir));
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            f = TmpFile.createTmpFileJDK118((String)prefix, suffix, dir);
        }
        return f;
    }

    private static synchronized File createTmpFileJDK118(String prefix, String suffix, String dir) throws IOException {
        if (suffix == null) {
            suffix = ".tmp";
        }
        if (!((String)dir).endsWith(File.separator)) {
            dir = (String)dir + File.separator;
        }
        int _id = ((AtomicInteger)mUniqueId.get()).getAndIncrement();
        String path = (String)dir + prefix + Logger.getTimeStampStr() + _id + suffix;
        File f = new File(path);
        FileOutputStream out = new FileOutputStream(f);
        out.close();
        return f;
    }
}

