/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform.total;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dss.util.transform.Cube;
import oracle.dss.util.transform.DataCell;
import oracle.dss.util.transform.DataCellInterface;
import oracle.dss.util.transform.DataTable;
import oracle.dss.util.transform.EdgeTree;
import oracle.dss.util.transform.EdgeTreeNode;
import oracle.dss.util.transform.Filter;
import oracle.dss.util.transform.LayerInterface;
import oracle.dss.util.transform.MemberCell;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.MemberWrapper;
import oracle.dss.util.transform.PairRowIteratorImpl;
import oracle.dss.util.transform.QDRLite;
import oracle.dss.util.transform.ResultTable;
import oracle.dss.util.transform.Row;
import oracle.dss.util.transform.RowBasedCubicDataAccess;
import oracle.dss.util.transform.RowIterator;
import oracle.dss.util.transform.RowProjection;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TransformRuntimeException;
import oracle.dss.util.transform.total.AggColumn;
import oracle.dss.util.transform.total.AggLocation;
import oracle.dss.util.transform.total.AggMethod;
import oracle.dss.util.transform.total.AggSpec;
import oracle.dss.util.transform.total.AggType;
import oracle.dss.util.transform.total.AggWhat;
import oracle.dss.util.transform.total.TotalData;
import oracle.dss.util.transform.total.TotalMember;
import oracle.javatools.annotations.Concealed;

@Deprecated
@Concealed(value="Contact developer")
public class TotalRow
extends Row {
    protected AggSpec m_spec = null;
    protected RowProjection m_projection = null;
    protected long m_aggedRowCount = 0L;
    protected ArrayList<Row> m_rowsSeen = new ArrayList();
    protected EdgeTree.RowInfo[] m_column = null;
    protected EdgeTree.RowInfo[] m_row = null;
    protected Cube.PageRowInfo m_pri = null;

    public TotalRow(Row row, RowProjection projection, AggSpec spec) throws TransformException {
        this(row.getDataTable());
        this.m_spec = spec;
        this.m_projection = projection;
        this.setMembers(this.getTotalMembers(row.getMembers(), spec));
        this.setCells(this.getTotalCells(row));
    }

    public void setLocation(EdgeTree.RowInfo[] column, EdgeTree.RowInfo[] row, Cube.PageRowInfo pri) {
        this.m_column = column;
        this.m_row = row;
        this.m_pri = pri;
    }

    @Override
    public boolean isCalculatedValue() {
        return true;
    }

    protected TotalRow(DataTable dt) {
        super(dt);
    }

    @Override
    public void release() {
        if (this.m_spec != null) {
            this.m_spec.release();
        }
        this.m_spec = null;
        this.m_projection = null;
        this.m_column = null;
        this.m_row = null;
        super.release();
    }

    public boolean totalDuplicates() {
        return this.m_spec.getOptions().totalDuplicates();
    }

    public AggLocation getAggLocation() {
        return this.m_spec.getOptions().getAggLocation();
    }

    public TotalData getTotalData() {
        return this.m_spec.getOptions().getTotalData();
    }

    public Filter[] getAggFilter(String column) {
        AggWhat[] cols = this.m_spec.getColumnsToAggregate();
        if (cols == null || column == null) {
            return null;
        }
        AggColumn col = null;
        for (int i = 0; i < cols.length; ++i) {
            if (!(cols[i] instanceof AggColumn) || !column.equals((col = (AggColumn)cols[i]).getColumn())) continue;
            return col.getShowAggComponentFilters();
        }
        return null;
    }

    public void aggregate(Row row, QDRLite groupingKey) throws TransformException {
        if (!this.totalDuplicates() && row != null) {
            if (this.m_rowsSeen.contains(row)) {
                return;
            }
            this.m_rowsSeen.add(row);
        }
        ++this.m_aggedRowCount;
        int cellCount = this.getCells().length;
        for (int i = 0; i < cellCount; ++i) {
            ((DataCellImpl)this.getCells()[i].getDataCellInterface()).aggregate(row.getCells()[i], groupingKey, row);
        }
    }

    public boolean include() {
        return this.m_spec.getOptions().allowSingleTotals() || this.m_aggedRowCount > 1L;
    }

    @Override
    public Object clone(DataTable dt) throws CloneNotSupportedException {
        TotalRow row = new TotalRow(dt);
        row.m_spec = this.m_spec;
        row.m_projection = this.m_projection;
        row.setMembers(this.getMembers());
        DataCell[] di = this.getCells();
        DataCell[] newDI = new DataCell[di.length];
        for (int i = 0; i < newDI.length; ++i) {
            newDI[i] = new DataCell((DataCellImpl)((DataCellImpl)di[i].getDataCellInterface()).clone(), di[i].getDataCellColumnName());
        }
        row.setCells(newDI);
        row.setLocation(this.m_column, this.m_row, this.m_pri);
        return row;
    }

    protected MemberCell[] getTotalMembers(MemberCell[] members, AggSpec spec) throws TransformException {
        if (members == null) {
            return null;
        }
        MemberCell[] retVal = new MemberCell[members.length];
        AggWhat[] aggColumns = spec.getColumnsToAggregate();
        boolean isReplacement = spec.getOptions().getAggLocation() == AggLocation.REPLACE;
        block0: for (int i = 0; i < retVal.length; ++i) {
            for (int c = 0; c < aggColumns.length; ++c) {
                if (aggColumns[c] instanceof AggColumn && ((AggColumn)aggColumns[c]).getColumn().equals(members[i].getMemberColumnName())) {
                    retVal[i] = new MemberCell(new TotalMember(aggColumns[c].getMemberInterface(), isReplacement, spec.getAggMethods()), members[i].getMemberColumnName());
                    continue block0;
                }
                retVal[i] = members[i];
            }
        }
        return retVal;
    }

    protected DataCell[] getTotalCells(Row row) throws TransformException {
        DataCell[] cells;
        DataCell[] dataCellArray = cells = row != null ? row.getCells() : null;
        if (cells == null) {
            return null;
        }
        DataCell[] retVal = new DataCell[cells.length];
        for (int i = 0; i < retVal.length; ++i) {
            if (cells[i] == null) continue;
            retVal[i] = new DataCell(new DataCellImpl(cells[i], cells[i].getDataCellColumnName()), cells[i].getDataCellColumnName());
        }
        return retVal;
    }

    protected class DataCellImpl
    implements DataCellInterface {
        protected DataCell m_internalImpl = null;
        protected Map<String, LayerValue> m_layerValueMap = new HashMap<String, LayerValue>();
        protected String m_columnName = null;
        protected List<String> m_keyPaths = null;
        protected List<Object> m_rowKeys = null;
        protected List<Map<String, Object>> m_aggregates = null;
        protected List<Map<String, Object>> m_pureQDRAggs = null;
        protected List<Map<String, Object>> m_postCubeAggs = null;
        protected String m_meas = null;
        protected final String CELL_AGGS = "DataCellImplTotalCellAggs";

        public DataCellImpl(DataCell internal, String meas) throws TransformException {
            this.m_internalImpl = internal;
            this.m_meas = meas;
        }

        protected void integrateKeyPathAggs(DataCellInterface dci, String dataItem, Row row, QDRLite groupingKey) throws TransformException {
            Object keyPath = dci.getData("dataKeyPath");
            if (keyPath != null && this.m_keyPaths == null) {
                this.m_keyPaths = new ArrayList<String>();
            }
            if (keyPath instanceof List) {
                this.m_keyPaths.addAll((List)keyPath);
            } else if (keyPath instanceof String) {
                this.m_keyPaths.add((String)keyPath);
            }
            Object rowKey = dci.getData("dataRowKey");
            if (rowKey != null && this.m_rowKeys == null) {
                this.m_rowKeys = new ArrayList<Object>();
            }
            if (rowKey instanceof List) {
                this.m_rowKeys.addAll((List)rowKey);
            } else if (rowKey != null) {
                this.m_rowKeys.add(rowKey);
            }
            this.doAggregates(dci, dataItem, row, groupingKey);
        }

        private void doAggregates(DataCellInterface dci, String dataItem, Row row, QDRLite groupingKey) throws TransformException {
            if (this.m_aggregates == null) {
                this.m_aggregates = new ArrayList<Map<String, Object>>();
            }
            if (this.m_postCubeAggs == null) {
                this.m_postCubeAggs = new ArrayList<Map<String, Object>>();
            }
            QDRLite qdr = this.getAggColumns(row);
            qdr = this.getGroupingColumns(qdr, groupingKey);
            try {
                Object oldValue;
                QDRLite postQDR = (QDRLite)qdr.clone();
                String meas = groupingKey.getMeasureDim();
                if (meas != null) {
                    postQDR.addDimMemberPair(meas, dataItem);
                }
                if ((oldValue = postQDR.getDimMember("dataValue")) != null) {
                    postQDR.removeDimMemberPair("dataValue");
                    Logger.getLogger("oracle.dss.util.transform.total").log(Level.WARNING, "dataValue=" + oldValue + " removed");
                }
                postQDR.addDimMemberPair("dataValue", dci.getData("dataValue"));
                this.m_postCubeAggs.add(postQDR);
            }
            catch (CloneNotSupportedException e) {
                throw new TransformException(e.getMessage(), e);
            }
            Object subaggs = dci.getData("DataCellImplTotalCellAggs");
            if (subaggs instanceof List) {
                this.m_aggregates.addAll((List)subaggs);
            } else {
                qdr.addDimMemberPair(dataItem, dci);
                this.m_aggregates.add(qdr);
            }
        }

        private QDRLite getGroupingColumns(QDRLite qdr, QDRLite groupingKey) {
            List<String> cols = groupingKey.getColumns();
            if (cols == null) {
                return qdr;
            }
            Iterator<String> iter = cols.iterator();
            String col = null;
            while (iter.hasNext()) {
                col = iter.next();
                qdr.addDimMemberPair(col, groupingKey.getDimMember(col));
            }
            return qdr;
        }

        private QDRLite getAggColumns(Row row) throws TransformException {
            QDRLite qdr = new QDRLite();
            AggWhat[] aggs = TotalRow.this.m_spec.getColumnsToAggregate();
            if (aggs != null) {
                String col = null;
                for (int i = 0; i < aggs.length; ++i) {
                    MemberInterface mi;
                    if (!(aggs[i] instanceof AggColumn)) continue;
                    col = ((AggColumn)aggs[i]).getColumn();
                    MemberCell cell = row.getMemberCell(col);
                    MemberInterface memberInterface = mi = cell != null ? cell.getMemberInterface() : null;
                    if (mi != null) {
                        qdr.addDimMemberPair(col, mi.getMetadata("value"));
                        continue;
                    }
                    Object val = row.getExtraMemberValue(col);
                    if (val == null) continue;
                    qdr.addDimMemberPair(col, val);
                }
            }
            return qdr;
        }

        public Object clone() throws CloneNotSupportedException {
            try {
                DataCellImpl dci = new DataCellImpl(this.m_internalImpl, this.m_meas);
                Set<String> keySet = this.m_layerValueMap.keySet();
                Iterator<String> keyIter = keySet.iterator();
                String key = null;
                while (keyIter.hasNext()) {
                    key = keyIter.next();
                    dci.m_layerValueMap.put(key, (LayerValue)this.m_layerValueMap.get(key).clone());
                }
                dci.m_columnName = this.m_columnName;
                dci.m_keyPaths = new ArrayList<String>();
                dci.m_keyPaths.addAll(this.m_keyPaths);
                dci.m_rowKeys = new ArrayList<Object>();
                dci.m_rowKeys.addAll(this.m_rowKeys);
                dci.m_aggregates = new ArrayList<Map<String, Object>>();
                dci.m_aggregates.addAll(this.m_aggregates);
                dci.m_postCubeAggs = new ArrayList<Map<String, Object>>();
                dci.m_postCubeAggs.addAll(this.m_postCubeAggs);
                return dci;
            }
            catch (TransformException e) {
                throw new CloneNotSupportedException(e.getMessage());
            }
        }

        private LayerValue _getLayerValue(String type) {
            if (type.equals("dataFormattedValue")) {
                return this.m_layerValueMap.get("dataValue");
            }
            return this.m_layerValueMap.get(type);
        }

        public void aggregate(DataCell cell, QDRLite groupingKey, Row row) throws TransformException {
            if (cell == null) {
                return;
            }
            this.m_columnName = cell.getDataCellColumnName();
            String[] layerType = TotalRow.this.m_spec.getAllDataLayers();
            block8: for (int i = 0; i < layerType.length; ++i) {
                Object newVal = cell.getDataCellInterface().getData(layerType[i]);
                LayerValue lv = this._getLayerValue(layerType[i]);
                if (lv == null) {
                    lv = new LayerValue();
                    this.m_layerValueMap.put(layerType[i], lv);
                }
                AggType aggType = this.getAggType(groupingKey, lv, layerType[i]);
                if (lv.m_value != null && !(lv.m_value instanceof Number) && aggType != AggType.COUNT) {
                    if (!lv.m_seenValue) continue;
                    lv.m_value = null;
                    continue;
                }
                if (newVal != null && !(newVal instanceof Number) && aggType != AggType.COUNT) {
                    if (lv.m_seenValue) continue;
                    lv.m_value = newVal;
                    lv.m_seenValue = true;
                    continue;
                }
                if (i == 0) {
                    this.integrateKeyPathAggs(cell.getDataCellInterface(), cell.getDataCellColumnName(), row, groupingKey);
                }
                switch (aggType) {
                    case SUM: {
                        lv.m_value = this.sum((Number)lv.m_value, (Number)newVal);
                        continue block8;
                    }
                    case MIN: {
                        lv.m_value = this.min((Number)lv.m_value, (Number)newVal);
                        continue block8;
                    }
                    case MAX: {
                        lv.m_value = this.max((Number)lv.m_value, (Number)newVal);
                        continue block8;
                    }
                    case AVERAGE: {
                        lv.m_value = this.sum((Number)lv.m_value, (Number)newVal);
                        this.countValue(newVal, lv);
                        continue block8;
                    }
                    case COUNT: {
                        this.countValue(newVal, lv);
                        continue block8;
                    }
                    case STDDEV: 
                    case VARIANCE: {
                        if (lv.m_value2 != null && !(lv.m_value2 instanceof Number)) {
                            return;
                        }
                        Number n = (Number)newVal;
                        lv.m_value = this.sum((Number)lv.m_value, n);
                        if (n != null) {
                            double dN = n.doubleValue();
                            lv.m_value2 = this.sum((Number)lv.m_value2, dN * dN);
                        }
                        this.countValue(newVal, lv);
                        continue block8;
                    }
                }
            }
        }

        private boolean _isAggColumn(String[][] layout, int e, int l) {
            AggWhat[] cols = TotalRow.this.m_spec.getColumnsToAggregate();
            if (cols == null) {
                return false;
            }
            for (int i = 0; i < cols.length; ++i) {
                int[] el = cols[i].getEdgeAndLayer(layout);
                if (el == null || el.length <= 1 || el[0] != e || el[1] != l) continue;
                return true;
            }
            return false;
        }

        private String[] _getSubEdgeLayout() {
            ArrayList<String> colLayers = new ArrayList<String>();
            String[][] layout = TotalRow.this.m_projection.getLayout();
            for (int e = 0; e < layout.length; ++e) {
                if (layout[e] == null) continue;
                for (int l = 0; l < layout[e].length; ++l) {
                    if (!this._isAggColumn(layout, e, l)) continue;
                    for (int i = l; i < layout[e].length; ++i) {
                        if (colLayers.indexOf(layout[e][i]) != -1) continue;
                        colLayers.add(layout[e][i]);
                    }
                    return colLayers.toArray(new String[0]);
                }
            }
            return null;
        }

        private SubCubeProjectionImpl _getSubCubeProjection(PairRowIteratorImpl iter) throws TransformException {
            MemberInterface[] allDataItems = TotalRow.this.m_projection.getDataItems();
            MemberInterface[] dataItems = new MemberInterface[1];
            if (allDataItems != null) {
                for (int i = 0; i < allDataItems.length; ++i) {
                    if (!this.m_meas.equals(allDataItems[i].getValue())) continue;
                    dataItems[0] = allDataItems[i];
                    break;
                }
            }
            String[][] newLayout = new String[][]{this._getSubEdgeLayout(), {TotalRow.this.m_projection.getDataLayer().getValue()}};
            return new SubCubeProjectionImpl(iter, newLayout, TotalRow.this.m_projection, dataItems);
        }

        private List<Map<String, Object>> _getPureQDR() throws TransformException {
            if (this.m_aggregates == null) {
                return null;
            }
            ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> qdr : this.m_aggregates) {
                HashMap<String, Object> newMap = new HashMap<String, Object>();
                Set<String> keySet = qdr.keySet();
                for (String key : keySet) {
                    if (qdr.get(key) instanceof DataCellInterface) {
                        newMap.put(key, ((DataCellInterface)qdr.get(key)).getData("dataValue"));
                        continue;
                    }
                    newMap.put(key, qdr.get(key));
                }
                retList.add(newMap);
            }
            return retList;
        }

        @Override
        public Object getData(String type) throws TransformException {
            if (type.equals("dataIsTotal")) {
                return true;
            }
            if (type.equals("dataKeyPath")) {
                return this.m_keyPaths;
            }
            if (type.equals("dataRowKey")) {
                return this.m_rowKeys;
            }
            if (type.equals("DataCellImplTotalCellAggs")) {
                return this.m_aggregates;
            }
            if (type.equals("dataAggregates")) {
                if (this.m_pureQDRAggs == null) {
                    this.m_pureQDRAggs = this._getPureQDR();
                }
                return this.m_pureQDRAggs;
            }
            if (type.equals("aggregateCollection")) {
                return this.m_postCubeAggs;
            }
            if (type.equals("aggType")) {
                LayerValue lv = this._getLayerValue("dataValue");
                if (lv != null && lv.m_aggType != null) {
                    return lv.m_aggType.toString();
                }
                return AggType.NONE.toString();
            }
            LayerValue lv = this._getLayerValue(type);
            if (lv != null) {
                TotalData totalData;
                switch (lv.m_aggType) {
                    case FIRST: 
                    case LAST: {
                        QDRLite qdr = this._buildFirstLastQDR(lv.m_aggType);
                        DataCellInterface ci = TotalRow.this.m_projection.getData(qdr);
                        if (ci != null) {
                            return ci.getData(type);
                        }
                        return null;
                    }
                    case CUBE: {
                        if (this.m_aggregates != null) {
                            PairRowIteratorImpl iter = new PairRowIteratorImpl(this.m_aggregates);
                            if (type.equals("dataFormattedValue")) {
                                return new RowBasedCubicDataAccess(new ResultTable(this._getSubCubeProjection(iter)));
                            }
                            return iter;
                        }
                        return null;
                    }
                    case AVERAGE: {
                        TotalData totalData2;
                        if (lv.m_value instanceof String) {
                            return null;
                        }
                        Number retVal = this.div((Number)lv.m_value, lv.m_count);
                        if (type.equals("dataFormattedValue") && (totalData2 = TotalRow.this.getTotalData()) != null) {
                            return totalData2.getFormattedData(retVal, this.m_columnName, lv.m_aggType);
                        }
                        return retVal;
                    }
                    case COUNT: {
                        TotalData totalData3;
                        if (type.equals("dataFormattedValue") && (totalData3 = TotalRow.this.getTotalData()) != null) {
                            return totalData3.getFormattedData(lv.m_count, this.m_columnName, lv.m_aggType);
                        }
                        return lv.m_count;
                    }
                    case STDDEV: 
                    case VARIANCE: {
                        TotalData totalData4;
                        if (lv.m_statVal == null) {
                            if (lv.m_count == 0L) {
                                return null;
                            }
                            double sum = ((Number)lv.m_value).doubleValue();
                            long count = lv.m_count;
                            double mean = this.div(sum, count).doubleValue();
                            double sumOfSquares = ((Number)lv.m_value2).doubleValue();
                            double variance = (sumOfSquares - sum * mean) / (double)count;
                            lv.m_statVal = lv.m_aggType == AggType.VARIANCE ? Double.valueOf(variance) : Double.valueOf(Math.sqrt(variance));
                            lv.m_count = null;
                            lv.m_value = null;
                            lv.m_value2 = null;
                        }
                        if (type.equals("dataFormattedValue") && (totalData4 = TotalRow.this.getTotalData()) != null) {
                            return totalData4.getFormattedData(lv.m_statVal, this.m_columnName, lv.m_aggType);
                        }
                        return lv.m_statVal;
                    }
                }
                if (type.equals("dataFormattedValue") && (totalData = TotalRow.this.getTotalData()) != null) {
                    return totalData.getFormattedData(lv.m_value, this.m_columnName, lv.m_aggType);
                }
                return lv.m_value;
            }
            return this.m_internalImpl.getDataCellInterface().getData(type);
        }

        private QDRLite _buildPageEdges(Cube.PageRowInfo pri, QDRLite qdr) {
            if (pri == null || pri.getMembers() == null) {
                return qdr;
            }
            MemberWrapper[][][] pageVals = pri.getMembers();
            for (int e = 0; e < pageVals.length; ++e) {
                if (pageVals[e] == null) continue;
                for (int m = 0; m < pageVals[e].length; ++m) {
                    if (pageVals[e][m] == null || pri.getMeasures() != null && (pri.getMeasures() == null || !pri.getMeasures()[m].equals(this.m_meas))) continue;
                    for (int v = 0; v < pageVals[e][m].length; ++v) {
                        if (pageVals[e][m][v] == null) continue;
                        qdr.addDimMemberPair(pageVals[e][m][v].getEdgeTreeNode().getLayerName(), pageVals[e][m][v].getValue());
                    }
                }
            }
            return qdr;
        }

        private QDRLite _buildEdge(EdgeTree.RowInfo[] rowInfo, int layer, AggType aggType, QDRLite qdr) throws TransformException {
            if (rowInfo != null) {
                for (int i = 0; i < rowInfo.length; ++i) {
                    MemberWrapper[] members;
                    if (rowInfo[i].getMeasure() != null && (this.m_meas == null || !this.m_meas.equals(rowInfo[i].getMeasure())) || (members = rowInfo[i].getFullValues()) == null) continue;
                    Object value = null;
                    EdgeTreeNode node = null;
                    EdgeTreeNode parent = null;
                    MemberWrapper last = null;
                    for (int m = 0; m < members.length; ++m) {
                        if (layer == -1 || m < layer) {
                            if (members[m] == null) {
                                node = last.getEdgeTreeNode();
                            } else {
                                node = members[m].getEdgeTreeNode();
                                last = members[m];
                            }
                        } else {
                            parent = members[m] != null ? members[m].getEdgeTreeNode().getParent() : node;
                            if (parent != null) {
                                node = aggType == AggType.FIRST ? parent.getFirstChild(layer > -1) : parent.getLastChild(layer > -1);
                            }
                        }
                        if (node == null) continue;
                        qdr.addDimMemberPair(node.getLayerName(), node.getMember().getValue());
                    }
                }
            }
            return qdr;
        }

        private QDRLite _buildFirstLastQDR(AggType aggType) throws TransformException {
            int[] edgeLayer;
            AggWhat[] cols = TotalRow.this.m_spec.getColumnsToAggregate();
            if (cols != null && cols.length > 0 && (edgeLayer = cols[0].getEdgeAndLayer(TotalRow.this.m_projection.getLayout()))[0] != -1 && edgeLayer[0] < 2) {
                QDRLite qdr = new QDRLite((String)null);
                qdr = this._buildEdge(TotalRow.this.m_row, edgeLayer[0] == 1 ? edgeLayer[1] : -1, aggType, qdr);
                qdr = this._buildEdge(TotalRow.this.m_column, edgeLayer[0] == 0 ? edgeLayer[1] : -1, aggType, qdr);
                qdr = this._buildPageEdges(TotalRow.this.m_pri, qdr);
                return qdr;
            }
            return null;
        }

        protected void countValue(Object newVal, LayerValue lv) {
            if (newVal != null) {
                lv.m_count = lv.m_count + 1L;
            }
        }

        protected Number min(Number oper1, Number oper2) {
            if (oper1 == null && oper2 != null) {
                return oper2;
            }
            if (oper1 != null && oper2 == null) {
                return oper1;
            }
            if (oper1 instanceof Integer) {
                int val1 = oper1.intValue();
                if (oper2 instanceof Integer) {
                    return Math.min(val1, oper2.intValue());
                }
                if (oper2 instanceof Long) {
                    return Math.min((long)val1, oper2.longValue());
                }
                if (oper2 instanceof Float) {
                    return Float.valueOf(Math.min((float)val1, oper2.floatValue()));
                }
                if (oper2 instanceof Double) {
                    return Math.min((double)val1, oper2.doubleValue());
                }
                if (oper2 instanceof Short) {
                    return Math.min(val1, oper2.shortValue());
                }
                if (oper2 instanceof Byte) {
                    return Math.min(val1, oper2.byteValue());
                }
                if (oper2 instanceof BigInteger) {
                    return ((BigInteger)oper2).min(BigInteger.valueOf(val1));
                }
                if (oper2 instanceof BigDecimal) {
                    return ((BigDecimal)oper2).min(BigDecimal.valueOf(val1));
                }
            } else if (oper1 instanceof Long) {
                long val1 = oper1.longValue();
                if (oper2 instanceof Integer) {
                    return Math.min(val1, (long)oper2.intValue());
                }
                if (oper2 instanceof Long) {
                    return Math.min(val1, oper2.longValue());
                }
                if (oper2 instanceof Float) {
                    return Float.valueOf(Math.min((float)val1, oper2.floatValue()));
                }
                if (oper2 instanceof Double) {
                    return Math.min((double)val1, oper2.doubleValue());
                }
                if (oper2 instanceof Short) {
                    return Math.min(val1, (long)oper2.shortValue());
                }
                if (oper2 instanceof Byte) {
                    return Math.min(val1, (long)oper2.byteValue());
                }
                if (oper2 instanceof BigInteger) {
                    return ((BigInteger)oper2).min(BigInteger.valueOf(val1));
                }
                if (oper2 instanceof BigDecimal) {
                    return ((BigDecimal)oper2).min(BigDecimal.valueOf(val1));
                }
            } else if (oper1 instanceof Float) {
                float val1 = oper1.floatValue();
                if (oper2 instanceof Integer) {
                    return Float.valueOf(Math.min(val1, (float)oper2.intValue()));
                }
                if (oper2 instanceof Long) {
                    return Float.valueOf(Math.min(val1, (float)oper2.longValue()));
                }
                if (oper2 instanceof Float) {
                    return Float.valueOf(Math.min(val1, oper2.floatValue()));
                }
                if (oper2 instanceof Double) {
                    return Math.min((double)val1, oper2.doubleValue());
                }
                if (oper2 instanceof Short) {
                    return Float.valueOf(Math.min(val1, (float)oper2.shortValue()));
                }
                if (oper2 instanceof Byte) {
                    return Float.valueOf(Math.min(val1, (float)oper2.byteValue()));
                }
                if (oper2 instanceof BigInteger) {
                    return ((BigInteger)oper2).min(BigInteger.valueOf((long)val1));
                }
                if (oper2 instanceof BigDecimal) {
                    return ((BigDecimal)oper2).min(BigDecimal.valueOf(val1));
                }
            } else if (oper1 instanceof Double) {
                double val1 = oper1.doubleValue();
                if (oper2 instanceof Integer) {
                    return Math.min(val1, (double)oper2.intValue());
                }
                if (oper2 instanceof Long) {
                    return Math.min(val1, (double)oper2.longValue());
                }
                if (oper2 instanceof Float) {
                    return Math.min(val1, (double)oper2.floatValue());
                }
                if (oper2 instanceof Double) {
                    return Math.min(val1, oper2.doubleValue());
                }
                if (oper2 instanceof Short) {
                    return Math.min(val1, (double)oper2.shortValue());
                }
                if (oper2 instanceof Byte) {
                    return Math.min(val1, (double)oper2.byteValue());
                }
                if (oper2 instanceof BigInteger) {
                    return ((BigInteger)oper2).min(BigInteger.valueOf((long)val1));
                }
                if (oper2 instanceof BigDecimal) {
                    return ((BigDecimal)oper2).min(BigDecimal.valueOf(val1));
                }
            } else if (oper1 instanceof Short) {
                short val1 = oper1.shortValue();
                if (oper2 instanceof Integer) {
                    return Math.min(val1, oper2.intValue());
                }
                if (oper2 instanceof Long) {
                    return Math.min((long)val1, oper2.longValue());
                }
                if (oper2 instanceof Float) {
                    return Float.valueOf(Math.min((float)val1, oper2.floatValue()));
                }
                if (oper2 instanceof Double) {
                    return Math.min((double)val1, oper2.doubleValue());
                }
                if (oper2 instanceof Short) {
                    return Math.min(val1, oper2.shortValue());
                }
                if (oper2 instanceof Byte) {
                    return Math.min(val1, oper2.byteValue());
                }
                if (oper2 instanceof BigInteger) {
                    return ((BigInteger)oper2).min(BigInteger.valueOf(val1));
                }
                if (oper2 instanceof BigDecimal) {
                    return ((BigDecimal)oper2).min(BigDecimal.valueOf(val1));
                }
            } else if (oper1 instanceof Byte) {
                byte val1 = oper1.byteValue();
                if (oper2 instanceof Integer) {
                    return Math.min(val1, oper2.intValue());
                }
                if (oper2 instanceof Long) {
                    return Math.min((long)val1, oper2.longValue());
                }
                if (oper2 instanceof Float) {
                    return Float.valueOf(Math.min((float)val1, oper2.floatValue()));
                }
                if (oper2 instanceof Double) {
                    return Math.min((double)val1, oper2.doubleValue());
                }
                if (oper2 instanceof Short) {
                    return Math.min(val1, oper2.shortValue());
                }
                if (oper2 instanceof Byte) {
                    return Math.min(val1, oper2.byteValue());
                }
                if (oper2 instanceof BigInteger) {
                    return ((BigInteger)oper2).min(BigInteger.valueOf(val1));
                }
                if (oper2 instanceof BigDecimal) {
                    return ((BigDecimal)oper2).min(BigDecimal.valueOf(val1));
                }
            } else if (oper1 instanceof BigInteger) {
                BigInteger val1 = (BigInteger)oper1;
                if (oper2 instanceof Integer) {
                    return val1.min(BigInteger.valueOf(oper2.intValue()));
                }
                if (oper2 instanceof Long) {
                    return val1.min(BigInteger.valueOf(oper2.longValue()));
                }
                if (oper2 instanceof Float) {
                    return val1.min(BigInteger.valueOf((long)oper2.floatValue()));
                }
                if (oper2 instanceof Double) {
                    return val1.min(BigInteger.valueOf((long)oper2.doubleValue()));
                }
                if (oper2 instanceof Short) {
                    return val1.min(BigInteger.valueOf(oper2.shortValue()));
                }
                if (oper2 instanceof Byte) {
                    return val1.min(BigInteger.valueOf(oper2.byteValue()));
                }
                if (oper2 instanceof BigInteger) {
                    return val1.min((BigInteger)oper2);
                }
                if (oper2 instanceof BigDecimal) {
                    return val1.min(BigInteger.valueOf(((BigDecimal)oper2).longValue()));
                }
            } else if (oper1 instanceof BigDecimal) {
                BigDecimal val1 = (BigDecimal)oper1;
                if (oper2 instanceof Integer) {
                    return val1.min(BigDecimal.valueOf(oper2.intValue()));
                }
                if (oper2 instanceof Long) {
                    return val1.min(BigDecimal.valueOf(oper2.longValue()));
                }
                if (oper2 instanceof Float) {
                    return val1.min(BigDecimal.valueOf(oper2.floatValue()));
                }
                if (oper2 instanceof Double) {
                    return val1.min(BigDecimal.valueOf(oper2.doubleValue()));
                }
                if (oper2 instanceof Short) {
                    return val1.min(BigDecimal.valueOf(oper2.shortValue()));
                }
                if (oper2 instanceof Byte) {
                    return val1.min(BigDecimal.valueOf(oper2.byteValue()));
                }
                if (oper2 instanceof BigInteger) {
                    return val1.min(new BigDecimal((BigInteger)oper2));
                }
                if (oper2 instanceof BigDecimal) {
                    return val1.min((BigDecimal)oper2);
                }
            }
            return null;
        }

        protected Number max(Number oper1, Number oper2) {
            if (oper1 == null && oper2 != null) {
                return oper2;
            }
            if (oper1 != null && oper2 == null) {
                return oper1;
            }
            if (oper1 instanceof Integer) {
                int val1 = oper1.intValue();
                if (oper2 instanceof Integer) {
                    return Math.max(val1, oper2.intValue());
                }
                if (oper2 instanceof Long) {
                    return Math.max((long)val1, oper2.longValue());
                }
                if (oper2 instanceof Float) {
                    return Float.valueOf(Math.max((float)val1, oper2.floatValue()));
                }
                if (oper2 instanceof Double) {
                    return Math.max((double)val1, oper2.doubleValue());
                }
                if (oper2 instanceof Short) {
                    return Math.max(val1, oper2.shortValue());
                }
                if (oper2 instanceof Byte) {
                    return Math.max(val1, oper2.byteValue());
                }
                if (oper2 instanceof BigInteger) {
                    return ((BigInteger)oper2).max(BigInteger.valueOf(val1));
                }
                if (oper2 instanceof BigDecimal) {
                    return ((BigDecimal)oper2).max(BigDecimal.valueOf(val1));
                }
            } else if (oper1 instanceof Long) {
                long val1 = oper1.longValue();
                if (oper2 instanceof Integer) {
                    return Math.max(val1, (long)oper2.intValue());
                }
                if (oper2 instanceof Long) {
                    return Math.max(val1, oper2.longValue());
                }
                if (oper2 instanceof Float) {
                    return Float.valueOf(Math.max((float)val1, oper2.floatValue()));
                }
                if (oper2 instanceof Double) {
                    return Math.max((double)val1, oper2.doubleValue());
                }
                if (oper2 instanceof Short) {
                    return Math.max(val1, (long)oper2.shortValue());
                }
                if (oper2 instanceof Byte) {
                    return Math.max(val1, (long)oper2.byteValue());
                }
                if (oper2 instanceof BigInteger) {
                    return ((BigInteger)oper2).max(BigInteger.valueOf(val1));
                }
                if (oper2 instanceof BigDecimal) {
                    return ((BigDecimal)oper2).max(BigDecimal.valueOf(val1));
                }
            } else if (oper1 instanceof Float) {
                float val1 = oper1.floatValue();
                if (oper2 instanceof Integer) {
                    return Float.valueOf(Math.max(val1, (float)oper2.intValue()));
                }
                if (oper2 instanceof Long) {
                    return Float.valueOf(Math.max(val1, (float)oper2.longValue()));
                }
                if (oper2 instanceof Float) {
                    return Float.valueOf(Math.max(val1, oper2.floatValue()));
                }
                if (oper2 instanceof Double) {
                    return Math.max((double)val1, oper2.doubleValue());
                }
                if (oper2 instanceof Byte) {
                    return Float.valueOf(Math.max(val1, (float)oper2.byteValue()));
                }
                if (oper2 instanceof Short) {
                    return Float.valueOf(Math.max(val1, (float)oper2.shortValue()));
                }
                if (oper2 instanceof BigInteger) {
                    return ((BigInteger)oper2).max(BigInteger.valueOf((long)val1));
                }
                if (oper2 instanceof BigDecimal) {
                    return ((BigDecimal)oper2).max(BigDecimal.valueOf(val1));
                }
            } else if (oper1 instanceof Double) {
                double val1 = oper1.doubleValue();
                if (oper2 instanceof Integer) {
                    return Math.max(val1, (double)oper2.intValue());
                }
                if (oper2 instanceof Long) {
                    return Math.max(val1, (double)oper2.longValue());
                }
                if (oper2 instanceof Float) {
                    return Math.max(val1, (double)oper2.floatValue());
                }
                if (oper2 instanceof Double) {
                    return Math.max(val1, oper2.doubleValue());
                }
                if (oper2 instanceof Byte) {
                    return Math.max(val1, (double)oper2.byteValue());
                }
                if (oper2 instanceof Short) {
                    return Math.max(val1, (double)oper2.shortValue());
                }
                if (oper2 instanceof BigInteger) {
                    return ((BigInteger)oper2).max(BigInteger.valueOf((long)val1));
                }
                if (oper2 instanceof BigDecimal) {
                    return ((BigDecimal)oper2).max(BigDecimal.valueOf(val1));
                }
            } else if (oper1 instanceof Short) {
                short val1 = oper1.shortValue();
                if (oper2 instanceof Integer) {
                    return Math.max(val1, oper2.intValue());
                }
                if (oper2 instanceof Long) {
                    return Math.max((long)val1, oper2.longValue());
                }
                if (oper2 instanceof Float) {
                    return Float.valueOf(Math.max((float)val1, oper2.floatValue()));
                }
                if (oper2 instanceof Double) {
                    return Math.max((double)val1, oper2.doubleValue());
                }
                if (oper2 instanceof Short) {
                    return Math.max(val1, oper2.shortValue());
                }
                if (oper2 instanceof BigInteger) {
                    return ((BigInteger)oper2).max(BigInteger.valueOf(val1));
                }
                if (oper2 instanceof BigDecimal) {
                    return ((BigDecimal)oper2).max(BigDecimal.valueOf(val1));
                }
            } else if (oper1 instanceof Byte) {
                byte val1 = oper1.byteValue();
                if (oper2 instanceof Integer) {
                    return Math.max(val1, oper2.intValue());
                }
                if (oper2 instanceof Long) {
                    return Math.max((long)val1, oper2.longValue());
                }
                if (oper2 instanceof Float) {
                    return Float.valueOf(Math.max((float)val1, oper2.floatValue()));
                }
                if (oper2 instanceof Double) {
                    return Math.max((double)val1, oper2.doubleValue());
                }
                if (oper2 instanceof Short) {
                    return Math.max(val1, oper2.shortValue());
                }
                if (oper2 instanceof BigInteger) {
                    return ((BigInteger)oper2).max(BigInteger.valueOf(val1));
                }
                if (oper2 instanceof BigDecimal) {
                    return ((BigDecimal)oper2).max(BigDecimal.valueOf(val1));
                }
            } else if (oper1 instanceof BigInteger) {
                BigInteger val1 = (BigInteger)oper1;
                if (oper2 instanceof Integer) {
                    return val1.max(BigInteger.valueOf(oper2.intValue()));
                }
                if (oper2 instanceof Long) {
                    return val1.max(BigInteger.valueOf(oper2.longValue()));
                }
                if (oper2 instanceof Float) {
                    return val1.max(BigInteger.valueOf((long)oper2.floatValue()));
                }
                if (oper2 instanceof Double) {
                    return val1.max(BigInteger.valueOf((long)oper2.doubleValue()));
                }
                if (oper2 instanceof Short) {
                    return val1.max(BigInteger.valueOf(oper2.shortValue()));
                }
                if (oper2 instanceof Byte) {
                    return val1.max(BigInteger.valueOf(oper2.byteValue()));
                }
                if (oper2 instanceof BigInteger) {
                    return val1.max((BigInteger)oper2);
                }
                if (oper2 instanceof BigDecimal) {
                    return val1.max(BigInteger.valueOf(((BigDecimal)oper2).longValue()));
                }
            } else if (oper1 instanceof BigDecimal) {
                BigDecimal val1 = (BigDecimal)oper1;
                if (oper2 instanceof Integer) {
                    return val1.max(BigDecimal.valueOf(oper2.intValue()));
                }
                if (oper2 instanceof Long) {
                    return val1.max(BigDecimal.valueOf(oper2.longValue()));
                }
                if (oper2 instanceof Float) {
                    return val1.max(BigDecimal.valueOf(oper2.floatValue()));
                }
                if (oper2 instanceof Double) {
                    return val1.max(BigDecimal.valueOf(oper2.doubleValue()));
                }
                if (oper2 instanceof Short) {
                    return val1.max(BigDecimal.valueOf(oper2.shortValue()));
                }
                if (oper2 instanceof Byte) {
                    return val1.max(BigDecimal.valueOf(oper2.byteValue()));
                }
                if (oper2 instanceof BigInteger) {
                    return val1.max(new BigDecimal((BigInteger)oper2));
                }
                if (oper2 instanceof BigDecimal) {
                    return val1.max((BigDecimal)oper2);
                }
            }
            return null;
        }

        protected Number sum(Number oper1, Number oper2) {
            if (oper1 == null && oper2 != null) {
                return oper2;
            }
            if (oper1 != null && oper2 == null) {
                return oper1;
            }
            if (oper1 instanceof Integer) {
                int val1 = oper1.intValue();
                if (oper2 instanceof Integer) {
                    return (long)(val1 + oper2.intValue());
                }
                if (oper2 instanceof Long) {
                    return (long)val1 + oper2.longValue();
                }
                if (oper2 instanceof Float) {
                    return (double)((float)val1 + oper2.floatValue());
                }
                if (oper2 instanceof Double) {
                    return (double)val1 + oper2.doubleValue();
                }
                if (oper2 instanceof Short) {
                    return (long)(val1 + oper2.shortValue());
                }
                if (oper2 instanceof Byte) {
                    return (long)(val1 + oper2.byteValue());
                }
                if (oper2 instanceof BigInteger) {
                    return ((BigInteger)oper2).add(BigInteger.valueOf(val1));
                }
                if (oper2 instanceof BigDecimal) {
                    return ((BigDecimal)oper2).add(BigDecimal.valueOf(val1));
                }
            } else if (oper1 instanceof Long) {
                long val1 = oper1.longValue();
                if (oper2 instanceof Integer) {
                    return val1 + (long)oper2.intValue();
                }
                if (oper2 instanceof Long) {
                    return val1 + oper2.longValue();
                }
                if (oper2 instanceof Float) {
                    return Float.valueOf((float)val1 + oper2.floatValue());
                }
                if (oper2 instanceof Double) {
                    return (double)val1 + oper2.doubleValue();
                }
                if (oper2 instanceof Short) {
                    return val1 + (long)oper2.shortValue();
                }
                if (oper2 instanceof Byte) {
                    return val1 + (long)oper2.byteValue();
                }
                if (oper2 instanceof BigInteger) {
                    return ((BigInteger)oper2).add(BigInteger.valueOf(val1));
                }
                if (oper2 instanceof BigDecimal) {
                    return ((BigDecimal)oper2).add(BigDecimal.valueOf(val1));
                }
            } else if (oper1 instanceof Float) {
                float val1 = oper1.floatValue();
                if (oper2 instanceof Integer) {
                    return Float.valueOf(val1 + (float)oper2.intValue());
                }
                if (oper2 instanceof Long) {
                    return Float.valueOf(val1 + (float)oper2.longValue());
                }
                if (oper2 instanceof Float) {
                    return Float.valueOf(val1 + oper2.floatValue());
                }
                if (oper2 instanceof Double) {
                    return (double)val1 + oper2.doubleValue();
                }
                if (oper2 instanceof Short) {
                    return (double)(val1 + (float)oper2.shortValue());
                }
                if (oper2 instanceof Byte) {
                    return (double)(val1 + (float)oper2.byteValue());
                }
                if (oper2 instanceof BigInteger) {
                    return ((BigInteger)oper2).add(BigInteger.valueOf((long)val1));
                }
                if (oper2 instanceof BigDecimal) {
                    return ((BigDecimal)oper2).add(BigDecimal.valueOf(val1));
                }
            } else if (oper1 instanceof Double) {
                double val1 = oper1.doubleValue();
                if (oper2 instanceof Integer) {
                    return val1 + (double)oper2.intValue();
                }
                if (oper2 instanceof Long) {
                    return val1 + (double)oper2.longValue();
                }
                if (oper2 instanceof Float) {
                    return val1 + (double)oper2.floatValue();
                }
                if (oper2 instanceof Double) {
                    return val1 + oper2.doubleValue();
                }
                if (oper2 instanceof Short) {
                    return val1 + (double)oper2.shortValue();
                }
                if (oper2 instanceof Byte) {
                    return val1 + (double)oper2.byteValue();
                }
                if (oper2 instanceof BigInteger) {
                    return ((BigInteger)oper2).add(BigInteger.valueOf((long)val1));
                }
                if (oper2 instanceof BigDecimal) {
                    return ((BigDecimal)oper2).add(BigDecimal.valueOf(val1));
                }
            } else if (oper1 instanceof Short) {
                short val1 = oper1.shortValue();
                if (oper2 instanceof Integer) {
                    return (long)(val1 + oper2.intValue());
                }
                if (oper2 instanceof Long) {
                    return (long)val1 + oper2.longValue();
                }
                if (oper2 instanceof Float) {
                    return (double)((float)val1 + oper2.floatValue());
                }
                if (oper2 instanceof Double) {
                    return (double)val1 + oper2.doubleValue();
                }
                if (oper2 instanceof Short) {
                    return (long)(val1 + oper2.shortValue());
                }
                if (oper2 instanceof Byte) {
                    return (long)(val1 + oper2.byteValue());
                }
                if (oper2 instanceof BigInteger) {
                    return ((BigInteger)oper2).add(BigInteger.valueOf(val1));
                }
                if (oper2 instanceof BigDecimal) {
                    return ((BigDecimal)oper2).add(BigDecimal.valueOf(val1));
                }
            } else if (oper1 instanceof Byte) {
                byte val1 = oper1.byteValue();
                if (oper2 instanceof Integer) {
                    return (long)(val1 + oper2.intValue());
                }
                if (oper2 instanceof Long) {
                    return (long)val1 + oper2.longValue();
                }
                if (oper2 instanceof Float) {
                    return (double)((float)val1 + oper2.floatValue());
                }
                if (oper2 instanceof Double) {
                    return (double)val1 + oper2.doubleValue();
                }
                if (oper2 instanceof Short) {
                    return (long)(val1 + oper2.shortValue());
                }
                if (oper2 instanceof Byte) {
                    return (long)(val1 + oper2.byteValue());
                }
                if (oper2 instanceof BigInteger) {
                    return ((BigInteger)oper2).add(BigInteger.valueOf(val1));
                }
                if (oper2 instanceof BigDecimal) {
                    return ((BigDecimal)oper2).add(BigDecimal.valueOf(val1));
                }
            } else if (oper1 instanceof BigInteger) {
                BigInteger val1 = (BigInteger)oper1;
                if (oper2 instanceof Integer) {
                    return val1.add(BigInteger.valueOf(oper2.intValue()));
                }
                if (oper2 instanceof Long) {
                    return val1.add(BigInteger.valueOf(oper2.longValue()));
                }
                if (oper2 instanceof Float) {
                    return val1.add(BigInteger.valueOf((long)oper2.floatValue()));
                }
                if (oper2 instanceof Double) {
                    return val1.add(BigInteger.valueOf((long)oper2.doubleValue()));
                }
                if (oper2 instanceof Short) {
                    return val1.add(BigInteger.valueOf(oper2.shortValue()));
                }
                if (oper2 instanceof Byte) {
                    return val1.add(BigInteger.valueOf(oper2.byteValue()));
                }
                if (oper2 instanceof BigInteger) {
                    return val1.add((BigInteger)oper2);
                }
                if (oper2 instanceof BigDecimal) {
                    return val1.add(BigInteger.valueOf(((BigDecimal)oper2).longValue()));
                }
            } else if (oper1 instanceof BigDecimal) {
                BigDecimal val1 = (BigDecimal)oper1;
                if (oper2 instanceof Integer) {
                    return val1.add(BigDecimal.valueOf(oper2.intValue()));
                }
                if (oper2 instanceof Long) {
                    return val1.add(BigDecimal.valueOf(oper2.longValue()));
                }
                if (oper2 instanceof Float) {
                    return val1.add(BigDecimal.valueOf(oper2.floatValue()));
                }
                if (oper2 instanceof Double) {
                    return val1.add(BigDecimal.valueOf(oper2.doubleValue()));
                }
                if (oper2 instanceof Short) {
                    return val1.add(BigDecimal.valueOf(oper2.shortValue()));
                }
                if (oper2 instanceof Byte) {
                    return val1.add(BigDecimal.valueOf(oper2.byteValue()));
                }
                if (oper2 instanceof BigInteger) {
                    return val1.add(new BigDecimal((BigInteger)oper2));
                }
                if (oper2 instanceof BigDecimal) {
                    return val1.add((BigDecimal)oper2);
                }
            }
            return null;
        }

        protected Number div(Number oper1, Long oper2) {
            long val2 = oper2;
            if (oper1 instanceof Integer) {
                return Math.round((long)oper1.intValue() / val2);
            }
            if (oper1 instanceof Long) {
                return Math.round(oper1.doubleValue() / (double)val2);
            }
            if (oper1 instanceof Float) {
                return Float.valueOf(oper1.floatValue() / (float)val2);
            }
            if (oper1 instanceof Double) {
                return oper1.doubleValue() / (double)val2;
            }
            if (oper1 instanceof Short) {
                return (short)Math.round((long)oper1.shortValue() / val2);
            }
            if (oper1 instanceof Byte) {
                return (byte)Math.round((long)oper1.byteValue() / val2);
            }
            if (oper1 instanceof BigInteger) {
                return ((BigInteger)oper1).divide(BigInteger.valueOf(val2));
            }
            if (oper1 instanceof BigDecimal) {
                try {
                    return ((BigDecimal)oper1).divide(BigDecimal.valueOf(val2));
                }
                catch (ArithmeticException e) {
                    return ((BigDecimal)oper1).divide(BigDecimal.valueOf(val2), MathContext.DECIMAL32);
                }
            }
            return null;
        }

        protected boolean isGroupingMatch(QDRLite qdr, QDRLite groupingKey) {
            return qdr.isSupersetOf(groupingKey);
        }

        protected AggType getAggType(QDRLite groupingKey, LayerValue lv, String layerType) throws TransformException {
            if (lv.m_aggType != null) {
                return lv.m_aggType;
            }
            AggMethod[] methods = TotalRow.this.m_spec.getAggMethods();
            if (methods == null) {
                lv.m_aggType = AggType.NONE;
                return lv.m_aggType;
            }
            QDRLite qdr = null;
            String measColName = this.m_internalImpl.getDataCellColumnName();
            try {
                for (int i = 0; i < methods.length; ++i) {
                    qdr = methods[i].getQDRLite();
                    if (qdr == null) {
                        lv.m_aggType = methods[i].getAggType(layerType);
                        return lv.m_aggType;
                    }
                    QDRLite groupingKeyClone = (QDRLite)groupingKey.clone();
                    LayerInterface li = TotalRow.this.m_projection.getDataLayer();
                    groupingKeyClone.addDimMemberPair(li != null ? li.getValue() : null, measColName);
                    boolean groupingMatch = this.isGroupingMatch(qdr, groupingKeyClone);
                    if (groupingMatch) {
                        lv.m_aggType = methods[i].getAggType(layerType);
                        return lv.m_aggType;
                    }
                    if (lv.m_aggType != null) continue;
                    lv.m_aggType = AggType.NONE;
                }
            }
            catch (CloneNotSupportedException e) {
                throw new TransformException(e.getMessage(), e);
            }
            return lv.m_aggType;
        }

        @Override
        public boolean setData(Object value, String type) throws TransformException {
            return this.m_internalImpl.getDataCellInterface().setData(value, type);
        }

        private class LayerValue {
            protected Object m_value = null;
            protected boolean m_seenValue = false;
            protected Object m_value2 = null;
            protected Number m_statVal = null;
            protected Long m_count = 0L;
            protected AggType m_aggType = null;

            public LayerValue() {
            }

            public LayerValue(Object value, boolean seenValue, Object value2, Number statVal, Long count, AggType aggType) {
                this.m_value = value;
                this.m_seenValue = seenValue;
                this.m_value2 = value2;
                this.m_statVal = statVal;
                this.m_count = count;
                this.m_aggType = aggType;
            }

            public Object clone() throws CloneNotSupportedException {
                return new LayerValue(this.m_value, this.m_seenValue, this.m_value2, this.m_statVal, this.m_count, this.m_aggType);
            }
        }
    }

    protected class SubCubeProjectionImpl
    implements RowProjection {
        protected PairRowIteratorImpl m_iter = null;
        protected String[][] m_layout = null;
        protected MemberInterface[] m_dataItems = null;
        protected RowProjection m_masterProj = null;

        public SubCubeProjectionImpl(PairRowIteratorImpl iter, String[][] layout, RowProjection masterProj, MemberInterface[] dataItems) {
            this.m_iter = iter;
            this.m_layout = layout;
            this.m_masterProj = masterProj;
            this.m_dataItems = dataItems;
        }

        @Override
        public String[][] getLayout() {
            return this.m_layout;
        }

        @Override
        public LayerInterface getDataLayer() {
            return this.m_masterProj.getDataLayer();
        }

        @Override
        public MemberInterface[] getDataItems() {
            return this.m_dataItems;
        }

        @Override
        public DataCellInterface getData(Map<String, Object> keyPath) {
            List<Map<String, Object>> pairs = this.m_iter.getPairs();
            String dataCol = null;
            String dataLayer = null;
            try {
                dataLayer = this.getDataLayer().getValue();
                dataCol = (String)keyPath.get(dataLayer);
            }
            catch (TransformException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
            for (Map<String, Object> pair : pairs) {
                Set<String> cols = keyPath.keySet();
                boolean found = true;
                for (String col : cols) {
                    if (col.equals(dataLayer) || pair.get(col).equals(keyPath.get(col))) continue;
                    found = false;
                    break;
                }
                if (!found || dataCol == null || !(pair.get(dataCol) instanceof DataCellInterface)) continue;
                return (DataCellInterface)pair.get(dataCol);
            }
            return null;
        }

        @Override
        public RowIterator getRowIterator() {
            return this.m_iter;
        }

        @Override
        public LayerInterface getLayer(String layer) {
            return TotalRow.this.m_projection.getLayer(layer);
        }

        @Override
        public String[] getIgnoredColumns() {
            return null;
        }
    }
}

