/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dss.util.transform.CollapseableMemberImpl;
import oracle.dss.util.transform.LayerInterface;
import oracle.dss.util.transform.LayerInterfaceWrapper;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TreeNode;
import oracle.javatools.annotations.Concealed;

@Deprecated
@Concealed
public class TreeNodeImpl
implements TreeNode {
    protected LayerInterface m_layerInt = null;
    protected MemberInterface m_memberInt = null;
    protected List<TreeNodeImpl> m_children = new ArrayList<TreeNodeImpl>();
    protected HashMap<String, TreeNodeImpl[]> m_childMap = new HashMap();
    protected TreeNodeImpl m_parent = null;
    protected int m_edge = -1;

    public TreeNodeImpl() {
    }

    public TreeNodeImpl(MemberInterface member, TreeNodeImpl parent, LayerInterface layer, String layerType, int edge) {
        this();
        this.setup(member, parent, layer, layerType, edge);
    }

    protected void setup(MemberInterface member, TreeNodeImpl parent, LayerInterface layer, String layerType, int edge) {
        this.m_layerInt = layerType != null && !layerType.equals("layerName") ? new LayerInterfaceWrapper(layer, layerType) : layer;
        this.m_memberInt = member instanceof CollapseableMemberImpl ? member : new CollapseableMemberImpl(member);
        this.m_parent = parent;
        this.m_edge = edge;
    }

    public boolean isLastNode() {
        TreeNodeImpl firstChild = (TreeNodeImpl)this.getFirstChild();
        if (firstChild == null) {
            return true;
        }
        return firstChild.getEdge() != this.getEdge();
    }

    public int getEdge() {
        return this.m_edge;
    }

    public void addChild(TreeNodeImpl node) throws TransformException {
        this.m_children.add(node);
        this._addChildToMap(node);
    }

    private void _addChildToMap(TreeNodeImpl node) throws TransformException {
        String key = node.getMember().getValue();
        TreeNodeImpl[] nodes = this.m_childMap.get(key);
        if (nodes == null) {
            nodes = new TreeNodeImpl[]{node};
            this.m_childMap.put(key, nodes);
        } else {
            TreeNodeImpl[] newNodes = new TreeNodeImpl[nodes.length + 1];
            System.arraycopy(nodes, 0, newNodes, 0, nodes.length);
            newNodes[newNodes.length - 1] = node;
            this.m_childMap.put(key, newNodes);
        }
    }

    public void insertChild(TreeNodeImpl locToInsert, TreeNodeImpl nodeToInsert) throws TransformException {
        int pos = this.m_children.lastIndexOf(locToInsert);
        if (pos > -1 && pos < this.m_children.size() - 1) {
            this.m_children.add(pos + 1, nodeToInsert);
            this._addChildToMap(nodeToInsert);
        } else {
            this.addChild(nodeToInsert);
        }
    }

    public TreeNodeImpl findChild(String value) throws TransformException {
        TreeNodeImpl[] nodes = this.m_childMap.get(value);
        if (nodes != null && nodes.length > 0) {
            return nodes[0];
        }
        return null;
    }

    public TreeNodeImpl findLastEdgeChild(String value) throws TransformException {
        TreeNodeImpl[] nodes = this.m_childMap.get(value);
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                if (!nodes[i].isLastNode()) continue;
                return nodes[i];
            }
        }
        return null;
    }

    @Override
    public TreeNode getParent() {
        return this.m_parent;
    }

    @Override
    public MemberInterface getMember() {
        return this.m_memberInt;
    }

    @Override
    public LayerInterface getLayer() {
        return this.m_layerInt;
    }

    @Override
    public TreeNode getFirstChild() {
        if (this.m_children.size() > 0) {
            return this.m_children.get(0);
        }
        return null;
    }

    @Override
    public TreeNode getNextSibling() {
        if (this.m_parent != null) {
            List<TreeNodeImpl> children = this.m_parent.m_children;
            int loc = children.indexOf(this);
            int size = children.size();
            if (loc > -1) {
                if (loc < size - 1) {
                    return children.get(loc + 1);
                }
                return null;
            }
        }
        return null;
    }
}

