/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.rules.discriminator;

import java.util.Enumeration;
import java.util.Vector;
import oracle.dss.rules.ComponentTypeConverter;
import oracle.dss.rules.RuleContext;
import oracle.dss.rules.discriminator.ValueDiscriminator;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class StringValueDiscriminator
extends ValueDiscriminator {
    private static final long serialVersionUID = 1L;
    private Vector m_strings;
    public static final String NAME_STR_VAL_DISC = "StrValDisc";
    protected static final String a_stringValue = "StrVal";

    public StringValueDiscriminator() {
    }

    public StringValueDiscriminator(Vector strings, int operator) {
        super(operator);
        this.m_strings = strings;
    }

    public StringValueDiscriminator(String str, int operator) {
        super(operator);
        this.m_strings = new Vector();
        this.m_strings.addElement(str);
    }

    @Override
    public Object clone() {
        return new StringValueDiscriminator(this.m_strings, this.m_relOperator);
    }

    public void setString(String str) {
        if (str != null) {
            this.m_strings = new Vector();
            this.m_strings.addElement(str);
        }
    }

    public void setStrings(Vector strings) {
        this.m_strings = strings;
    }

    public Vector getStrings() {
        return this.m_strings;
    }

    public String getString() {
        if (this.m_strings != null) {
            return (String)this.m_strings.elementAt(0);
        }
        return null;
    }

    @Override
    public boolean applies(RuleContext context) {
        String contextText = (String)context.get("STRING_VALUE");
        if (contextText == null && this.m_strings == null) {
            return true;
        }
        if (contextText == null || this.m_strings == null) {
            return false;
        }
        switch (this.m_relOperator) {
            case 0: {
                for (int i = 0; i < this.m_strings.size(); ++i) {
                    if (this.m_strings.elementAt(i) == null || !contextText.equals(this.m_strings.elementAt(i).toString())) continue;
                    return true;
                }
                return false;
            }
            case 1: {
                for (int i = 0; i < this.m_strings.size(); ++i) {
                    if (this.m_strings.elementAt(i) != null && contextText.compareTo(this.m_strings.elementAt(i).toString()) < 0) continue;
                    return false;
                }
                return true;
            }
            case 2: {
                for (int i = 0; i < this.m_strings.size(); ++i) {
                    if (this.m_strings.elementAt(i) != null && contextText.compareTo(this.m_strings.elementAt(i).toString()) <= 0) continue;
                    return false;
                }
                return true;
            }
            case 3: {
                for (int i = 0; i < this.m_strings.size(); ++i) {
                    if (this.m_strings.elementAt(i) != null && contextText.compareTo(this.m_strings.elementAt(i).toString()) > 0) continue;
                    return false;
                }
                return true;
            }
            case 4: {
                for (int i = 0; i < this.m_strings.size(); ++i) {
                    if (this.m_strings.elementAt(i) != null && contextText.compareTo(this.m_strings.elementAt(i).toString()) >= 0) continue;
                    return false;
                }
                return true;
            }
            case 5: {
                for (int i = 0; i < this.m_strings.size(); ++i) {
                    if (this.m_strings.elementAt(i) == null || !contextText.equals(this.m_strings.elementAt(i).toString())) continue;
                    return false;
                }
                return true;
            }
        }
        for (int i = 0; i < this.m_strings.size(); ++i) {
            if (this.m_strings.elementAt(i) == null || !contextText.equals(this.m_strings.elementAt(i).toString())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof StringValueDiscriminator)) {
            return false;
        }
        StringValueDiscriminator nvd = (StringValueDiscriminator)o;
        if (this.getRelOperator() != nvd.getRelOperator()) {
            return false;
        }
        Vector nStrings = nvd.getStrings();
        if (nStrings == null || this.m_strings == null || nStrings.size() != this.m_strings.size()) {
            return false;
        }
        for (int i = 0; i < this.m_strings.size(); ++i) {
            if (nStrings.elementAt(i) != null && nStrings.elementAt(i).equals(this.m_strings.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean setXML(ObjectNode node, ComponentTypeConverter converter, String version, int reset) {
        ContainerNode svNode = node.getContainer(NAME_STR_VAL_DISC);
        if (svNode != null) {
            PropertyNode pNode = svNode.getProperty("relOp");
            if (pNode != null) {
                String tmp = pNode.getValueAsString();
                this.setRelOperator(this.convertRelOperatorToInt(tmp));
            }
            this.m_strings = new Vector();
            Enumeration e = svNode.getPropertyNodes(a_stringValue);
            if (e != null) {
                while (e.hasMoreElements()) {
                    pNode = (PropertyNode)e.nextElement();
                    this.m_strings.addElement(pNode.getValueAsString());
                }
            }
        }
        return true;
    }

    @Override
    public ObjectNode getXML(boolean allProperties, ComponentTypeConverter converter, boolean emptyElement) {
        ObjectNode node = new ObjectNode(NAME_STR_VAL_DISC);
        boolean nodeExists = false;
        node.addProperty("relOp", this.convertRelOperatorToString(this.getRelOperator()));
        if (this.m_strings != null && this.m_strings.size() > 0) {
            for (int i = 0; i < this.m_strings.size(); ++i) {
                node.addProperty(a_stringValue, (String)this.m_strings.elementAt(i), false);
            }
        }
        return node;
    }
}

