/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.rules.discriminator;

import java.util.Hashtable;
import java.util.List;
import oracle.dss.rules.ComponentTypeConverter;
import oracle.dss.rules.RuleContext;
import oracle.dss.rules.discriminator.ComponentTypeDiscriminator;
import oracle.dss.rules.discriminator.ConditionDiscriminator;
import oracle.dss.rules.discriminator.DateValueDiscriminator;
import oracle.dss.rules.discriminator.Discriminator;
import oracle.dss.rules.discriminator.DiscriminatorState;
import oracle.dss.rules.discriminator.DiscriminatorXML;
import oracle.dss.rules.discriminator.NumberValueDiscriminator;
import oracle.dss.rules.discriminator.PositionDiscriminator;
import oracle.dss.rules.discriminator.QDRDiscriminator;
import oracle.dss.rules.discriminator.StringValueDiscriminator;
import oracle.dss.rules.discriminator.TotalsDiscriminator;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class CompositeDiscriminator
implements DiscriminatorXML,
DiscriminatorState {
    private static final long serialVersionUID = 1L;
    protected Discriminator m_left = null;
    protected Discriminator m_right = null;
    protected int m_condOperator = 0;
    public static final int AND = 0;
    public static final int OR = 1;
    public static final int NOT = 2;
    protected static final String S_NAME_COMPOS_DISC = "CD";
    protected static final String s_condOperator = "o";
    protected static final String s_rightDisc = "r";
    protected Hashtable m_context = null;
    public static final String NAME_COMPOS_DISC = "ComposDisc";
    protected static final String a_condOperator = "cond";
    protected static final String a_rightDisc = "RightDisc";
    protected static final String a_leftDisc = "LeftDisc";
    protected static final String and = "AND";
    protected static final String or = "OR";
    protected static final String not = "NOT";

    public CompositeDiscriminator() {
    }

    public CompositeDiscriminator(Discriminator l, Discriminator r, int condOp) {
        this.m_left = (Discriminator)(l != null ? l.clone() : l);
        this.m_right = (Discriminator)(r != null ? r.clone() : r);
        this.m_condOperator = condOp;
    }

    @Override
    public Object clone() {
        return new CompositeDiscriminator(this.m_left, this.m_right, this.m_condOperator);
    }

    public int getCondOperator() {
        return this.m_condOperator;
    }

    public void setCondOperator(int condOp) {
        if (condOp < 0 || condOp > 2) {
            return;
        }
        this.m_condOperator = condOp;
    }

    public Discriminator getLeft() {
        return this.m_left;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CompositeDiscriminator)) {
            return false;
        }
        CompositeDiscriminator compDisc = (CompositeDiscriminator)o;
        return (compDisc.getLeft() == null && this.getLeft() == null || compDisc.getLeft().equals(this.getLeft())) && (compDisc.getRight() == null && this.getRight() == null || compDisc.getRight().equals(this.getRight())) && compDisc.getCondOperator() == this.getCondOperator();
    }

    public void setLeft(Discriminator discriminator) {
        this.m_left = (Discriminator)(discriminator != null ? discriminator.clone() : discriminator);
    }

    public Discriminator getRight() {
        return this.m_right;
    }

    public void setRight(Discriminator discriminator) {
        this.m_right = (Discriminator)(discriminator != null ? discriminator.clone() : discriminator);
    }

    @Override
    public boolean applies(RuleContext context) {
        switch (this.m_condOperator) {
            case 0: {
                return this.m_left.applies(context) && this.m_right.applies(context);
            }
            case 1: {
                return this.m_left.applies(context) || this.m_right.applies(context);
            }
            case 2: {
                return !this.m_left.applies(context);
            }
        }
        return this.m_left.applies(context) && this.m_right.applies(context);
    }

    public void setContext(Hashtable context) {
        this.m_context = context;
    }

    @Override
    public boolean setXML(ObjectNode node, ComponentTypeConverter converter, String version, int reset) {
        ObjectNode rightXML;
        PropertyNode pNode = node.getProperty(a_condOperator);
        if (pNode != null) {
            if (pNode.getValueAsString().equals(and)) {
                this.setCondOperator(0);
            } else if (pNode.getValueAsString().equals(or)) {
                this.setCondOperator(1);
            } else if (pNode.getValueAsString().equals(not)) {
                this.setCondOperator(2);
            }
        }
        Object XML1 = null;
        ObjectNode leftXML = node.getPropertyValueAsObjectNode(a_leftDisc, true);
        if (leftXML != null) {
            PropertyNode tempNode = leftXML.getProperty("CompTypeDisc");
            if (tempNode != null) {
                this.setLeft(new ComponentTypeDiscriminator(converter.convertComponentTypeToInteger(tempNode.getValueAsString())));
            } else {
                ObjectNode ldiscriminator = leftXML.getPropertyValueAsObjectNode();
                if (ldiscriminator != null) {
                    if (ldiscriminator.getName().equals(NAME_COMPOS_DISC)) {
                        cDisc = new CompositeDiscriminator();
                        ((CompositeDiscriminator)cDisc).setContext(this.m_context);
                        boolean result = ((CompositeDiscriminator)cDisc).setXML(ldiscriminator, converter, version, reset);
                        this.setLeft(cDisc);
                    } else if (ldiscriminator.getName().equals("ConditionDisc")) {
                        cDisc = new ConditionDiscriminator();
                        boolean result = ((ConditionDiscriminator)cDisc).setXML(ldiscriminator, converter, version, reset);
                        this.setLeft(cDisc);
                    } else if (ldiscriminator.getName().equals("NumValDisc")) {
                        NumberValueDiscriminator nvd = new NumberValueDiscriminator();
                        boolean result = nvd.setXML(ldiscriminator, converter, version, reset);
                        this.setLeft(nvd);
                    } else if (ldiscriminator.getName().equals("DateValDisc")) {
                        DateValueDiscriminator dvd = new DateValueDiscriminator();
                        boolean result = dvd.setXML(ldiscriminator, converter, version, reset);
                        this.setLeft(dvd);
                    } else if (ldiscriminator.getName().equals("PosDisc")) {
                        PositionDiscriminator pd = new PositionDiscriminator();
                        boolean result = pd.setXML(ldiscriminator, converter, version, reset);
                        this.setLeft(pd);
                    } else if (ldiscriminator.getName().equals("QDRDisc")) {
                        QDRDiscriminator qdrd = new QDRDiscriminator();
                        qdrd.setContext(this.m_context);
                        boolean result = qdrd.setXML(ldiscriminator, converter, version, reset);
                        this.setLeft(qdrd);
                    } else if (ldiscriminator.getName().equals("StrValDisc")) {
                        StringValueDiscriminator svd = new StringValueDiscriminator();
                        boolean result = svd.setXML(leftXML, converter, version, reset);
                        this.setLeft(svd);
                    } else if (ldiscriminator.getName().equals("TotDisc")) {
                        TotalsDiscriminator td = new TotalsDiscriminator();
                        boolean result = td.setXML(ldiscriminator, converter, version, reset);
                        this.setLeft(td);
                    } else {
                        PropertyNode lNode = ldiscriminator.getProperty("type");
                        if (lNode == null) {
                            return true;
                        }
                        String undefinedDiscriminatorPath = lNode.getValueAsString();
                        try {
                            Class<?> undefinedDiscriminatorClass = Class.forName(undefinedDiscriminatorPath);
                            DiscriminatorXML undefinedDiscriminator = (DiscriminatorXML)undefinedDiscriminatorClass.newInstance();
                            boolean result = undefinedDiscriminator.setXML(ldiscriminator, converter, version, reset);
                            this.setLeft(undefinedDiscriminator);
                        }
                        catch (Exception exception) {
                            return true;
                        }
                    }
                }
            }
        }
        if ((rightXML = node.getPropertyValueAsObjectNode(a_rightDisc, true)) != null) {
            XML1 = null;
            PropertyNode tempNode = rightXML.getProperty("CompTypeDisc");
            if (tempNode != null) {
                this.setRight(new ComponentTypeDiscriminator(converter.convertComponentTypeToInteger(tempNode.getValueAsString())));
            } else {
                ObjectNode rdiscriminator = rightXML.getPropertyValueAsObjectNode();
                if (rdiscriminator != null) {
                    if (rdiscriminator.getName().equals(NAME_COMPOS_DISC)) {
                        CompositeDiscriminator cDisc = new CompositeDiscriminator();
                        cDisc.setContext(this.m_context);
                        boolean result = cDisc.setXML(rdiscriminator, converter, version, reset);
                        this.setRight(cDisc);
                    } else if (rdiscriminator.getName().equals("ConditionDisc")) {
                        ConditionDiscriminator cDisc = new ConditionDiscriminator();
                        boolean result = cDisc.setXML(rdiscriminator, converter, version, reset);
                        this.setRight(cDisc);
                    } else if (rdiscriminator.getName().equals("NumValDisc")) {
                        NumberValueDiscriminator nvd = new NumberValueDiscriminator();
                        boolean result = nvd.setXML(rdiscriminator, converter, version, reset);
                        this.setRight(nvd);
                    } else if (rdiscriminator.getName().equals("DateValDisc")) {
                        DateValueDiscriminator dvd = new DateValueDiscriminator();
                        boolean result = dvd.setXML(rdiscriminator, converter, version, reset);
                        this.setRight(dvd);
                    } else if (rdiscriminator.getName().equals("PosDisc")) {
                        PositionDiscriminator pd = new PositionDiscriminator();
                        boolean result = pd.setXML(rdiscriminator, converter, version, reset);
                        this.setRight(pd);
                    } else if (rdiscriminator.getName().equals("QDRDisc")) {
                        QDRDiscriminator qdrd = new QDRDiscriminator();
                        qdrd.setContext(this.m_context);
                        boolean result = qdrd.setXML(rdiscriminator, converter, version, reset);
                        this.setRight(qdrd);
                    } else if (rdiscriminator.getName().equals("StrValDisc")) {
                        StringValueDiscriminator svd = new StringValueDiscriminator();
                        boolean result = svd.setXML(rightXML, converter, version, reset);
                        this.setRight(svd);
                    } else if (rdiscriminator.getName().equals("TotDisc")) {
                        TotalsDiscriminator td = new TotalsDiscriminator();
                        boolean result = td.setXML(rdiscriminator, converter, version, reset);
                        this.setRight(td);
                    } else {
                        PropertyNode rNode = rdiscriminator.getProperty("type");
                        if (rNode == null) {
                            return true;
                        }
                        String undefinedDiscriminatorPath = rNode.getValueAsString();
                        try {
                            Class<?> undefinedDiscriminatorClass = Class.forName(undefinedDiscriminatorPath);
                            DiscriminatorXML undefinedDiscriminator = (DiscriminatorXML)undefinedDiscriminatorClass.newInstance();
                            boolean result = undefinedDiscriminator.setXML(rdiscriminator, converter, version, reset);
                            this.setRight(undefinedDiscriminator);
                        }
                        catch (Exception exception) {
                            return true;
                        }
                    }
                }
            }
        }
        return true;
    }

    @Override
    public ObjectNode getXML(boolean allProperties, ComponentTypeConverter converter, boolean emptyElement) {
        ObjectNode XML;
        String componentType;
        ObjectNode node = new ObjectNode(NAME_COMPOS_DISC);
        boolean nodeExists = false;
        if (this.getCondOperator() == 1) {
            node.addProperty(a_condOperator, or);
        } else if (this.getCondOperator() == 2) {
            node.addProperty(a_condOperator, not);
        } else {
            node.addProperty(a_condOperator, and);
        }
        if (this.getLeft() instanceof DiscriminatorXML && (allProperties || this.getLeft() != null)) {
            ObjectNode leftNode = new ObjectNode(a_leftDisc);
            if (this.getLeft() instanceof ComponentTypeDiscriminator) {
                componentType = null;
                componentType = converter.convertComponentTypeToString(((ComponentTypeDiscriminator)this.getLeft()).getComponentType());
                leftNode.addProperty("CompTypeDisc", componentType, false);
                node.addProperty(leftNode);
                nodeExists = true;
            } else {
                if (this.m_context != null) {
                    if (this.getLeft() instanceof QDRDiscriminator) {
                        ((QDRDiscriminator)this.getLeft()).setContext(this.m_context);
                    } else if (this.getLeft() instanceof CompositeDiscriminator) {
                        ((CompositeDiscriminator)this.getLeft()).setContext(this.m_context);
                    }
                }
                if ((XML = ((DiscriminatorXML)this.getLeft()).getXML(allProperties, converter, true)) != null) {
                    leftNode.addProperty(XML);
                    node.addProperty(leftNode);
                    nodeExists = true;
                }
            }
        }
        if (this.getRight() instanceof DiscriminatorXML && (allProperties || this.getRight() != null)) {
            ObjectNode rightNode = new ObjectNode(a_rightDisc);
            if (this.getRight() instanceof ComponentTypeDiscriminator) {
                componentType = null;
                componentType = converter.convertComponentTypeToString(((ComponentTypeDiscriminator)this.getRight()).getComponentType());
                rightNode.addProperty("CompTypeDisc", componentType, false);
                node.addProperty(rightNode);
                nodeExists = true;
            } else {
                if (this.getRight() instanceof QDRDiscriminator) {
                    ((QDRDiscriminator)this.getRight()).setContext(this.m_context);
                } else if (this.getRight() instanceof CompositeDiscriminator) {
                    ((CompositeDiscriminator)this.getRight()).setContext(this.m_context);
                }
                XML = ((DiscriminatorXML)this.getRight()).getXML(allProperties, converter, true);
                if (XML != null) {
                    rightNode.addProperty(XML);
                    node.addProperty(rightNode);
                    nodeExists = true;
                }
            }
        }
        if (nodeExists) {
            return node;
        }
        if (emptyElement) {
            return node;
        }
        return null;
    }

    @Override
    public void setStateAsObjectNode(List context, ObjectNode node, DiscriminatorState baseState) {
        PropertyNode pNode = node.getProperty(s_condOperator);
        if (pNode == null) {
            this.setCondOperator(0);
        } else {
            this.setCondOperator(pNode.getValueAsInteger());
        }
        this.setLeft(CompositeDiscriminator.createDiscriminator(context, node, null));
        ObjectNode rightNode = node.getPropertyValueAsObjectNode(s_rightDisc, true);
        if (rightNode != null) {
            this.setRight(CompositeDiscriminator.createDiscriminator(context, rightNode, null));
        }
    }

    @Override
    public ObjectNode getStateAsObjectNode(List memberContext, DiscriminatorState baseState) {
        ObjectNode leftNode;
        ObjectNode node = new ObjectNode(S_NAME_COMPOS_DISC);
        boolean nodeExists = false;
        if (this.getCondOperator() != 0) {
            node.addProperty(s_condOperator, this.getCondOperator());
        }
        if (this.getLeft() instanceof DiscriminatorState && (leftNode = ((DiscriminatorState)((Object)this.getLeft())).getStateAsObjectNode(memberContext, baseState)) != null) {
            node.addProperty(leftNode);
            nodeExists = true;
        }
        if (this.getRight() instanceof DiscriminatorState) {
            ObjectNode rightNode = new ObjectNode(s_rightDisc);
            ObjectNode right = ((DiscriminatorState)((Object)this.getRight())).getStateAsObjectNode(memberContext, baseState);
            if (right != null) {
                rightNode.addProperty(right);
                node.addProperty(rightNode);
                nodeExists = true;
            }
        }
        return nodeExists ? node : null;
    }

    public static Discriminator createDiscriminator(List context, ObjectNode discNode, DiscriminatorState baseState) {
        if (discNode == null) {
            return null;
        }
        ObjectNode node = discNode.getPropertyValueAsObjectNode("QD", true);
        if (node != null) {
            QDRDiscriminator discriminator = new QDRDiscriminator();
            discriminator.setStateAsObjectNode(context, node, baseState);
            return discriminator;
        }
        node = discNode.getPropertyValueAsObjectNode("ND", true);
        if (node != null) {
            NumberValueDiscriminator discriminator = new NumberValueDiscriminator();
            discriminator.setStateAsObjectNode(context, node, baseState);
            return discriminator;
        }
        node = discNode.getPropertyValueAsObjectNode(S_NAME_COMPOS_DISC, true);
        if (node != null) {
            CompositeDiscriminator discriminator = new CompositeDiscriminator();
            discriminator.setStateAsObjectNode(context, node, baseState);
            return discriminator;
        }
        node = discNode.getPropertyValueAsObjectNode("DD", true);
        if (node != null) {
            DateValueDiscriminator discriminator = new DateValueDiscriminator();
            discriminator.setStateAsObjectNode(context, node, baseState);
            return discriminator;
        }
        node = discNode.getPropertyValueAsObjectNode("TD", true);
        if (node != null) {
            TotalsDiscriminator discriminator = new TotalsDiscriminator();
            discriminator.setStateAsObjectNode(context, node, baseState);
            return discriminator;
        }
        return null;
    }
}

