/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.model.dvt.util.transform;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DeleteChanges {
    private List<Positions> m_positions = new ArrayList<Positions>();
    private List<Map<String, Object>> m_values = new ArrayList<Map<String, Object>>();

    protected DeleteChanges() {
    }

    protected void addDeletion(Map<String, Object> del, List<Positions> positions) {
        int index = this.m_values.indexOf(del);
        for (Positions pos : positions) {
            int posIndex = this.m_positions.indexOf(pos);
            if (index == -1 || posIndex == -1) {
                this.addDeletionInternal(del, pos);
                continue;
            }
            this.setDeletionInternal(index, del, pos);
        }
    }

    protected void addDeletion(Map<String, Object> del, Positions pos) {
        ArrayList<Positions> positions = new ArrayList<Positions>();
        positions.add(pos);
        this.addDeletion(del, positions);
    }

    protected void addAll(DeleteChanges dels) {
        this.m_positions.addAll(dels.getPositions());
        this.m_values.addAll(dels.getDeletions());
    }

    protected void addAll(List<Map<String, Object>> dels, List<Positions> pos) {
        this.m_positions.addAll(pos);
        this.m_values.addAll(dels);
    }

    protected void addDeletionInternal(Map<String, Object> del, Positions pos) {
        this.m_positions.add(pos);
        this.m_values.add(del);
    }

    protected void setDeletionInternal(int index, Map<String, Object> del, Positions pos) {
        this.m_positions.set(index, pos);
        this.m_values.set(index, del);
    }

    public List<Positions> getPositions() {
        return this.m_positions;
    }

    public List<Map<String, Object>> getDeletions() {
        return this.m_values;
    }

    public static class Positions {
        private int m_row = -1;
        private int m_col = -1;
        private int m_edge = -1;
        private int m_layer = -1;
        private int m_slice = -1;

        protected Positions(long row, long col) {
            this.m_row = (int)row;
            this.m_col = (int)col;
        }

        protected Positions(int edge, int layer, long slice) {
            this.m_edge = edge;
            this.m_layer = layer;
            this.m_slice = (int)slice;
        }

        public int getEdge() {
            return this.m_edge;
        }

        public int getLayer() {
            return this.m_layer;
        }

        public int getSlice() {
            return this.m_slice;
        }

        public int getRow() {
            return this.m_row;
        }

        public int getColumn() {
            return this.m_col;
        }

        public boolean isRowColumn() {
            return this.m_row > -1 && this.m_col > -1;
        }
    }
}

