/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import oracle.dbtools.extension.project.commands.stage.StageMessages;
import oracle.dbtools.extension.project.commands.stage.objectclasses.DbDiffObject;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.exceptions.ChangelogGenerationException;
import oracle.dbtools.extension.project.core.exceptions.GitRefException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.OrTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathSuffixFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class GitUtils {
    public static String ERROR_TYPE = "ERROR";

    public static Git initRepo(File repoPath) throws GitAPIException {
        return Git.init().setDirectory(repoPath).call();
    }

    public static Git cloneRepo(String uri, File repoPath) throws GitAPIException {
        return Git.cloneRepository().setURI(uri).setDirectory(repoPath).call();
    }

    public static Git findGitRepo(File path) throws InterruptedException, IOException {
        FileRepositoryBuilder repositoryBuilder = new FileRepositoryBuilder();
        repositoryBuilder.findGitDir(path);
        File dir = null;
        for (int count = 0; dir == null && count < 5; ++count) {
            dir = repositoryBuilder.getGitDir();
            Thread.sleep(200L);
        }
        if (dir != null) {
            return GitUtils.openRepo(dir);
        }
        return null;
    }

    public static Git openRepo(File repoDir) throws IOException {
        Repository repo = ((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setMustExist(true)).setGitDir(repoDir)).build();
        return new Git(repo);
    }

    public static String getCurrentBranchName(Git git) throws GitAPIException, IOException {
        return GitUtils.findCurrentBranch(git).isPresent() ? GitUtils.findCurrentBranch(git).get().getName() : null;
    }

    public static Optional<Ref> findCurrentBranch(Git git) throws IOException, GitAPIException {
        String currentBranch = git.getRepository().getFullBranch();
        return git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call().stream().filter(e -> e.getName().equals(currentBranch)).findFirst();
    }

    public static Optional<Ref> findRemoteBranch(Git git, Ref branch) throws GitAPIException {
        return git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call().stream().filter(e -> e.getObjectId().getName().equals(branch.getObjectId().getName())).findFirst();
    }

    public static HashMap<String, LinkedList<DbDiffObject>> diffBranches(Repository repo, String master, String branch) throws ChangelogGenerationException {
        DbDiffObject obj = null;
        boolean DEBUG = (Boolean)ProjectConfig.getCurrentContext().getProperty("project.debug");
        boolean VERBOSE = (Boolean)ProjectConfig.getCurrentContext().getProperty("project.verbose");
        HashMap<String, LinkedList<DbDiffObject>> diffs = new HashMap<String, LinkedList<DbDiffObject>>();
        if (DEBUG) {
            ProjectConfig.ctx.writeln("Diffing Branches");
        }
        try {
            Git git = new Git(repo);
            AbstractTreeIterator oldTreeParser = GitUtils.prepareTreeParser(repo, master);
            FileTreeIterator newTreeIter = new FileTreeIterator(git.getRepository());
            PathSuffixFilter sqlFilter = PathSuffixFilter.create((String)".sql");
            PathSuffixFilter plsFilter = PathSuffixFilter.create((String)".pls");
            PathSuffixFilter pkbFilter = PathSuffixFilter.create((String)".pkb");
            PathSuffixFilter pksFilter = PathSuffixFilter.create((String)".pks");
            PathSuffixFilter trgFilter = PathSuffixFilter.create((String)".trg");
            TreeFilter[] filterList = new TreeFilter[]{sqlFilter, plsFilter, pkbFilter, pksFilter, trgFilter};
            TreeFilter orFilter = OrTreeFilter.create((TreeFilter[])filterList);
            PathFilter srcFilter = PathFilter.create((String)"src");
            List entries = git.diff().setOldTree(oldTreeParser).setNewTree((AbstractTreeIterator)newTreeIter).setPathFilter(AndTreeFilter.create((TreeFilter)srcFilter, (TreeFilter)orFilter)).call();
            for (DiffEntry entry : entries) {
                ByteArrayOutputStream baos;
                ObjectLoader loader;
                String branchFileContent = null;
                String masterFileContent = null;
                if (DEBUG) {
                    ProjectConfig.ctx.writeln("result: diff " + entry);
                }
                if (entry.getNewPath().contains("apex_app") || entry.getOldPath().contains("apex_app")) continue;
                if (!diffs.containsKey(entry.getChangeType().toString())) {
                    diffs.put(entry.getChangeType().toString(), new LinkedList());
                }
                if ("DELETE".equalsIgnoreCase(entry.getChangeType().toString()) || "MODIFY".equalsIgnoreCase(entry.getChangeType().toString())) {
                    loader = repo.open((AnyObjectId)entry.getOldId().toObjectId());
                    baos = new ByteArrayOutputStream();
                    loader.copyTo((OutputStream)baos);
                    masterFileContent = baos.toString(StandardCharsets.UTF_8);
                }
                if ("ADD".equalsIgnoreCase(entry.getChangeType().toString()) || "MODIFY".equalsIgnoreCase(entry.getChangeType().toString())) {
                    loader = repo.open((AnyObjectId)entry.getNewId().toObjectId());
                    baos = new ByteArrayOutputStream();
                    loader.copyTo((OutputStream)baos);
                    branchFileContent = baos.toString(StandardCharsets.UTF_8);
                }
                try {
                    obj = new DbDiffObject(entry, branchFileContent, masterFileContent);
                    diffs.get(entry.getChangeType().toString()).add(obj);
                }
                catch (ChangelogGenerationException e) {
                    if (!diffs.containsKey(ERROR_TYPE)) {
                        diffs.put(entry.getChangeType().toString(), new LinkedList());
                    }
                    diffs.get(ERROR_TYPE).add(obj);
                }
            }
            if (DEBUG) {
                ProjectConfig.ctx.writeln("Completed Diffing");
            }
            return diffs;
        }
        catch (IOException | GitAPIException io) {
            throw new ChangelogGenerationException(io.getMessage(), io);
        }
    }

    private static AbstractTreeIterator prepareTreeParser(Repository repo, String ref) throws IOException, GitAPIException {
        Ref head = repo.exactRef(ref);
        if (null == head) {
            throw new GitRefException(StageMessages.getString("NULL_GIT_REF"));
        }
        try (RevWalk walk = new RevWalk(repo);){
            RevCommit commit = walk.parseCommit((AnyObjectId)head.getObjectId());
            RevTree tree = walk.parseTree((AnyObjectId)commit.getTree().getId());
            CanonicalTreeParser treeParser = new CanonicalTreeParser();
            try (ObjectReader reader = repo.newObjectReader();){
                treeParser.reset(reader, (AnyObjectId)tree.getId());
            }
            walk.dispose();
            CanonicalTreeParser canonicalTreeParser = treeParser;
            return canonicalTreeParser;
        }
    }

    public static LinkedList<String> listBranch(String repoPath, String branch) {
        boolean DEBUG = (Boolean)ProjectConfig.getCurrentContext().getProperty("project.debug");
        Path path = Paths.get(repoPath, new String[0]);
        if (!path.toFile().exists()) {
            ProjectConfig.ctx.writeln("No Git repository could be found.");
            return null;
        }
        if (DEBUG) {
            ProjectConfig.ctx.writeln("debug: repoPath: " + repoPath);
        }
        try {
            Repository repo = ((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setMustExist(true)).setGitDir(path.toFile())).build();
            LinkedList<String> ret = new LinkedList<String>();
            Ref head = repo.exactRef(branch);
            if (DEBUG) {
                ProjectConfig.ctx.writeln("debug: head: " + head);
            }
            RevWalk walk = new RevWalk(repo);
            RevCommit commit = walk.parseCommit((AnyObjectId)head.getObjectId());
            RevTree tree = commit.getTree();
            TreeWalk treeWalk = new TreeWalk(repo);
            treeWalk.addTree((AnyObjectId)tree);
            treeWalk.setRecursive(false);
            while (treeWalk.next()) {
                if (treeWalk.isSubtree()) {
                    if (DEBUG) {
                        ProjectConfig.ctx.writeln("debug: " + treeWalk.getPathString());
                    }
                    treeWalk.enterSubtree();
                    continue;
                }
                if (DEBUG) {
                    ProjectConfig.ctx.writeln("debug:   " + treeWalk.getPathString());
                }
                ret.add("  " + treeWalk.getPathString());
            }
            return ret;
        }
        catch (CorruptObjectException e) {
            ProjectConfig.ctx.writeln("CorruptObjectException excountered exiting.");
            return null;
        }
        catch (IncorrectObjectTypeException e) {
            ProjectConfig.ctx.writeln("IncorrectObjectTypeException excountered exiting.");
            return null;
        }
        catch (MissingObjectException e) {
            ProjectConfig.ctx.writeln("MissingObjectException excountered exiting.");
            return null;
        }
        catch (IOException e) {
            ProjectConfig.ctx.writeln("IOException excountered exiting.");
            return null;
        }
    }

    public static Status getRepoStatus(Git git) throws GitAPIException {
        Status status = git.status().call();
        System.out.println("Added: " + status.getAdded());
        System.out.println("Changed: " + status.getChanged());
        System.out.println("Conflicting: " + status.getConflicting());
        System.out.println("ConflictingStageState: " + status.getConflictingStageState());
        System.out.println("IgnoredNotInIndex: " + status.getIgnoredNotInIndex());
        System.out.println("Missing: " + status.getMissing());
        System.out.println("Modified: " + status.getModified());
        System.out.println("Removed: " + status.getRemoved());
        System.out.println("Untracked: " + status.getUntracked());
        System.out.println("UntrackedFolders: " + status.getUntrackedFolders());
        return status;
    }
}

