/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.messages;

import com.google.common.base.Throwables;
import java.io.IOException;
import lombok.Generated;
import oracle.dbtools.extension.project.commands.UtilMessages;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.utils.ConsoleColors;

public class GeneralMessages {
    static boolean flush = true;

    public static void createDirMsg(ConsoleColors color, String message) {
        if (ProjectConfig.isVerbose()) {
            ProjectConfig.getCurrentContext().writeln(UtilMessages.format("CREATE_DIR_MESSAGE", color.code, ConsoleColors.RESET.code, message));
        }
        if (flush) {
            try {
                ProjectConfig.getCurrentContext().getOutputStream().getMainStream().flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void createDirMsg(String message) {
        GeneralMessages.createDirMsg(ConsoleColors.GREEN, message);
    }

    public static void createFileMsg(ConsoleColors color, String message) {
        if (ProjectConfig.isVerbose()) {
            ProjectConfig.getCurrentContext().writeln(UtilMessages.format("CREATE_FILE_MESSAGE", color.code, ConsoleColors.RESET.code, message));
        }
        if (flush) {
            try {
                ProjectConfig.getCurrentContext().getOutputStream().getMainStream().flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void createFileMsg(String message) {
        GeneralMessages.createFileMsg(ConsoleColors.GREEN, message);
    }

    public static void moveFileMsg(ConsoleColors color, String fromdir, String todir) {
        if (ProjectConfig.isVerbose()) {
            ProjectConfig.getCurrentContext().writeln(UtilMessages.format("MOVE_FILE_MESSAGE", color.code, ConsoleColors.RESET.code, fromdir, todir));
        }
        if (flush) {
            try {
                ProjectConfig.getCurrentContext().getOutputStream().getMainStream().flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void moveFileMsg(String fromDir, String toDir) {
        GeneralMessages.moveFileMsg(ConsoleColors.GREEN, fromDir, toDir);
    }

    public static void moveFolderMsg(ConsoleColors color, String fromdir, String todir) {
        if (ProjectConfig.isVerbose()) {
            ProjectConfig.getCurrentContext().writeln(UtilMessages.format("MOVE_FOLDER_MESSAGE", color.code, ConsoleColors.RESET.code, fromdir, todir));
        }
        if (flush) {
            try {
                ProjectConfig.getCurrentContext().getOutputStream().getMainStream().flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void moveFolderMsg(String fromDir, String toDir) {
        GeneralMessages.moveFolderMsg(ConsoleColors.GREEN, fromDir, toDir);
    }

    public static void createChangeMsg(ConsoleColors color, String message) {
        if (ProjectConfig.isVerbose()) {
            ProjectConfig.getCurrentContext().writeln(UtilMessages.format("CREATE_CHANGELOG_MESSAGE", color.code, ConsoleColors.RESET.code, message));
        }
        if (flush) {
            try {
                ProjectConfig.getCurrentContext().getOutputStream().getMainStream().flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void createChangeMsg(String message) {
        GeneralMessages.createChangeMsg(ConsoleColors.GREEN, message);
    }

    public static void createDropChangeMsg(ConsoleColors color, String message) {
        if (ProjectConfig.isVerbose()) {
            ProjectConfig.getCurrentContext().writeln(UtilMessages.format("CREATE_DROP_LOG_MESSAGE", color.code, ConsoleColors.RESET.code, message));
            if (flush) {
                try {
                    ProjectConfig.getCurrentContext().getOutputStream().getMainStream().flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static void createDropChangeMsg(String message) {
        GeneralMessages.createDropChangeMsg(ConsoleColors.YELLOW, message);
    }

    public static void updateFileMsg(ConsoleColors color, String message) {
        if (ProjectConfig.isVerbose()) {
            ProjectConfig.getCurrentContext().writeln(UtilMessages.format("UPDATE_FILE_MESSAGE", color.code, ConsoleColors.RESET.code, message));
            if (flush) {
                try {
                    ProjectConfig.getCurrentContext().getOutputStream().getMainStream().flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static void updateFileMsg(String message) {
        GeneralMessages.updateFileMsg(ConsoleColors.GREEN, message);
    }

    public static void updateChangeMsg(ConsoleColors color, String message) {
        if (ProjectConfig.isVerbose()) {
            ProjectConfig.getCurrentContext().writeln(UtilMessages.format("UPDATE_CHANGELOG_MESSAGE", color.code, ConsoleColors.RESET.code, message));
            if (flush) {
                try {
                    ProjectConfig.getCurrentContext().getOutputStream().getMainStream().flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static void updateChangeMsg(String message) {
        GeneralMessages.updateChangeMsg(ConsoleColors.GREEN, message);
    }

    public static void deleteFileMsg(ConsoleColors color, String message) {
        if (ProjectConfig.isVerbose()) {
            ProjectConfig.getCurrentContext().writeln(UtilMessages.format("REMOVE_FILE_MESSAGE", color.code, ConsoleColors.RESET.code, message));
            if (flush) {
                try {
                    ProjectConfig.getCurrentContext().getOutputStream().getMainStream().flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static void deleteFileMsg(String message) {
        GeneralMessages.deleteFileMsg(ConsoleColors.YELLOW, message);
    }

    public static void excludeFileMsg(ConsoleColors color, String message) {
        if (ProjectConfig.isVerbose()) {
            ProjectConfig.getCurrentContext().writeln(UtilMessages.format("EXCLUDE_FILE_MESSAGE", color.code, ConsoleColors.RESET.code, message));
            if (flush) {
                try {
                    ProjectConfig.getCurrentContext().getOutputStream().getMainStream().flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static void excludeFileMsg(String message) {
        GeneralMessages.excludeFileMsg(ConsoleColors.YELLOW, message);
    }

    public static void skipFileMsg(ConsoleColors color, String message) {
        if (ProjectConfig.isVerbose()) {
            ProjectConfig.getCurrentContext().writeln(UtilMessages.format("SKIP_FILE_MESSAGE", color.code, ConsoleColors.RESET.code, message));
            if (flush) {
                try {
                    ProjectConfig.getCurrentContext().getOutputStream().getMainStream().flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static void skipFileMsg(String message) {
        GeneralMessages.skipFileMsg(ConsoleColors.YELLOW, message);
    }

    public static void skipChangeMsg(ConsoleColors color, String message) {
        if (ProjectConfig.isVerbose()) {
            ProjectConfig.getCurrentContext().writeln(UtilMessages.format("SKIP_CHANGELOG_MESSAGE", color.code, ConsoleColors.RESET.code, message));
            if (flush) {
                try {
                    ProjectConfig.getCurrentContext().getOutputStream().getMainStream().flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static void skipChangeMsg(String message) {
        GeneralMessages.skipChangeMsg(ConsoleColors.YELLOW, message);
    }

    public static void verboseMessage(ConsoleColors color, String message) {
        if (ProjectConfig.isVerbose()) {
            ProjectConfig.getCurrentContext().writeln(color.code + message + ConsoleColors.RESET.code);
            if (flush) {
                try {
                    ProjectConfig.getCurrentContext().getOutputStream().getMainStream().flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static void verboseMessage(String message) {
        GeneralMessages.verboseMessage(ConsoleColors.WHITE, message);
    }

    public static void debugMessage(ConsoleColors color, String message) {
        if (ProjectConfig.isDebug()) {
            ProjectConfig.getCurrentContext().writeln(color.code + message + ConsoleColors.RESET.code);
            if (flush) {
                try {
                    ProjectConfig.getCurrentContext().getOutputStream().getMainStream().flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static void debugMessage(String message) {
        GeneralMessages.debugMessage(ConsoleColors.BLUE, message);
    }

    public static void debugException(ConsoleColors color, Throwable e) {
        if (ProjectConfig.isDebug()) {
            ProjectConfig.getCurrentContext().writeln(color.code + "ERROR/EXCEPTION");
            ProjectConfig.getCurrentContext().writeln(Throwables.getStackTraceAsString((Throwable)e));
            ProjectConfig.getCurrentContext().writeln(ConsoleColors.RESET.code);
            if (flush) {
                try {
                    ProjectConfig.getCurrentContext().getOutputStream().getMainStream().flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static void debugException(Throwable e) {
        GeneralMessages.debugException(ConsoleColors.BLUE, e);
    }

    public static void errorMessage(ConsoleColors color, String message) {
        ProjectConfig.getCurrentContext().writeln(color.code + "ERROR: " + message + ConsoleColors.RESET.code);
        if (flush) {
            try {
                ProjectConfig.getCurrentContext().getOutputStream().getMainStream().flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void errorMessage(String message) {
        GeneralMessages.errorMessage(ConsoleColors.RED, message);
    }

    public static void successMessage(ConsoleColors color, String message) {
        ProjectConfig.getCurrentContext().writeln(color.code + message + ConsoleColors.RESET.code);
        if (flush) {
            try {
                ProjectConfig.getCurrentContext().getOutputStream().getMainStream().flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void successMessage(String message) {
        GeneralMessages.successMessage(ConsoleColors.GREEN, message);
    }

    public static void warnMessage(ConsoleColors color, String message) {
        ProjectConfig.getCurrentContext().writeln(color.code + "WARN: " + message + ConsoleColors.RESET.code);
        if (flush) {
            try {
                ProjectConfig.getCurrentContext().getOutputStream().getMainStream().flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void warnMessage(String message) {
        GeneralMessages.warnMessage(ConsoleColors.YELLOW, message);
    }

    @Generated
    public static void setFlush(boolean flush) {
        GeneralMessages.flush = flush;
    }
}

