/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.config;

import java.io.File;
import java.nio.file.Path;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.extension.project.commands.ProjectMessages;
import oracle.dbtools.extension.project.commands.handler.ProjectOptions;
import oracle.dbtools.extension.project.core.exceptions.ProjectNotIdentifiedException;
import oracle.dbtools.extension.project.core.utils.ProjectFileUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ProjectConfig {
    public static final String PROJECT_CONFIG_FOLDER_NAME = ".dbtools";
    public static final String FILTERS_FOLDER_NAME = "filters";
    public static final String CONFIG_FOLDER_NAME = "config";
    public static final String VSCODE_FOLDER_NAME = ".vscode";
    public static final String PROJECT_README_RESOURCE_PATH = "oracle/dbtools/extension/project/commands/init/templates/ProjectReadme.md.tmpl";
    public static final String SRC_README_RESOURCE_PATH = "oracle/dbtools/extension/project/commands/init/templates/SrcReadme.md.tmpl";
    public static final String DB_README_RESOURCE_PATH = "oracle/dbtools/extension/project/commands/init/templates/DbReadme.md.tmpl";
    public static final String DIST_README_RESOURCE_PATH = "oracle/dbtools/extension/project/commands/init/templates/DistReadme.md.tmpl";
    public static final String GIT_IGNORE_PATH = "oracle/dbtools/extension/project/commands/init/templates/gitIgnore.tmpl";
    public static final String APEX_REL_FOLDER_NAME = "apex";
    public static final String APEX_CHANGELOG_NAME = "apex.changelog.xml";
    public static final String APEX_CHANGELOG_RESOURCE_PATH = "oracle/dbtools/extension/project/commands/stage/templates/apex.changelog.tmpl";
    public static final String SOURCE_FOLDER_NAME = "src";
    public static final String APEX_FOLDER_NAME = "apex_apps";
    public static final String DATABASE_FOLDER_NAME = "database";
    public static final String APEX_SRC_FOLDER_NAME = "apex_apps";
    public static final String DIST_FOLDER_NAME = "dist";
    public static final String ARTIFACT_FOLDER_NAME = "artifact";
    public static final String UTIL_FOLDER_NAME = "utils";
    public static final String INSTALL_FILE_NAME = "install.sql";
    public static final String PRECHECK_SCRIPT_NAME = "prechecks.sql";
    public static final String COMPILE_INVALID_SCRIPT_NAME = "recompile.sql";
    public static final String RELEASE_FOLDER_NAME = "releases";
    public static final String RELEASE_CHANGELOG_NAME = "release.changelog.xml";
    public static final String NEXT_RELEASE_CHANGELOG_RESOURCE_PATH = "oracle/dbtools/extension/project/commands/stage/templates/release.changelog.tmpl";
    public static final String MAIN_CHANGELOG_NAME = "main.changelog.xml";
    public static final String MAIN_CHANGELOG_RESOURCE_PATH = "oracle/dbtools/extension/project/commands/stage/templates/main.changelog.tmpl";
    public static final String NEXT_FOLDER_NAME = "next";
    public static final String INSTALL_SQL_RESOURCE_PATH = "oracle/dbtools/extension/project/commands/stage/templates/install_sql.tmpl";
    public static final String STAGE_FOLDER_NAME = "changes";
    public static final String STAGE_CHANGELOG_NAME = "stage.changelog.xml";
    public static final String STAGE_CHANGELOG_RESOURCE_PATH = "oracle/dbtools/extension/project/commands/stage/templates/stage.changelog.tmpl";
    public static final String CODE_FOLDER_NAME = "code";
    public static final String CUSTOM_FOLDER_NAME = "_custom";
    public static final String CUSTOM_CHANGE_RESOURCE_PATH = "oracle/dbtools/extension/project/commands/stage/templates/add_custom_sql.tmpl";
    public static final String NEXT_CODE_FOLDER_NAME = "code";
    public static final String NEXT_CODE_CHANGELOG_NAME = "code.changelog.xml";
    public static final String NEXT_CODE_CHANGELOG_RESOURCE_PATH = "oracle/dbtools/extension/project/commands/stage/templates/code.changelog.tmpl";
    public static final String INSTALL_RELEASES_FILE_NAME = "install_releases.sql";
    public static final String DEFAULT_GIT_BRANCH = "git.defaultBranch";
    public static final String PROJECT_DEBUG_PROPERTY = "project.debug";
    public static final String PROJECT_VERBOSE_PROPERTY = "project.verbose";
    public static final String COMPILE_INVALID_SCRIPT_PATH = "oracle/dbtools/extension/project/commands/stage/templates/compile-invalid.sql.tmpl";
    public static final String PRECHECK_SCRIPT_PATH = "oracle/dbtools/extension/project/commands/stage/templates/pre-checks.sql.tmpl";
    public static final String PROJECT_DEFAULT_SETTINGS = "oracle/dbtools/extension/project/commands/init/templates/projectDefaultSettings.json";
    public static final String PROJECT_CONFIG_FILE_NAME = "project.config.json";
    public static final String PROJECT_SQL_FORMAT_NAME = "project.sqlformat.xml";
    public static final String GITIGNORE_FILE_NAME = ".gitignore";
    public static final String README_FILE_NAME = "README.md";
    public static final String RESET_ENV_FILE_NAME = "reset_environment.sql";
    public static final String GUID_FILE_NAME = "GUID";
    public static final String PROJECT_CONFIG_REL_FILE_PATH = ".dbtools" + File.separator + "project.config.json";
    public static final String SQL_FORMAT_RESOURCE_PATH = "export/format/project.sqlformat.xml";
    public static final String INTERNAL_FILTERS_FILE_NAME = "internal.fixed.filters";
    public static final String INTERNAL_FILTERS_RESOURCE_PATH = "export/filters/internal.fixed.filters";
    public static final String PROJECT_FILTERS_FILE_NAME = "project.filters";
    public static final String PROJECT_FILTERS_RESOURCE_PATH = "export/filters/project.filters";
    public static final String SYS_FILTERS_FILE_NAME = "sys.filters";
    public static final String SYS_FILTERS_RESOURCE_PATH = "export/filters/sys.filters";
    public static ScriptRunnerContext ctx = ScriptRunnerContext.getCurrentContext();

    private ProjectConfig() {
    }

    public static String getSqlclVersion() {
        if (ctx == null) {
            throw new RuntimeException("CONTEXT_DOESNT_EXIST");
        }
        return ctx.getCmdlineVersion().toCanonicalString();
    }

    public static String getCurrentWorkingProjectName() {
        if (ProjectConfig.getCurrentWorkingProjectRoot() == null) {
            return null;
        }
        return new File(String.valueOf(ProjectConfig.getCurrentWorkingProjectRoot())).getName();
    }

    public static Path getCurrentWorkingProjectRoot() {
        return ProjectFileUtils.getCurrentWorkingProjectRoot(ProjectConfig.getCWD());
    }

    public static String getCWD() {
        if (ctx == null) {
            throw new RuntimeException("CONTEXT_DOESNT_EXIST");
        }
        return FileUtils.getCWD((ScriptRunnerContext)ctx);
    }

    public static void setScriptRunnerContext(ScriptRunnerContext context) {
        ctx = context;
    }

    public static ScriptRunnerContext getCurrentContext() {
        return ctx;
    }

    public static void setupDebugVerbose(ParsedCommand command) {
        boolean debug = false;
        boolean verbose = false;
        try {
            debug = command.isFlagSet((Id)ProjectOptions.Options.DEBUG);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            verbose = command.isFlagSet((Id)ProjectOptions.Options.VERBOSE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ctx.putProperty(PROJECT_DEBUG_PROPERTY, (Object)debug);
        ctx.putProperty(PROJECT_VERBOSE_PROPERTY, (Object)verbose);
    }

    public static boolean isDebug() {
        try {
            return (Boolean)ctx.getProperty(PROJECT_DEBUG_PROPERTY);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static boolean isVerbose() {
        try {
            return (Boolean)ctx.getProperty(PROJECT_VERBOSE_PROPERTY);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static boolean isNotProjectFolder() throws ProjectNotIdentifiedException {
        if (ProjectConfig.getCurrentWorkingProjectRoot() == null) {
            throw new ProjectNotIdentifiedException(ProjectMessages.get("PROJECT_NOT_IDENTIFIED"));
        }
        return false;
    }
}

