/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.verify;

import com.google.common.base.Throwables;
import java.nio.file.Path;
import java.sql.Connection;
import java.util.List;
import oracle.dbtools.extension.project.commands.Interfaces.CommandInterface;
import oracle.dbtools.extension.project.commands.ProjectMessages;
import oracle.dbtools.extension.project.commands.handler.ProjectOptions;
import oracle.dbtools.extension.project.commands.verify.VerifyMessages;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.exceptions.InvalidCommandOptions;
import oracle.dbtools.extension.project.core.messages.GeneralMessages;
import oracle.dbtools.extension.project.core.utils.ProjectUtils;
import oracle.dbtools.extension.project.core.verify.VerifyEngine;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class VerifyCommand
implements CommandInterface {
    @Override
    public void run(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand parsedCommand) {
        block13: {
            try {
                boolean listGroups = parsedCommand.isFlagSet((Id)ProjectOptions.Options.LIST_GROUPS);
                boolean listServices = parsedCommand.isFlagSet((Id)ProjectOptions.Options.LIST_TESTS);
                String wantedGroup = (String)parsedCommand.getOptionValue((Id)ProjectOptions.Options.GROUP);
                String wantedService = (String)parsedCommand.getOptionValue((Id)ProjectOptions.Options.TEST);
                Path root = ProjectUtils.getProjectRootFolder();
                ProjectConfig.setupDebugVerbose(parsedCommand);
                if (listGroups || listServices) {
                    this.listAction(listGroups, listServices, wantedGroup, wantedService);
                } else {
                    VerifyEngine engine = VerifyEngine.getInstance();
                    if (wantedService != null) {
                        if (!engine.serviceExists(wantedService)) {
                            ctx.writeln(VerifyMessages.format("SERVICE_NOT_FOUND", wantedService));
                            return;
                        }
                        boolean result = engine.runService(wantedService, null);
                        if (ProjectConfig.isVerbose()) {
                            engine.reportServiceMessages(wantedService, ProjectConfig.getCurrentWorkingProjectRoot());
                        }
                    } else if (wantedGroup != null) {
                        if (!engine.groupExists(wantedGroup)) {
                            ctx.writeln(VerifyMessages.format("SERVICE_NOT_FOUND", wantedGroup));
                            return;
                        }
                        boolean result = engine.runGroup(wantedGroup, null);
                        if (ProjectConfig.isVerbose()) {
                            engine.reportGroupMessages(wantedGroup, ProjectConfig.getCurrentWorkingProjectRoot());
                        }
                    } else {
                        boolean result = engine.runAllGroups(null);
                        if (ProjectConfig.isVerbose()) {
                            engine.reportAllMessages(ProjectConfig.getCurrentWorkingProjectRoot());
                        }
                    }
                }
            }
            catch (Exception e) {
                GeneralMessages.errorMessage(ProjectMessages.format("PROCESSING_ERROR", e.getMessage()));
                if (!ProjectConfig.isDebug()) break block13;
                ctx.writeln("DEBUG:");
                ctx.writeln(Throwables.getStackTraceAsString((Throwable)e));
            }
        }
    }

    private void listAction(boolean listGroups, boolean listServices, String group, String service) throws InvalidCommandOptions {
        block9: {
            ScriptRunnerContext ctx;
            VerifyEngine engine;
            block10: {
                block8: {
                    engine = VerifyEngine.getInstance();
                    ctx = ProjectConfig.getCurrentContext();
                    if (listGroups && listServices) {
                        throw new InvalidCommandOptions(VerifyMessages.getString("BAD_LIST_FLAGS"));
                    }
                    if (!listGroups) break block8;
                    if (group != null) {
                        ctx.writeln(VerifyMessages.format("IGNORED_PARAMETER", "group", "listGroups"));
                    }
                    if (service != null) {
                        ctx.writeln(VerifyMessages.format("IGNORED_PARAMETER", "service", "listGroups"));
                    }
                    List<String> groups = engine.getAllGroupNames();
                    ctx.writeln("Groups");
                    ctx.writeln("------");
                    for (String gname : groups) {
                        ctx.writeln(gname);
                    }
                    break block9;
                }
                if (!listServices || group == null) break block10;
                if (service != null) {
                    ctx.writeln(VerifyMessages.format("IGNORED_PARAMETER", "service", "listServices"));
                }
                List<String> services = engine.getGroupServiceNames(group);
                ctx.writeln("Services fot group " + group);
                ctx.writeln("---------------------------");
                for (String sName : services) {
                    ctx.writeln(sName);
                }
                break block9;
            }
            if (!listServices) break block9;
            if (service != null) {
                ctx.writeln(VerifyMessages.format("IGNORED_PARAMETER", "service", "listServices"));
            }
            List<String> services = engine.getAllServiceNames();
            ctx.writeln("Services");
            ctx.writeln("--------");
            for (String sName : services) {
                ProjectConfig.getCurrentContext().writeln(sName);
            }
        }
    }
}

