/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.stage;

import com.google.common.base.Throwables;
import java.nio.file.Path;
import java.sql.Connection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.extension.project.commands.Interfaces.CommandInterface;
import oracle.dbtools.extension.project.commands.ProjectMessages;
import oracle.dbtools.extension.project.commands.handler.ProjectOptions;
import oracle.dbtools.extension.project.commands.stage.StageMessages;
import oracle.dbtools.extension.project.commands.stage.objectclasses.DbDiffObject;
import oracle.dbtools.extension.project.commands.stage.utils.StageUtils;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.exceptions.ProjectSettingsException;
import oracle.dbtools.extension.project.core.exceptions.StageProcessException;
import oracle.dbtools.extension.project.core.messages.GeneralMessages;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.extension.project.core.utils.GitUtils;
import oracle.dbtools.extension.project.core.utils.ProjectUtils;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class StageCommand
implements CommandInterface {
    Path root;

    @Override
    public void run(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand command) {
        try {
            LinkedList<DbDiffObject> bad;
            HashMap<String, LinkedList<DbDiffObject>> diffs;
            Object dest;
            ProjectConfig.setupDebugVerbose(command);
            this.root = ProjectUtils.getProjectRootFolder();
            if (conn == null && ctx.getCurrentConnection() == null) {
                conn = ProjectUtils.getConnection(ctx, ProjectConfig.isVerbose());
            }
            if (conn == null) {
                throw new StageProcessException(StageMessages.get("NULL_CONNECTION"));
            }
            GeneralMessages.verboseMessage(StageMessages.get("STAGE_RUN_BEGIN_MESSAGE"));
            StageUtils stageUtil = new StageUtils(this.root, ctx);
            String currentBranch = GitUtils.getCurrentBranchName(stageUtil.getGit());
            List<String> protectedBranched = ProjectSettings.getSettingAsList("git.protectedBranches");
            if (protectedBranched != null && protectedBranched.contains(currentBranch)) {
                throw new ProjectSettingsException(StageMessages.getString("PROTECTED_BRANCH"));
            }
            String master = (String)command.getOptionValue((Id)ProjectOptions.Options.BRANCH_NAME);
            if ((master == null || master.isEmpty()) && (master = ProjectSettings.getSettingAsString("git.defaultBranch")) != null && master.isEmpty()) {
                ctx.writeln(StageMessages.format("NO_DEFAULT_GIT_BRANCH", new Object[0]));
                return;
            }
            LinkedList<Object> errors = new LinkedList();
            Object source = master;
            if (source != null && !((String)source).startsWith("refs/heads/")) {
                source = "refs/heads/" + (String)source;
            }
            if ((dest = stageUtil.getBranch()) != null && !((String)dest).startsWith("refs/heads/")) {
                dest = "refs/heads/" + (String)dest;
            }
            if ((diffs = GitUtils.diffBranches(stageUtil.getGit().getRepository(), (String)source, (String)dest)).containsKey("ERROR")) {
                errors = diffs.get("ERROR");
                diffs.remove("ERROR");
            }
            if (!(bad = stageUtil.processDiffs(diffs, conn)).isEmpty()) {
                errors.addAll(bad);
            }
            GeneralMessages.verboseMessage(StageMessages.format("STAGE_RUN_END_MESSAGE", stageUtil.getBranch()));
            if (errors != null && !errors.isEmpty()) {
                GeneralMessages.errorMessage(StageMessages.get("BAD_SRC_FILES"));
                for (DbDiffObject dbDiffObject : errors) {
                    ctx.writeln(dbDiffObject.getDestFileName());
                    ctx.writeln("\t" + dbDiffObject.getException().getMessage());
                }
            }
            stageUtil.close();
            GeneralMessages.successMessage(StageMessages.get("STAGE_SUCCESS"));
        }
        catch (Exception e) {
            if (ctx.getCurrentConnection() != null) {
                GeneralMessages.errorMessage(ProjectMessages.format("PROCESSING_ERROR", e.getCause() == null ? e.getMessage() : e.getCause().getMessage()));
            }
            GeneralMessages.debugMessage(Throwables.getStackTraceAsString((Throwable)e));
        }
    }
}

