/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.release;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.Connection;
import oracle.dbtools.extension.project.commands.Interfaces.CommandInterface;
import oracle.dbtools.extension.project.commands.ProjectMessages;
import oracle.dbtools.extension.project.commands.handler.ProjectOptions;
import oracle.dbtools.extension.project.commands.release.ReleaseMessages;
import oracle.dbtools.extension.project.commands.stage.utils.StageUtils;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.exceptions.CreateDirectoryException;
import oracle.dbtools.extension.project.core.exceptions.CreateFileException;
import oracle.dbtools.extension.project.core.exceptions.ProjectNotIdentifiedException;
import oracle.dbtools.extension.project.core.exceptions.ProjectSettingsException;
import oracle.dbtools.extension.project.core.exceptions.ReleaseProcessException;
import oracle.dbtools.extension.project.core.exceptions.StageProcessException;
import oracle.dbtools.extension.project.core.messages.GeneralMessages;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ReleaseCommand
implements CommandInterface {
    @Override
    public void run(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand command) {
        String VERSION = (String)command.getOptionValue((Id)ProjectOptions.Options.VERSION);
        try {
            ProjectConfig.setupDebugVerbose(command);
            Path root = ProjectConfig.getCurrentWorkingProjectRoot();
            if (root == null) {
                ctx.writeln(ProjectMessages.get("PROJECT_NOT_IDENTIFIED"));
                return;
            }
            if (ProjectConfig.isVerbose()) {
                ctx.writeln(ReleaseMessages.format("RELEASE_RUN_MESSAGE", VERSION) + System.lineSeparator());
            }
            StageUtils stageUtil = new StageUtils(root, ctx);
            stageUtil.release(VERSION);
            ProjectSettings.saveValue("lastReleaseVersion", VERSION, "STRING");
            stageUtil.close();
            GeneralMessages.successMessage(ReleaseMessages.get("PROCESS_SUCCESS"));
        }
        catch (IOException | InterruptedException | CreateDirectoryException | CreateFileException | ProjectNotIdentifiedException | ProjectSettingsException | ReleaseProcessException | StageProcessException e) {
            GeneralMessages.errorMessage(ProjectMessages.format("PROCESSING_ERROR", e.getMessage()));
            GeneralMessages.debugMessage(Throwables.getStackTraceAsString((Throwable)e));
        }
    }
}

