/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.export;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.arbori.util.CharOffsets;
import oracle.arbori.util.DbObjNames;
import oracle.arbori.util.DictionaryViews;
import oracle.arbori.util.IO;
import oracle.dbtools.app.Format;
import oracle.dbtools.app.Persist2XML;
import oracle.dbtools.extension.apex.core.APEXExport;
import oracle.dbtools.extension.project.commands.export.ApexExportWrapper;
import oracle.dbtools.extension.project.commands.export.DDL;
import oracle.dbtools.extension.project.commands.export.DbmsMetadata;
import oracle.dbtools.extension.project.commands.export.ExportMessages;
import oracle.dbtools.extension.project.commands.export.Filters;
import oracle.dbtools.extension.project.commands.export.Report;
import oracle.dbtools.extension.project.commands.export.UnarySqlPredicate;
import oracle.dbtools.extension.project.commands.stage.transforms.ObjectTypes;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.messages.GeneralMessages;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.extension.project.core.utils.ProjectFileUtils;
import oracle.dbtools.extension.project.core.utils.ProjectUtils;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.util.SpinningWheel;
import oracle.jdbc.OracleDatabaseException;
import org.apache.commons.io.FileUtils;

public class Export {
    public static Format format = new Format();
    public static final String APEX_APPLICATION = "APEX_APPLICATION";
    public static final String ORDS_SCHEMA = "ORDS_SCHEMA";
    public static final String ALL_OBJECTS = "ALL_OBJECTS";
    public static final String ALL_TAB_COMMENTS = "ALL_TAB_COMMENTS";
    public static final String ALL_COL_COMMENTS = "ALL_COL_COMMENTS";
    public static final String ALL_TAB_COL_COMMENTS = "ALL_TAB_COL_COMMENTS";
    public static final String USER_SYS_PRIVS = "USER_SYS_PRIVS";
    public static final String ALL_TAB_PRIVS = "ALL_TAB_PRIVS";
    DbmsMetadata[] workers;
    int threads;
    ScriptRunnerContext ctx;
    final Connection conn;
    Map<String, String> filters;
    DictionaryViews dictViews;
    String projectPath;
    boolean listOnly;
    Report report;

    /*
     * WARNING - void declaration
     */
    public Export(ScriptRunnerContext ctx, List<String> schemas, List<String> objects, int threads, boolean listOnly) throws Exception {
        List<Object> tmp;
        List<String> configSchemas;
        block28: {
            this.filters = new HashMap<String, String>();
            this.threads = threads;
            this.ctx = ctx;
            this.listOnly = listOnly;
            this.projectPath = ProjectFileUtils.findProjectRoot(ctx);
            if (this.projectPath == null) {
                throw new Exception(ExportMessages.getString("EXPORT_PROJECT_NOT_IDENTIFIED"));
            }
            this.conn = ProjectUtils.getConnection(ctx, true);
            if (null == this.conn) {
                return;
            }
            this.report = new Report(this);
            this.dictViews = new DictionaryViews(this.conn);
            if (!ProjectSettings.getSettingAsBoolean("export.format.enable").booleanValue()) {
                format = null;
            } else {
                File f = new File(this.projectPath + File.separator + ".dbtools" + File.separator + "project.sqlformat.xml");
                if (f.exists()) {
                    try {
                        URL url = f.toURI().toURL();
                        Map options = Persist2XML.read((URL)url);
                        format.setOptions(options);
                    }
                    catch (Exception e) {
                        Report.warning(ctx, "Failed to read format options " + e.getMessage());
                    }
                }
            }
            configSchemas = ProjectSettings.getSettingAsList("schemas");
            tmp = new LinkedList();
            String configFiltersDir = this.projectPath + File.separator + ".dbtools" + File.separator + "filters";
            try {
                boolean bl;
                String canonicalInternalFilters = ProjectFileUtils.getResourcesFileContent(Paths.get("export/filters/internal.fixed.filters", new String[0]));
                boolean bl2 = false;
                for (Object file : IO.visitor4Directory((String)configFiltersDir, (String[])new String[]{"filter", "filters", "condition", "conditions"})) {
                    void var13_24;
                    String string = ((File)file).toString();
                    String content = IO.readFile((String)string);
                    int pos = string.lastIndexOf(File.separator);
                    if (0 < pos) {
                        String string2 = string.substring(pos + 1);
                    }
                    if (var13_24.contains("internal")) {
                        bl = true;
                        int lineDiff = CharOffsets.lineDiff((String)content, (String)canonicalInternalFilters);
                        if (-1 < lineDiff) {
                            Report.warning(ctx, ExportMessages.getString("INTERNAL_FILTERS_FOUND"));
                        }
                    }
                    if ((tmp = Filters.parse(content, (String)var13_24)) == null) {
                        return;
                    }
                    for (String string3 : tmp) {
                        this.filters.put(string3, (String)var13_24);
                    }
                }
                if (!bl) {
                    String filename = "sqlcl internal.fixed.filters";
                    tmp = Filters.parse(canonicalInternalFilters, filename);
                    for (String string : tmp) {
                        this.filters.put(string, filename);
                    }
                }
            }
            catch (IOException e) {
                if (!ProjectConfig.isDebug()) break block28;
                Report.warning(ctx, "Warning: " + e.getMessage() + " not found\n");
            }
        }
        if (schemas.size() == 0 && objects.size() == 0 && configSchemas != null) {
            tmp = Filters.addSchemas(configSchemas);
            for (String string : tmp) {
                this.filters.put(string, "config schemas");
            }
        }
        tmp = Filters.addSchemas(schemas);
        for (String string : tmp) {
            this.filters.put(string, " -schemas export option");
        }
        tmp = Filters.addObjects(objects);
        for (String string : tmp) {
            this.filters.put(string, " -objects export option");
        }
        try {
            this.export();
        }
        catch (SyntaxError e) {
            throw e;
        }
        catch (SQLException e) {
            void var10_21;
            String string = "";
            Throwable cause = e.getCause();
            if (cause instanceof OracleDatabaseException) {
                OracleDatabaseException ode = (OracleDatabaseException)cause;
                String string4 = string + ode.getSql() + "\n";
            }
            throw new Exception((String)var10_21 + e.getMessage());
        }
        finally {
            this.quitWorkers();
            this.report.summary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void export() throws Exception {
        ResultSet rs;
        Statement stmt;
        boolean isApplied;
        UnarySqlPredicate pred;
        long t1;
        Object query;
        String priorType;
        block123: {
            boolean emitSchema = Boolean.TRUE.equals(ProjectSettings.getSettingAsBoolean("export.setTransform.emitSchema"));
            Filters.verify(this.filters);
            ScriptExecutor sqlcl = (ScriptExecutor)this.ctx.getProperty("runner");
            String objectColumns = "    OWNER, OBJECT_NAME, SUBOBJECT_NAME, OBJECT_ID, DATA_OBJECT_ID,\n    OBJECT_TYPE, CREATED, LAST_DDL_TIME, TIMESTAMP, STATUS,\n    TEMPORARY, GENERATED, SECONDARY, NAMESPACE, EDITION_NAME,\n    SHARING, EDITIONABLE, ORACLE_MAINTAINED, APPLICATION, DEFAULT_COLLATION,\n    DUPLICATED, SHARDED, CREATED_APPID, CREATED_VSNID,\n    MODIFIED_APPID, MODIFIED_VSNID";
            SpinningWheel.start((ScriptRunnerContext)this.ctx);
            priorType = null;
            HashSet<String> tables = new HashSet<String>();
            HashSet<CallSite> mvs = new HashSet<CallSite>();
            HashSet<Object> owners = new HashSet<Object>();
            query = "select * from (SELECT " + objectColumns + " , 'ALL_OBJECTS' EXPORT_TYPE \nFROM   all_objects) all_objects\nORDER BY object_type,owner, object_name";
            query = Filters.apply((String)query, this.filters);
            query = this.dictViews.translate((String)query);
            GeneralMessages.debugMessage("/* Main dictionary query against ALL_OBJECTS: */\n" + (String)query);
            t1 = System.currentTimeMillis();
            String typ = "null";
            String nam = "null";
            try (Statement stmt2 = this.conn.createStatement();
                 ResultSet rs2 = stmt2.executeQuery((String)query);){
                this.initWorkers();
                GeneralMessages.debugMessage("Elapsed = " + (System.currentTimeMillis() - t1) / 1000L + "s");
                while (rs2.next()) {
                    if (sqlcl != null && sqlcl.getInterrupted()) {
                        this.cancelExport();
                        return;
                    }
                    String owner = rs2.getString("owner");
                    String string = rs2.getString("object_name");
                    String type = rs2.getString("object_type");
                    nam = string;
                    typ = type;
                    String qualifiedName = (String)owner + "." + string;
                    if (!type.equals(priorType)) {
                        Report.writeln(this.ctx, "*** " + ObjectTypes.plural(type) + " ***");
                        Report.noVerboseDebugSpinningWheel(this.ctx);
                    }
                    priorType = type;
                    if ("MATERIALIZED VIEW".equals(type)) {
                        mvs.add((CallSite)((Object)qualifiedName));
                    }
                    if ("TABLE".equals(type)) {
                        if (mvs.contains(qualifiedName)) continue;
                        tables.add(qualifiedName);
                    }
                    owners.add(owner);
                    if (this.listOnly && !ProjectConfig.isVerbose()) {
                        Report.writeln(this.ctx, qualifiedName);
                        this.report.incrTypeCnt(type);
                        continue;
                    }
                    Report.verbose(this.ctx, qualifiedName);
                    if (this.listOnly) continue;
                    this.startWorker(owner, type, string);
                }
            }
            catch (Throwable e) {
                Report.processException(this.ctx, e, typ, nam);
                return;
            }
            pred = new UnarySqlPredicate(this.conn, "export_type", new String[]{"CREATE_USER"});
            isApplied = pred.eval(this.filters);
            for (String string : owners) {
                if (this.listOnly || !isApplied) break;
                Object ddl = "create user " + string + " no authentication;\n";
                ddl = DbmsMetadata.appendSxmlAndHash(this.conn.getSchema(), "USER", string, (String)ddl, null);
                DbmsMetadata.saveDbObject(this, string, "USER", string, (String)ddl);
            }
            String template = "'comment on table HR.COUNTRIES is '''||REPLACE(comments,'''','''''')||''';'";
            template = emitSchema ? template.replace("HR.COUNTRIES", "'||owner||'.'||table_name||'") : template.replace("HR.COUNTRIES", "'||table_name||'");
            String string = "COMMENT";
            query = "/* Query ALL_TAB_COMMENTS: */\nSELECT * from (select owner, table_name name, " + template + " ddl, \n'ALL_TAB_COMMENTS' export_type \nFROM   all_tab_comments \nWHERE  comments is not null) all_tab_comments\n\n";
            Map<String, String> object2ddl = new DDL((String)query, this).generate(string, null, tables);
            template = "'comment on column HR.COUNTRIES.'||column_name||' is '''||REPLACE(comments,'''','''''')||''';'";
            template = emitSchema ? template.replace("HR.COUNTRIES", "'||owner||'.'||table_name||'") : template.replace("HR.COUNTRIES", "'||table_name||'");
            query = "/* Query ALL_COL_COMMENTS: */\nSELECT * from (select owner, table_name name, column_name, " + template + " ddl, \n'ALL_COL_COMMENTS' export_type \nFROM   all_col_comments \nWHERE  comments is not null) all_col_comments\n\n";
            SpinningWheel.start((ScriptRunnerContext)this.ctx);
            object2ddl = new DDL((String)query, this).generate(null, object2ddl, tables);
            if (!this.listOnly) {
                DbmsMetadata.saveObjects(object2ddl, string, this);
            }
            query = "select * from (SELECT owner, constraint_name, table_name, \n       r_owner, r_constraint_name, generated \n , 'ALL_OBJECTS' EXPORT_TYPE \nFROM   sys.all_constraints \nWHERE  constraint_type in ('R') \n) all_constraints \n";
            query = Filters.apply((String)query, this.filters);
            query = this.dictViews.translate((String)query);
            GeneralMessages.debugMessage("/* Query ALL_CONSTRAINTS: */\n" + (String)query);
            t1 = System.currentTimeMillis();
            SpinningWheel.start((OutputStream)this.ctx.getOutputStream());
            stmt = this.conn.createStatement();
            try {
                rs = stmt.executeQuery((String)query);
                try {
                    GeneralMessages.debugMessage("Elapsed = " + (System.currentTimeMillis() - t1) / 1000L + "s");
                    while (rs.next()) {
                        if (sqlcl != null && sqlcl.getInterrupted()) {
                            this.cancelExport();
                            return;
                        }
                        String owner = rs.getString("owner");
                        String name = rs.getString("constraint_name");
                        String table_name = rs.getString("table_name");
                        String string2 = "REF_CONSTRAINT";
                        if (!tables.contains(owner + "." + table_name)) continue;
                        if (!string2.equals(priorType)) {
                            Report.writeln(this.ctx, "*** " + ObjectTypes.plural(string2) + " ***");
                            Report.noVerboseDebugSpinningWheel(this.ctx);
                        }
                        priorType = string2;
                        Report.verbose(this.ctx, owner + "." + name);
                        if (this.listOnly && !ProjectConfig.isVerbose()) {
                            Report.writeln(this.ctx, owner + "." + name);
                            this.report.incrTypeCnt(string2);
                            continue;
                        }
                        if (this.listOnly) continue;
                        this.startWorker(owner, string2, name);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            query = "select * from (select GRANTOR, -- need explicit select terms for filter application \n       GRANTEE, \n       TABLE_SCHEMA  OWNER_TMP,   --<-- inconsistent dictionary views column name\n       TABLE_NAME         , \n       PRIVILEGE          ,  \n       GRANTABLE          ,   \n       HIERARCHY          ,   \n       COMMON             ,   \n       TYPE               ,  \n       INHERITED             \n , 'ALL_TAB_PRIVS' EXPORT_TYPE \nfrom   all_tab_privs where type != 'USER') all_tab_privs \n";
            query = Filters.apply((String)query, this.filters);
            query = this.dictViews.translate((String)query);
            if (((String)query).contains("Dba_tab_privs")) {
                query = ((String)query).replace("TABLE_SCHEMA", "OWNER");
            }
            query = ((String)query).replace("OWNER_TMP", "OWNER");
            GeneralMessages.debugMessage("/* Query ALL_TAB_PRIVS: */\n" + (String)query);
            SpinningWheel.start((ScriptRunnerContext)this.ctx);
            t1 = System.currentTimeMillis();
            stmt = this.conn.createStatement();
            try {
                rs = stmt.executeQuery((String)query);
                try {
                    GeneralMessages.debugMessage("Elapsed = " + (System.currentTimeMillis() - t1) / 1000L + "s");
                    HashMap<CallSite, CallSite> file2ddl = new HashMap<CallSite, CallSite>();
                    while (rs.next()) {
                        String filename;
                        String tmp;
                        if (sqlcl != null && sqlcl.getInterrupted()) {
                            this.cancelExport();
                            return;
                        }
                        String grant = "GRANT";
                        this.report.incrTypeCnt("GRANT");
                        if (!"GRANT".equals(priorType)) {
                            Report.writeln(this.ctx, "*** " + ObjectTypes.plural("GRANT") + " ***");
                            Report.noVerboseDebugSpinningWheel(this.ctx);
                        }
                        priorType = "GRANT";
                        String grantee = rs.getString("grantee");
                        String grantor = rs.getString("grantor");
                        String table_schema = rs.getString("owner");
                        if (table_schema == null) {
                            throw new Exception("table_schema == null");
                        }
                        String table_name = rs.getString("table_name");
                        String privilege = rs.getString("privilege");
                        String string3 = rs.getString("type");
                        Object ddl = "grant " + privilege + " on " + table_schema + "." + DbObjNames.addDoubleQuote((String)table_name) + " to " + grantee + ";";
                        Report.verbose(this.ctx, (String)ddl + "                   \r");
                        if (this.listOnly) continue;
                        if (format != null) {
                            try {
                                long t11 = System.currentTimeMillis();
                                ddl = format.format((String)ddl);
                                this.report.formatTiming += System.currentTimeMillis() - t11;
                            }
                            catch (Exception e) {
                                Report.warning(this.ctx, "Failed formatting grants");
                            }
                        }
                        if ((tmp = (String)file2ddl.get(table_schema + "." + (filename = "object_grants_as_grantor." + table_schema + "." + string3 + "." + table_name.replaceAll("/", "_")))) == null) {
                            tmp = "";
                        }
                        file2ddl.put((CallSite)((Object)(table_schema + "." + filename)), (CallSite)((Object)(tmp + (String)ddl + "\n\n")));
                    }
                    for (String key : file2ddl.keySet()) {
                        int pos = key.indexOf(".");
                        String ddl = (String)file2ddl.get(key);
                        try {
                            ddl = DbmsMetadata.appendSxmlAndHash(this.conn.getSchema(), "OBJECT_GRANT", key.substring(pos + 1), ddl, null);
                        }
                        catch (NoSuchAlgorithmException e) {
                            Report.error(this.ctx, e.getMessage());
                        }
                        DbmsMetadata.saveDbObject(this, key.substring(0, pos), "OBJECT_GRANT", key.substring(pos + 1), ddl);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            query = "select * from (select  APPLICATION_ID,   \n       APPLICATION_NAME, \n       OWNER           \n , 'APEX_APPLICATION' EXPORT_TYPE \nfrom   APEX_APPLICATIONS) APEX_APPLICATIONS\n";
            query = Filters.apply((String)query, this.filters);
            t1 = System.currentTimeMillis();
            pred = new UnarySqlPredicate(this.conn, "export_type", new String[]{APEX_APPLICATION});
            isApplied = pred.eval(this.filters);
            if (isApplied) {
                GeneralMessages.debugMessage("/* Query APEX_APPLICATIONS: */\n" + (String)query);
                try {
                    stmt = this.conn.createStatement();
                    try {
                        rs = stmt.executeQuery((String)query);
                        try {
                            GeneralMessages.debugMessage("Elapsed = " + (System.currentTimeMillis() - t1) / 1000L + "s");
                            while (rs.next()) {
                                if (!APEX_APPLICATION.equals(priorType)) {
                                    Report.writeln(this.ctx, "*** APEX_APPLICATION ***");
                                }
                                SpinningWheel.start((ScriptRunnerContext)this.ctx);
                                priorType = APEX_APPLICATION;
                                if (sqlcl != null && sqlcl.getInterrupted()) {
                                    this.cancelExport();
                                    return;
                                }
                                this.report.incrTypeCnt(APEX_APPLICATION);
                                String id = rs.getString("application_id");
                                String apex_owner = rs.getString("owner").toLowerCase();
                                if (this.listOnly) {
                                    void var16_27;
                                    this.ctx.writeln("application_id=" + id);
                                    this.report.incrTypeCnt((String)var16_27);
                                    continue;
                                }
                                try {
                                    LinkedHashMap<String, APEXExport.RowDetails> export = ApexExportWrapper.ExportApplication(id, this.ctx);
                                    Path srcPath = Paths.get(this.projectPath, "src");
                                    FileUtils.createParentDirectories((File)srcPath.toFile());
                                    Path apexPath = Paths.get(srcPath.toString(), "database".toLowerCase(), apex_owner, "apex_apps".toLowerCase());
                                    FileUtils.createParentDirectories((File)srcPath.toFile());
                                    for (String key : export.keySet()) {
                                        APEXExport.RowDetails row = export.get(key);
                                        if (row == null) continue;
                                        Path file = Paths.get(apexPath.toString().toLowerCase(), "f" + row.getAppId(), row.getFileName().toLowerCase());
                                        FileUtils.createParentDirectories((File)file.toFile());
                                        String content = !file.toString().endsWith(".yaml") ? DbmsMetadata.appendSxmlAndHash(this.conn.getSchema(), APEX_APPLICATION, "f" + row.getAppId(), row.getContents(), null) : row.getContents();
                                        ProjectFileUtils.createFileWithContent(file, content);
                                    }
                                }
                                catch (Exception e) {
                                    Report.warning(this.ctx, "Failed to export application_id = " + id + " due to " + e.getMessage());
                                }
                            }
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                    finally {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                }
                catch (Exception e) {
                    if (e.getMessage().contains("ORA-00942")) {
                        if (ProjectConfig.isDebug()) {
                            Report.warning(this.ctx, (String)query + "\n" + e.getMessage());
                        }
                        break block123;
                    }
                    throw e;
                }
                finally {
                    Report.write(this.ctx, "");
                }
            }
        }
        t1 = System.currentTimeMillis();
        query = "select * from ( \n SELECT ords_metadata.ords_export.export_schema() out, \n                        'ORDS_SCHEMA'\n                          EXPORT_TYPE \n  FROM dual)";
        query = Filters.apply((String)query, this.filters);
        pred = new UnarySqlPredicate(this.conn, "export_type", new String[]{ORDS_SCHEMA});
        isApplied = pred.eval(this.filters);
        if (isApplied) {
            SpinningWheel.start((ScriptRunnerContext)this.ctx);
            GeneralMessages.debugMessage("/* Query ORDS: */\n" + (String)query);
            try {
                stmt = this.conn.createStatement();
                try {
                    rs = stmt.executeQuery((String)query);
                    try {
                        rs.next();
                        String ords = rs.getString(1);
                        Report.writeln(this.ctx, "*** ORDS_SCHEMA ***");
                        priorType = ORDS_SCHEMA;
                        Path srcPath = Paths.get(this.projectPath, "src");
                        FileUtils.createParentDirectories((File)srcPath.toFile());
                        String name = "ords_schema";
                        Path ordsPath = Paths.get(srcPath.toString(), "database", name);
                        FileUtils.createParentDirectories((File)srcPath.toFile());
                        Path file = Paths.get(ordsPath.toString(), name + ".sql");
                        FileUtils.createParentDirectories((File)file.toFile());
                        ords = DbmsMetadata.appendSxmlAndHash(this.conn.getSchema(), ORDS_SCHEMA, name, ords, null);
                        ProjectFileUtils.createFileWithContent(file, ords);
                        this.report.incrTypeCnt(ORDS_SCHEMA);
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            catch (Exception e) {
                if (e.getMessage().contains("ORA-00904") && ProjectConfig.isDebug()) {
                    Report.warning(this.ctx, (String)query + "\n" + e.getMessage());
                }
                if (!"Result set after last row".equals(e.getMessage()) && ProjectConfig.isDebug()) {
                    Report.warning(this.ctx, "Failed to export ords  due to " + e.getMessage());
                }
            }
            finally {
                Report.write(this.ctx, "");
                GeneralMessages.debugMessage("Elapsed = " + (System.currentTimeMillis() - t1) / 1000L + "s");
            }
        }
    }

    void initWorkers() throws SQLException {
        this.workers = new DbmsMetadata[this.threads];
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i] = new DbmsMetadata(this);
        }
    }

    void startWorker(String owner, String type, String name) {
        if (type == null || "null".equals(type)) {
            throw new AssertionError((Object)"type == null");
        }
        while (!Thread.interrupted()) {
            for (int i = 0; i < this.workers.length; ++i) {
                if (!this.workers[i].setArgs(owner, type, name)) continue;
                return;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    void cancelExport() {
        Report.warning(this.ctx, "\nCancelled export");
        this.quitWorkers();
        SpinningWheel.stop();
    }

    void quitWorkers() {
        if (this.workers == null) {
            return;
        }
        if (this.workers != null && ProjectConfig.isDebug()) {
            for (DbmsMetadata dm : this.workers) {
                if (dm.getName() == null) continue;
                Report.debug(this.ctx, "Active thread, object name: " + dm.getName());
            }
        }
        for (DbmsMetadata dm : this.workers) {
            dm.quit = true;
        }
        int timeout = 60000;
        SpinningWheel.start();
        long t1 = System.currentTimeMillis();
        block4: while (true) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            for (DbmsMetadata dm : this.workers) {
                if (dm.finished) continue;
                if (t1 + (long)timeout >= System.currentTimeMillis()) continue block4;
                Report.error(this.ctx, dm.getName() + " not finished (timeout = " + timeout / 1000 + "s)");
                return;
            }
            break;
        }
    }
}

