/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.export;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BinaryRelation {
    Map<String, Set<String>> forward = new HashMap<String, Set<String>>();
    Map<String, Set<String>> backward = new HashMap<String, Set<String>>();

    public static BinaryRelation join(BinaryRelation r1, BinaryRelation r2) {
        BinaryRelation ret = new BinaryRelation();
        for (String from : r1.forward.keySet()) {
            for (String mid : r1.forward.get(from)) {
                Set<String> set = r2.forward.get(mid);
                if (set == null) continue;
                for (String to : set) {
                    ret.add(from, to);
                }
            }
        }
        return ret;
    }

    public void add(String from, String to) {
        Set<String> tmp = this.forward.get(from);
        if (tmp == null) {
            tmp = new HashSet<String>();
            this.forward.put(from, tmp);
        }
        tmp.add(to);
        tmp = this.backward.get(to);
        if (tmp == null) {
            tmp = new HashSet<String>();
            this.backward.put(to, tmp);
        }
        tmp.add(to);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        for (String from : this.forward.keySet()) {
            for (String to : this.forward.get(from)) {
                ret.append(from + " ---> " + to + "\n");
            }
        }
        return ret.toString();
    }

    public int size() {
        int ret = 0;
        for (String from : this.forward.keySet()) {
            for (String to : this.forward.get(from)) {
                ++ret;
            }
        }
        return ret;
    }

    public Set<String> reflectiveElements() {
        HashSet<String> ret = new HashSet<String>();
        for (String from : this.forward.keySet()) {
            for (String to : this.forward.get(from)) {
                if (!from.equals(to)) continue;
                ret.add(from);
            }
        }
        return ret;
    }
}

