/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.deploy;

import com.google.common.base.Throwables;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.util.UUID;
import oracle.dbtools.extension.project.commands.Interfaces.CommandInterface;
import oracle.dbtools.extension.project.commands.ProjectMessages;
import oracle.dbtools.extension.project.commands.deploy.DeployMessages;
import oracle.dbtools.extension.project.commands.handler.ProjectOptions;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.exceptions.ProjectDBConnectionException;
import oracle.dbtools.extension.project.core.exceptions.ProjectDeployException;
import oracle.dbtools.extension.project.core.messages.GeneralMessages;
import oracle.dbtools.extension.project.core.utils.FileCompressionUtils;
import oracle.dbtools.extension.project.core.utils.ProjectFileUtils;
import oracle.dbtools.extension.project.core.utils.QueryUtil;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import org.apache.commons.io.FilenameUtils;

public class DeployCommand
implements CommandInterface {
    private static final boolean OS_IS_WINDOWS;

    @Override
    public void run(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand command) {
        try {
            Path artifactPath;
            ProjectConfig.setupDebugVerbose(command);
            String fileOption = (String)command.getOptionValue((Id)ProjectOptions.Options.FILE);
            if (OS_IS_WINDOWS) {
                if (!(fileOption = Paths.get(fileOption, new String[0]).normalize().toString()).startsWith("\\")) {
                    fileOption = Paths.get(ProjectConfig.getCWD(), fileOption).normalize().toString();
                }
            } else {
                fileOption = !fileOption.contains("~") && !fileOption.startsWith("/") ? Path.of(ProjectConfig.getCWD(), fileOption).toString() : ProjectFileUtils.expandTilde(fileOption);
            }
            GeneralMessages.verboseMessage(DeployMessages.getString("CHECK_DB_CONN"));
            if (ctx.getCurrentConnection() == null) {
                throw new ProjectDBConnectionException(DeployMessages.getString("DB_CONN_EXCEPTION"));
            }
            File file = new File(fileOption);
            String baseName = FilenameUtils.getBaseName((String)file.toString());
            GeneralMessages.verboseMessage(DeployMessages.format("EXTRACT_FILE_NAME", baseName));
            if (file.exists() && file.isFile()) {
                GeneralMessages.verboseMessage(DeployMessages.format("ARTIFACT_DECOMPRESSION", new Object[0]));
                UUID uuid = UUID.randomUUID();
                artifactPath = Files.createTempDirectory(uuid.toString(), new FileAttribute[0]);
                FileCompressionUtils.decompressFile(Path.of(file.getPath(), new String[0]), artifactPath);
                GeneralMessages.verboseMessage(DeployMessages.format("ARTIFACT_DECOMPRESSED", artifactPath));
                if (!Paths.get(artifactPath.toString(), "install.sql").toFile().exists()) {
                    throw new ProjectDeployException(DeployMessages.format("INSTALL_DOESNT_EXIST", new Object[0]));
                }
                GeneralMessages.successMessage(DeployMessages.format("STARTING_MIGRATION", new Object[0]));
                Object b4 = ctx.getProperty("script.runner.cd_command");
                String b42 = (String)ctx.getMap().get(ScriptRunnerContext.SqlplusVariable._PWD.toString());
                ctx.putProperty("script.runner.cd_command", (Object)artifactPath.toString());
                ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._PWD.toString(), artifactPath.toString());
                ScriptRunnerContext octx = null;
                octx = LbUtils.getContext();
                LbUtils.setPctx((ScriptRunnerContext)ctx);
                LbUtils.getConfig().setContext(ctx);
                String out = QueryUtil.runSqlReturnResult("cd " + artifactPath + "\n@install.sql\n", conn, true);
                ctx.writeln(out);
                LbUtils.getConfig().setContext(octx);
                ctx.putProperty("script.runner.cd_command", b4);
                ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._PWD.toString(), b42);
                GeneralMessages.successMessage(DeployMessages.format("MIGRATION_COMPLETED", new Object[0]));
            } else {
                throw new ProjectDeployException(DeployMessages.format("NO_PROPER_ARTIFACT_PROVIDED", new Object[0]));
            }
            GeneralMessages.verboseMessage(DeployMessages.format("REMOVE_DECOMPRESSED_ARTIFACT", artifactPath));
        }
        catch (Exception e) {
            if (ctx.getCurrentConnection() != null) {
                GeneralMessages.errorMessage(ProjectMessages.format("PROCESSING_ERROR", e.getLocalizedMessage()));
            }
            GeneralMessages.debugMessage(Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    static {
        String os = System.getProperty("os.name");
        OS_IS_WINDOWS = os.startsWith("Windows");
    }
}

