/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci;

import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import net.i2p.crypto.eddsa.KeyPairGenerator;
import org.apache.sshd.common.config.keys.writer.openssh.OpenSSHKeyPairResourceWriter;
import org.apache.sshd.common.util.io.output.SecureByteArrayOutputStream;

final class SessionKey {
    private static final KeyPairGenerator keyPairGenerator = new KeyPairGenerator();
    private final KeyPair key = keyPairGenerator.generateKeyPair();
    private final String id = "dbtools-client-" + System.currentTimeMillis();
    private final String openSSHPublicKey;

    static SessionKey instance() {
        return Holder.INSTANCE;
    }

    private SessionKey() {
        String publicKey = null;
        OpenSSHKeyPairResourceWriter writer = OpenSSHKeyPairResourceWriter.INSTANCE;
        try (SecureByteArrayOutputStream bos = new SecureByteArrayOutputStream();){
            writer.writePublicKey(this.key, "", (OutputStream)bos);
            publicKey = bos.toString();
        }
        catch (IOException | GeneralSecurityException e) {
            publicKey = null;
        }
        this.openSSHPublicKey = publicKey;
    }

    KeyPair getKeyPair() {
        return this.key;
    }

    String getOpenSSHPublicKey() {
        return this.openSSHPublicKey;
    }

    String getID() {
        return this.id;
    }

    private static class Holder {
        private static final SessionKey INSTANCE = new SessionKey();

        private Holder() {
        }
    }
}

