/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp.transport;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.cmp.PKIMessage;
import oracle.security.crypto.cmp.transport.TCPMessage;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class PKIRequestTCPMsg
extends TCPMessage {
    private static final TCPMessage.Type TYPE = TCPMessage.Type.PKI_REQ;
    private PKIMessage pkiMsg;
    private transient byte[] contents;

    public PKIRequestTCPMsg(PKIMessage pkiMsg) {
        this(TCPMessage.Version.CMP2000, pkiMsg);
    }

    public PKIRequestTCPMsg(TCPMessage.Version version, PKIMessage pkiMsg) {
        super(version);
        this.pkiMsg = pkiMsg;
    }

    public PKIRequestTCPMsg(InputStream is) throws IOException {
        this.input(is);
    }

    @Override
    public TCPMessage.Type getType() {
        return TYPE;
    }

    public PKIMessage getPKIMessage() {
        return this.pkiMsg;
    }

    @Override
    byte[] getValueBytes() {
        if (this.contents == null) {
            this.contents = Utils.toBytes((Streamable)this.pkiMsg);
        }
        return this.contents;
    }

    @Override
    void setValueBytes(byte[] value) {
        try {
            this.pkiMsg = new PKIMessage((InputStream)new UnsyncByteArrayInputStream(value));
        }
        catch (IOException ex) {
            throw new StreamableInputException(ex.toString());
        }
        this.contents = value;
    }

    @Override
    void clearCache() {
        this.contents = null;
    }

    public String toString() {
        return TYPE + " { pkiMsg = " + this.pkiMsg + " }";
    }
}

