/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp.attribute;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.cmp.CMP;
import oracle.security.crypto.cmp.attribute.RegistrationControl;

public class AuthenticatorRegControl
extends RegistrationControl {
    private static final ASN1ObjectID TYPE = CMP.id_regCtrl_authenticator;
    private String authenticator;

    public AuthenticatorRegControl() {
        super(TYPE, null);
    }

    public AuthenticatorRegControl(String authenticator) {
        this();
        this.authenticator = authenticator;
    }

    public AuthenticatorRegControl(InputStream is) throws IOException {
        this();
        this.input(is);
    }

    public String getAuthenticator() {
        this.decodeValue();
        return this.authenticator;
    }

    @Override
    protected void encodeValue() {
        if (!this.encoded) {
            ASN1String str = new ASN1String(this.authenticator, 12);
            this.setValue((ASN1Object)str);
            this.encoded = true;
            this.decoded = true;
        }
    }

    @Override
    protected void decodeValue() {
        if (!this.decoded) {
            this.authenticator = ((ASN1String)this.getValue()).getValue();
            this.decoded = true;
        }
    }
}

