/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.util.Hashtable;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cmp.CMPUtils;
import oracle.security.crypto.cmp.Challenge;
import oracle.security.crypto.cmp.PKIMessageBody;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class POPChallenge
extends PKIMessageBody {
    private static final PKIMessageBody.Type TYPE = PKIMessageBody.Type.POP_CHALLENGE;
    private Vector challenges = new Vector();
    private Hashtable witnessTab = new Hashtable();
    private transient ASN1Object contents;

    public POPChallenge() {
    }

    public POPChallenge(Challenge challenge) {
        this.addChallenge(challenge);
    }

    public POPChallenge(InputStream is) throws IOException {
        this.input(is);
    }

    public void addChallenge(Challenge challenge) {
        BigInteger witNum = new BigInteger(1, challenge.getWitness());
        if (this.witnessTab.get(witNum) != null) {
            throw new IllegalArgumentException("Challenge random integer must be unique");
        }
        if (this.challenges.size() == 0 && challenge.getDigestAlgID() == null) {
            throw new IllegalArgumentException("First challenge must specify the digest algorithm");
        }
        this.challenges.addElement(challenge);
        this.witnessTab.put(witNum, witNum);
        this.update();
    }

    public Vector getChallenges() {
        return this.challenges;
    }

    public boolean verify(int challengeIndex, GeneralName sender, PrivateKey privKey) throws NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, NoSuchPaddingException, IllegalBlockSizeException {
        Challenge challenge = (Challenge)this.challenges.elementAt(challengeIndex);
        int i = challengeIndex;
        AlgorithmIdentifier algID = challenge.getDigestAlgID();
        while (algID == null && i >= 0) {
            algID = ((Challenge)this.challenges.elementAt(--i)).getDigestAlgID();
        }
        if (algID == null) {
            throw new NoSuchAlgorithmException("No digest algorithm found for challenge witness");
        }
        byte[] witness = MessageDigest.getInstance(CMPUtils.getAlgoName(algID)).digest(challenge.getRandomInt(privKey).toByteArray());
        if (!Utils.areEqual((byte[])challenge.getWitness(), (byte[])witness)) {
            return false;
        }
        return sender.equals((Object)challenge.getSender(privKey));
    }

    @Override
    public PKIMessageBody.Type getType() {
        return TYPE;
    }

    public String toString() {
        return TYPE + " { challenges = " + Utils.toString((Vector)this.challenges) + " }";
    }

    public void input(InputStream is) throws IOException {
        this.update();
        this.contents = new ASN1Sequence(is);
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        this.challenges.removeAllElements();
        this.witnessTab.clear();
        while (sis.hasMoreData()) {
            Challenge challenge = new Challenge((InputStream)sis);
            BigInteger witNum = new BigInteger(1, challenge.getWitness());
            if (this.witnessTab.get(witNum) != null) {
                throw new InvalidInputException("Challenge random integers must be unique");
            }
            this.challenges.addElement(challenge);
            this.witnessTab.put(witNum, witNum);
        }
        sis.terminate();
    }

    @Override
    ASN1Object toASN1Object() {
        if (this.contents == null) {
            this.contents = new ASN1Sequence(this.challenges);
        }
        return this.contents;
    }

    @Override
    void clearCache() {
        this.contents = null;
    }
}

