/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.AttributeTypeAndValue;
import oracle.security.crypto.cert.AttributeTypeAndValueList;
import oracle.security.crypto.cmp.PKIMessageBody;
import oracle.security.crypto.cmp.attribute.InfoTypeAndValue;
import oracle.security.crypto.util.OIDManager;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class GeneralMessage
extends PKIMessageBody {
    private static final PKIMessageBody.Type TYPE = PKIMessageBody.Type.GENERAL_MESSAGE;
    private AttributeTypeAndValueList infoList = new AttributeTypeAndValueList();
    private transient ASN1Object contents;

    public GeneralMessage() {
    }

    public GeneralMessage(ASN1ObjectID type) {
        this(type, null);
    }

    public GeneralMessage(ASN1ObjectID type, ASN1Object value) {
        this.addInfo(type, value);
    }

    public GeneralMessage(InfoTypeAndValue info) {
        this.addInfo(info);
    }

    public GeneralMessage(InputStream is) throws IOException {
        this.input(is);
    }

    public void addInfo(InfoTypeAndValue info) {
        this.infoList.addAttribute((AttributeTypeAndValue)info);
        this.update();
    }

    public void addInfo(ASN1ObjectID type) {
        this.addInfo(type, null);
    }

    public void addInfo(ASN1ObjectID type, ASN1Object value) {
        InfoTypeAndValue info = null;
        Class c = OIDManager.getOIDManager().getMapping(type, "infoTypeAndValue");
        if (c != null) {
            try {
                info = (InfoTypeAndValue)((Object)c.newInstance());
                info.setValue(value);
            }
            catch (IllegalAccessException ex) {
                info = null;
            }
            catch (InstantiationException ex) {
                info = null;
            }
            catch (ClassCastException ex) {
                info = null;
            }
        }
        if (info == null) {
            info = new InfoTypeAndValue(type, value);
        }
        this.addInfo(info);
    }

    public AttributeTypeAndValueList getInfo() {
        return this.infoList;
    }

    @Override
    public PKIMessageBody.Type getType() {
        return TYPE;
    }

    public String toString() {
        return TYPE + " { info = " + this.infoList + " }";
    }

    public void input(InputStream is) throws IOException {
        this.update();
        this.contents = new ASN1Sequence(is);
        this.infoList = new AttributeTypeAndValueList();
        ASN1SequenceInputStream sisInfo = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        while (sisInfo.hasMoreData()) {
            this.infoList.addAttribute((AttributeTypeAndValue)InfoTypeAndValue.inputInstance((InputStream)sisInfo));
        }
        sisInfo.terminate();
    }

    @Override
    ASN1Object toASN1Object() {
        if (this.contents == null) {
            this.contents = this.infoList;
        }
        return this.contents;
    }

    @Override
    void clearCache() {
        this.contents = null;
    }
}

