/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.history;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.ide.extension.DeferredElementVisitorHook;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionRegistry;
import oracle.ideimpl.history.HistorianHandler;
import oracle.ideimpl.history.HistorianRegistration;

public final class HistorianRegistrations {
    private static HistorianRegistrations _instance;
    private static final Lock _instanceLock;
    private static List<HistorianRegistration> _deferredRegistrations;
    private final List<HistorianRegistration> _registrations = new CopyOnWriteArrayList<HistorianRegistration>();

    private HistorianRegistrations() {
    }

    public static HistorianRegistrations getInstance() {
        _instanceLock.lock();
        try {
            if (_instance == null) {
                _instance = new HistorianRegistrations();
                _instance._register(_deferredRegistrations);
                _deferredRegistrations = null;
                DeferredElementVisitorHook hookHandler = (DeferredElementVisitorHook)ExtensionRegistry.getExtensionRegistry().getHook(HistorianHandler.NAME);
                hookHandler.attachElementVisitor((ElementVisitor)new HistorianHandler());
            }
            HistorianRegistrations historianRegistrations = _instance;
            return historianRegistrations;
        }
        finally {
            _instanceLock.unlock();
        }
    }

    public List<HistorianRegistration> getRegistrations() {
        return new ArrayList<HistorianRegistration>(this._registrations);
    }

    static final void register(HistorianRegistration registration) {
        _instanceLock.lock();
        try {
            if (_instance != null) {
                _instance._register(registration);
            } else {
                _deferredRegistrations.add(registration);
            }
        }
        finally {
            _instanceLock.unlock();
        }
    }

    private final void _register(HistorianRegistration registration) {
        this._registrations.add(registration);
    }

    private final void _register(Collection<HistorianRegistration> registrations) {
        this._registrations.addAll(registrations);
    }

    static {
        _instanceLock = new ReentrantLock();
        _deferredRegistrations = new ArrayList<HistorianRegistration>();
    }
}

