/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.navigator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import javax.ide.extension.ExtensionRegistry;
import oracle.ide.Context;
import oracle.ide.controller.AsynchronousController;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.navigator.RefreshTask;
import oracle.ideimpl.navigator.NavigatorArb;
import oracle.javatools.data.HashStructure;
import org.netbeans.api.progress.ProgressHandle;

public final class RefreshSupport {
    private static RefreshSupport INSTANCE;
    private final List<RefreshTask> refreshHookList;
    private static AsynchronousController.TaskInfo running;
    private static final Logger LOG;

    private RefreshSupport() {
        ElementName REFRESH_HOOK_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "refresh-hook");
        ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
        HashStructureHook hook = (HashStructureHook)registry.getHook(REFRESH_HOOK_NAME);
        this.refreshHookList = new ArrayList<RefreshTask>();
        if (hook != null) {
            hook.addHashStructureHookListener((HashStructureHookListener)new RefreshHookListener());
        }
    }

    private static synchronized RefreshSupport get() {
        if (null == INSTANCE) {
            INSTANCE = new RefreshSupport();
        }
        return INSTANCE;
    }

    private final List<? extends RefreshTask> refreshTasks() {
        return Collections.unmodifiableList(this.refreshHookList);
    }

    public static final void refreshApplication(Context context, AsynchronousController.TaskInfo info) {
        RefreshSupport.get().refresh(context, false, info);
    }

    public static final void refresh(Context context, AsynchronousController.TaskInfo info) {
        RefreshSupport.get().refresh(context, true, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void refresh(Context context, boolean contextRefresh, AsynchronousController.TaskInfo info) {
        LOG.fine((contextRefresh ? "Context" : "Application") + " refresh started.");
        AsynchronousController.TaskInfo rti = running;
        if (rti != null) {
            rti.cancel();
            rti.waitFinished();
        }
        running = info;
        try {
            ProgressHandle handle = info.createHandle(NavigatorArb.getString(15), true, false);
            handle.start();
            for (RefreshTask refreshTask : this.refreshTasks()) {
                if (info.isCancelled()) {
                    return;
                }
                LOG.finer("Running '" + refreshTask.getDisplayName() + "' task.");
                handle.setDisplayName(refreshTask.getDisplayName());
                handle.progress("");
                if (contextRefresh) {
                    refreshTask.refresh(context, handle);
                    continue;
                }
                refreshTask.refreshApplication(context, handle);
            }
            LOG.finer("Refresh finished successfuly.");
        }
        catch (InterruptedException ie) {
            LOG.finer("Interrupted refresh command.");
            return;
        }
        finally {
            running = null;
        }
    }

    static {
        LOG = Logger.getLogger(RefreshSupport.class.getName());
    }

    private class RefreshHookListener
    implements HashStructureHookListener {
        private RefreshHookListener() {
        }

        public void elementVisited(HashStructureHookEvent e) {
            this.handleData(e.getNewElementHashStructure());
        }

        public void listenerAttached(HashStructureHookEvent e) {
            this.handleData(e.getCombinedHashStructure());
        }

        private void handleData(HashStructure hashStructure) {
            List l = hashStructure.getAsList("observer");
            if (l != null) {
                for (HashStructure o : l) {
                    LazyClassAdapter classAdapter = LazyClassAdapter.getInstance((HashStructure)o);
                    RefreshSupport.this.refreshHookList.add((RefreshTask)classAdapter.createInstance(RefreshTask.class, "#text"));
                }
            }
        }
    }
}

