/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.navigator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import oracle.ide.Context;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigator.RefreshTask;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.net.VirtualFileSystemHelper;
import oracle.ideimpl.navigator.NavigatorArb;
import oracle.javatools.data.PropertyStorage;
import org.netbeans.api.progress.ProgressHandle;

class RefreshProjectTask
extends RefreshTask {
    RefreshProjectTask() {
    }

    @Override
    public String getDisplayName() {
        return NavigatorArb.getString(14);
    }

    @Override
    public void refresh(Context context, ProgressHandle handle) {
        Project project;
        if (Thread.interrupted()) {
            return;
        }
        TNode[] tnodesArr = ExplorerContext.getTNodes((Context)context);
        if (tnodesArr != null && (project = context.getProject()) != null) {
            LinkedList<TNode> tnodes = new LinkedList<TNode>();
            tnodes.addAll(Arrays.asList(tnodesArr));
            URLPath dirsToRefresh = new URLPath();
            ArrayList<Element> nodes = new ArrayList<Element>(tnodesArr.length);
            while (tnodes.size() > 0) {
                Locatable loc;
                URL url;
                TNode tnode = (TNode)tnodes.removeFirst();
                Element data = tnode.getData();
                nodes.add(data);
                if (data instanceof Project) {
                    ContentSet allContents = ProjectContent.getInstance((PropertyStorage)((Project)data)).getAllContents();
                    dirsToRefresh.add(allContents.getAllRootDirs());
                    continue;
                }
                if (data instanceof RelativeDirectoryContextFolder) {
                    RelativeDirectoryContextFolder dirFolder = (RelativeDirectoryContextFolder)data;
                    dirsToRefresh.add(dirFolder.getRootDirectories());
                    continue;
                }
                if (!(data instanceof Locatable) || (url = (loc = (Locatable)data).getURL()) == null) continue;
                dirsToRefresh.add(URLFileSystem.getParent((URL)url));
            }
            for (URL dirURL : dirsToRefresh) {
                VirtualFileSystemHelper.invalidateDirectoryTree((URL)dirURL);
            }
            UpdateMessage.fireStructureChanged((Subject)project, nodes);
        }
    }

    @Override
    public void refreshApplication(Context context, ProgressHandle handle) {
        Collection projects = context.getWorkspace().projects();
        for (Project p : projects) {
            handle.progress(p.getLongLabel());
            ContentSet allContents = ProjectContent.getInstance((PropertyStorage)p).getAllContents();
            URLPath dirsToRefresh = new URLPath();
            dirsToRefresh.add(allContents.getAllRootDirs());
            for (URL dirURL : dirsToRefresh) {
                VirtualFileSystemHelper.invalidateDirectoryTree((URL)dirURL);
            }
            if (Thread.interrupted()) {
                return;
            }
            UpdateMessage.fireStructureChanged((Subject)p);
        }
    }
}

