/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.navigator;

import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ide.extension.ElementName;
import javax.swing.JMenu;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.ContentSetSupport;
import oracle.ide.navigator.NavigatorInit;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.navigator.ProjectNavigatorManager;
import oracle.ide.view.View;
import oracle.javatools.data.HashStructure;

public final class ViewSupport
extends NavigatorInit {
    private static boolean isDirectoryViewOn = false;
    private static final String APP_VIEW_ACTION_NAME = "navigator-application-view";
    private static final int APP_VIEW_ACTION_ID = Ide.findOrCreateCmdID((String)"navigator-application-view");
    private static final String DIR_VIEW_ACTION_NAME = "navigator-directory-view";
    private static final int DIR_VIEW_ACTION_ID = Ide.findOrCreateCmdID((String)"navigator-directory-view");
    private static final String VIEW_GROUP = "appnav-treeview-group";
    private static final String DIR_OPTION_ID = "directory-view";

    ViewSupport(NavigatorWindow navWin, Context context) {
        super(navWin, context);
    }

    public static final void init() {
    }

    public static final boolean isDirectoryView() {
        return isDirectoryViewOn;
    }

    public static final Boolean isDirectoryView(Workspace workspace) {
        assert (workspace != null) : "Null workspace!";
        if (workspace == null) {
            return false;
        }
        return workspace.getUserPropertiesOnly().getBoolean(DIR_OPTION_ID, false);
    }

    public static final void updateView(Workspace workspace) {
        String dirOption;
        assert (workspace != null) : "Null workspace!";
        HashStructure userProperties = workspace.getUserPropertiesOnly();
        assert (userProperties != null) : "Null user properties for workspace '" + workspace.getLongLabel() + "'!";
        String string = dirOption = userProperties != null ? userProperties.getString(DIR_OPTION_ID) : null;
        if (dirOption == null) {
            String defaultView;
            String templateId = workspace.getProperty("appTemplateId");
            if (templateId != null && (defaultView = ViewDefaultProvider.get().getDefaultViewForTemplateId(templateId)) != null && "directory-structure".equals(defaultView)) {
                isDirectoryViewOn = true;
                return;
            }
            isDirectoryViewOn = false;
        } else {
            isDirectoryViewOn = Boolean.parseBoolean(dirOption);
        }
    }

    @Override
    public void initToolbar(Toolbar toolbar) {
        MenuToolButton menuToolButton = ContentSetSupport.findDisplayOptionsMenu(toolbar);
        Menubar menuMgr = Ide.getMenubar();
        JMenu viewNavViewOptionsMenu = Menubar.getJMenu((String)"navigator-view-options-menu");
        if (toolbar != null) {
            IdeAction appView = IdeAction.find((String)APP_VIEW_ACTION_NAME);
            IdeAction lappView = appView.newLocalAction((View)this.getNavigatorWindow());
            lappView.setState(true);
            lappView.putValue("Radio", (Object)Boolean.TRUE);
            lappView.putValue("RadioGroupName", (Object)VIEW_GROUP);
            menuToolButton.addPopupItem((ToggleAction)lappView);
            menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)lappView), viewNavViewOptionsMenu, 0.5f);
            IdeAction dirView = IdeAction.find((String)DIR_VIEW_ACTION_NAME);
            IdeAction ldirView = dirView.newLocalAction((View)this.getNavigatorWindow());
            ldirView.setState(false);
            ldirView.putValue("Radio", (Object)Boolean.TRUE);
            ldirView.putValue("RadioGroupName", (Object)VIEW_GROUP);
            menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)ldirView), viewNavViewOptionsMenu, 0.5f);
            RadioController radio = new RadioController(new IdeAction[]{lappView, ldirView});
            lappView.addController((Controller)radio);
            ldirView.addController((Controller)radio);
            menuToolButton.addPopupItem((ToggleAction)ldirView);
        }
    }

    private static class ViewDefaultProvider {
        private final Map<String, String> appTemplates = new HashMap<String, String>();
        private static ViewDefaultProvider instance = null;

        private ViewDefaultProvider() {
        }

        public static final synchronized ViewDefaultProvider get() {
            if (instance == null) {
                instance = new ViewDefaultProvider();
                ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
                HashStructureHook hook = (HashStructureHook)registry.getHook(new ElementName("http://xmlns.oracle.com/ide/extension", "template-hook"));
                hook.addHashStructureHookListener(new HashStructureHookListener(){

                    public void elementVisited(HashStructureHookEvent e) {
                    }

                    public void listenerAttached(HashStructureHookEvent e) {
                        List a = e.getCombinedHashStructure().getAsList("applicationTemplate");
                        for (HashStructure mash : a) {
                            String templateId = mash.getString("templateId/#text");
                            String templateView = mash.getString("navigatorDefaultView/#text");
                            if (templateId == null || templateView == null) continue;
                            ViewDefaultProvider.instance.appTemplates.put(templateId, templateView);
                        }
                    }
                });
            }
            return instance;
        }

        public final String getDefaultViewForTemplateId(String templateId) {
            assert (templateId != null) : "Null value provided.";
            return this.appTemplates.get(templateId);
        }
    }

    private static class RadioController
    implements Controller {
        IdeAction[] actions;

        RadioController(IdeAction[] actions) {
            this.actions = actions;
        }

        public boolean handleEvent(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == APP_VIEW_ACTION_ID) {
                isDirectoryViewOn = false;
            } else if (cmdId == DIR_VIEW_ACTION_ID) {
                isDirectoryViewOn = true;
            }
            if (context == null || context.getWorkspace() == null) {
                return true;
            }
            HashStructure applicationUserProps = context.getWorkspace().getUserPropertiesOnly();
            applicationUserProps.putBoolean(ViewSupport.DIR_OPTION_ID, isDirectoryViewOn);
            ProjectNavigatorManager.refreshAllProjectsInNavigator(context);
            return true;
        }

        public boolean update(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (context == null || context.getWorkspace() == null) {
                action.setEnabled(false);
            } else {
                action.setEnabled(true);
            }
            if (cmdId == APP_VIEW_ACTION_ID) {
                action.setState(!isDirectoryViewOn);
                return true;
            }
            if (cmdId == DIR_VIEW_ACTION_ID) {
                action.setState(isDirectoryViewOn);
                return true;
            }
            return false;
        }
    }
}

