/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.navigator;

import java.awt.EventQueue;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.appstate.ApplicationStateProvider;
import oracle.ide.cmd.OpenCommand;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.ApplicationNavigatorState;
import oracle.ide.navigator.ApplicationNavigatorWindow;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.HashStructure;

final class ApplicationNavigatorStateProvider
implements ApplicationStateProvider {
    private static final Logger LOG = Logger.getLogger(ApplicationNavigatorStateProvider.class.getName());

    ApplicationNavigatorStateProvider() {
    }

    public void saveState(HashStructure data) {
        new ApplicationNavigatorState(data).setActiveApplication(this.findActiveApplication());
    }

    public void restoreState(HashStructure data) {
        this.setActiveApplication(new ApplicationNavigatorState(data).getActiveApplication());
    }

    private URL findActiveApplication() {
        ApplicationNavigatorWindow applicationNavigator = this.applicationNavigator();
        if (applicationNavigator == null) {
            return null;
        }
        Workspace workspace = applicationNavigator.currentApplication();
        if (workspace != null) {
            return workspace.getURL();
        }
        return null;
    }

    private void setActiveApplication(final URL activeApplication) {
        if (activeApplication == null) {
            return;
        }
        if (this.applicationNavigator() == null) {
            return;
        }
        if (!this.checkExists(activeApplication)) {
            return;
        }
        if (activeApplication.equals(this.findActiveApplication())) {
            return;
        }
        Workspaces workspaces = Ide.getWorkspaces();
        for (final Workspace workspace : workspaces.workspaces()) {
            if (!activeApplication.equals(workspace.getURL())) continue;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ApplicationNavigatorStateProvider.this.applicationNavigator().selectApplication(workspace);
                    LOG.log(Level.FINE, "Restored already open application {0}.", ApplicationNavigatorStateProvider.this.platformName(activeApplication));
                }
            });
            return;
        }
        try {
            OpenCommand openCommand = new OpenCommand();
            openCommand.setContext(Ide.getMainWindow().getLastActiveView().getContext());
            openCommand.openURL(activeApplication);
            LOG.log(Level.FINE, "Restored application {0} by opening it.", this.platformName(activeApplication));
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to open application " + this.platformName(activeApplication), e);
        }
    }

    private ApplicationNavigatorWindow applicationNavigator() {
        NavigatorManager manager = NavigatorManager.getApplicationNavigatorManager();
        if (manager == null) {
            LOG.config("Unable to save or restore active application: no application navigator manager.");
            return null;
        }
        NavigatorWindow window = manager.getNavigatorWindow();
        if (window == null) {
            LOG.config("Unable to save or restore active application: no application navigator window.");
            return null;
        }
        if (window instanceof ApplicationNavigatorWindow) {
            return (ApplicationNavigatorWindow)window;
        }
        LOG.config("Unable to save or restore active application: application navigator is an unexpected type: " + window.getClass());
        return null;
    }

    private boolean checkExists(URL applicationUrl) {
        if (!URLFileSystem.exists((URL)applicationUrl)) {
            LOG.log(Level.WARNING, "Unable to restore active application {0}, because it does not exist.", this.platformName(applicationUrl));
            return false;
        }
        return true;
    }

    private String platformName(URL url) {
        return URLFileSystem.getPlatformPathName((URL)url);
    }
}

