/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasetools.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum KeyStoreType implements BmcEnum
{
    JavaKeyStore("JAVA_KEY_STORE"),
    JavaTrustStore("JAVA_TRUST_STORE"),
    Pkcs12("PKCS12"),
    Sso("SSO"),
    UnknownEnumValue(null);

    private static final Logger LOG;
    private final String value;
    private static Map<String, KeyStoreType> map;

    private KeyStoreType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static KeyStoreType create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        LOG.warn("Received unknown value '{}' for enum 'KeyStoreType', returning UnknownEnumValue", (Object)key);
        return UnknownEnumValue;
    }

    static {
        LOG = LoggerFactory.getLogger(KeyStoreType.class);
        map = new HashMap<String, KeyStoreType>();
        for (KeyStoreType v : KeyStoreType.values()) {
            if (v == UnknownEnumValue) continue;
            map.put(v.getValue(), v);
        }
    }
}

