/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasetools.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasetools.model.DatabaseToolsConnectionOracleDatabaseProxyClientDetails;
import com.oracle.bmc.databasetools.model.DatabaseToolsUserPasswordDetails;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="proxyAuthenticationType")
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseToolsConnectionOracleDatabaseProxyClientUserNameDetails
extends DatabaseToolsConnectionOracleDatabaseProxyClientDetails {
    @JsonProperty(value="userName")
    private final String userName;
    @JsonProperty(value="userPassword")
    private final DatabaseToolsUserPasswordDetails userPassword;
    @JsonProperty(value="roles")
    private final List<String> roles;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DatabaseToolsConnectionOracleDatabaseProxyClientUserNameDetails(String userName, DatabaseToolsUserPasswordDetails userPassword, List<String> roles) {
        this.userName = userName;
        this.userPassword = userPassword;
        this.roles = roles;
    }

    public String getUserName() {
        return this.userName;
    }

    public DatabaseToolsUserPasswordDetails getUserPassword() {
        return this.userPassword;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatabaseToolsConnectionOracleDatabaseProxyClientUserNameDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", userName=").append(String.valueOf(this.userName));
        sb.append(", userPassword=").append(String.valueOf((Object)this.userPassword));
        sb.append(", roles=").append(String.valueOf(this.roles));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseToolsConnectionOracleDatabaseProxyClientUserNameDetails)) {
            return false;
        }
        DatabaseToolsConnectionOracleDatabaseProxyClientUserNameDetails other = (DatabaseToolsConnectionOracleDatabaseProxyClientUserNameDetails)((Object)o);
        return Objects.equals(this.userName, other.userName) && Objects.equals((Object)this.userPassword, (Object)other.userPassword) && Objects.equals(this.roles, other.roles) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.userName == null ? 43 : this.userName.hashCode());
        result = result * 59 + (this.userPassword == null ? 43 : this.userPassword.hashCode());
        result = result * 59 + (this.roles == null ? 43 : this.roles.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="userName")
        private String userName;
        @JsonProperty(value="userPassword")
        private DatabaseToolsUserPasswordDetails userPassword;
        @JsonProperty(value="roles")
        private List<String> roles;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder userName(String userName) {
            this.userName = userName;
            this.__explicitlySet__.add("userName");
            return this;
        }

        public Builder userPassword(DatabaseToolsUserPasswordDetails userPassword) {
            this.userPassword = userPassword;
            this.__explicitlySet__.add("userPassword");
            return this;
        }

        public Builder roles(List<String> roles) {
            this.roles = roles;
            this.__explicitlySet__.add("roles");
            return this;
        }

        public DatabaseToolsConnectionOracleDatabaseProxyClientUserNameDetails build() {
            DatabaseToolsConnectionOracleDatabaseProxyClientUserNameDetails model = new DatabaseToolsConnectionOracleDatabaseProxyClientUserNameDetails(this.userName, this.userPassword, this.roles);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DatabaseToolsConnectionOracleDatabaseProxyClientUserNameDetails model) {
            if (model.wasPropertyExplicitlySet("userName")) {
                this.userName(model.getUserName());
            }
            if (model.wasPropertyExplicitlySet("userPassword")) {
                this.userPassword(model.getUserPassword());
            }
            if (model.wasPropertyExplicitlySet("roles")) {
                this.roles(model.getRoles());
            }
            return this;
        }
    }
}

