/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasetools;

import com.oracle.bmc.databasetools.DatabaseTools;
import com.oracle.bmc.databasetools.model.DatabaseToolsConnectionSummary;
import com.oracle.bmc.databasetools.model.DatabaseToolsEndpointServiceSummary;
import com.oracle.bmc.databasetools.model.DatabaseToolsPrivateEndpointSummary;
import com.oracle.bmc.databasetools.model.WorkRequestError;
import com.oracle.bmc.databasetools.model.WorkRequestLogEntry;
import com.oracle.bmc.databasetools.model.WorkRequestSummary;
import com.oracle.bmc.databasetools.requests.ListDatabaseToolsConnectionsRequest;
import com.oracle.bmc.databasetools.requests.ListDatabaseToolsEndpointServicesRequest;
import com.oracle.bmc.databasetools.requests.ListDatabaseToolsPrivateEndpointsRequest;
import com.oracle.bmc.databasetools.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.databasetools.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.databasetools.requests.ListWorkRequestsRequest;
import com.oracle.bmc.databasetools.responses.ListDatabaseToolsConnectionsResponse;
import com.oracle.bmc.databasetools.responses.ListDatabaseToolsEndpointServicesResponse;
import com.oracle.bmc.databasetools.responses.ListDatabaseToolsPrivateEndpointsResponse;
import com.oracle.bmc.databasetools.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.databasetools.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.databasetools.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class DatabaseToolsPaginators {
    private final DatabaseTools client;

    public DatabaseToolsPaginators(DatabaseTools client) {
        this.client = client;
    }

    public Iterable<ListDatabaseToolsConnectionsResponse> listDatabaseToolsConnectionsResponseIterator(final ListDatabaseToolsConnectionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDatabaseToolsConnectionsRequest.Builder>(){

            @Override
            public ListDatabaseToolsConnectionsRequest.Builder get() {
                return ListDatabaseToolsConnectionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDatabaseToolsConnectionsResponse, String>(){

            @Override
            public String apply(ListDatabaseToolsConnectionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDatabaseToolsConnectionsRequest.Builder>, ListDatabaseToolsConnectionsRequest>(){

            @Override
            public ListDatabaseToolsConnectionsRequest apply(RequestBuilderAndToken<ListDatabaseToolsConnectionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDatabaseToolsConnectionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDatabaseToolsConnectionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDatabaseToolsConnectionsRequest, ListDatabaseToolsConnectionsResponse>(){

            @Override
            public ListDatabaseToolsConnectionsResponse apply(ListDatabaseToolsConnectionsRequest request) {
                return DatabaseToolsPaginators.this.client.listDatabaseToolsConnections(request);
            }
        });
    }

    public Iterable<DatabaseToolsConnectionSummary> listDatabaseToolsConnectionsRecordIterator(final ListDatabaseToolsConnectionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDatabaseToolsConnectionsRequest.Builder>(){

            @Override
            public ListDatabaseToolsConnectionsRequest.Builder get() {
                return ListDatabaseToolsConnectionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDatabaseToolsConnectionsResponse, String>(){

            @Override
            public String apply(ListDatabaseToolsConnectionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDatabaseToolsConnectionsRequest.Builder>, ListDatabaseToolsConnectionsRequest>(){

            @Override
            public ListDatabaseToolsConnectionsRequest apply(RequestBuilderAndToken<ListDatabaseToolsConnectionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDatabaseToolsConnectionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDatabaseToolsConnectionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDatabaseToolsConnectionsRequest, ListDatabaseToolsConnectionsResponse>(){

            @Override
            public ListDatabaseToolsConnectionsResponse apply(ListDatabaseToolsConnectionsRequest request) {
                return DatabaseToolsPaginators.this.client.listDatabaseToolsConnections(request);
            }
        }, (Function)new Function<ListDatabaseToolsConnectionsResponse, List<DatabaseToolsConnectionSummary>>(){

            @Override
            public List<DatabaseToolsConnectionSummary> apply(ListDatabaseToolsConnectionsResponse response) {
                return response.getDatabaseToolsConnectionCollection().getItems();
            }
        });
    }

    public Iterable<ListDatabaseToolsEndpointServicesResponse> listDatabaseToolsEndpointServicesResponseIterator(final ListDatabaseToolsEndpointServicesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDatabaseToolsEndpointServicesRequest.Builder>(){

            @Override
            public ListDatabaseToolsEndpointServicesRequest.Builder get() {
                return ListDatabaseToolsEndpointServicesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDatabaseToolsEndpointServicesResponse, String>(){

            @Override
            public String apply(ListDatabaseToolsEndpointServicesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDatabaseToolsEndpointServicesRequest.Builder>, ListDatabaseToolsEndpointServicesRequest>(){

            @Override
            public ListDatabaseToolsEndpointServicesRequest apply(RequestBuilderAndToken<ListDatabaseToolsEndpointServicesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDatabaseToolsEndpointServicesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDatabaseToolsEndpointServicesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDatabaseToolsEndpointServicesRequest, ListDatabaseToolsEndpointServicesResponse>(){

            @Override
            public ListDatabaseToolsEndpointServicesResponse apply(ListDatabaseToolsEndpointServicesRequest request) {
                return DatabaseToolsPaginators.this.client.listDatabaseToolsEndpointServices(request);
            }
        });
    }

    public Iterable<DatabaseToolsEndpointServiceSummary> listDatabaseToolsEndpointServicesRecordIterator(final ListDatabaseToolsEndpointServicesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDatabaseToolsEndpointServicesRequest.Builder>(){

            @Override
            public ListDatabaseToolsEndpointServicesRequest.Builder get() {
                return ListDatabaseToolsEndpointServicesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDatabaseToolsEndpointServicesResponse, String>(){

            @Override
            public String apply(ListDatabaseToolsEndpointServicesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDatabaseToolsEndpointServicesRequest.Builder>, ListDatabaseToolsEndpointServicesRequest>(){

            @Override
            public ListDatabaseToolsEndpointServicesRequest apply(RequestBuilderAndToken<ListDatabaseToolsEndpointServicesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDatabaseToolsEndpointServicesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDatabaseToolsEndpointServicesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDatabaseToolsEndpointServicesRequest, ListDatabaseToolsEndpointServicesResponse>(){

            @Override
            public ListDatabaseToolsEndpointServicesResponse apply(ListDatabaseToolsEndpointServicesRequest request) {
                return DatabaseToolsPaginators.this.client.listDatabaseToolsEndpointServices(request);
            }
        }, (Function)new Function<ListDatabaseToolsEndpointServicesResponse, List<DatabaseToolsEndpointServiceSummary>>(){

            @Override
            public List<DatabaseToolsEndpointServiceSummary> apply(ListDatabaseToolsEndpointServicesResponse response) {
                return response.getDatabaseToolsEndpointServiceCollection().getItems();
            }
        });
    }

    public Iterable<ListDatabaseToolsPrivateEndpointsResponse> listDatabaseToolsPrivateEndpointsResponseIterator(final ListDatabaseToolsPrivateEndpointsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDatabaseToolsPrivateEndpointsRequest.Builder>(){

            @Override
            public ListDatabaseToolsPrivateEndpointsRequest.Builder get() {
                return ListDatabaseToolsPrivateEndpointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDatabaseToolsPrivateEndpointsResponse, String>(){

            @Override
            public String apply(ListDatabaseToolsPrivateEndpointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDatabaseToolsPrivateEndpointsRequest.Builder>, ListDatabaseToolsPrivateEndpointsRequest>(){

            @Override
            public ListDatabaseToolsPrivateEndpointsRequest apply(RequestBuilderAndToken<ListDatabaseToolsPrivateEndpointsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDatabaseToolsPrivateEndpointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDatabaseToolsPrivateEndpointsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDatabaseToolsPrivateEndpointsRequest, ListDatabaseToolsPrivateEndpointsResponse>(){

            @Override
            public ListDatabaseToolsPrivateEndpointsResponse apply(ListDatabaseToolsPrivateEndpointsRequest request) {
                return DatabaseToolsPaginators.this.client.listDatabaseToolsPrivateEndpoints(request);
            }
        });
    }

    public Iterable<DatabaseToolsPrivateEndpointSummary> listDatabaseToolsPrivateEndpointsRecordIterator(final ListDatabaseToolsPrivateEndpointsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDatabaseToolsPrivateEndpointsRequest.Builder>(){

            @Override
            public ListDatabaseToolsPrivateEndpointsRequest.Builder get() {
                return ListDatabaseToolsPrivateEndpointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDatabaseToolsPrivateEndpointsResponse, String>(){

            @Override
            public String apply(ListDatabaseToolsPrivateEndpointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDatabaseToolsPrivateEndpointsRequest.Builder>, ListDatabaseToolsPrivateEndpointsRequest>(){

            @Override
            public ListDatabaseToolsPrivateEndpointsRequest apply(RequestBuilderAndToken<ListDatabaseToolsPrivateEndpointsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDatabaseToolsPrivateEndpointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDatabaseToolsPrivateEndpointsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDatabaseToolsPrivateEndpointsRequest, ListDatabaseToolsPrivateEndpointsResponse>(){

            @Override
            public ListDatabaseToolsPrivateEndpointsResponse apply(ListDatabaseToolsPrivateEndpointsRequest request) {
                return DatabaseToolsPaginators.this.client.listDatabaseToolsPrivateEndpoints(request);
            }
        }, (Function)new Function<ListDatabaseToolsPrivateEndpointsResponse, List<DatabaseToolsPrivateEndpointSummary>>(){

            @Override
            public List<DatabaseToolsPrivateEndpointSummary> apply(ListDatabaseToolsPrivateEndpointsResponse response) {
                return response.getDatabaseToolsPrivateEndpointCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return DatabaseToolsPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return DatabaseToolsPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return DatabaseToolsPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return DatabaseToolsPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return DatabaseToolsPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return DatabaseToolsPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestCollection().getItems();
            }
        });
    }
}

