/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.util;

import java.io.File;
import java.net.MalformedURLException;
import javax.naming.NamingException;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.jdevimpl.vcs.svn.AlreadyExistsException;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.client.SVNClientRegistry;
import oracle.jdevimpl.vcs.svn.model.SVNAuthInfo;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNavigatorAPI;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNode;
import oracle.jdevimpl.vcs.svn.prefs.SVNEnvironmentPrefs;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;

public class SubversionTestUtils {
    public static void createContext() {
    }

    public static final SVNUrl createSVNUrl(String urlString) throws MalformedURLException {
        return new SVNUrl(urlString);
    }

    public static final SVNURL createSVNURL(String urlString) throws SVNException {
        return SVNURL.parseURIEncoded((String)urlString);
    }

    public static final String svnurlToString(SVNUrl svnurl) {
        return svnurl == null ? null : svnurl.toString();
    }

    public static final SVNRevision createSVNRevision(String rev) {
        if (rev.equals("HEAD")) {
            return SVNRevision.HEAD;
        }
        try {
            int revNum = Integer.parseInt(rev);
            if (revNum > -1) {
                return new SVNRevision.Number((long)revNum);
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return null;
    }

    public static final void createRepository(String repoRoot) throws NamingException, SVNClientException {
        SubversionTestUtils.createContext();
        SVNClientRegistry reg = SVNClientRegistry.getInstance();
        reg.setContextClient(SVNProfile.IDE_CLIENT_CONTEXT_ID, reg.getSVNKitClient());
        ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
        client.createRepository(new File(repoRoot), "fsfs");
    }

    public static final SVNRepositoryInfo createConnection(String repoRoot, String name) throws MalformedURLException {
        SVNAuthInfo authInfo = new SVNAuthInfo("", "".toCharArray());
        SVNUrl rootSVNUrl = null;
        rootSVNUrl = repoRoot.startsWith("/") ? new SVNUrl("file://".concat(repoRoot)) : new SVNUrl("file:///".concat(repoRoot));
        SVNRepositoryInfo repoInfo = new SVNRepositoryInfo(rootSVNUrl, name, authInfo);
        try {
            SVNRepositoryNavigatorAPI.getInstance().createRepositoryConnection(repoInfo);
        }
        catch (AlreadyExistsException alreadyExistsException) {
            // empty catch block
        }
        return repoInfo;
    }

    public static final SVNRepositoryInfo removeConnection(String repoRoot, String name) throws MalformedURLException {
        SVNAuthInfo authInfo = new SVNAuthInfo("", "".toCharArray());
        SVNUrl rootSVNUrl = null;
        rootSVNUrl = repoRoot.startsWith("/") ? new SVNUrl("file://".concat(repoRoot)) : new SVNUrl("file:///".concat(repoRoot));
        SVNRepositoryInfo repoInfo = new SVNRepositoryInfo(rootSVNUrl, name, authInfo);
        SVNRepositoryNode reposNode = new SVNRepositoryNode(repoInfo);
        SVNRepositoryNavigatorAPI.getInstance().removeRepositoryConnection(reposNode);
        return repoInfo;
    }

    public static final void turnOffOverlayLabels() {
        SVNEnvironmentPrefs.getInstance((PropertyStorage)Preferences.getPreferences()).setUseLabelDecorations(false);
    }
}

