/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op.ui;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizerAdapter;
import oracle.jdevimpl.vcs.svn.op.ui.KeepLocksPanel;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNBugtraqProperties;

public class CommitOptionsCustomizer
extends VCSOptionsCustomizerAdapter {
    private final KeepLocksPanel _ui;
    private final SVNBugtraqProperties _properties;

    public CommitOptionsCustomizer(SVNBugtraqProperties properties) {
        this._properties = properties;
        this._ui = new KeepLocksPanel(properties);
    }

    public Component getComponent() {
        return this._ui;
    }

    public Map getOptions() {
        HashMap<String, Object> opts = new HashMap<String, Object>(5);
        opts.put("oracle.jdeveloper.subversion.KEEP_LOCKS", this._ui.isKeepLocksSelected());
        opts.put("oracle.jdeveloper.subversion.bugtraq", this._ui.getBugtraqNo());
        return opts;
    }

    public void setOptions(Map opts) {
        Boolean keepLocks;
        if (opts != null && (keepLocks = (Boolean)opts.get("oracle.jdeveloper.subversion.KEEP_LOCKS")) != null) {
            this._ui.setKeepLocksSelected(keepLocks);
        }
    }

    public Component getInitialFocusComponent() {
        return null;
    }

    public void validateOptions() throws VCSException {
        if (this._properties == null || this._ui.getBugtraqNo() == null) {
            return;
        }
        if (this._properties.isNumber() && !this._ui.getBugtraqNo().isEmpty()) {
            String inputStr = this._ui.getBugtraqNo();
            Pattern pattern = Pattern.compile("([0-9]*[,]?)+$");
            Matcher matcher = pattern.matcher(inputStr);
            if (!matcher.matches()) {
                throw new VCSException(Resource.get("BUGTRAQ_ERROR_NUMBER_TITLE"), Resource.format("BUGTRAQ_ERROR_NUMBER", this._properties.getLabel()));
            }
        }
    }
}

