/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.Action;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.jdeveloper.history.HistoryContext;
import oracle.jdeveloper.history.HistoryEntrySelector;
import oracle.jdeveloper.history.HistoryManager;
import oracle.jdeveloper.vcs.annotations.AnnotateLink;
import oracle.jdeveloper.vcs.annotations.AnnotationAction;
import oracle.jdeveloper.vcs.annotations.Annotations;
import oracle.jdeveloper.vcs.annotations.AnnotationsCommand;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.versionhistory.VersionHistoryUtil;
import oracle.jdevimpl.vcs.svn.SVNExceptionHandler;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNBugtraqProperties;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.wc.ISVNAnnotateHandler;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SVNOperationViewAnnotation
extends AnnotationsCommand {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.viewannotation";

    public SVNOperationViewAnnotation() {
        super(Ide.findOrCreateCmdID((String)COMMAND_ID));
    }

    protected boolean isUnmodifiedStatus(VCSStatus status) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Annotations getAnnotations(File file) throws Exception {
        try {
            final HashMap<Long, String> msgs = new HashMap<Long, String>();
            URL url = URLFactory.newFileURL((File)file);
            SVNRepositoryInfo repos = SVNUtil.getFirstAssociatedRepository(url);
            SVNLogClient lclient = SVNUtil.getLogClient(repos);
            File[] files = new File[]{file};
            lclient.doLog(files, SVNRevision.WORKING, SVNRevision.create((long)1L), false, false, -1L, new ISVNLogEntryHandler(){

                public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                    msgs.put(logEntry.getRevision(), logEntry.getMessage());
                }
            });
            ISVNAnnotateHandlerImpl handler = new ISVNAnnotateHandlerImpl(msgs, repos.getAuthInfo().getUserName(), URLFactory.newFileURL((File)file));
            lclient.doAnnotate(file, SVNRevision.BASE, SVNRevision.create((long)1L), SVNRevision.WORKING, (ISVNAnnotateHandler)handler);
            ISVNAnnotateHandlerImpl iSVNAnnotateHandlerImpl = handler;
            return iSVNAnnotateHandlerImpl;
        }
        catch (SVNException e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning(e.getMessage());
            Annotations annotations = null;
            return annotations;
        }
        catch (IOException e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning(e.getMessage());
            Annotations annotations = null;
            return annotations;
        }
        finally {
            SVNProfile.getQualifiedLogger(SVNOperationViewAnnotation.class.getName()).log(Level.INFO, "Annotations for " + file.getPath());
        }
    }

    protected Annotations getAnnotations(URL url) {
        return null;
    }

    private class ISVNAnnotateHandlerImpl
    extends Annotations
    implements ISVNAnnotateHandler {
        private List<SVNAnnotation> _annotates = new ArrayList<SVNAnnotation>();
        private Map<Long, String> _msgs = new HashMap<Long, String>();
        private String _pseudoRevision;
        private Date _pseudoDate;
        private long _maxRevision = 0L;
        private String _user;
        private URL _url;
        private SVNBugtraqProperties _bugtraq;
        private AnnotateLink _link;
        private Collection<Action> _compareAction;

        ISVNAnnotateHandlerImpl(Map<Long, String> msgs, String user, URL url) {
            this._msgs.putAll(msgs);
            this._user = user;
            this._url = url;
        }

        public Date getChanged(int lineNumber) {
            if (lineNumber < this.getLineCount()) {
                if (this._annotates.get((int)lineNumber)._revision == -1L) {
                    return this.getModifiedDate();
                }
                return this._annotates.get((int)lineNumber)._date;
            }
            return null;
        }

        public String getRevision(int lineNumber) {
            if (lineNumber < this.getLineCount()) {
                if (this._annotates.get((int)lineNumber)._revision == -1L) {
                    return this.modifiedRev();
                }
                return String.valueOf(this._annotates.get((int)lineNumber)._revision);
            }
            return null;
        }

        public String getExtendedRevision(int lineNumber) {
            if (lineNumber < this.getLineCount()) {
                if (this._annotates.get((int)lineNumber)._revision == -1L) {
                    return Resource.get("ANNOTATE_NOT_COMMIT");
                }
                return String.valueOf(this._annotates.get((int)lineNumber)._revision);
            }
            return null;
        }

        public String getAuthor(int lineNumber) {
            if (lineNumber < this.getLineCount()) {
                if (this._annotates.get((int)lineNumber)._revision == -1L) {
                    return this._user;
                }
                return this._annotates.get((int)lineNumber)._author;
            }
            return null;
        }

        public String getLine(int lineNumber) {
            if (lineNumber < this.getLineCount()) {
                return this._annotates.get((int)lineNumber)._line;
            }
            return null;
        }

        public int getLineCount() {
            return this._annotates.size();
        }

        public String getComment(int lineNumber) {
            if (lineNumber < this.getLineCount()) {
                Long rev = this._annotates.get((int)lineNumber)._revision;
                if (rev == -1L) {
                    return null;
                }
                return this._msgs.get(rev);
            }
            return null;
        }

        public URL getURL() {
            return this._url;
        }

        public Collection<String> getBugNumbers(int lineNumber) {
            SVNBugtraqProperties bugtrag;
            String comment = this.getComment(lineNumber);
            if (comment != null && !comment.isEmpty() && (bugtrag = this.getBugtraqProperties()) != null) {
                Collection<String> ids = bugtrag.getIssueId(comment);
                return ids;
            }
            return Collections.emptySet();
        }

        public AnnotateLink getLink() {
            if (this._link == null) {
                this._link = new SVNAnnotateLink();
            }
            return this._link;
        }

        public void handleLine(Date date, long revision, String author, String line) throws SVNException {
            SVNAnnotation annotation = new SVNAnnotation();
            annotation._date = date;
            annotation._author = author;
            annotation._line = line;
            annotation._revision = revision;
        }

        public void handleLine(Date date, long revision, String author, String line, Date mergedDate, long mergedRevision, String mergedAuthor, String mergedPath, int lineNumber) throws SVNException {
            SVNAnnotation annotation = new SVNAnnotation();
            annotation._date = date;
            annotation._author = author;
            annotation._line = line;
            annotation._revision = revision;
            this._annotates.add(lineNumber, annotation);
            this._maxRevision = Math.max(this._maxRevision, revision);
        }

        public boolean handleRevision(Date date, long revision, String author, File contents) throws SVNException {
            return false;
        }

        public Collection<Action> getCompareActions(int lineNumber) {
            if (this._compareAction == null) {
                this._compareAction = new ArrayList<Action>();
                this._compareAction.add((Action)((Object)new ComparePreviousAction()));
                this._compareAction.add((Action)((Object)new CompareHeadAction()));
            }
            return this._compareAction;
        }

        public void handleEOF() throws SVNException {
        }

        private String modifiedRev() {
            if (this._pseudoRevision == null) {
                this._pseudoRevision = String.valueOf(this._maxRevision + 1L);
            }
            return this._pseudoRevision;
        }

        private Date getModifiedDate() {
            if (this._pseudoDate == null) {
                this._pseudoDate = new Date(System.currentTimeMillis());
            }
            return this._pseudoDate;
        }

        private SVNBugtraqProperties getBugtraqProperties() {
            if (this._bugtraq == null) {
                try {
                    this._bugtraq = new SVNBugtraqProperties(this.getURL());
                }
                catch (SVNClientException e) {
                    SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning(e.getMessage());
                }
            }
            return this._bugtraq;
        }

        private class SVNAnnotateLink
        extends AnnotateLink {
            private SVNAnnotateLink() {
            }

            public boolean isEnabled() {
                return true;
            }

            public String getLabel() {
                SVNBugtraqProperties bugtraq = ISVNAnnotateHandlerImpl.this.getBugtraqProperties();
                return bugtraq.getLabel();
            }

            public void openLink(URL file, String link) {
                SVNBugtraqProperties bugtraq;
                URL url;
                BrowserRunner runner = BrowserRunner.getBrowserRunner();
                if (runner != null && (url = (bugtraq = ISVNAnnotateHandlerImpl.this.getBugtraqProperties()).getIssueURL(link)) != null) {
                    runner.runBrowserOnURL(url, null, null);
                }
            }
        }

        private class ComparePreviousAction
        extends CompareCommonAction {
            ComparePreviousAction() {
                super(Resource.get("ANNOTATE_COMPARE_PREVIOUS"));
            }

            public boolean isEnabled() {
                String rev = (String)this.getValue("Revision");
                if (rev.equals(Resource.get("ANNOTATE_NOT_COMMIT"))) {
                    return true;
                }
                return this.getPrevious(rev) > -1L;
            }

            public void actionPerformed(ActionEvent e) {
                String id = (String)this.getValue("Revision");
                if (id.equals(Resource.get("ANNOTATE_NOT_COMMIT"))) {
                    Long prvId = this.getHead();
                    HistoryEntrySelector lhs = new HistoryEntrySelector(prvId.toString());
                    Context historicalContext = new Context(SVNOperationViewAnnotation.this.getContext());
                    HistoryContext.setHistoryEntrySelectorLHS((Context)historicalContext, (HistoryEntrySelector)lhs);
                    HistoryManager.getHistoryManager().showHistory(historicalContext);
                } else {
                    try {
                        Long prvId = this.getPrevious(id);
                        if (prvId > -1L) {
                            VersionHistoryUtil.openHistoryViewer((URL)ISVNAnnotateHandlerImpl.this.getURL(), (String)prvId.toString(), (String)id);
                        }
                    }
                    catch (Exception f) {
                        SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning(f.getMessage());
                        new SVNExceptionHandler().handleException(f);
                    }
                }
            }

            private Long getPrevious(String id) {
                Long prv = -1L;
                Long lId = Long.parseLong(id);
                for (Long key : ISVNAnnotateHandlerImpl.this._msgs.keySet()) {
                    if (key >= lId || key <= prv) continue;
                    prv = key;
                }
                return prv;
            }
        }

        private class CompareHeadAction
        extends CompareCommonAction {
            CompareHeadAction() {
                super(Resource.get("ANNOTATE_COMPARE_HEAD"));
            }

            public boolean isEnabled() {
                String rev = (String)this.getValue("Revision");
                return !rev.equals(Resource.get("ANNOTATE_NOT_COMMIT"));
            }

            public void actionPerformed(ActionEvent e) {
                String id = (String)this.getValue("Revision");
                Long headId = this.getHead();
                try {
                    VersionHistoryUtil.openHistoryViewer((URL)ISVNAnnotateHandlerImpl.this.getURL(), (String)id, (String)headId.toString());
                }
                catch (Exception f) {
                    SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning(f.getMessage());
                    new SVNExceptionHandler().handleException(f);
                }
            }
        }

        private class CompareCommonAction
        extends AnnotationAction {
            CompareCommonAction(String name) {
                super(name);
            }

            protected Long getHead() {
                Long head = -1L;
                for (Long key : ISVNAnnotateHandlerImpl.this._msgs.keySet()) {
                    if (key <= head) continue;
                    head = key;
                }
                return head;
            }
        }
    }

    private class SVNAnnotation {
        private Date _date;
        private long _revision;
        private String _author;
        private String _line;

        private SVNAnnotation() {
        }
    }
}

