/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.ui.MonitoredPanel;
import oracle.jdevimpl.vcs.svn.op.ui.SwitchPanel;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNSwitchHandler;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNOperationSwitch
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.switch";
    private SwitchPanel _switchPanel;
    private JEWTDialog _dialog;
    private ISVNInfo _wcInfo;

    public SVNOperationSwitch() {
        super(COMMAND_ID);
    }

    protected int doitImpl(VCSProfile profile) throws Exception {
        this._wcInfo = this.getWCInfo();
        if (this._wcInfo == null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)Resource.get("ACTION_BRANCH_ERROR_MESSAGE_NO_INFO"), (String)Resource.get("ACTION_BRANCH_ERROR_TITLE_NO_INFO"), null);
            return 1;
        }
        this.createPanel();
        this.createDialog();
        this.initListeners();
        if (this._dialog.runDialog()) {
            profile.getStatusCacheBridge().clear();
            return 0;
        }
        return 1;
    }

    private ISVNInfo getWCInfo() {
        Node node = this.getContext().getNode();
        URL url = null;
        File file = null;
        if (node != null) {
            url = node.getURL();
            String suffix = URLFileSystem.getSuffix((URL)url);
            if (suffix.equals(".jws") || suffix.equals(".jpr")) {
                url = URLFileSystem.getParent((URL)url);
            }
        } else {
            Element elem = this.getContext().getElement();
            if (elem instanceof RelativeDirectoryContextFolder) {
                url = ((RelativeDirectoryContextFolder)elem).getRootDirectories().getFirstEntry();
            } else if (elem instanceof Locatable) {
                url = ((Locatable)elem).getURL();
            }
        }
        file = SVNUtil.toFile(url);
        ISVNClientAdapter client = null;
        try {
            client = SVNUtil.getIDEClientAdapter();
            ISVNInfo info = client.getInfoFromWorkingCopy(file);
            return info;
        }
        catch (SVNClientException e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning(e.getMessage());
            return null;
        }
    }

    private void createPanel() {
        this._switchPanel = new SwitchPanel();
        this._switchPanel.setFromField(this._wcInfo.getUrl().toString());
        this._switchPanel.setToField(this.getToURLString());
        this._switchPanel.setContext(this.getContext());
    }

    private void createDialog() {
        String title = Resource.get("ACTION_SWITCH_DIALOG_TITLE");
        this._dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)this._switchPanel, (Component)this._switchPanel.getInitialFocus(), (String)title, (int)7);
        this._dialog.setDefaultButton(1);
        this._dialog.setContent((Component)this._switchPanel);
        this._dialog.setResizable(true);
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(Resource.get("ACTION_SWITCH_DIALOG_HEADER_DESC"));
        this._dialog.setDialogHeader((Component)header);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._switchPanel, "f1_svnswitch_html");
    }

    private void initListeners() {
        this._dialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
                if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                    return;
                }
                SwitchThread switchThread = new SwitchThread();
                switchThread.start();
                throw new PropertyVetoException("", pce);
            }
        });
        this._switchPanel.addListener(new MonitoredPanel.PanelListener(){

            @Override
            public void setContainsURL(boolean containsValidContent) {
                SVNOperationSwitch.this.setOKButton(containsValidContent);
            }
        });
    }

    private void setOKButton(final boolean containsValidContent) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SVNOperationSwitch.this._dialog.setOKButtonEnabled(containsValidContent);
            }
        });
    }

    private String getToURLString() {
        return SVNUtil.canonicalizeSVNUrl(this._wcInfo.getUrl()).toString();
    }

    private class SwitchThread
    extends Thread {
        IndeterminateProgressMonitor progressMon;

        private SwitchThread() {
            super("svn-switch-thread");
        }

        @Override
        public void run() {
            final WaitCursor wc = new WaitCursor(SVNOperationSwitch.this._dialog.getContent());
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    wc.show();
                }
            });
            this.executeSwitchingWithProgress();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SVNOperationSwitch.this._dialog.setVisible(false);
                    SVNOperationSwitch.this._dialog.dispose();
                }
            });
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    wc.hide();
                }
            });
            VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion");
            profile.getStatusCacheBridge().clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeSwitchingWithProgress() {
            SVNSwitchHandler handler = new SVNSwitchHandler(SVNOperationSwitch.this.getContext());
            this.progressMon = new IndeterminateProgressMonitor((Component)SVNOperationSwitch.this._dialog, Resource.get("ACTION_SWITCH_PROGRESS_TITLE"), (Object)Resource.get("ACTION_SWITCH_PROGRESS_MESSAGE"), null);
            this.progressMon.setMillisToPopup(0);
            this.progressMon.setCloseOnFinish(true);
            this.progressMon.setCancellable(false);
            this.progressMon.start();
            try {
                File destFile = SVNOperationSwitch.this._wcInfo.getFile();
                SVNUrl toUrl = SVNOperationSwitch.this._switchPanel.getToUrl();
                SVNRevision toRevision = SVNOperationSwitch.this._switchPanel.getRevision();
                boolean isRecursive = true;
                SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(SVNOperationSwitch.this._wcInfo.getUrl());
                handler.executeSwitching(destFile, toUrl, toRevision, isRecursive, repoInfo, this.progressMon);
            }
            finally {
                this.progressMon.finish();
            }
        }
    }
}

