/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSDialogRunner;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.svn.SVNExecutorService;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteNode;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.ui.ExportFromReposPanel;
import oracle.jdevimpl.vcs.svn.op.ui.ExportFromWCPanel;
import oracle.jdevimpl.vcs.svn.op.ui.ExportPathListener;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNOperationExport
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.export";

    public SVNOperationExport() {
        super(COMMAND_ID);
    }

    public SVNOperationExport(String command) {
        super(command);
    }

    protected boolean isAvailableImpl(VCSProfile profile) throws Exception {
        return super.isAvailableImpl(profile);
    }

    protected int doitImpl(VCSProfile profile) throws Exception {
        Element selected = this.getContext().getElement();
        if (selected instanceof SVNRemoteNode) {
            SVNRemoteNode remoteNode = (SVNRemoteNode)selected;
            this.exportFromRepository((SVNRepositoryInfo)remoteNode.getParentRepository().getData(), remoteNode.getSVNUrl());
            return 1;
        }
        Locatable[] node = VCSContextUtils.getContextLocatables((Context)this.getContext());
        if (node != null && node.length > 0) {
            Collection<VCSHashURL> parents = this.getCommonFolderURL(node);
            Iterator<VCSHashURL> it = parents.iterator();
            while (it.hasNext()) {
                if (this.exportFromWorkingCopy(it.next().getURL())) continue;
                return 1;
            }
            return 1;
        }
        return 1;
    }

    private void exportFromRepository(final SVNRepositoryInfo repos, final SVNUrl url) {
        final ExportFromReposPanel panel = new ExportFromReposPanel(url);
        final JEWTDialog dialog = new JEWTDialog((Frame)Ide.getMainWindow(), Resource.get("ACTION_EXPORT_DIALOG_TITLE"), 7);
        dialog.setDefaultButton(1);
        dialog.setOKButtonEnabled(false);
        dialog.setContent((Component)panel);
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(Resource.get("ACTION_EXPORT_DIALOG_HEADER_DESC_SVNURL"));
        dialog.setDialogHeader((Component)header);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_svnexportfilessvnurl_html");
        panel.addExportPathListener(new ExportPathListener(){

            @Override
            public void exportPathSelected(String newPath) {
                dialog.setOKButtonEnabled(newPath != null && newPath.length() > 0);
            }
        });
        dialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
                if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                    return;
                }
                if (panel.getRevision() == SVNRevision.INVALID_REVISION) {
                    MessageDialog.error((Component)dialog, (Object)Resource.get("INVALID_REVISION_ERROR_MESSAGE"), (String)Resource.get("INVALID_REVISION_ERROR_TITLE"), null);
                    throw new PropertyVetoException(null, pce);
                }
            }
        });
        dialog.addVetoableChangeListener((VetoableChangeListener)new ExportPathValidator(){

            @Override
            protected URL getExportPath() {
                return panel.getExportPath();
            }

            @Override
            protected JEWTDialog getParentDialog() {
                return dialog;
            }
        });
        if (VCSDialogRunner.runDialog((JDialog)dialog)) {
            RequestProcessor processor = new RequestProcessor("Subversion Export", 1);
            processor.post((Runnable)new ExportBackground(){

                @Override
                protected SVNRepositoryInfo getReposInfo() {
                    return repos;
                }

                @Override
                protected URL getExportPath() {
                    return panel.getExportPath();
                }

                @Override
                protected void executeExport(ISVNClientAdapter client, URL exportPath) throws SVNClientException {
                    client.doExport(url, SVNUtil.toFile(exportPath), panel.getRevision(), true);
                }
            });
        }
    }

    private boolean exportFromWorkingCopy(final URL dirUrl) {
        final ExportFromWCPanel panel = new ExportFromWCPanel(dirUrl);
        final JEWTDialog dialog = new JEWTDialog((Frame)Ide.getMainWindow(), Resource.get("ACTION_EXPORT_DIALOG_TITLE"), 7);
        dialog.setDefaultButton(1);
        dialog.setOKButtonEnabled(false);
        dialog.setContent((Component)panel);
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(Resource.get("ACTION_EXPORT_DIALOG_HEADER_DESC_URL"));
        dialog.setDialogHeader((Component)header);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_svnexportfilesurl_html");
        panel.addExportPathListener(new ExportPathListener(){

            @Override
            public void exportPathSelected(String newPath) {
                dialog.setOKButtonEnabled(newPath != null && newPath.length() > 0);
            }
        });
        dialog.addVetoableChangeListener((VetoableChangeListener)new ExportPathValidator(){

            @Override
            protected URL getExportPath() {
                return panel.getExportPath();
            }

            @Override
            protected JEWTDialog getParentDialog() {
                return dialog;
            }
        });
        if (VCSDialogRunner.runDialog((JDialog)dialog)) {
            SVNExecutorService.getInstance().submit(new ExportTask(){

                @Override
                protected String getProgressMessage() {
                    return Resource.get("UI_EXP_PROGRESS_MSG_URL");
                }

                @Override
                protected URL getExportPath() {
                    return panel.getExportPath();
                }

                @Override
                protected void executeExport(ISVNClientAdapter client, URL exportPath) throws SVNClientException {
                    client.doExport(SVNUtil.toFile(dirUrl), SVNUtil.toFile(exportPath), true);
                }
            });
            return true;
        }
        return false;
    }

    private Collection<VCSHashURL> getCommonFolderURL(Locatable[] locatables) {
        ArrayList<VCSHashURL> c = new ArrayList<VCSHashURL>();
        for (Locatable locatable : locatables) {
            VCSHashURL hURL = URLFileSystem.isDirectoryPath((URL)locatable.getURL()) ? new VCSHashURL(locatable.getURL()) : new VCSHashURL(URLFileSystem.getParent((URL)locatable.getURL()));
            if (c.contains(hURL)) continue;
            c.add(hURL);
        }
        Iterator it = c.iterator();
        while (it.hasNext()) {
            VCSHashURL h = (VCSHashURL)it.next();
            if (!this.isLocatedIn(h, c)) continue;
            it.remove();
        }
        return c;
    }

    private boolean isLocatedIn(VCSHashURL url, Collection<VCSHashURL> c) {
        for (VCSHashURL h : c) {
            if (h.equals((Object)url) || !URLFileSystem.isBaseURLFor((URL)h.getURL(), (URL)url.getURL())) continue;
            return true;
        }
        return false;
    }

    private abstract class ExportBackground
    implements Runnable {
        private ExportBackground() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ProgressHandle handle = ProgressHandle.createHandle((String)Resource.get("SUBVERSION_EXPORT"));
            handle.start();
            ISVNClientAdapter client = null;
            URL exportPath = this.getExportPath();
            try {
                client = SVNUtil.getIDEClientAdapter();
                SVNOperationLogger.getInstance().beginOperation(client, this.getReposInfo());
                this.executeExport(client, exportPath);
                SVNOperationLogger.getInstance().successFinish(Resource.get("OP_EXPORT"));
            }
            catch (SVNClientException ce) {
                SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(ce.getMessage());
                ExceptionDialog.showExceptionDialog((Window)VCSWindowUtils.getCurrentWindow(), (Exception)((Object)ce), (String)Resource.get("ACTION_EXPORT_ERROR_TITLE"), (String)Resource.format("ACTION_EXPORT_ERROR_MSG", URLFileSystem.getPlatformPathName((URL)exportPath)));
            }
            finally {
                handle.finish();
                if (client != null) {
                    SVNOperationLogger.getInstance().endOperation();
                }
            }
        }

        protected SVNRepositoryInfo getReposInfo() {
            return null;
        }

        protected abstract URL getExportPath();

        protected abstract void executeExport(ISVNClientAdapter var1, URL var2) throws SVNClientException;
    }

    private abstract class ExportTask
    implements Runnable {
        private ExportTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            IndeterminateProgressMonitor progress = new IndeterminateProgressMonitor((Component)VCSWindowUtils.getCurrentWindow(), Resource.get("UI_EXP_PROGRESS_TITLE"), (Object)this.getProgressMessage(), null);
            progress.setCancellable(false);
            progress.setCloseOnFinish(true);
            progress.setMillisToPopup(0);
            progress.start();
            ISVNClientAdapter client = null;
            URL exportPath = this.getExportPath();
            try {
                client = SVNUtil.getIDEClientAdapter();
                SVNOperationLogger.getInstance().beginOperation(client, this.getReposInfo());
                this.executeExport(client, exportPath);
                SVNOperationLogger.getInstance().successFinish(Resource.get("OP_EXPORT"));
            }
            catch (SVNClientException ce) {
                SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(ce.getMessage());
                ExceptionDialog.showExceptionDialog((Window)VCSWindowUtils.getCurrentWindow(), (Exception)((Object)ce), (String)Resource.get("ACTION_EXPORT_ERROR_TITLE"), (String)Resource.format("ACTION_EXPORT_ERROR_MSG", URLFileSystem.getPlatformPathName((URL)exportPath)));
            }
            finally {
                if (client != null) {
                    SVNOperationLogger.getInstance().endOperation();
                }
                progress.finish();
            }
        }

        protected SVNRepositoryInfo getReposInfo() {
            return null;
        }

        protected abstract String getProgressMessage();

        protected abstract URL getExportPath();

        protected abstract void executeExport(ISVNClientAdapter var1, URL var2) throws SVNClientException;
    }

    protected abstract class ExportPathValidator
    implements VetoableChangeListener {
        protected ExportPathValidator() {
        }

        @Override
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)e)) {
                return;
            }
            URL path = this.getExportPath();
            URL[] urls = URLFileSystem.list((URL)path);
            if (URLFileSystem.exists((URL)path) && urls != null && urls.length > 0 && !this.confirmNonEmptyDir(path)) {
                throw new PropertyVetoException(null, e);
            }
            if (!URLFileSystem.mkdirs((URL)path)) {
                MessageDialog.error((Component)this.getParentDialog(), (Object)Resource.format("ACTION_EXPORT_ERROR_MSG", path), (String)Resource.get("ACTION_EXPORT_ERROR_TITLE"), null);
                throw new PropertyVetoException(null, e);
            }
        }

        protected abstract URL getExportPath();

        protected abstract JEWTDialog getParentDialog();

        private boolean confirmNonEmptyDir(URL dir) {
            return MessageDialog.confirm((Component)this.getParentDialog(), (Object)Resource.format("ACTION_EXPORT_CONFIRM_MSG", URLFileSystem.getPlatformPathName((URL)dir)), (String)Resource.get("ACTION_EXPORT_CONFIRM_TITLE"), null);
        }
    }
}

