/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.nav;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.VetoableChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.ide.wizard.Wizard;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ImageIconCache;
import oracle.jdeveloper.vcs.nav.ConnectionProvider;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.svn.AlreadyExistsException;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNavigatorAPI;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNode;
import oracle.jdevimpl.vcs.svn.nav.ui.ConnectionPanel;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryManager;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNRepositoryInfoValidator;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class SVNRepositoryWizard
extends Wizard {
    public static final String PROPERTY_NAME_EDITING = SVNRepositoryWizard.class.getName() + ".editing";
    public static final String PRESET_REPO_URL = "PRESET_REPO_URL";
    public static final String PRESET_REPO_NAME = "PRESET_REPO_NAME";
    public static final String PRESET_REPO_USERNAME = "PRESET_REPO_USERNAME";
    public static final String PRESET_TESTAREA = "PRESET_NO_TEST";

    public boolean isAvailable(Context context) {
        return true;
    }

    public boolean invoke(Context context) {
        boolean ok;
        NodeCommitter nodeCommitter;
        final ConnectionPanel panel = context.getProperty(PRESET_TESTAREA) != null && context.getProperty(PRESET_TESTAREA).equals(Boolean.FALSE) ? new ConnectionPanel(false) : new ConnectionPanel();
        boolean editing = this.isEditing(context);
        final JEWTDialog dialog = this.createDialog(panel, editing);
        final WaitCursor wc = new WaitCursor((Component)panel);
        panel.addListener(new ConnectionPanel.Listener(){

            @Override
            public void setContainsURL(boolean containsUrl) {
                dialog.setOKButtonEnabled(containsUrl);
            }

            @Override
            public void testHasBegun() {
                dialog.setOKButtonEnabled(false);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        wc.show();
                    }
                });
            }

            @Override
            public void testHasFinished() {
                dialog.setOKButtonEnabled(true);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        wc.hide();
                    }
                });
            }
        });
        dialog.addWindowListener(new WindowListener(){

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                panel.cleanupInteraction();
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        if (editing) {
            SVNRepositoryNode reposNode;
            if (context.getNode() instanceof SVNRepositoryNode) {
                reposNode = (SVNRepositoryNode)context.getNode();
            } else {
                reposNode = this.getRepositoryNode(context);
                if (reposNode == null) {
                    MessageDialog.error((Component)VCSWindowUtils.getCurrentWindow(), (Object)Resource.get("EDIT_CONNECTION_ERROR"), (String)Resource.get("EDIT_CONNECTION_TITLE"), null);
                    return false;
                }
            }
            panel.setRepositoryInfo((SVNRepositoryInfo)reposNode.getData());
            nodeCommitter = new EditNodeCommitter(dialog, panel, reposNode);
        } else {
            panel.setRepositoryInfo(null);
            nodeCommitter = new NewNodeCommitter(dialog, panel);
        }
        dialog.addVetoableChangeListener((VetoableChangeListener)((Object)new ConnectionCommitter(panel, nodeCommitter)));
        if (context.getProperty(PRESET_REPO_URL) != null) {
            panel.setURL((String)context.getProperty(PRESET_REPO_URL));
        }
        if (context.getProperty(PRESET_REPO_NAME) != null) {
            panel.setRepositoryName((String)context.getProperty(PRESET_REPO_NAME));
        }
        if (context.getProperty(PRESET_REPO_USERNAME) != null) {
            panel.setUserName((String)context.getProperty(PRESET_REPO_USERNAME));
        }
        if (ok = WizardLauncher.runDialog((JDialog)dialog)) {
            SVNUtil.usageTrackerLog();
        }
        if (ok && !editing && !ConnectionProvider.isVersioningConnectionView((View)context.getView())) {
            SVNRepositoryNavigatorAPI.getInstance().showRepositoryNavigator();
        }
        return ok;
    }

    public String getShortLabel() {
        return Resource.get("NAV_CONNECTION_WIZARD_LABEL");
    }

    public String getLongLabel() {
        return Resource.get("NAV_CONNECTION_WIZARD_DESCRIPTION");
    }

    public Icon getIcon() {
        return ImageIconCache.get((URL)Resource.class.getResource(Resource.get("NAV_CONNECTION_WIZARD_ICON")));
    }

    private boolean isEditing(Context ctx) {
        Boolean authenticate;
        Boolean editing = (Boolean)ctx.getProperty(PROPERTY_NAME_EDITING);
        if (editing == null) {
            editing = Boolean.FALSE;
        }
        if ((authenticate = (Boolean)ctx.getProperty("authenication-edit")) == null) {
            authenticate = Boolean.FALSE;
        }
        return (ctx.getNode() instanceof SVNRepositoryNode || authenticate != false) && editing != false;
    }

    private SVNRepositoryNode getRepositoryNode(Context context) {
        SVNUrl reposUrl;
        Node node;
        URL url = null;
        Node node2 = node = context != null ? context.getNode() : null;
        if (node != null) {
            url = node.getURL();
        } else if (context.getElement() != null && context.getElement() instanceof Locatable) {
            url = ((Locatable)context.getElement()).getURL();
        } else if (context.getProject() != null) {
            url = context.getProject().getURL();
        }
        if (url == null) {
            return null;
        }
        try {
            reposUrl = SVNURLInfoCache.getInstance().getURL(url);
            if (reposUrl == null) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(reposUrl);
        return new SVNRepositoryNode(repoInfo);
    }

    private JEWTDialog createDialog(JComponent content, boolean editMode) {
        JEWTDialog dialog = new JEWTDialog((Frame)Ide.getMainWindow(), editMode ? Resource.get("NAV_CONNECTION_WIZARD_DIALOG_TITLE_EDIT") : Resource.get("NAV_CONNECTION_WIZARD_DIALOG_TITLE_CREATE"), 7);
        dialog.setDefaultButton(1);
        dialog.setContent((Component)content);
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(Resource.get("NAV_CONNECTION_WIZARD_DIALOG_HEADER_DESC"));
        dialog.setDialogHeader((Component)header);
        HelpSystem.getHelpSystem().registerTopic(content, editMode ? "f1_svneditsvnconnection_html" : "f1_svncreatesvnconnection_html");
        dialog.setName("SVN-Connection-Dialog");
        return dialog;
    }

    private final class EditNodeCommitter
    extends NodeCommitter {
        private final SVNRepositoryNode _originalNode;

        private EditNodeCommitter(JEWTDialog dialog, ConnectionPanel panel, SVNRepositoryNode originalNode) {
            super(dialog, panel);
            this._originalNode = originalNode;
        }

        @Override
        protected final boolean commitNode() {
            try {
                SVNRepositoryInfo reposInfo = this._panel.createRepositoryInfo();
                if (SVNRepositoryManager.getInstance().existsName(reposInfo) && !((SVNRepositoryInfo)this._originalNode.getData()).getAlias().equals(reposInfo.getAlias())) {
                    throw new AlreadyExistsException();
                }
                SVNRepositoryNavigatorAPI.getInstance().removeRepositoryConnection(this._originalNode);
                SVNRepositoryNavigatorAPI.getInstance().createRepositoryConnection(reposInfo);
                return true;
            }
            catch (MalformedURLException mfue) {
                this.respond(mfue);
            }
            catch (AlreadyExistsException aee) {
                this.respond(aee);
            }
            return false;
        }
    }

    private final class NewNodeCommitter
    extends NodeCommitter {
        private NewNodeCommitter(JEWTDialog dialog, ConnectionPanel panel) {
            super(dialog, panel);
        }

        @Override
        protected final boolean commitNode() {
            try {
                SVNRepositoryInfo reposInfo = this._panel.createRepositoryInfo();
                SVNRepositoryNavigatorAPI.getInstance().createRepositoryConnection(reposInfo);
                return true;
            }
            catch (MalformedURLException mfue) {
                this.respond(mfue);
            }
            catch (AlreadyExistsException aee) {
                this.respond(aee);
            }
            return false;
        }
    }

    private static class ConnectionCommitter
    extends VCSDialogCommitter {
        private final ConnectionPanel _cPanel;
        private final NodeCommitter _nodeCommitter;

        ConnectionCommitter(ConnectionPanel cPanel, NodeCommitter nodeCommitter) {
            this._cPanel = cPanel;
            this._nodeCommitter = nodeCommitter;
        }

        protected boolean doCommitOperation() {
            SVNRepositoryInfoValidator validator;
            SVNRepositoryInfo svnInfo = null;
            try {
                svnInfo = this._cPanel.createRepositoryInfo();
            }
            catch (MalformedURLException e) {
                MessageDialog.information((Component)this._cPanel, (Object)Resource.format("CONNECTION_BAD_URL", svnInfo.getURL()), (String)Resource.get("CONNECTION_ERROR_TITLE"), null);
                return false;
            }
            try {
                validator = new SVNRepositoryInfoValidator(svnInfo, SVNUtil.getWCClient(svnInfo));
            }
            catch (Exception ce) {
                SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning(ce.getMessage());
                MessageDialog.information((Component)this._cPanel, (Object)ce.getMessage(), (String)Resource.get("CONNECTION_ERROR_TITLE"), null);
                return false;
            }
            boolean success = false;
            try {
                success = validator.validate();
            }
            catch (SVNRepositoryInfoValidator.TimeoutException te) {
                MessageDialog.information((Component)this._cPanel, (Object)Resource.get("CONNECTION_TEST_TIMEOUT"), (String)Resource.get("CONNECTION_ERROR_TITLE"), null);
                return false;
            }
            if (!success) {
                MessageDialog.information((Component)this._cPanel, (Object)Resource.get("CONNECTION_NOT_CONNECTED"), (String)Resource.get("CONNECTION_ERROR_TITLE"), null);
                return false;
            }
            return this._nodeCommitter.commitNode();
        }
    }

    private abstract class NodeCommitter {
        protected final JEWTDialog _dialog;
        protected final ConnectionPanel _panel;

        NodeCommitter(JEWTDialog dialog, ConnectionPanel panel) {
            this._dialog = dialog;
            this._panel = panel;
        }

        protected abstract boolean commitNode();

        protected void respond(MalformedURLException mfue) {
            MessageDialog.error((Component)this._panel, (Object)Resource.get("NAV_CONNECTION_WIZARD_COMMIT_BAD_URL"), (String)Resource.get("NAV_CONNECTION_WIZARD_COMMIT_ERROR"), null);
            this._dialog.setOKButtonEnabled(false);
        }

        protected void respond(AlreadyExistsException aee) {
            MessageDialog.error((Component)this._panel, (Object)(aee.getMessage() != null ? aee.getMessage() : Resource.get("NAV_CONNECTION_WIZARD_COMMIT_NON_UNIQUE")), (String)Resource.get("NAV_CONNECTION_WIZARD_COMMIT_ERROR"), null);
            this._dialog.setOKButtonEnabled(false);
        }
    }
}

