/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.imp;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.WaitCursor;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ImageIconCache;
import oracle.jdevimpl.vcs.svn.SVNExecutorService;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.imp.SVNImportModel;
import oracle.jdevimpl.vcs.svn.imp.SVNImportWizard;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.SVNOperationNewRemoteDir;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryManager;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNReposInfoComboBoxRenderer;
import oracle.jdevimpl.vcs.svn.util.SVNRepositoryTreeNode;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class DestinationPanel
extends DefaultTraversablePanel
implements ActionListener {
    private static final String TRANSIENT_TREE_PATH_KEY = DestinationPanel.class.getName() + ".treePath";
    private final Map _treeModels = new HashMap(10);
    private boolean _initialized = false;
    private JMultiLineLabel _hint;
    private JLabel _reposListLabel;
    private JComboBox _reposList;
    private JScrollPane _treeScroller;
    private JTree _tree;
    private DefaultMutableTreeNode _treeRoot;
    private JLabel _treeLabel;
    private JToolBar _treeToolbar;
    private JButton _newReposDirButton;

    private void reloadTreeNodes(boolean contactRepos) {
        SVNRepositoryInfo repos = (SVNRepositoryInfo)this._reposList.getSelectedItem();
        this._treeRoot.removeAllChildren();
        if (contactRepos) {
            this._treeModels.put(repos, null);
        }
        Iterator it = this.getNodeModel(repos).iterator();
        while (it.hasNext()) {
            this._treeRoot.add((MutableTreeNode)it.next());
        }
        ((DefaultTreeModel)this._tree.getModel()).reload(this._treeRoot);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._reposList) {
            this.reloadTreeNodes(false);
            this._tree.setSelectionPath(new TreePath(this._treeRoot));
        }
        if (e.getSource() == this._newReposDirButton) {
            TreeNode selectedNode;
            SVNRepositoryInfo repos = (SVNRepositoryInfo)this._reposList.getSelectedItem();
            SVNUrl parent = repos.getURL();
            TreePath selectedPath = this._tree.getSelectionPath();
            DefaultMutableTreeNode parentNode = this._treeRoot;
            if (selectedPath != null && (selectedNode = (TreeNode)selectedPath.getLastPathComponent()) != this._treeRoot) {
                SVNRepositoryTreeNode svnNode = (SVNRepositoryTreeNode)selectedNode;
                parent = svnNode.getURL();
                parentNode = svnNode;
            }
            SVNOperationNewRemoteDir command = new SVNOperationNewRemoteDir(repos, parent, false);
            Context context = Context.newIdeContext();
            command.setContext(context);
            try {
                CommandProcessor.getInstance().invoke((Command)command);
                String newDir = (String)context.getProperty(SVNOperationNewRemoteDir.DIR_NAME_PROP_KEY);
                final WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
                if (newDir != null) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            wc.show(500);
                        }
                    });
                    if (parentNode instanceof SVNRepositoryTreeNode) {
                        ((SVNRepositoryTreeNode)parentNode).repopulate();
                        ((DefaultTreeModel)this._tree.getModel()).reload(parentNode);
                        Enumeration<TreeNode> childNodes = parentNode.children();
                        this.selectChildNode(newDir, childNodes);
                    } else {
                        this.reloadTreeNodes(true);
                        Enumeration<TreeNode> childNodes = this._treeRoot.children();
                        this.selectChildNode(newDir, childNodes);
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            wc.hide();
                        }
                    });
                }
            }
            catch (Exception commandException) {
                SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(commandException.getMessage());
            }
        }
    }

    private void selectChildNode(String newDir, Enumeration childNodes) {
        while (childNodes.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)childNodes.nextElement();
            if (!newDir.equals(node.getUserObject())) continue;
            this._tree.setSelectionPath(new TreePath(node.getPath()));
        }
    }

    public void onEntry(final TraversableContext ctx) {
        this.initialize();
        final SVNImportModel model = (SVNImportModel)ctx.get(SVNImportWizard.DATA_KEY);
        SVNExecutorService.getInstance().submit(new Runnable(){

            @Override
            public void run() {
                DestinationPanel.this.getNodeModel(model.getRepository());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TreePath selectedPath;
                        SVNUrl reposUrl = model.getRepository().getURL();
                        for (int i = 0; i < DestinationPanel.this._reposList.getItemCount(); ++i) {
                            SVNRepositoryInfo repos = (SVNRepositoryInfo)DestinationPanel.this._reposList.getItemAt(i);
                            if (!reposUrl.equals((Object)repos.getURL())) continue;
                            DestinationPanel.this._reposList.setSelectedIndex(i);
                            break;
                        }
                        if ((selectedPath = (TreePath)ctx.get(TRANSIENT_TREE_PATH_KEY)) != null) {
                            DestinationPanel.this._tree.setSelectionPath(selectedPath);
                        } else {
                            try {
                                DestinationPanel.this._tree.setSelectionPath(new TreePath(DestinationPanel.this._treeRoot));
                            }
                            catch (NoSuchElementException noSuchElementException) {
                                // empty catch block
                            }
                        }
                        ctx.getWizardCallbacks().wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
                    }
                });
            }
        });
        ctx.getWizardCallbacks().wizardEnableButtons(Boolean.FALSE, Boolean.FALSE, Boolean.FALSE);
    }

    public void onExit(TraversableContext ctx) throws TraversalException {
        this.initialize();
        SVNImportModel model = (SVNImportModel)ctx.get(SVNImportWizard.DATA_KEY);
        SVNRepositoryInfo repos = (SVNRepositoryInfo)this._reposList.getSelectedItem();
        model.setRepository(repos);
        TreePath selectedPath = this._tree.getSelectionPath();
        if (selectedPath != null) {
            TreeNode selectedNode = (TreeNode)selectedPath.getLastPathComponent();
            if (selectedNode == this._treeRoot) {
                model.setDestinationUrl(repos.getSVNURL());
            } else {
                SVNRepositoryTreeNode svnNode = (SVNRepositoryTreeNode)selectedNode;
                model.setDestinationUrl(svnNode.getSVNURL());
            }
            ctx.put(TRANSIENT_TREE_PATH_KEY, (Object)selectedPath);
        } else {
            model.setDestinationUrl(repos.getSVNURL());
            ctx.put(TRANSIENT_TREE_PATH_KEY, null);
        }
    }

    private Collection getNodeModel(SVNRepositoryInfo repos) {
        Collection nodeModel = (Collection)this._treeModels.get(repos);
        if (nodeModel == null) {
            try {
                nodeModel = this.generateNodeModel(repos);
                this._treeModels.put(repos, nodeModel);
            }
            catch (SVNClientException ce) {
                nodeModel = Collections.EMPTY_LIST;
            }
        }
        return nodeModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection generateNodeModel(SVNRepositoryInfo repos) throws SVNClientException {
        ArrayList arrayList;
        SVNRepositoryTreeNode virtualRoot = new SVNRepositoryTreeNode(repos, SVNNodeKind.DIR, repos.getURL(), "/", 1, true, SVNUtil.getIDEClientAdapter());
        ArrayList nodes = new ArrayList(20);
        final WaitCursor wc = new WaitCursor((Component)((Object)this));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                wc.show(500);
            }
        });
        try {
            Enumeration children = virtualRoot.children();
            while (children.hasMoreElements()) {
                nodes.add(children.nextElement());
            }
            arrayList = nodes;
        }
        catch (Throwable throwable) {
            EventQueue.invokeLater(new Runnable(){
                final /* synthetic */ WaitCursor val$wc;
                {
                    this.val$wc = waitCursor;
                }

                @Override
                public void run() {
                    this.val$wc.hide();
                }
            });
            throw throwable;
        }
        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
        return arrayList;
    }

    private synchronized void initialize() {
        if (this._initialized) {
            return;
        }
        this.createComponents();
        this.layoutComponents();
        this.initListeners();
        this._initialized = true;
    }

    private void createComponents() {
        this._hint = new JMultiLineLabel();
        this._hint.setText(Resource.get("IMPORT_UI_DEST_HINT"));
        this._reposList = new JComboBox<Object>(SVNRepositoryManager.getInstance().list().toArray());
        this._reposList.setRenderer(new SVNReposInfoComboBoxRenderer());
        this._reposListLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._reposListLabel, (Component)this._reposList, (String)Resource.get("IMPORT_UI_REPOS_CONNECTION"));
        this._treeRoot = new DefaultMutableTreeNode("root");
        this._tree = new JTree(this._treeRoot);
        this._tree.setVisibleRowCount(10);
        this._tree.setRootVisible(true);
        this._tree.setShowsRootHandles(true);
        this._tree.getSelectionModel().setSelectionMode(1);
        this._tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (!(value instanceof SVNRepositoryTreeNode)) {
                    this.setIcon(ImageIconCache.get((URL)Resource.class.getResource(Resource.get("NAV_ICON_REPOSITORY_NODE"))));
                }
                return this;
            }
        });
        this._treeLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._treeLabel, (Component)this._tree, (String)Resource.get("IMPORT_UI_REPOS_TREE"));
        this._treeScroller = new JScrollPane(this._tree);
        this._newReposDirButton = new JButton(OracleIcons.getIcon((String)"folderNew.png"));
        this._newReposDirButton.setMargin(new Insets(1, 1, 1, 1));
        this._newReposDirButton.setToolTipText(Resource.get("IMPORT_UI_CREATE_REMOTE_FOLDER_TOOLTIP"));
        this._newReposDirButton.setName("NewReposDir");
        this._treeToolbar = new JToolBar(0);
        this._treeToolbar.setBorder(BorderFactory.createEmptyBorder());
        this._treeToolbar.setFloatable(false);
        this._treeToolbar.setRollover(true);
        this._treeToolbar.add(this._newReposDirButton);
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this._hint, this.gbc(0, 0, 2, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add(this._reposListLabel, this.gbc(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 3, 0), 0, 0));
        this.add(this._reposList, this.gbc(0, 2, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 50, 0));
        this.add(this._treeLabel, this.gbc(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 3, 0), 0, 0));
        this.add(this._treeToolbar, this.gbc(1, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 3, 0), 0, 0));
        this.add(this._treeScroller, this.gbc(0, 4, 2, 1, 0.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void initListeners() {
        this._reposList.addActionListener(this);
        this._newReposDirButton.addActionListener(this);
    }
}

