/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.history;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.history.HistoryEntry;
import oracle.jdeveloper.vcs.generic.HistoryEntryProducer;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.history.SVNHistoryEntry;
import oracle.jdevimpl.vcs.svn.history.SVNWCHistoryEntry;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class SVNHistoryEntryProducer
implements HistoryEntryProducer {
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(SVNHistoryEntryProducer.class.getName());
    public static Object CLIENT_CONTEXT = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HistoryEntry[] produceEntries(URL target) {
        try {
            ISVNClientAdapter client = SVNUtil.getClientAdapter(CLIENT_CONTEXT);
            SVNRepositoryInfo reposInfo = SVNUtil.getFirstAssociatedRepository(target);
            SVNClientInteraction.getInstance().beginInteraction(client, reposInfo);
            HistoryEntry[] historyEntryArray = this.produceEntries(client, target);
            return historyEntryArray;
        }
        catch (Exception ce) {
            String path = URLFileSystem.getPlatformPathName((URL)target);
            sLogger.log(Level.SEVERE, "unable to mine history for " + path, ce);
            MessageDialog.error((Component)VCSWindowUtils.getCurrentWindow(), (Object)Resource.format("HISTROY_PRODUCER_ERROR_MESSAGE", path), (String)Resource.get("HISTROY_PRODUCER_ERROR_TITLE"), null);
            HistoryEntry[] historyEntryArray = new HistoryEntry[]{};
            return historyEntryArray;
        }
        finally {
            SVNClientInteraction.getInstance().endInteraction();
        }
    }

    private HistoryEntry[] produceEntries(ISVNClientAdapter client, URL target) throws SVNClientException {
        try {
            ISVNLogMessage[] logMessages = client.getLogMessages(SVNUtil.toFile(target), SVNRevision.START, SVNRevision.HEAD, false);
            ArrayList<SVNHistoryEntry> entries = new ArrayList<SVNHistoryEntry>(logMessages.length * 2);
            Date maxDate = new Date(0L);
            entries.add(this.getWorkingCopyEntry(client, target));
            for (int i = 0; i < logMessages.length; ++i) {
                entries.add(new SVNHistoryEntry(target, logMessages[i].getDate(), logMessages[i].getAuthor(), logMessages[i].getRevision().getNumber(), logMessages[i].getMessage()));
                if (!logMessages[i].getDate().after(maxDate)) continue;
                maxDate = logMessages[i].getDate();
            }
            SVNHistoryEntry[] hEntries = entries.toArray(new SVNHistoryEntry[entries.size()]);
            hEntries[0].setDate(maxDate);
            return hEntries;
        }
        catch (NumberFormatException fne) {
            throw SVNClientException.wrapException((Exception)fne);
        }
    }

    private SVNHistoryEntry getWorkingCopyEntry(ISVNClientAdapter client, URL target) throws SVNClientException {
        ISVNInfo info = client.getInfoFromWorkingCopy(SVNUtil.toFile(target));
        return new SVNWCHistoryEntry(target, info.getLastChangedDate(), info.getLastCommitAuthor(), info.getRevision().getNumber());
    }
}

