/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.commithistory;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaClass;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.bali.ewt.util.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ideri.util.Product;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.util.DateComparator;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.vcs.commithistory.CommitCancel;
import oracle.jdeveloper.vcs.commithistory.CommitHistoryDetail;
import oracle.jdeveloper.vcs.commithistory.CommitHistoryItem;
import oracle.jdeveloper.vcs.commithistory.CommitHistoryTableModel;
import oracle.jdeveloper.vcs.commithistory.CommitVersionDockableWindow;
import oracle.jdeveloper.vcs.spi.CommonTableModel;
import oracle.jdeveloper.vcs.spi.VCSDetailException;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSMenuConstants;
import oracle.jdeveloper.vcs.vop.DisplayProperty;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.commithistory.SVNCommitVersionCompare;
import oracle.jdevimpl.vcs.svn.commithistory.SVNCommitVersionController;
import oracle.jdevimpl.vcs.svn.commithistory.SVNCommitVersionExport;
import oracle.jdevimpl.vcs.svn.commithistory.SVNCommitVersionMenuListener;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import oracle.jdevimpl.vcs.vop.ClientDisplayProperty;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.DefaultSVNDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SVNCommitVersionDockableWindow
extends CommitVersionDockableWindow {
    private URL _svnRoot;
    private Map<Object, CommitHistoryDetail> _details = new HashMap<Object, CommitHistoryDetail>();
    private CommitVersionDockableWindow.TabbedComponent[] _propertiesUI;
    private GenericTable _propTable;
    private static final String HISTORY_TABLE_SETTINGS = "svn-history-settings";
    public static final String COMMIT_SVN_ROOT = "commit-svn-root";
    public static final String COMMIT_SVN_DIRECTORY = "commit-svn-dir";

    public SVNCommitVersionDockableWindow(String viewId) {
        super(viewId);
        Ide.getSystem().attach(new Observer(){

            public void update(Object observed, UpdateMessage change) {
                if (Boolean.getBoolean("ide.vcs.noapplications") || Product.isRaptor()) {
                    return;
                }
                if (change.getMessageID() != IdeConstants.ACTIVE_PROJECT_CHANGED) {
                    return;
                }
                Workspace workspace = (Workspace)change.getModifyObjects().get(1);
                if (workspace == null) {
                    return;
                }
                URL root = SVNUtil.resolveWorkingCopy(workspace);
                if (root != null && !URLFileSystem.equals((URL)SVNCommitVersionDockableWindow.this._svnRoot, (URL)root)) {
                    SVNCommitVersionDockableWindow.this.clear();
                    SVNCommitVersionDockableWindow.this.refresh();
                }
            }
        });
        this.setType(32);
    }

    protected Controller createController() {
        return new SVNCommitVersionController();
    }

    protected String getThobberLabel() {
        return Resource.get("COMMIT_HISTORY_PROGRESS");
    }

    protected Toolbar getToolbarImpl() {
        Toolbar toolbar = new Toolbar();
        toolbar.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        toolbar.add((ToggleAction)this.getLocalAction(51));
        toolbar.addSeparator();
        toolbar.add((Component)this.getPathCheckBox());
        return toolbar;
    }

    protected ContextMenuListener getContextMenuListener() {
        return new SVNCommitVersionMenuListener();
    }

    protected void refresh() {
        this.showMessage(Resource.get("COMMIT_HISTORY_PROGRESS"));
        this.refreshImpl();
    }

    protected void setSelectedCommitId(String commitId) {
    }

    protected CommitVersionDockableWindow.TabbedComponent[] getTabbedComponents() {
        if (this._propertiesUI == null) {
            this._propTable = new GenericTable();
            PropertiesTableModel model = (PropertiesTableModel)((Object)this.getPropertiesModel(this.getDisplayProperties()));
            this._propTable.setModel((TableModel)((Object)model));
            this._propertiesUI = new CommitVersionDockableWindow.TabbedComponent[1];
            this._propertiesUI[0] = new CommitVersionDockableWindow.TabbedComponent((CommitVersionDockableWindow)this, Resource.get("COMMIT_HISTORY_PROP_TITLE"), Resource.get("COMMIT_HISTORY_PROP_NMEMONIC").charAt(0), (JComponent)new JScrollPane((Component)this._propTable));
        }
        return this._propertiesUI;
    }

    private TableModel getPropertiesModel(DisplayProperty[] displayProperties) {
        return new PropertiesTableModel(displayProperties);
    }

    private DisplayProperty[] getDisplayProperties() {
        DisplayProperty[] props = new DisplayProperty[]{new ClientDisplayProperty(Resource.get("COMMIT_HISTORY_PROP_NAME"), null, 2, (Object)" Modified ", null, String.class, 100), new ClientDisplayProperty(Resource.get("COMMIT_HISTORY_PROP_VALUE"), null, 2, (Object)" /some/example/path/that/is/reasonably/long/for/a/property ", null, String.class, 300)};
        return props;
    }

    protected boolean populateTabs(Object userObject, Collection<CommitHistoryDetail.FileDetail> fileDetail, CommitCancel cancel) throws VCSException {
        if (userObject instanceof SVNLogEntry) {
            SVNWCClient wcClient;
            SVNURL svnurl = null;
            SVNLogEntry entry = (SVNLogEntry)userObject;
            try {
                svnurl = SVNURLInfoCache.getInstance().getSVNURL(this._svnRoot);
                wcClient = SVNUtil.getWCClient(SVNUtil.getFirstAssociatedRepository(this._svnRoot));
            }
            catch (Exception e) {
                throw new VCSDetailException(Resource.get("ERROR_COMMIT_TITLE"), Resource.format("ERROR_HISTORY", entry.getRevision()), e.getMessage());
            }
            final ArrayList data = new ArrayList();
            for (CommitHistoryDetail.FileDetail detail : fileDetail) {
                if (this.isDeleted(detail.getEditType())) continue;
                if (cancel.isCanceled()) {
                    return false;
                }
                if (Thread.interrupted()) {
                    return false;
                }
                try {
                    SVNURL fileUrl = SVNUtil.appendPath(svnurl, detail.getPath());
                    wcClient.doGetProperty(fileUrl, null, SVNRevision.create((long)entry.getRevision()), SVNRevision.create((long)entry.getRevision()), SVNDepth.EMPTY, new ISVNPropertyHandler(){

                        public void handleProperty(File path, SVNPropertyData property) throws SVNException {
                            data.add(new Pair((Object)property.getName(), (Object)SVNPropertyValue.getPropertyAsString((SVNPropertyValue)property.getValue())));
                        }

                        public void handleProperty(SVNURL url, SVNPropertyData property) throws SVNException {
                            data.add(new Pair((Object)property.getName(), (Object)SVNPropertyValue.getPropertyAsString((SVNPropertyValue)property.getValue())));
                        }

                        public void handleProperty(long revision, SVNPropertyData property) throws SVNException {
                            data.add(new Pair((Object)property.getName(), (Object)SVNPropertyValue.getPropertyAsString((SVNPropertyValue)property.getValue())));
                        }
                    });
                }
                catch (SVNException svne) {
                    throw new VCSDetailException(Resource.get("ERROR_COMMIT_TITLE"), Resource.format("ERROR_HISTORY", entry.getRevision()), svne.getMessage());
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PropertiesTableModel model = (PropertiesTableModel)((Object)SVNCommitVersionDockableWindow.this._propTable.getModel());
                    model.addRows(data);
                }
            });
        }
        return false;
    }

    protected CommitHistoryDetail getCommitVersionDetail(Object userObject, CommitCancel cancel) throws VCSException {
        if (userObject instanceof SVNLogEntry) {
            SVNURL svnurl = null;
            SVNLogEntry entry = (SVNLogEntry)userObject;
            try {
                svnurl = SVNURLInfoCache.getInstance().getSVNURL(this._svnRoot);
            }
            catch (Exception e) {
                throw new VCSDetailException(Resource.get("ERROR_COMMIT_TITLE"), Resource.format("ERROR_HISTORY", entry.getRevision()), e.getMessage());
            }
            if (this._details.containsKey(userObject)) {
                return this._details.get(userObject);
            }
            CommitHistoryDetail detail = new CommitHistoryDetail();
            if (cancel.isCanceled()) {
                return null;
            }
            Map paths = entry.getChangedPaths();
            Iterator it = paths.keySet().iterator();
            while (it.hasNext()) {
                if (cancel.isCanceled()) {
                    return null;
                }
                if (Thread.interrupted()) {
                    return null;
                }
                String key = (String)it.next();
                SVNLogEntryPath path = (SVNLogEntryPath)paths.get(key);
                try {
                    detail.addFile(path.getPath(), this.getModifyDesc(path.getType()), null, null);
                }
                catch (Exception e) {
                    throw new VCSDetailException(Resource.get("ERROR_COMMIT_TITLE"), Resource.format("ERROR_HISTORY", entry.getRevision()), e.getMessage());
                }
            }
            detail.setRevId(Long.toString(entry.getRevision()));
            detail.setMessage(entry.getMessage());
            this._details.put(userObject, detail);
            return detail;
        }
        return null;
    }

    protected boolean getCommitVersionDetailDiff(Object userObject, Collection<CommitHistoryDetail.FileDetail> fileDetail, CommitCancel cancel) throws VCSException {
        if (userObject instanceof SVNLogEntry) {
            SVNDiffClient diffClient;
            SVNURL svnurl = null;
            SVNLogEntry entry = (SVNLogEntry)userObject;
            try {
                svnurl = SVNURLInfoCache.getInstance().getSVNURL(this._svnRoot);
                diffClient = SVNUtil.getDiffClient(SVNUtil.getFirstAssociatedRepository(this._svnRoot));
                DefaultSVNDiffGenerator generator = new DefaultSVNDiffGenerator();
                generator.setDiffOptions(new SVNDiffOptions(true, true, true));
                diffClient.setDiffGenerator((ISVNDiffGenerator)generator);
            }
            catch (Exception e) {
                throw new VCSDetailException(Resource.get("ERROR_COMMIT_TITLE"), Resource.format("ERROR_HISTORY", entry.getRevision()), e.getMessage());
            }
            for (CommitHistoryDetail.FileDetail detail : fileDetail) {
                if (cancel.isCanceled()) {
                    return false;
                }
                if (Thread.interrupted()) {
                    return false;
                }
                try {
                    if (detail.getAdd() != null && detail.getDelete() != null) continue;
                    Pair<String, String> diff = new Pair<String, String>((Object)"", (Object)"");
                    if (this.isDifferenceAvailable(detail.getEditType())) {
                        SVNURL fileUrl = SVNUtil.appendPath(svnurl, detail.getPath());
                        diff = this.getDifference(diffClient, fileUrl, entry.getRevision());
                    }
                    detail.setAdd((String)diff.getFirst());
                    detail.setDelete((String)diff.getSecond());
                }
                catch (Exception e) {
                    throw new VCSDetailException(Resource.get("ERROR_COMMIT_TITLE"), Resource.format("ERROR_HISTORY", entry.getRevision()), e.getMessage());
                }
            }
            return true;
        }
        return false;
    }

    protected void createLocalActions() {
        int mnemonic = StringUtils.getMnemonicKeyCode((String)Resource.get("MENU_COMMIT_VERSION_COMPARE"));
        IdeAction action = IdeAction.findOrCreate((int)Ide.findOrCreateCmdID((String)SVNCommitVersionCompare.COMMAND_ID), (MetaClass)new MetaClass(ExtensionRegistry.getExtensionRegistry().getClassLoader("oracle.jdeveloper.subversion"), SVNCommitVersionCompare.COMMAND_ID), (String)Resource.get("MENU_COMMIT_VERSION_COMPARE"), (String)VCSMenuConstants.ACTION_CATEGORY_VERSIONING, (Integer)mnemonic, null, null, (boolean)true);
        action.addController(this.getController());
        mnemonic = StringUtils.getMnemonicKeyCode((String)Resource.get("MENU_COMMIT_VERSION_EXPORT"));
        action = IdeAction.findOrCreate((int)Ide.findOrCreateCmdID((String)SVNCommitVersionExport.COMMAND_ID), (MetaClass)new MetaClass(ExtensionRegistry.getExtensionRegistry().getClassLoader("oracle.jdeveloper.subversion"), SVNCommitVersionExport.COMMAND_ID), (String)Resource.get("MENU_COMMIT_VERSION_EXPORT"), (String)VCSMenuConstants.ACTION_CATEGORY_VERSIONING, (Integer)mnemonic, null, null, (boolean)true);
        action.addController(this.getController());
    }

    protected String getSettingsKey() {
        return HISTORY_TABLE_SETTINGS;
    }

    protected Pair<String, Action> getLinkTextFromMessage(String message) {
        return null;
    }

    protected String getDescription(CommitHistoryItem item) {
        return Resource.format("COMMIT_HISTORY_DESC", (Long)item.getItem(0));
    }

    protected String getCommitId(CommitHistoryItem item) {
        if (item.getUserObject() instanceof SVNLogEntry) {
            return Long.toString(((SVNLogEntry)item.getUserObject()).getRevision());
        }
        return null;
    }

    public String getTitleName() {
        return Resource.get("COMMIT_HISTORY_TAB_NAME");
    }

    public void update(URL url, Object commitId) {
    }

    private void clear() {
        this._details.clear();
        this.clearPath();
    }

    public final Context getContext(EventObject eo) {
        Context context = super.getContext(eo);
        context.setProperty(COMMIT_SVN_ROOT, (Object)this._svnRoot);
        context.setProperty(COMMIT_SVN_DIRECTORY, (Object)this.getDirectoryURL());
        return context;
    }

    private void refreshImpl() {
        SwingWorker<Runnable, Object> worker = new SwingWorker<Runnable, Object>(){
            private Exception _e;

            @Override
            protected Runnable doInBackground() throws Exception {
                return this._doInBackground();
            }

            @Override
            protected void done() {
                if (this._e != null) {
                    SVNCommitVersionDockableWindow.this.showMessage(this._e.getMessage());
                }
                try {
                    Runnable r = (Runnable)this.get();
                    if (r != null) {
                        r.run();
                    } else {
                        SVNCommitVersionDockableWindow.this.showMessage(Resource.get("HISTORY_COMMIT_NOT_FOUND"));
                    }
                }
                catch (Exception ex) {
                    SVNCommitVersionDockableWindow.this.showMessage(ex.getMessage());
                }
            }

            private Runnable _doInBackground() throws SVNException, IOException {
                URL svnRoot = SVNUtil.getActiveSVNRepos();
                if (svnRoot == null) {
                    return null;
                }
                URL commitUrl = SVNCommitVersionDockableWindow.this.getDirectoryURL() == null ? svnRoot : SVNCommitVersionDockableWindow.this.getDirectoryURL();
                SVNCommitVersionDockableWindow.this._svnRoot = svnRoot;
                final List<CommitHistoryItem> items = this.getCommitLog(commitUrl);
                return new Runnable(){

                    @Override
                    public void run() {
                        TableModel model = SVNCommitVersionDockableWindow.this.getCommitTable().getModel();
                        if (!(model instanceof CommitHistoryTableModel)) {
                            DisplayProperty[] properties = this.getDisplayProperties();
                            model = new CommitHistoryTableModel(properties);
                            SVNCommitVersionDockableWindow.this.installTableModel((CommitHistoryTableModel)model);
                            this.addTableRenderer();
                        }
                        SVNCommitVersionDockableWindow.this.getCommitTable().setSorted(items.size() > 1);
                        ((CommitHistoryTableModel)model).addItems(items);
                        SVNCommitVersionDockableWindow.this.resetCommitDetail();
                        SVNCommitVersionDockableWindow.this.showResults();
                    }

                    private DisplayProperty[] getDisplayProperties() {
                        DisplayProperty[] props = new DisplayProperty[]{new ClientDisplayProperty(Resource.get("COMMIT_HISTORY_COMMIT_ID"), null, 2, (Object)" AAAAAA ", null, String.class, 50), new ClientDisplayProperty(Resource.get("COMMIT_HISTORY_COMMITTER"), null, 2, (Object)" Fred Flintstone ", null, String.class, 75), new ClientDisplayProperty(Resource.get("COMMIT_HISTORY_DATE"), null, 2, (Object)" 01-jan-2000 00:00:00 ", (Comparator)DateComparator.getInstance(), Date.class, 125), new ClientDisplayProperty(Resource.get("COMMIT_HISTORY_MESSAGE_TAB"), null, 2, (Object)" This is the commit message here ", null, String.class, 200)};
                        return props;
                    }

                    private void addTableRenderer() {
                        SVNCommitVersionDockableWindow.this.getCommitTable().setDefaultRenderer(Object.class, (TableCellRenderer)new SVNHistoryTableRenderer());
                    }
                };
            }

            private List<CommitHistoryItem> getCommitLog(URL commitUrl) throws SVNException, IOException {
                SVNLogClient client = SVNUtil.getLogClient(SVNUtil.getFirstAssociatedRepository(commitUrl));
                final ArrayList<CommitHistoryItem> items = new ArrayList<CommitHistoryItem>();
                File[] files = new File[]{SVNUtil.toFile(commitUrl)};
                client.doLog(files, SVNRevision.HEAD, SVNRevision.create((long)1L), true, true, 100L, new ISVNLogEntryHandler(){

                    public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                        Object[] obj = new Object[]{logEntry.getRevision(), logEntry.getAuthor(), logEntry.getDate(), logEntry.getMessage()};
                        CommitHistoryItem item = new CommitHistoryItem(obj, (Object)logEntry);
                        items.add(item);
                    }
                });
                return items;
            }
        };
        this.showProgress();
        worker.execute();
    }

    private String getModifyDesc(char type) {
        switch (type) {
            case 'A': {
                return Resource.get("COMMIT_HISTORY_ADDED");
            }
            case 'D': {
                return Resource.get("COMMIT_HISTORY_DELETED");
            }
            case 'M': {
                return Resource.get("COMMIT_HISTORY_MODIFIED");
            }
            case 'R': {
                return Resource.get("COMMIT_HISTORY_REPLACED");
            }
        }
        return Resource.get("COMMIT_HISTORY_UNKNOWN");
    }

    private boolean isDifferenceAvailable(String type) {
        return type.equals(Resource.get("COMMIT_HISTORY_MODIFIED"));
    }

    private boolean isDeleted(String type) {
        return type.equals(Resource.get("COMMIT_HISTORY_DELETED"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<String, String> getDifference(SVNDiffClient diff, SVNURL svnurl, long revision) throws SVNException, IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        diff.doDiff(svnurl, SVNRevision.create((long)(revision - 1L)), svnurl, SVNRevision.create((long)revision), SVNDepth.EMPTY, true, (OutputStream)output);
        BufferedReader reader = new BufferedReader(new StringReader(output.toString()));
        int addL = 0;
        int delL = 0;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("+ ")) {
                    ++addL;
                    continue;
                }
                if (!line.startsWith("- ")) continue;
                ++delL;
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return new Pair((Object)Integer.toString(addL), (Object)Integer.toString(delL));
    }

    private static class PropertiesTableModel
    extends CommonTableModel {
        private List<Pair<String, String>> _props = new ArrayList<Pair<String, String>>();

        PropertiesTableModel(DisplayProperty[] prop) {
            super(prop);
        }

        public int getRowCount() {
            if (this._props == null) {
                return 0;
            }
            return this._props.size();
        }

        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return this._props.get(row).getFirst();
            }
            if (col == 1) {
                return this._props.get(row).getSecond();
            }
            return null;
        }

        private void addRows(List<Pair<String, String>> data) {
            if (this._props == null) {
                this._props = Collections.synchronizedList(new ArrayList());
            } else {
                if (this._props.size() > 0) {
                    this.fireTableRowsDeleted(0, this._props.size() - 1);
                }
                this._props.clear();
            }
            this._props.addAll(data);
            if (data.size() > 0) {
                this.fireTableRowsInserted(0, data.size() - 1);
            }
        }
    }

    private static class SVNHistoryTableRenderer
    extends DefaultTableCellRenderer {
        private static DateFormat format = DateFormat.getDateTimeInstance();

        private SVNHistoryTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Date) {
                this.setText(format.format((Date)value));
            }
            return this;
        }
    }
}

