/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.model.generated.server;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import oracle.dmt.dataminer.core.model.generated.server.DbmsDataMiningTransformEx;
import oracle.dmt.dataminer.core.model.generated.server.OdmrBinDefinitions;
import oracle.dmt.dataminer.core.model.generated.server.OdmrObjectIds;
import oracle.dmt.dataminer.core.model.generated.server.OdmrObjectNames;
import oracle.dmt.dataminer.core.model.generated.server.OdmrRecodeDefinitions;
import oracle.dmt.dataminer.core.model.generated.server.OdmrTransformSettings;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.CLOB;
import oracle.sql.ORAData;

public class ODMRPkg_Transform {
    protected Connection __onn = null;
    protected DataSource __dataSource = null;

    public void setDataSource(DataSource dataSource) throws SQLException {
        this.release();
        this.__dataSource = dataSource;
    }

    public void setDataSourceLocation(String string) throws SQLException {
        try {
            Class<?> clazz = Class.forName("javax.naming.InitialContext");
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("lookup", String.class);
            DataSource dataSource = (DataSource)method.invoke(obj, "java:comp/env/" + string);
            this.setDataSource(dataSource);
        }
        catch (Exception exception) {
            throw new SQLException("Error initializing DataSource at " + string + ": " + exception.getMessage());
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.__onn != null) {
            return this.__onn;
        }
        if (this.__dataSource != null) {
            this.__onn = this.__dataSource.getConnection();
        }
        return this.__onn;
    }

    public void release() throws SQLException {
        this.__onn = null;
        this.__dataSource = null;
    }

    public void closeConnection() {
        if (this.__dataSource != null) {
            try {
                if (this.__onn != null) {
                    this.__onn.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.__onn = null;
        }
    }

    public void setConnection(Connection connection) throws SQLException {
        this.__onn = connection;
    }

    public ODMRPkg_Transform() throws SQLException {
    }

    public ODMRPkg_Transform(Connection connection) throws SQLException {
        this.__onn = connection;
    }

    public ODMRPkg_Transform(DataSource dataSource) throws SQLException {
        this.__dataSource = dataSource;
    }

    public OdmrObjectIds binQuantile(BigDecimal bigDecimal, OdmrObjectIds odmrObjectIds, BigDecimal bigDecimal2, String string) throws SQLException {
        Connection connection = null;
        OdmrObjectIds odmrObjectIds2 = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.BIN_QUANTILE(:2 ,:3 ,:4 ,:5 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (odmrObjectIds == null) {
                oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            } else {
                oracleCallableStatement.setORAData(3, (ORAData)odmrObjectIds);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(4, 2);
            } else {
                oracleCallableStatement.setBigDecimal(4, bigDecimal2);
            }
            if (string == null) {
                oracleCallableStatement.setNull(5, 1);
            } else {
                oracleCallableStatement.setString(5, string);
            }
            oracleCallableStatement.executeUpdate();
            odmrObjectIds2 = (OdmrObjectIds)oracleCallableStatement.getORAData(1, OdmrObjectIds.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.BIN_QUANTILE(:2 ,:3 ,:4 ,:5 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (odmrObjectIds == null) {
                    oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                } else {
                    oracleCallableStatement.setORAData(3, (ORAData)odmrObjectIds);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(4, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(4, bigDecimal2);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(5, 1);
                } else {
                    oracleCallableStatement.setString(5, string);
                }
                oracleCallableStatement.executeUpdate();
                odmrObjectIds2 = (OdmrObjectIds)oracleCallableStatement.getORAData(1, OdmrObjectIds.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return odmrObjectIds2;
    }

    public void buildSqlTreeXform(BigDecimal bigDecimal, DbmsDataMiningTransformEx[] dbmsDataMiningTransformExArray, boolean bl) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN JPUB_PLSQL_WRAPPER.ODMR_TRANSFORM$BUILD_SQL_TREE(:1 ,:2 ,:3 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            oracleCallableStatement.registerOutParameter(2, 2002, "SYS.DBMS_DATA_MINING_TRANSFORM_EX");
            if (dbmsDataMiningTransformExArray[0] == null) {
                oracleCallableStatement.setNull(2, 2002, "SYS.DBMS_DATA_MINING_TRANSFORM_EX");
            } else {
                oracleCallableStatement.setORAData(2, (ORAData)dbmsDataMiningTransformExArray[0]);
            }
            oracleCallableStatement.setBoolean(3, bl);
            oracleCallableStatement.executeUpdate();
            dbmsDataMiningTransformExArray[0] = (DbmsDataMiningTransformEx)oracleCallableStatement.getORAData(2, DbmsDataMiningTransformEx.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN JPUB_PLSQL_WRAPPER.ODMR_TRANSFORM$BUILD_SQL_TREE(:1 ,:2 ,:3 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                oracleCallableStatement.registerOutParameter(2, 2002, "SYS.DBMS_DATA_MINING_TRANSFORM_EX");
                if (dbmsDataMiningTransformExArray[0] == null) {
                    oracleCallableStatement.setNull(2, 2002, "SYS.DBMS_DATA_MINING_TRANSFORM_EX");
                } else {
                    oracleCallableStatement.setORAData(2, (ORAData)dbmsDataMiningTransformExArray[0]);
                }
                oracleCallableStatement.setBoolean(3, bl);
                oracleCallableStatement.executeUpdate();
                dbmsDataMiningTransformExArray[0] = (DbmsDataMiningTransformEx)oracleCallableStatement.getORAData(2, DbmsDataMiningTransformEx.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void transformationRefresh(BigDecimal bigDecimal, OdmrObjectIds odmrObjectIds) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_TRANSFORM.TRANSFORMATION_REFRESH(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (odmrObjectIds == null) {
                oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            } else {
                oracleCallableStatement.setORAData(2, (ORAData)odmrObjectIds);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_TRANSFORM.TRANSFORMATION_REFRESH(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (odmrObjectIds == null) {
                    oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                } else {
                    oracleCallableStatement.setORAData(2, (ORAData)odmrObjectIds);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public String bufferToStr(DbmsDataMiningTransformEx[] dbmsDataMiningTransformExArray) throws SQLException {
        Connection connection = null;
        String string = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := JPUB_PLSQL_WRAPPER.ODMR_TRANSFORM$BUFFER_TO_STR(:2 ); END;");
            oracleCallableStatement.registerOutParameter(1, 12);
            oracleCallableStatement.registerOutParameter(2, 2002, "SYS.DBMS_DATA_MINING_TRANSFORM_EX");
            if (dbmsDataMiningTransformExArray[0] == null) {
                oracleCallableStatement.setNull(2, 2002, "SYS.DBMS_DATA_MINING_TRANSFORM_EX");
            } else {
                oracleCallableStatement.setORAData(2, (ORAData)dbmsDataMiningTransformExArray[0]);
            }
            oracleCallableStatement.executeUpdate();
            string = oracleCallableStatement.getString(1);
            dbmsDataMiningTransformExArray[0] = (DbmsDataMiningTransformEx)oracleCallableStatement.getORAData(2, DbmsDataMiningTransformEx.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := JPUB_PLSQL_WRAPPER.ODMR_TRANSFORM$BUFFER_TO_STR(:2 ); END;");
                oracleCallableStatement.registerOutParameter(1, 12);
                oracleCallableStatement.registerOutParameter(2, 2002, "SYS.DBMS_DATA_MINING_TRANSFORM_EX");
                if (dbmsDataMiningTransformExArray[0] == null) {
                    oracleCallableStatement.setNull(2, 2002, "SYS.DBMS_DATA_MINING_TRANSFORM_EX");
                } else {
                    oracleCallableStatement.setORAData(2, (ORAData)dbmsDataMiningTransformExArray[0]);
                }
                oracleCallableStatement.executeUpdate();
                string = oracleCallableStatement.getString(1);
                dbmsDataMiningTransformExArray[0] = (DbmsDataMiningTransformEx)oracleCallableStatement.getORAData(2, DbmsDataMiningTransformEx.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return string;
    }

    public OdmrObjectIds numericFunction(BigDecimal bigDecimal, BigDecimal bigDecimal2, String string, OdmrTransformSettings odmrTransformSettings) throws SQLException {
        Connection connection = null;
        OdmrObjectIds odmrObjectIds = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.NUMERIC_FUNCTION(:2 ,:3 ,:4 ,:5 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(3, 2);
            } else {
                oracleCallableStatement.setBigDecimal(3, bigDecimal2);
            }
            if (string == null) {
                oracleCallableStatement.setNull(4, 12);
            } else {
                oracleCallableStatement.setString(4, string);
            }
            if (odmrTransformSettings == null) {
                oracleCallableStatement.setNull(5, 2003, "ODMRSYS.ODMR_TRANSFORM_SETTINGS");
            } else {
                oracleCallableStatement.setORAData(5, (ORAData)odmrTransformSettings);
            }
            oracleCallableStatement.executeUpdate();
            odmrObjectIds = (OdmrObjectIds)oracleCallableStatement.getORAData(1, OdmrObjectIds.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.NUMERIC_FUNCTION(:2 ,:3 ,:4 ,:5 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(3, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(3, bigDecimal2);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(4, 12);
                } else {
                    oracleCallableStatement.setString(4, string);
                }
                if (odmrTransformSettings == null) {
                    oracleCallableStatement.setNull(5, 2003, "ODMRSYS.ODMR_TRANSFORM_SETTINGS");
                } else {
                    oracleCallableStatement.setORAData(5, (ORAData)odmrTransformSettings);
                }
                oracleCallableStatement.executeUpdate();
                odmrObjectIds = (OdmrObjectIds)oracleCallableStatement.getORAData(1, OdmrObjectIds.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return odmrObjectIds;
    }

    public OdmrObjectIds binEqualWidth(BigDecimal bigDecimal, OdmrObjectIds odmrObjectIds, BigDecimal bigDecimal2, String string, Integer n) throws SQLException {
        Connection connection = null;
        OdmrObjectIds odmrObjectIds2 = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.BIN_EQUAL_WIDTH(:2 ,:3 ,:4 ,:5 ,:6 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (odmrObjectIds == null) {
                oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            } else {
                oracleCallableStatement.setORAData(3, (ORAData)odmrObjectIds);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(4, 2);
            } else {
                oracleCallableStatement.setBigDecimal(4, bigDecimal2);
            }
            if (string == null) {
                oracleCallableStatement.setNull(5, 1);
            } else {
                oracleCallableStatement.setString(5, string);
            }
            if (n == null) {
                oracleCallableStatement.setNull(6, 4);
            } else {
                oracleCallableStatement.setInt(6, n.intValue());
            }
            oracleCallableStatement.executeUpdate();
            odmrObjectIds2 = (OdmrObjectIds)oracleCallableStatement.getORAData(1, OdmrObjectIds.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.BIN_EQUAL_WIDTH(:2 ,:3 ,:4 ,:5 ,:6 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (odmrObjectIds == null) {
                    oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                } else {
                    oracleCallableStatement.setORAData(3, (ORAData)odmrObjectIds);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(4, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(4, bigDecimal2);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(5, 1);
                } else {
                    oracleCallableStatement.setString(5, string);
                }
                if (n == null) {
                    oracleCallableStatement.setNull(6, 4);
                } else {
                    oracleCallableStatement.setInt(6, n.intValue());
                }
                oracleCallableStatement.executeUpdate();
                odmrObjectIds2 = (OdmrObjectIds)oracleCallableStatement.getORAData(1, OdmrObjectIds.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return odmrObjectIds2;
    }

    public void buildSqlTree(BigDecimal bigDecimal, DbmsDataMiningTransformEx[] dbmsDataMiningTransformExArray, boolean bl) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN JPUB_PLSQL_WRAPPER.ODMR_TRANSFORM$BUILD_SQL_TR$1(:1 ,:2 ,:3 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            oracleCallableStatement.registerOutParameter(2, 2002, "SYS.DBMS_DATA_MINING_TRANSFORM_EX");
            if (dbmsDataMiningTransformExArray[0] == null) {
                oracleCallableStatement.setNull(2, 2002, "SYS.DBMS_DATA_MINING_TRANSFORM_EX");
            } else {
                oracleCallableStatement.setORAData(2, (ORAData)dbmsDataMiningTransformExArray[0]);
            }
            oracleCallableStatement.setBoolean(3, bl);
            oracleCallableStatement.executeUpdate();
            dbmsDataMiningTransformExArray[0] = (DbmsDataMiningTransformEx)oracleCallableStatement.getORAData(2, DbmsDataMiningTransformEx.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN JPUB_PLSQL_WRAPPER.ODMR_TRANSFORM$BUILD_SQL_TR$1(:1 ,:2 ,:3 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                oracleCallableStatement.registerOutParameter(2, 2002, "SYS.DBMS_DATA_MINING_TRANSFORM_EX");
                if (dbmsDataMiningTransformExArray[0] == null) {
                    oracleCallableStatement.setNull(2, 2002, "SYS.DBMS_DATA_MINING_TRANSFORM_EX");
                } else {
                    oracleCallableStatement.setORAData(2, (ORAData)dbmsDataMiningTransformExArray[0]);
                }
                oracleCallableStatement.setBoolean(3, bl);
                oracleCallableStatement.executeUpdate();
                dbmsDataMiningTransformExArray[0] = (DbmsDataMiningTransformEx)oracleCallableStatement.getORAData(2, DbmsDataMiningTransformEx.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void printResults() throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_TRANSFORM.PRINT_RESULTS(); END;");
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_TRANSFORM.PRINT_RESULTS(); END;");
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public OdmrObjectIds normalize(BigDecimal bigDecimal, OdmrObjectIds odmrObjectIds, String string, Integer n) throws SQLException {
        Connection connection = null;
        OdmrObjectIds odmrObjectIds2 = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.NORMALIZE(:2 ,:3 ,:4 ,:5 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (odmrObjectIds == null) {
                oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            } else {
                oracleCallableStatement.setORAData(3, (ORAData)odmrObjectIds);
            }
            if (string == null) {
                oracleCallableStatement.setNull(4, 12);
            } else {
                oracleCallableStatement.setString(4, string);
            }
            if (n == null) {
                oracleCallableStatement.setNull(5, 4);
            } else {
                oracleCallableStatement.setInt(5, n.intValue());
            }
            oracleCallableStatement.executeUpdate();
            odmrObjectIds2 = (OdmrObjectIds)oracleCallableStatement.getORAData(1, OdmrObjectIds.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.NORMALIZE(:2 ,:3 ,:4 ,:5 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (odmrObjectIds == null) {
                    oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                } else {
                    oracleCallableStatement.setORAData(3, (ORAData)odmrObjectIds);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(4, 12);
                } else {
                    oracleCallableStatement.setString(4, string);
                }
                if (n == null) {
                    oracleCallableStatement.setNull(5, 4);
                } else {
                    oracleCallableStatement.setInt(5, n.intValue());
                }
                oracleCallableStatement.executeUpdate();
                odmrObjectIds2 = (OdmrObjectIds)oracleCallableStatement.getORAData(1, OdmrObjectIds.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return odmrObjectIds2;
    }

    public void clearBuffer(DbmsDataMiningTransformEx[] dbmsDataMiningTransformExArray) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN JPUB_PLSQL_WRAPPER.ODMR_TRANSFORM$CLEAR_BUFFER(:1 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2002, "SYS.DBMS_DATA_MINING_TRANSFORM_EX");
            if (dbmsDataMiningTransformExArray[0] == null) {
                oracleCallableStatement.setNull(1, 2002, "SYS.DBMS_DATA_MINING_TRANSFORM_EX");
            } else {
                oracleCallableStatement.setORAData(1, (ORAData)dbmsDataMiningTransformExArray[0]);
            }
            oracleCallableStatement.executeUpdate();
            dbmsDataMiningTransformExArray[0] = (DbmsDataMiningTransformEx)oracleCallableStatement.getORAData(1, DbmsDataMiningTransformEx.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN JPUB_PLSQL_WRAPPER.ODMR_TRANSFORM$CLEAR_BUFFER(:1 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2002, "SYS.DBMS_DATA_MINING_TRANSFORM_EX");
                if (dbmsDataMiningTransformExArray[0] == null) {
                    oracleCallableStatement.setNull(1, 2002, "SYS.DBMS_DATA_MINING_TRANSFORM_EX");
                } else {
                    oracleCallableStatement.setORAData(1, (ORAData)dbmsDataMiningTransformExArray[0]);
                }
                oracleCallableStatement.executeUpdate();
                dbmsDataMiningTransformExArray[0] = (DbmsDataMiningTransformEx)oracleCallableStatement.getORAData(1, DbmsDataMiningTransformEx.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void createCache(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, BigDecimal bigDecimal4) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_TRANSFORM.CREATE_CACHE(:1 ,:2 ,:3 ,:4 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal2);
            }
            if (bigDecimal3 == null) {
                oracleCallableStatement.setNull(3, 2);
            } else {
                oracleCallableStatement.setBigDecimal(3, bigDecimal3);
            }
            if (bigDecimal4 == null) {
                oracleCallableStatement.setNull(4, 2);
            } else {
                oracleCallableStatement.setBigDecimal(4, bigDecimal4);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_TRANSFORM.CREATE_CACHE(:1 ,:2 ,:3 ,:4 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal2);
                }
                if (bigDecimal3 == null) {
                    oracleCallableStatement.setNull(3, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(3, bigDecimal3);
                }
                if (bigDecimal4 == null) {
                    oracleCallableStatement.setNull(4, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(4, bigDecimal4);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void copyTransformation(BigDecimal bigDecimal, BigDecimal bigDecimal2, OdmrObjectIds odmrObjectIds) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_TRANSFORM.COPY_TRANSFORMATION(:1 ,:2 ,:3 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal2);
            }
            if (odmrObjectIds == null) {
                oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            } else {
                oracleCallableStatement.setORAData(3, (ORAData)odmrObjectIds);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_TRANSFORM.COPY_TRANSFORMATION(:1 ,:2 ,:3 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal2);
                }
                if (odmrObjectIds == null) {
                    oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                } else {
                    oracleCallableStatement.setORAData(3, (ORAData)odmrObjectIds);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public String createNestedTextTableSql(String string, String string2, String string3, String string4, BigDecimal bigDecimal, String string5) throws SQLException {
        Connection connection = null;
        String string6 = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.CREATE_NESTED_TEXT_TABLE_SQL(:2 ,:3 ,:4 ,:5 ,:6 ,:7 ); END;");
            oracleCallableStatement.registerOutParameter(1, 12);
            if (string == null) {
                oracleCallableStatement.setNull(2, 12);
            } else {
                oracleCallableStatement.setString(2, string);
            }
            if (string2 == null) {
                oracleCallableStatement.setNull(3, 12);
            } else {
                oracleCallableStatement.setString(3, string2);
            }
            if (string3 == null) {
                oracleCallableStatement.setNull(4, 12);
            } else {
                oracleCallableStatement.setString(4, string3);
            }
            if (string4 == null) {
                oracleCallableStatement.setNull(5, 12);
            } else {
                oracleCallableStatement.setString(5, string4);
            }
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(6, 2);
            } else {
                oracleCallableStatement.setBigDecimal(6, bigDecimal);
            }
            if (string5 == null) {
                oracleCallableStatement.setNull(7, 12);
            } else {
                oracleCallableStatement.setString(7, string5);
            }
            oracleCallableStatement.executeUpdate();
            string6 = oracleCallableStatement.getString(1);
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.CREATE_NESTED_TEXT_TABLE_SQL(:2 ,:3 ,:4 ,:5 ,:6 ,:7 ); END;");
                oracleCallableStatement.registerOutParameter(1, 12);
                if (string == null) {
                    oracleCallableStatement.setNull(2, 12);
                } else {
                    oracleCallableStatement.setString(2, string);
                }
                if (string2 == null) {
                    oracleCallableStatement.setNull(3, 12);
                } else {
                    oracleCallableStatement.setString(3, string2);
                }
                if (string3 == null) {
                    oracleCallableStatement.setNull(4, 12);
                } else {
                    oracleCallableStatement.setString(4, string3);
                }
                if (string4 == null) {
                    oracleCallableStatement.setNull(5, 12);
                } else {
                    oracleCallableStatement.setString(5, string4);
                }
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(6, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(6, bigDecimal);
                }
                if (string5 == null) {
                    oracleCallableStatement.setNull(7, 12);
                } else {
                    oracleCallableStatement.setString(7, string5);
                }
                oracleCallableStatement.executeUpdate();
                string6 = oracleCallableStatement.getString(1);
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return string6;
    }

    public void executeTextTransfrom(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, String string) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_TRANSFORM.EXECUTE_TEXT_TRANSFROM(:1 ,:2 ,:3 ,:4 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal2);
            }
            if (bigDecimal3 == null) {
                oracleCallableStatement.setNull(3, 2);
            } else {
                oracleCallableStatement.setBigDecimal(3, bigDecimal3);
            }
            if (string == null) {
                oracleCallableStatement.setNull(4, 12);
            } else {
                oracleCallableStatement.setString(4, string);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_TRANSFORM.EXECUTE_TEXT_TRANSFROM(:1 ,:2 ,:3 ,:4 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal2);
                }
                if (bigDecimal3 == null) {
                    oracleCallableStatement.setNull(3, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(3, bigDecimal3);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(4, 12);
                } else {
                    oracleCallableStatement.setString(4, string);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void clearCache(BigDecimal bigDecimal, OdmrObjectNames[] odmrObjectNamesArray) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_TRANSFORM.CLEAR_CACHE(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            oracleCallableStatement.registerOutParameter(2, 2003, "ODMRSYS.ODMR_OBJECT_NAMES");
            if (odmrObjectNamesArray[0] == null) {
                oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_OBJECT_NAMES");
            } else {
                oracleCallableStatement.setORAData(2, (ORAData)odmrObjectNamesArray[0]);
            }
            oracleCallableStatement.executeUpdate();
            odmrObjectNamesArray[0] = (OdmrObjectNames)oracleCallableStatement.getORAData(2, OdmrObjectNames.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_TRANSFORM.CLEAR_CACHE(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                oracleCallableStatement.registerOutParameter(2, 2003, "ODMRSYS.ODMR_OBJECT_NAMES");
                if (odmrObjectNamesArray[0] == null) {
                    oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_OBJECT_NAMES");
                } else {
                    oracleCallableStatement.setORAData(2, (ORAData)odmrObjectNamesArray[0]);
                }
                oracleCallableStatement.executeUpdate();
                odmrObjectNamesArray[0] = (OdmrObjectNames)oracleCallableStatement.getORAData(2, OdmrObjectNames.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public BigDecimal binCustom(BigDecimal bigDecimal, BigDecimal bigDecimal2, OdmrBinDefinitions odmrBinDefinitions) throws SQLException {
        Connection connection = null;
        BigDecimal bigDecimal3 = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.BIN_CUSTOM(:2 ,:3 ,:4 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2);
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(3, 2);
            } else {
                oracleCallableStatement.setBigDecimal(3, bigDecimal2);
            }
            if (odmrBinDefinitions == null) {
                oracleCallableStatement.setNull(4, 2003, "ODMRSYS.ODMR_BIN_DEFINITIONS");
            } else {
                oracleCallableStatement.setORAData(4, (ORAData)odmrBinDefinitions);
            }
            oracleCallableStatement.executeUpdate();
            bigDecimal3 = oracleCallableStatement.getBigDecimal(1);
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.BIN_CUSTOM(:2 ,:3 ,:4 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2);
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(3, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(3, bigDecimal2);
                }
                if (odmrBinDefinitions == null) {
                    oracleCallableStatement.setNull(4, 2003, "ODMRSYS.ODMR_BIN_DEFINITIONS");
                } else {
                    oracleCallableStatement.setORAData(4, (ORAData)odmrBinDefinitions);
                }
                oracleCallableStatement.executeUpdate();
                bigDecimal3 = oracleCallableStatement.getBigDecimal(1);
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return bigDecimal3;
    }

    public BigDecimal recode(BigDecimal bigDecimal, BigDecimal bigDecimal2, OdmrRecodeDefinitions odmrRecodeDefinitions) throws SQLException {
        Connection connection = null;
        BigDecimal bigDecimal3 = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.RECODE(:2 ,:3 ,:4 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2);
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(3, 2);
            } else {
                oracleCallableStatement.setBigDecimal(3, bigDecimal2);
            }
            if (odmrRecodeDefinitions == null) {
                oracleCallableStatement.setNull(4, 2003, "ODMRSYS.ODMR_RECODE_DEFINITIONS");
            } else {
                oracleCallableStatement.setORAData(4, (ORAData)odmrRecodeDefinitions);
            }
            oracleCallableStatement.executeUpdate();
            bigDecimal3 = oracleCallableStatement.getBigDecimal(1);
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.RECODE(:2 ,:3 ,:4 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2);
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(3, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(3, bigDecimal2);
                }
                if (odmrRecodeDefinitions == null) {
                    oracleCallableStatement.setNull(4, 2003, "ODMRSYS.ODMR_RECODE_DEFINITIONS");
                } else {
                    oracleCallableStatement.setORAData(4, (ORAData)odmrRecodeDefinitions);
                }
                oracleCallableStatement.executeUpdate();
                bigDecimal3 = oracleCallableStatement.getBigDecimal(1);
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return bigDecimal3;
    }

    public OdmrObjectIds missingValuesNumerical(BigDecimal bigDecimal, OdmrObjectIds odmrObjectIds, Integer n, BigDecimal bigDecimal2, Integer n2) throws SQLException {
        Connection connection = null;
        OdmrObjectIds odmrObjectIds2 = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.MISSING_VALUES_NUMERICAL(:2 ,:3 ,:4 ,:5 ,:6 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (odmrObjectIds == null) {
                oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            } else {
                oracleCallableStatement.setORAData(3, (ORAData)odmrObjectIds);
            }
            if (n == null) {
                oracleCallableStatement.setNull(4, 4);
            } else {
                oracleCallableStatement.setInt(4, n.intValue());
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(5, 2);
            } else {
                oracleCallableStatement.setBigDecimal(5, bigDecimal2);
            }
            if (n2 == null) {
                oracleCallableStatement.setNull(6, 4);
            } else {
                oracleCallableStatement.setInt(6, n2.intValue());
            }
            oracleCallableStatement.executeUpdate();
            odmrObjectIds2 = (OdmrObjectIds)oracleCallableStatement.getORAData(1, OdmrObjectIds.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.MISSING_VALUES_NUMERICAL(:2 ,:3 ,:4 ,:5 ,:6 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (odmrObjectIds == null) {
                    oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                } else {
                    oracleCallableStatement.setORAData(3, (ORAData)odmrObjectIds);
                }
                if (n == null) {
                    oracleCallableStatement.setNull(4, 4);
                } else {
                    oracleCallableStatement.setInt(4, n.intValue());
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(5, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(5, bigDecimal2);
                }
                if (n2 == null) {
                    oracleCallableStatement.setNull(6, 4);
                } else {
                    oracleCallableStatement.setInt(6, n2.intValue());
                }
                oracleCallableStatement.executeUpdate();
                odmrObjectIds2 = (OdmrObjectIds)oracleCallableStatement.getORAData(1, OdmrObjectIds.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return odmrObjectIds2;
    }

    public CLOB xformExp(DbmsDataMiningTransformEx dbmsDataMiningTransformEx) throws SQLException {
        Connection connection = null;
        CLOB cLOB = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.XFORM_EXP(JPUB_PLSQL_WRAPPER.SQL_TO_PL0(:2 )); END;");
            oracleCallableStatement.registerOutParameter(1, 2005);
            if (dbmsDataMiningTransformEx == null) {
                oracleCallableStatement.setNull(2, 2002, "SYS.DBMS_DATA_MINING_TRANSFORM_EX");
            } else {
                oracleCallableStatement.setORAData(2, (ORAData)dbmsDataMiningTransformEx);
            }
            oracleCallableStatement.executeUpdate();
            cLOB = oracleCallableStatement.getCLOB(1);
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.XFORM_EXP(JPUB_PLSQL_WRAPPER.SQL_TO_PL0(:2 )); END;");
                oracleCallableStatement.registerOutParameter(1, 2005);
                if (dbmsDataMiningTransformEx == null) {
                    oracleCallableStatement.setNull(2, 2002, "SYS.DBMS_DATA_MINING_TRANSFORM_EX");
                } else {
                    oracleCallableStatement.setORAData(2, (ORAData)dbmsDataMiningTransformEx);
                }
                oracleCallableStatement.executeUpdate();
                cLOB = oracleCallableStatement.getCLOB(1);
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return cLOB;
    }

    public BigDecimal textFeatures(BigDecimal bigDecimal, BigDecimal bigDecimal2, OdmrTransformSettings odmrTransformSettings, String string) throws SQLException {
        Connection connection = null;
        BigDecimal bigDecimal3 = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.TEXT_FEATURES(:2 ,:3 ,:4 ,:5 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2);
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(3, 2);
            } else {
                oracleCallableStatement.setBigDecimal(3, bigDecimal2);
            }
            if (odmrTransformSettings == null) {
                oracleCallableStatement.setNull(4, 2003, "ODMRSYS.ODMR_TRANSFORM_SETTINGS");
            } else {
                oracleCallableStatement.setORAData(4, (ORAData)odmrTransformSettings);
            }
            if (string == null) {
                oracleCallableStatement.setNull(5, 12);
            } else {
                oracleCallableStatement.setString(5, string);
            }
            oracleCallableStatement.executeUpdate();
            bigDecimal3 = oracleCallableStatement.getBigDecimal(1);
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.TEXT_FEATURES(:2 ,:3 ,:4 ,:5 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2);
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(3, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(3, bigDecimal2);
                }
                if (odmrTransformSettings == null) {
                    oracleCallableStatement.setNull(4, 2003, "ODMRSYS.ODMR_TRANSFORM_SETTINGS");
                } else {
                    oracleCallableStatement.setORAData(4, (ORAData)odmrTransformSettings);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(5, 12);
                } else {
                    oracleCallableStatement.setString(5, string);
                }
                oracleCallableStatement.executeUpdate();
                bigDecimal3 = oracleCallableStatement.getBigDecimal(1);
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return bigDecimal3;
    }

    public OdmrObjectIds missingValuesCategorical(BigDecimal bigDecimal, OdmrObjectIds odmrObjectIds, Integer n, String string) throws SQLException {
        Connection connection = null;
        OdmrObjectIds odmrObjectIds2 = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.MISSING_VALUES_CATEGORICAL(:2 ,:3 ,:4 ,:5 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (odmrObjectIds == null) {
                oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            } else {
                oracleCallableStatement.setORAData(3, (ORAData)odmrObjectIds);
            }
            if (n == null) {
                oracleCallableStatement.setNull(4, 4);
            } else {
                oracleCallableStatement.setInt(4, n.intValue());
            }
            if (string == null) {
                oracleCallableStatement.setNull(5, 12);
            } else {
                oracleCallableStatement.setString(5, string);
            }
            oracleCallableStatement.executeUpdate();
            odmrObjectIds2 = (OdmrObjectIds)oracleCallableStatement.getORAData(1, OdmrObjectIds.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.MISSING_VALUES_CATEGORICAL(:2 ,:3 ,:4 ,:5 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (odmrObjectIds == null) {
                    oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                } else {
                    oracleCallableStatement.setORAData(3, (ORAData)odmrObjectIds);
                }
                if (n == null) {
                    oracleCallableStatement.setNull(4, 4);
                } else {
                    oracleCallableStatement.setInt(4, n.intValue());
                }
                if (string == null) {
                    oracleCallableStatement.setNull(5, 12);
                } else {
                    oracleCallableStatement.setString(5, string);
                }
                oracleCallableStatement.executeUpdate();
                odmrObjectIds2 = (OdmrObjectIds)oracleCallableStatement.getORAData(1, OdmrObjectIds.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return odmrObjectIds2;
    }

    public OdmrObjectIds outlier(BigDecimal bigDecimal, OdmrObjectIds odmrObjectIds, String string, BigDecimal bigDecimal2) throws SQLException {
        Connection connection = null;
        OdmrObjectIds odmrObjectIds2 = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.OUTLIER(:2 ,:3 ,:4 ,:5 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (odmrObjectIds == null) {
                oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            } else {
                oracleCallableStatement.setORAData(3, (ORAData)odmrObjectIds);
            }
            if (string == null) {
                oracleCallableStatement.setNull(4, 12);
            } else {
                oracleCallableStatement.setString(4, string);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(5, 2);
            } else {
                oracleCallableStatement.setBigDecimal(5, bigDecimal2);
            }
            oracleCallableStatement.executeUpdate();
            odmrObjectIds2 = (OdmrObjectIds)oracleCallableStatement.getORAData(1, OdmrObjectIds.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.OUTLIER(:2 ,:3 ,:4 ,:5 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (odmrObjectIds == null) {
                    oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                } else {
                    oracleCallableStatement.setORAData(3, (ORAData)odmrObjectIds);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(4, 12);
                } else {
                    oracleCallableStatement.setString(4, string);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(5, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(5, bigDecimal2);
                }
                oracleCallableStatement.executeUpdate();
                odmrObjectIds2 = (OdmrObjectIds)oracleCallableStatement.getORAData(1, OdmrObjectIds.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return odmrObjectIds2;
    }

    public BigDecimal persistTextSettings(BigDecimal bigDecimal, BigDecimal bigDecimal2, OdmrTransformSettings odmrTransformSettings) throws SQLException {
        Connection connection = null;
        BigDecimal bigDecimal3 = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.PERSIST_TEXT_SETTINGS(:2 ,:3 ,:4 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2);
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(3, 2);
            } else {
                oracleCallableStatement.setBigDecimal(3, bigDecimal2);
            }
            if (odmrTransformSettings == null) {
                oracleCallableStatement.setNull(4, 2003, "ODMRSYS.ODMR_TRANSFORM_SETTINGS");
            } else {
                oracleCallableStatement.setORAData(4, (ORAData)odmrTransformSettings);
            }
            oracleCallableStatement.executeUpdate();
            bigDecimal3 = oracleCallableStatement.getBigDecimal(1);
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.PERSIST_TEXT_SETTINGS(:2 ,:3 ,:4 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2);
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(3, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(3, bigDecimal2);
                }
                if (odmrTransformSettings == null) {
                    oracleCallableStatement.setNull(4, 2003, "ODMRSYS.ODMR_TRANSFORM_SETTINGS");
                } else {
                    oracleCallableStatement.setORAData(4, (ORAData)odmrTransformSettings);
                }
                oracleCallableStatement.executeUpdate();
                bigDecimal3 = oracleCallableStatement.getBigDecimal(1);
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return bigDecimal3;
    }

    public OdmrObjectIds binTopn(BigDecimal bigDecimal, OdmrObjectIds odmrObjectIds, Integer n, Integer n2, BigDecimal bigDecimal2) throws SQLException {
        Connection connection = null;
        OdmrObjectIds odmrObjectIds2 = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.BIN_TOPN(:2 ,:3 ,:4 ,:5 ,:6 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (odmrObjectIds == null) {
                oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            } else {
                oracleCallableStatement.setORAData(3, (ORAData)odmrObjectIds);
            }
            if (n == null) {
                oracleCallableStatement.setNull(4, 4);
            } else {
                oracleCallableStatement.setInt(4, n.intValue());
            }
            if (n2 == null) {
                oracleCallableStatement.setNull(5, 4);
            } else {
                oracleCallableStatement.setInt(5, n2.intValue());
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(6, 2);
            } else {
                oracleCallableStatement.setBigDecimal(6, bigDecimal2);
            }
            oracleCallableStatement.executeUpdate();
            odmrObjectIds2 = (OdmrObjectIds)oracleCallableStatement.getORAData(1, OdmrObjectIds.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.BIN_TOPN(:2 ,:3 ,:4 ,:5 ,:6 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (odmrObjectIds == null) {
                    oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                } else {
                    oracleCallableStatement.setORAData(3, (ORAData)odmrObjectIds);
                }
                if (n == null) {
                    oracleCallableStatement.setNull(4, 4);
                } else {
                    oracleCallableStatement.setInt(4, n.intValue());
                }
                if (n2 == null) {
                    oracleCallableStatement.setNull(5, 4);
                } else {
                    oracleCallableStatement.setInt(5, n2.intValue());
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(6, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(6, bigDecimal2);
                }
                oracleCallableStatement.executeUpdate();
                odmrObjectIds2 = (OdmrObjectIds)oracleCallableStatement.getORAData(1, OdmrObjectIds.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return odmrObjectIds2;
    }

    public OdmrObjectIds autobinEqualWidth(BigDecimal bigDecimal, OdmrObjectIds odmrObjectIds, Integer n, Integer n2, Integer n3) throws SQLException {
        Connection connection = null;
        OdmrObjectIds odmrObjectIds2 = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.AUTOBIN_EQUAL_WIDTH(:2 ,:3 ,:4 ,:5 ,:6 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (odmrObjectIds == null) {
                oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            } else {
                oracleCallableStatement.setORAData(3, (ORAData)odmrObjectIds);
            }
            if (n == null) {
                oracleCallableStatement.setNull(4, 4);
            } else {
                oracleCallableStatement.setInt(4, n.intValue());
            }
            if (n2 == null) {
                oracleCallableStatement.setNull(5, 4);
            } else {
                oracleCallableStatement.setInt(5, n2.intValue());
            }
            if (n3 == null) {
                oracleCallableStatement.setNull(6, 4);
            } else {
                oracleCallableStatement.setInt(6, n3.intValue());
            }
            oracleCallableStatement.executeUpdate();
            odmrObjectIds2 = (OdmrObjectIds)oracleCallableStatement.getORAData(1, OdmrObjectIds.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.AUTOBIN_EQUAL_WIDTH(:2 ,:3 ,:4 ,:5 ,:6 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (odmrObjectIds == null) {
                    oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                } else {
                    oracleCallableStatement.setORAData(3, (ORAData)odmrObjectIds);
                }
                if (n == null) {
                    oracleCallableStatement.setNull(4, 4);
                } else {
                    oracleCallableStatement.setInt(4, n.intValue());
                }
                if (n2 == null) {
                    oracleCallableStatement.setNull(5, 4);
                } else {
                    oracleCallableStatement.setInt(5, n2.intValue());
                }
                if (n3 == null) {
                    oracleCallableStatement.setNull(6, 4);
                } else {
                    oracleCallableStatement.setInt(6, n3.intValue());
                }
                oracleCallableStatement.executeUpdate();
                odmrObjectIds2 = (OdmrObjectIds)oracleCallableStatement.getORAData(1, OdmrObjectIds.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return odmrObjectIds2;
    }

    public BigDecimal computeField(String string, CLOB cLOB) throws SQLException {
        Connection connection = null;
        BigDecimal bigDecimal = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.COMPUTE_FIELD(:2 ,:3 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2);
            if (string == null) {
                oracleCallableStatement.setNull(2, 12);
            } else {
                oracleCallableStatement.setString(2, string);
            }
            if (cLOB == null) {
                oracleCallableStatement.setNull(3, 2005);
            } else {
                oracleCallableStatement.setCLOB(3, cLOB);
            }
            oracleCallableStatement.executeUpdate();
            bigDecimal = oracleCallableStatement.getBigDecimal(1);
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_TRANSFORM.COMPUTE_FIELD(:2 ,:3 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2);
                if (string == null) {
                    oracleCallableStatement.setNull(2, 12);
                } else {
                    oracleCallableStatement.setString(2, string);
                }
                if (cLOB == null) {
                    oracleCallableStatement.setNull(3, 2005);
                } else {
                    oracleCallableStatement.setCLOB(3, cLOB);
                }
                oracleCallableStatement.executeUpdate();
                bigDecimal = oracleCallableStatement.getBigDecimal(1);
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return bigDecimal;
    }

    public void printXformSettings() throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_TRANSFORM.PRINT_XFORM_SETTINGS(); END;");
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_TRANSFORM.PRINT_XFORM_SETTINGS(); END;");
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }
}

