/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.model.fe.svd;

import oracle.dmt.dataminer.core.model.common.build.AttributeCoefficient;
import oracle.dmt.dataminer.core.utils.ObjectUtils;

public class SVDCoefficient
extends AttributeCoefficient
implements Comparable<SVDCoefficient> {
    private Integer id;
    private Double singularValue;

    public SVDCoefficient(String string) {
        this(null, string, null, null);
    }

    public SVDCoefficient(Integer n, String string, Double d) {
        this(n, string, null, d);
    }

    public SVDCoefficient(Integer n, String string, String string2, Double d) {
        super(string, string2);
        this.id = n;
        this.singularValue = d;
    }

    public void setId(int n) {
        this.id = n;
    }

    public int getId() {
        return this.id;
    }

    public void setSingularValue(Double d) {
        this.singularValue = d;
        if (d != null) {
            super.setCoefficient(d);
        }
    }

    public Double getSingularValue() {
        return this.singularValue;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof SVDCoefficient) {
            SVDCoefficient sVDCoefficient = (SVDCoefficient)object;
            bl = ObjectUtils.areEqual(this.getAttributeName(), sVDCoefficient.getAttributeName()) && ObjectUtils.areEqual(this.getAttributeSubname(), sVDCoefficient.getAttributeSubname()) && ObjectUtils.areEqual(this.getSingularValue(), sVDCoefficient.getSingularValue());
        }
        return bl;
    }

    public int hashCode() {
        int n = 7;
        n += ObjectUtils.hashCode(this.getAttributeName());
        n += ObjectUtils.hashCode(this.getAttributeSubname());
        return n += ObjectUtils.hashCode(this.getSingularValue());
    }

    @Override
    public int compareTo(SVDCoefficient sVDCoefficient) {
        return this.getAttributeName().compareTo(sVDCoefficient.getAttributeName());
    }
}

