/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.model.fe.common;

import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Stream;
import oracle.dmt.dataminer.core.model.common.build.AttributeCoefficient;
import oracle.dmt.dataminer.core.model.common.build.Column;
import oracle.dmt.dataminer.core.model.common.build.ColumnFilter;
import oracle.dmt.dataminer.core.model.fe.common.Tag;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.workflow.xmlschema.ExplicitSemanticAnalysisModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NonNegativeMatrixFactorModelType;
import oracle.javatools.util.Version;

public class FeatureCoefficient
extends AttributeCoefficient
implements Tag {
    private boolean filtered;
    private String featureId;
    private String partitionName;

    public FeatureCoefficient() {
        this.initInstanceVariables();
    }

    public FeatureCoefficient(String string) {
        super(string);
        this.initInstanceVariables();
    }

    public FeatureCoefficient(String string, String string2, double d, boolean bl) {
        super(string, string2, d);
        this.filtered = bl;
    }

    private void initInstanceVariables() {
        this.featureId = "";
        this.partitionName = "";
        this.attributeValue = "";
    }

    @Override
    public String getAttributeName() {
        return StringUtils.isEmpty(this.attributeName) ? "" : this.attributeName;
    }

    @Override
    public String getAttributeSubname() {
        return StringUtils.isEmpty(this.attributeSubname) ? "" : this.attributeSubname;
    }

    public void setFeatureId(String string) {
        this.featureId = string;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public void setPartitionName(String string) {
        this.partitionName = string;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    @Override
    public String getSource() {
        return this.attributeName;
    }

    @Override
    public String getText() {
        if (StringUtils.isNotEmpty(this.attributeSubname)) {
            return this.attributeSubname;
        }
        if (StringUtils.isNotEmpty(this.attributeValue)) {
            return this.attributeValue;
        }
        if (StringUtils.isNotEmpty(this.attributeName)) {
            return this.attributeName;
        }
        assert (false) : "The coefficient has not enough data to be represented as a Tag.";
        return "";
    }

    @Override
    public double getWeight() {
        return this.coefficient;
    }

    @Override
    public boolean isFiltered() {
        return this.filtered;
    }

    @Override
    public void setFiltered(boolean bl) {
        this.filtered = bl;
    }

    public Predicate<ColumnFilter> getColumnFilterPredicate(Version version, Class<? extends ModelType> clazz) {
        Predicate<ColumnFilter> predicate = columnFilter -> {
            if (columnFilter.getTargetColumn() == null || columnFilter.getOperator() == null || columnFilter.getValue() == null || StringUtils.isEmpty(this.attributeSubname) && StringUtils.isEmpty(this.attributeValue)) {
                return false;
            }
            Column column = columnFilter.getTargetColumn();
            if (StringUtils.isEmpty(column.getColumnName()) || !column.getColumnName().equals(this.attributeName)) {
                return false;
            }
            if (ColumnFilter.Operator.EXIST.equals((Object)columnFilter.getOperator())) {
                return StringUtils.isNotEmpty(this.attributeValue);
            }
            Stream<String> stream = Arrays.stream(columnFilter.getValue().split(";")).filter(StringUtils::isNotEmpty);
            String string = DbVersionHelper.isDB122Up(version) ? (ExplicitSemanticAnalysisModelType.class.equals((Object)clazz) ? this.attributeSubname : this.attributeValue) : (NonNegativeMatrixFactorModelType.class.equals((Object)clazz) ? this.attributeValue : this.attributeSubname);
            return stream.anyMatch(string2 -> {
                switch (columnFilter.getOperator()) {
                    case STARTS: {
                        return string.toUpperCase().startsWith(string2.toUpperCase());
                    }
                    case CONTAINS: {
                        return string.toUpperCase().contains(string2.toUpperCase());
                    }
                    case EQUALS: {
                        return string.equals(string2);
                    }
                }
                assert (false) : "Operator Not Supported.";
                return false;
            });
        };
        return predicate;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FeatureCoefficient)) {
            return false;
        }
        FeatureCoefficient featureCoefficient = (FeatureCoefficient)object;
        return Double.compare(this.coefficient, featureCoefficient.getCoefficient()) == 0 && this.attributeValue.equals(featureCoefficient.getAttributeValue()) && this.attributeSubname.equals(featureCoefficient.getAttributeSubname()) && this.attributeName.equals(featureCoefficient.getAttributeName());
    }

    public int hashCode() {
        return StringUtils.isEmpty(this.attributeSubname) ? this.attributeName.hashCode() ^ this.attributeValue.hashCode() ^ Double.valueOf(this.coefficient).hashCode() : StringUtils.join(".", this.attributeName, this.attributeSubname).hashCode() ^ this.attributeValue.hashCode() ^ Double.valueOf(this.coefficient).hashCode();
    }
}

