/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.model.ar;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.model.ar.RuleContentOption;
import oracle.dmt.dataminer.core.model.generated.server.DmItem;
import oracle.dmt.dataminer.core.model.generated.server.DmItems;
import oracle.dmt.dataminer.core.model.generated.server.DmPredicate;
import oracle.dmt.dataminer.core.model.generated.server.DmPredicates;
import oracle.dmt.dataminer.core.utils.format.NumericFormat;

public class Item {
    private String attributeName;
    private String attributeSubname;
    private Double attributeNumValue;
    private String attributeStrValue;
    private Map<String, Double> aggregates;
    private Map<String, Double> aggregatesAvg;
    private List<String> aggregateNames;

    public Item() {
        this("", "", 0.0, "");
    }

    public Item(String string, String string2, Double d, String string3) {
        this.attributeName = string;
        this.attributeSubname = string2;
        this.attributeNumValue = d;
        this.attributeStrValue = string3;
        this.initAggregateVariables();
    }

    public Item(DmItem dmItem) throws SQLException {
        this.attributeName = dmItem.getAttributeName();
        this.attributeSubname = dmItem.getAttributeSubname();
        if (dmItem.getAttributeNumValue() != null) {
            this.attributeNumValue = dmItem.getAttributeNumValue().doubleValue();
        }
        this.attributeStrValue = dmItem.getAttributeStrValue();
        this.initAggregateVariables();
    }

    public Item(DmPredicate dmPredicate) throws SQLException {
        this.attributeName = dmPredicate.getAttributeName();
        this.attributeSubname = dmPredicate.getAttributeSubname();
        if (dmPredicate.getAttributeNumValue() != null) {
            this.attributeNumValue = dmPredicate.getAttributeNumValue().doubleValue();
        }
        this.attributeStrValue = dmPredicate.getAttributeStrValue();
        this.initAggregateVariables();
    }

    private void initAggregateVariables() {
        this.aggregates = new HashMap<String, Double>();
        this.aggregatesAvg = new HashMap<String, Double>();
        this.aggregateNames = new ArrayList<String>();
    }

    public void setAttributeName(String string) {
        this.attributeName = string;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeSubname(String string) {
        this.attributeSubname = string;
    }

    public String getAttributeSubname() {
        return this.attributeSubname;
    }

    public void setAttributeNumValue(Double d) {
        this.attributeNumValue = d;
    }

    public Double getAttributeNumValue() {
        return this.attributeNumValue;
    }

    public void setAttributeStrValue(String string) {
        this.attributeStrValue = string;
    }

    public String getAttributeStrValue() {
        return this.attributeStrValue;
    }

    public String getFullAttributeName() {
        if (this.attributeSubname != null && this.attributeSubname.trim().length() != 0) {
            return this.attributeName + "." + this.attributeSubname;
        }
        return this.attributeName;
    }

    public String getFullAttributeName(NameContent nameContent) {
        Object object = "";
        switch (nameContent) {
            case NC_NAME_ONLY: {
                object = this.attributeName;
                break;
            }
            case NC_NAME_SUBNAME_ONLY: {
                object = this.attributeName;
                if (this.attributeSubname == null || this.attributeSubname.trim().length() == 0) break;
                object = this.attributeName + "." + this.attributeSubname;
                break;
            }
            case NC_SUBNAME_ONLY: {
                if (this.attributeSubname == null) break;
                object = this.attributeSubname;
                break;
            }
            default: {
                object = "";
            }
        }
        return object;
    }

    public String getValue() {
        if (this.attributeNumValue != null) {
            return NumericFormat.format(this.attributeNumValue, true, 8);
        }
        return this.attributeStrValue;
    }

    public String getItemDetail(RuleContentOption ruleContentOption) {
        Object object = "";
        switch (ruleContentOption) {
            case NAME_SUBNAME_VALUE: {
                object = this.getFullAttributeName(NameContent.NC_NAME_SUBNAME_ONLY) + " = " + this.getValue();
                break;
            }
            case NAME_SUBNAME: {
                object = this.getFullAttributeName(NameContent.NC_NAME_SUBNAME_ONLY);
                break;
            }
            case SUBNAME: {
                object = this.getFullAttributeName(NameContent.NC_SUBNAME_ONLY);
                break;
            }
            case SUBNAME_VALUE: {
                object = this.getFullAttributeName(NameContent.NC_SUBNAME_ONLY) + " = " + this.getValue();
                break;
            }
        }
        return object;
    }

    public void addAggregate(String string, Double d, Double d2) {
        this.aggregates.put(string, d);
        this.aggregatesAvg.put(string, d2);
        this.aggregateNames.add(string);
    }

    public Double getAggregate(String string) {
        return this.aggregates.get(string);
    }

    public Double getAggregateAvg(String string) {
        return this.aggregatesAvg.get(string);
    }

    public List<String> getAggregateNames() {
        return this.aggregateNames;
    }

    public static List<Item> createItemsFrom(DmItems dmItems) throws SQLException {
        ArrayList<Item> arrayList = new ArrayList<Item>(dmItems.length());
        for (int i = 0; i < dmItems.length(); ++i) {
            DmItem dmItem = dmItems.getElement(i);
            Item item = new Item(dmItem);
            arrayList.add(item);
        }
        return arrayList;
    }

    public static List<Item> createItemsFrom(DmPredicates dmPredicates) throws SQLException {
        ArrayList<Item> arrayList = new ArrayList<Item>(dmPredicates.length());
        for (int i = 0; i < dmPredicates.length(); ++i) {
            DmPredicate dmPredicate = dmPredicates.getElement(i);
            Item item = new Item(dmPredicate);
            arrayList.add(item);
        }
        return arrayList;
    }

    public static enum NameContent {
        NC_NAME_ONLY,
        NC_NAME_SUBNAME_ONLY,
        NC_SUBNAME_ONLY;

    }
}

