/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.md;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ModelDetailsQuery;
import oracle.dmt.dataminer.core.model.common.build.RowDiagnosticTableDetails;
import oracle.dmt.dataminer.core.utils.Strings;
import oracle.dmt.dataminer.workflow.xmlschema.MiningDataType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.RModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.javatools.util.Version;

public class RModelDetailsQuery
extends ModelDetailsQuery {
    private List<RModelType.DetailFunction.Output.Column> outputSignature;

    public RModelDetailsQuery(Version version, ModelDetailType modelDetailType, List<RefModelType> list, Map<String, RowDiagnosticTableDetails> map, List<RModelType.DetailFunction.Output.Column> list2, boolean bl) {
        super(version, modelDetailType, list, map, bl, false);
        this.outputSignature = list2;
        this.initializeColumns();
    }

    public RModelDetailsQuery(Version version, ModelDetailType modelDetailType, List<RModelType.DetailFunction.Output.Column> list) {
        super(version, modelDetailType, false);
        this.outputSignature = list;
        this.initializeColumns();
    }

    @Override
    protected void initializeColumns() {
        int n = 0;
        this.outputColumns = new String[this.outputSignature.size() + 2][2];
        this.outputColumns[n++] = new String[]{"PARTITION_NAME", "VARCHAR2"};
        this.outputColumns[n++] = new String[]{"MODEL_NAME", "VARCHAR2"};
        for (RModelType.DetailFunction.Output.Column column : this.outputSignature) {
            this.outputColumns[n++] = new String[]{column.getName().toUpperCase(), MiningDataType.NUMBER.equals((Object)column.getType()) ? "NUMBER" : "VARCHAR2"};
        }
    }

    @Override
    protected String getSQLTemplate() {
        String string = this.outputSignature.stream().map(column -> String.format("    %s", column.getName().toUpperCase())).collect(Collectors.joining("," + Strings.NEW_LINE));
        String string2 = String.format("SELECT\n    PARTITION_NAME,\n    CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_NAME}\",\n%s\nFROM {$MODEL_SCHEMA_VALUE}.DM$VD{$MODEL_NAME_VALUE}", string);
        return string2;
    }
}

