/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.md;

import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ModelDetailsQuery;
import oracle.dmt.dataminer.core.model.common.build.RowDiagnosticTableDetails;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.javatools.util.Version;

public class GLMCRowDiagnosticsQuery
extends ModelDetailsQuery {
    private static final String TARGET_VALUE_PROB = "TARGET_VALUE_PROB";
    private static final String WORKING_RESIDUAL = "WORKING_RESIDUAL";
    private static final String PEARSON_RESIDUAL = "PEARSON_RESIDUAL";
    private static final String DEVIANCE_RESIDUAL = "DEVIANCE_RESIDUAL";
    private static final String C = "C";
    private static final String CBAR = "CBAR";
    private static final String DIFDEV = "DIFDEV";
    private static final String DIFCHISQ = "DIFCHISQ";

    public GLMCRowDiagnosticsQuery(Version version, ModelDetailType modelDetailType, List<RefModelType> list, Map<String, RowDiagnosticTableDetails> map, boolean bl) {
        super(version, modelDetailType, list, map, bl);
    }

    public GLMCRowDiagnosticsQuery(Version version, ModelDetailType modelDetailType) {
        super(version, modelDetailType);
    }

    @Override
    protected void initializeColumns() {
        this.outputColumns = DbVersionHelper.isDB122Up(this.dbVersion) ? new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"PARTITION_NAME", "VARCHAR2"}, {"CASE_ID", "VARCHAR2"}, {"TARGET_VALUE", "VARCHAR2"}, {TARGET_VALUE_PROB, "NUMBER"}, {"HAT", "NUMBER"}, {WORKING_RESIDUAL, "NUMBER"}, {PEARSON_RESIDUAL, "NUMBER"}, {DEVIANCE_RESIDUAL, "NUMBER"}, {C, "NUMBER"}, {CBAR, "NUMBER"}, {DIFDEV, "NUMBER"}, {DIFCHISQ, "NUMBER"}} : new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"CASE_ID", "VARCHAR2"}, {"TARGET_VALUE", "VARCHAR2"}, {TARGET_VALUE_PROB, "NUMBER"}, {"HAT", "NUMBER"}, {WORKING_RESIDUAL, "NUMBER"}, {PEARSON_RESIDUAL, "NUMBER"}, {DEVIANCE_RESIDUAL, "NUMBER"}, {C, "NUMBER"}, {CBAR, "NUMBER"}, {DIFDEV, "NUMBER"}, {DIFCHISQ, "NUMBER"}};
    }

    @Override
    protected String getSQLTemplate() {
        String string = null;
        string = DbVersionHelper.isDB122Up(this.dbVersion) ? "\n   SELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_SCHEMA}\",\n   CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_NAME}\",\n   CAST(case_id AS VARCHAR2(4000)) as \"{$CASE_ID}\", \n   PARTITION_NAME as \"{$PARTITION_NAME}\",\n   target_value as \"{$TARGET_VALUE}\",\n   target_value_prob as \"{$TARGET_VALUE_PROB}\", \n   hat as \"{$HAT}\", \n   working_residual as \"{$WORKING_RESIDUAL}\", \n   pearson_residual as \"{$PEARSON_RESIDUAL}\",\n   deviance_residual as \"{$DEVIANCE_RESIDUAL}\",\n   c as \"{$C}\",\n   cbar as \"{$CBAR}\", \n   difdev as \"{$DIFDEV}\",\n   difchisq as \"{$DIFCHISQ}\" \n   FROM {$MODEL_SCHEMA_VALUE}.DM$VA{$MODEL_NAME_VALUE}" : "\n     SELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_SCHEMA}\",\n     CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_NAME}\",\n     CAST(case_id AS VARCHAR2(4000)) as \"{$CASE_ID}\", \n     target_value as \"{$TARGET_VALUE}\",\n     target_value_prob as \"{$TARGET_VALUE_PROB}\", \n     hat as \"{$HAT}\", \n     working_residual as \"{$WORKING_RESIDUAL}\", \n     pearson_residual as \"{$PEARSON_RESIDUAL}\",\n     deviance_residual as \"{$DEVIANCE_RESIDUAL}\",\n     c  as \"{$C}\",\n     cbar as \"{$CBAR}\", \n     difdev as \"{$DIFDEV}\",\n     difchisq as \"{$DIFCHISQ}\"\n     FROM \"{$TABLE_NAME}\"";
        return string;
    }
}

