/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.md;

import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ModelDetailsQuery;
import oracle.dmt.dataminer.core.model.common.build.RowDiagnosticTableDetails;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.javatools.util.Version;

public class FeatureCoefficientsQuery
extends ModelDetailsQuery {
    public FeatureCoefficientsQuery(Version version, ModelDetailType modelDetailType, List<RefModelType> list, Map<String, RowDiagnosticTableDetails> map, boolean bl) {
        super(version, modelDetailType, list, map, bl);
    }

    public FeatureCoefficientsQuery(Version version, ModelDetailType modelDetailType) {
        super(version, modelDetailType);
    }

    @Override
    protected void initializeColumns() {
        this.outputColumns = DbVersionHelper.isDB122Up(this.dbVersion) ? new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"PARTITION_NAME", "VARCHAR2"}, {"ID", "NUMBER"}, {"FEATURE_ID", "VARCHAR2"}, {"ATTRIBUTE_NAME", "VARCHAR2"}, {"ATTRIBUTE_SUBNAME", "VARCHAR2"}, {"ATTRIBUTE_VALUE", "VARCHAR2"}, {"COEFFICIENT", "NUMBER"}} : new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"ID", "NUMBER"}, {"FEATURE_ID", "VARCHAR2"}, {"ATTRIBUTE_NAME", "VARCHAR2"}, {"ATTRIBUTE_SUBNAME", "VARCHAR2"}, {"ATTRIBUTE_VALUE", "VARCHAR2"}, {"COEFFICIENT", "NUMBER"}};
    }

    @Override
    protected String getSQLTemplate() {
        String string = null;
        string = DbVersionHelper.isDB122Up(this.dbVersion) ? "\n  SELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_SCHEMA}\",\n  CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_NAME}\",\n  {$ALGO_SOURCE}" : "\n  SELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_SCHEMA}\",\n  CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_NAME}\",  \n  t.feature_id as \"{$ID}\",\n  {$ALGO_SOURCE}";
        return string;
    }

    @Override
    protected String getActualSource(MiningAlgorithmType miningAlgorithmType) {
        String string;
        block12: {
            block11: {
                string = null;
                if (!DbVersionHelper.isDB122Up(this.dbVersion)) break block11;
                switch (miningAlgorithmType) {
                    case NONNEGATIVE_MATRIX_FACTOR: {
                        string = "     PARTITION_NAME as \"{$PARTITION_NAME}\",\n     FEATURE_ID as \"{$ID}\",\n     CAST(FEATURE_NAME AS VARCHAR2(4000)) as \"{$FEATURE_ID}\",\n     ATTRIBUTE_NAME as \"{$ATTRIBUTE_NAME}\",\n     ATTRIBUTE_SUBNAME as \"{$ATTRIBUTE_SUBNAME}\",\n     ATTRIBUTE_VALUE as \"{$ATTRIBUTE_VALUE}\",\n     COEFFICIENT as \"{$COEFFICIENT}\"\n     FROM {$MODEL_SCHEMA_VALUE}.DM$VE{$MODEL_NAME_VALUE}";
                        break block12;
                    }
                    case PRINCIPAL_COMPONENT_ANALYSIS: 
                    case SINGULAR_VALUE_DECOMP: {
                        string = "     PARTITION_NAME as \"{$PARTITION_NAME}\",\n     FEATURE_ID as \"{$ID}\",\n     CAST(FEATURE_NAME AS VARCHAR2(4000)) as \"{$FEATURE_ID}\",\n     ATTRIBUTE_NAME as \"{$ATTRIBUTE_NAME}\",\n     ATTRIBUTE_SUBNAME as \"{$ATTRIBUTE_SUBNAME}\",\n     ATTRIBUTE_VALUE as \"{$ATTRIBUTE_VALUE}\",\n     VALUE as \"{$COEFFICIENT}\"\n     FROM {$MODEL_SCHEMA_VALUE}.DM$VV{$MODEL_NAME_VALUE}";
                        break block12;
                    }
                    case EXPLICIT_SEMANTIC_ANALYSIS: {
                        string = "     PARTITION_NAME as \"{$PARTITION_NAME}\",\n     FEATURE_ID as \"{$ID}\",\n     FEATURE_ID as \"{$FEATURE_ID}\",\n     ATTRIBUTE_NAME as \"{$ATTRIBUTE_NAME}\",\n     ATTRIBUTE_SUBNAME as \"{$ATTRIBUTE_SUBNAME}\",\n     ATTRIBUTE_VALUE as \"{$ATTRIBUTE_VALUE}\",\n     COEFFICIENT as \"{$COEFFICIENT}\"\n     FROM {$MODEL_SCHEMA_VALUE}.DM$VA{$MODEL_NAME_VALUE}";
                        break block12;
                    }
                    default: {
                        assert (false) : "Incompatible Algorithm";
                        break block12;
                    }
                }
            }
            switch (miningAlgorithmType) {
                case NONNEGATIVE_MATRIX_FACTOR: {
                    string = "     CAST(t.mapped_feature_id AS VARCHAR2(4000)) as \"{$FEATURE_ID}\",\n     s.attribute_name as \"{$ATTRIBUTE_NAME}\",\n     s.attribute_subname as \"{$ATTRIBUTE_SUBNAME}\",\n     s.attribute_value as \"{$ATTRIBUTE_VALUE}\",\n     s.coefficient as \"{$COEFFICIENT}\"\n     FROM TABLE(dbms_data_mining.GET_MODEL_DETAILS_NMF('{$GET_MODEL_NAME}')) t,\n     TABLE(t.attribute_set) s";
                    break;
                }
                case PRINCIPAL_COMPONENT_ANALYSIS: 
                case SINGULAR_VALUE_DECOMP: {
                    string = "     CAST(t.mapped_feature_id AS VARCHAR2(4000)) as \"{$FEATURE_ID}\",\n     t.attribute_name as \"{$ATTRIBUTE_NAME}\",\n     t.attribute_subname as \"{$ATTRIBUTE_SUBNAME}\",\n     NULL as \"{$ATTRIBUTE_VALUE}\",\n     t.value as \"{$COEFFICIENT}\"\n     FROM TABLE(dbms_data_mining.GET_MODEL_DETAILS_SVD('{$GET_MODEL_NAME}')) t";
                    break;
                }
                default: {
                    assert (false) : "Incompatible Algorithm";
                    break;
                }
            }
        }
        return string;
    }
}

